/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ARStructMapTypeInfo;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.StringByteUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

@ARStructMapTypeInfo(KeyType="java.lang.Integer", KeyIndex={0}, ValueType="com.bmc.arsys.api.Value", ValueIndex={1})
public class Entry
extends LinkedHashMap<Integer, Value>
implements Serializable {
    private static final long serialVersionUID = -1287560156290121395L;
    private static Logger logger = Logger.getLogger(Entry.class);

    public Entry() {
    }

    public Entry(Map<? extends Integer, ? extends Value> m) {
        super(m);
    }

    public Entry(SortedMap<Integer, ? extends Value> m) {
        super(m);
    }

    public String getKey() {
        return this.getEntryId();
    }

    public String getEntryId() {
        Value val;
        if (this.containsKey(CoreFieldId.EntryId.getFieldId()) && (val = (Value)this.get(CoreFieldId.EntryId.getFieldId())) != null) {
            return (String)val.getValue();
        }
        return null;
    }

    public String getEntryIdWithNoSeparator() {
        String entryId = this.getEntryId();
        if (entryId != null) {
            return entryId.replace("|", "");
        }
        return entryId;
    }

    public void setEntryId(String entryId) {
        this.put(CoreFieldId.EntryId.getFieldId(), new Value(entryId));
    }

    public static String[] splitEntryId(String entryId) {
        return Entry.splitEntryId(entryId, "utf-8");
    }

    public static String[] splitEntryId(String entryId, String serverCharSet) {
        if (entryId == null || entryId.length() <= 0) {
            return null;
        }
        if (entryId.contains("|")) {
            StringTokenizer st = new StringTokenizer(entryId, "|", true);
            int count = st.countTokens();
            boolean lastTokenWasDelim = false;
            if (count > 0) {
                ArrayList<String> var = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String id = st.nextToken();
                    if (id.equals("|")) {
                        if (lastTokenWasDelim) {
                            var.add("");
                        }
                        lastTokenWasDelim = true;
                        continue;
                    }
                    lastTokenWasDelim = false;
                    var.add(id);
                }
                if (lastTokenWasDelim) {
                    var.add("");
                }
                return var.toArray(new String[0]);
            }
            return new String[]{entryId};
        }
        return StringByteUtil.splitString(entryId, 15, serverCharSet);
    }

    public static String prepareEntryId(Object[] var) {
        int count;
        StringBuilder sb = new StringBuilder();
        boolean added = false;
        int n = count = var != null ? var.length : 0;
        for (int i = 0; i < count; ++i) {
            String id = null;
            if (var[i] instanceof Object[] && ((Object[])var[i]).length > 1) {
                throw new IllegalArgumentException(CatalogReader.getInstance().getMessage(4564));
            }
            if (var[i] != null) {
                id = var[i].toString();
                if (id.length() <= 0) continue;
                if (added) {
                    sb.append("|");
                } else {
                    added = true;
                }
                sb.append(id);
                continue;
            }
            throw new IllegalArgumentException(CatalogReader.getInstance().getMessage(4564));
        }
        return sb.toString();
    }

    static List<Entry> buildGLEWFResponse(ARServerUser context, byte[] inbuf, String serverCharSetName, OutputInteger nMatches) throws ARException {
        ArrayList<Entry> entryList = new ArrayList<Entry>();
        logger.trace("buildGLEWFResponse:serverCharSetName:" + serverCharSetName);
        if (inbuf == null) {
            return entryList;
        }
        String bufStr = null;
        try {
            bufStr = new String(inbuf, serverCharSetName);
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex);
            throw new ARException(2, 9061, ex.getLocalizedMessage());
        }
        logger.trace("buildGLEWFResponse: buffer len=" + bufStr.length());
        int numEntries = 0;
        int numFieldsPerEntry = 0;
        int bIndex = 0;
        int eIndex = bufStr.indexOf("\n", bIndex);
        if (eIndex > 0) {
            try {
                numEntries = new Integer(bufStr.substring(bIndex, eIndex));
            }
            catch (NumberFormatException nfe) {
                logger.debug("NFE occurs at index [" + bIndex + "] for # of entries. " + bufStr.substring(bIndex));
                Entry.logBuffer(bufStr);
                throw nfe;
            }
        } else {
            logger.error("ERROR: Unable to parse GLEWF result buffer for the # of entries. " + bufStr.substring(bIndex));
            return entryList;
        }
        bIndex = eIndex + 1;
        eIndex = bufStr.indexOf("\n", bIndex);
        if (eIndex > 0) {
            if (nMatches != null) {
                try {
                    nMatches.setValue(new Long(bufStr.substring(bIndex, eIndex)));
                }
                catch (NumberFormatException nfe) {
                    logger.debug("NFE occurs at index [" + bIndex + "] for # of matches. " + bufStr.substring(bIndex));
                    Entry.logBuffer(bufStr);
                    throw nfe;
                }
            }
        } else {
            logger.error("ERROR: Unable to parse GLEWF result buffer for the # of matches. " + bufStr.substring(bIndex));
            return entryList;
        }
        if ((eIndex = bufStr.indexOf("\n", bIndex = eIndex + 1)) > 0) {
            try {
                numFieldsPerEntry = new Integer(bufStr.substring(bIndex, eIndex));
            }
            catch (NumberFormatException nfe) {
                logger.debug("NFE occurs at index [" + bIndex + "] for # of fields per entry. " + bufStr.substring(bIndex));
                Entry.logBuffer(bufStr);
                throw nfe;
            }
        } else {
            logger.error("ERROR: Unable to parse GLEWF result buffer for the # of fields per entry. " + bufStr.substring(bIndex));
            return entryList;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("buildGLEWFResponse: numEntries=" + numEntries + " nMatches=" + (nMatches != null ? nMatches : Integer.valueOf(0)) + " numFieldsPerEntry=" + numFieldsPerEntry);
        }
        LinkedList<Integer> fieldIdList = new LinkedList<Integer>();
        for (int i = 0; i < numFieldsPerEntry; ++i) {
            bIndex = eIndex + 1;
            if ((eIndex = bufStr.indexOf("\n", bIndex)) > 0) {
                try {
                    fieldIdList.add(new Integer(bufStr.substring(bIndex, eIndex)));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    logger.debug("NFE occurs at index [" + bIndex + "] for field Ids. " + bufStr.substring(bIndex));
                    Entry.logBuffer(bufStr);
                    throw nfe;
                }
            }
            logger.error("ERROR: Unable to parse GLEWF result buffer for field Ids. " + bufStr.substring(bIndex));
            return entryList;
        }
        OutputInteger len = new OutputInteger();
        int lenDiff = 0;
        for (int i = 0; i < numEntries; ++i) {
            Value value;
            Entry entry = context != null && context.getExtendedClassRegistry() != null && context.getExtendedClassRegistry().isExtendingClassRegistered(Entry.class) ? (Entry)((Object)context.getExtendedClassRegistry().newInstance(Entry.class)) : new Entry();
            bIndex = eIndex + 1;
            if ((eIndex = bufStr.indexOf("\n", bIndex)) > 0) {
                String entryId = bufStr.substring(bIndex, eIndex);
                value = new Value(entryId);
                entry.put(CoreFieldId.EntryId.getFieldId(), value);
                try {
                    lenDiff += entryId.getBytes(serverCharSetName).length - (eIndex - bIndex);
                }
                catch (UnsupportedEncodingException ex) {
                    logger.error(ex);
                    throw new ARException(2, 9062, ex.getLocalizedMessage());
                }
            } else {
                logger.error("ERROR: Unable to parse GLEWF result buffer for the entry Id. " + bufStr.substring(bIndex));
                return entryList;
            }
            for (int j = 0; j < numFieldsPerEntry; ++j) {
                int valJavaLen;
                int valSvrLen;
                int dataType;
                int fieldId = (Integer)fieldIdList.get(j);
                if (fieldId == CoreFieldId.EntryId.getFieldId()) continue;
                bIndex = eIndex + 1;
                if ((eIndex = bufStr.indexOf("\\", bIndex)) > 0) {
                    try {
                        dataType = new Integer(bufStr.substring(bIndex, eIndex));
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug("NFE occurs at index [" + bIndex + "] for the datatype." + bufStr.substring(bIndex));
                        Entry.logBuffer(bufStr);
                        throw nfe;
                    }
                } else {
                    logger.error("ERROR: Unable to parse GLEWF result buffer for the dataType. " + bufStr.substring(bIndex));
                    return entryList;
                }
                bIndex = eIndex + 1;
                eIndex = bufStr.indexOf("\\", bIndex);
                if (eIndex > 0) {
                    try {
                        valSvrLen = new Integer(bufStr.substring(bIndex, eIndex));
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug("NFE occurs at index [" + bIndex + "] for the value length." + bufStr.substring(bIndex));
                        Entry.logBuffer(bufStr);
                        throw nfe;
                    }
                } else {
                    logger.error("ERROR: Unable to parse GLEWF result buffer for the value length. " + bufStr.substring(bIndex));
                    return entryList;
                }
                bIndex = eIndex + 1;
                if (valSvrLen > 0) {
                    value = Value.deserializeFromBytesBuffer(inbuf, bIndex + lenDiff, valSvrLen, dataType, serverCharSetName, len);
                    valJavaLen = len.intValue();
                    lenDiff += valSvrLen - valJavaLen;
                } else {
                    value = new Value();
                    valJavaLen = 0;
                }
                entry.put(fieldId, value);
                eIndex = bIndex + valJavaLen;
            }
            entryList.add(entry);
        }
        return entryList;
    }

    static List<Entry> buildGMEResponse(Object[] rawData, List<String> entryIds, ARServerUser ctx) throws ARException {
        ArrayList<Entry> entryList = new ArrayList<Entry>();
        if (rawData == null) {
            logger.error("ERROR: Entry.buildGMEResponse rawData is null");
            return entryList;
        }
        Object[] existList = (Object[])rawData[6];
        Object[] entryDataList = (Object[])rawData[7];
        assert (existList != null && entryDataList != null && existList.length == entryDataList.length);
        int count = entryDataList.length;
        for (int i = 0; i < count; ++i) {
            Object[] cur = (Object[])entryDataList[i];
            if (ConversionUtil.getBooleanValue(existList[i]) && cur.getClass().isArray()) {
                Object[] varEntry = cur;
                Entry entry = ARTypeMgr.getInstance().ObjectFromVariant(Entry.class, varEntry, ctx);
                entry.setEntryId(entryIds.get(i));
                entryList.add(entry);
                continue;
            }
            entryList.add(null);
        }
        return entryList;
    }

    @Override
    public Object clone() {
        Entry obj = (Entry)super.clone();
        for (Integer key : this.keySet()) {
            Value val = (Value)this.get(key);
            Value clonedVal = null;
            if (val != null) {
                try {
                    clonedVal = (Value)val.clone();
                }
                catch (CloneNotSupportedException e) {
                    clonedVal = new Value(val.getValue().toString(), val.getDataType());
                }
            }
            obj.put(new Integer(key), clonedVal);
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Entry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return new EqualsBuilder().appendSuper(super.equals(obj)).isEquals();
    }

    private void validateEntryId(Value val) {
        if (val != null) {
            int type = val.getType();
            if (type != 4 && type != 0) {
                logger.error("ERROR: EntryId val.type can not be " + type);
                throw new IllegalArgumentException(CatalogReader.getInstance().getMessage(4564));
            }
            String id = (String)val.getValue();
            Entry.splitEntryId(id);
        }
    }

    @Override
    public Value put(Integer key, Value value) {
        if (key.intValue() == CoreFieldId.EntryId.getFieldId()) {
            this.validateEntryId(value);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Value> map) {
        if (map.containsKey(CoreFieldId.EntryId.getFieldId())) {
            Value val = map.get(CoreFieldId.EntryId.getFieldId());
            this.validateEntryId(val);
        }
        super.putAll(map);
    }

    private static void logBuffer(String buff) {
        String log = buff.replace("\\", "\\\\");
        log = log.replace("\n", "\\n");
        logger.debug("The complete buffer contents=" + log);
    }
}

