/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.ActiveLinkGuide;
import com.bmc.arsys.api.ApplicationContainer;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ContainerCriteria;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.FilterGuide;
import com.bmc.arsys.api.ObjectBase;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.PackingList;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.WebService;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public abstract class Container
extends ObjectBase
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7772090218050979379L;
    private List<Integer> m_adminGrpList;
    private String m_label;
    private String m_description;
    private List<Reference> m_references;
    private List<ContainerOwner> m_containerOwner;
    private ObjectPropertyMap m_objPropList;
    private List<PermissionInfo> m_AssignedGroup;

    public Container() {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.hashValues = new Integer[16];
    }

    Container(String name) {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.setName(name);
        this.setKey(name);
        this.hashValues = new Integer[16];
    }

    protected Container(String name, List<PermissionInfo> permissionList, String helpText, long lastUpdateTime, String owner, String lastChangedBy, String diaryStr) {
        super(name, null, helpText, lastUpdateTime, owner, lastChangedBy, diaryStr);
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        if (permissionList == null || permissionList.isEmpty()) {
            this.m_permissionList = null;
        } else {
            this.setPermissions(permissionList);
        }
        this.hashValues = new Integer[16];
        this.calculateHashCode();
    }

    @Override
    protected void createChangeFlags() {
        this.m_changeFlags = new ContainerCriteria();
    }

    public String getKey() {
        return this.getName();
    }

    public void setKey(String key) {
        this.setName(key);
    }

    public void setAdminGroupList(List<Integer> adminList) {
        this.m_adminGrpList = adminList;
        if (this.m_adminGrpList != null) {
            this.m_adminGrpList = new ArrayList<Integer>(adminList.size());
            for (int i = 0; i < adminList.size(); ++i) {
                this.m_adminGrpList.add(new Integer(adminList.get(i)));
            }
        }
        this.m_changeFlags.setParameter(8L, true);
    }

    public List<Integer> getAdminGroupList() {
        return this.m_adminGrpList;
    }

    @Override
    public void setPermissions(List<PermissionInfo> permissionList) {
        if (permissionList == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new ArrayList(permissionList.size());
            this.m_AssignedGroup = new ArrayList<PermissionInfo>(permissionList.size());
            for (int i = 0; i < permissionList.size(); ++i) {
                int intVal = permissionList.get(i).getGroupID();
                this.m_permissionList.add(new PermissionInfo(intVal, permissionList.get(i).getPermissionValue()));
                this.m_AssignedGroup.add(new PermissionInfo(intVal, permissionList.get(i).getPermissionValue()));
            }
        }
        this.m_changeFlags.setParameter(1L, true);
    }

    public void setLabel(String label) {
        this.m_label = label;
        this.m_changeFlags.setParameter(10L, true);
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setDescription(String desc) {
        this.m_description = desc;
        this.m_changeFlags.setParameter(11L, true);
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getType() {
        if (this instanceof ActiveLinkGuide) {
            return 1;
        }
        if (this instanceof ApplicationContainer) {
            return 2;
        }
        if (this instanceof PackingList) {
            return 3;
        }
        if (this instanceof FilterGuide) {
            return 4;
        }
        if (this instanceof WebService) {
            return 5;
        }
        return 1;
    }

    public void setReferences(List<Reference> refs) {
        this.m_references = refs;
        this.m_changeFlags.setParameter(13L, true);
    }

    public List<Reference> getReferences() {
        return this.m_references;
    }

    public void setContainerOwner(List<ContainerOwner> owner) {
        this.m_containerOwner = owner;
        this.m_changeFlags.setParameter(9L, true);
    }

    public List<ContainerOwner> getContainerOwner() {
        return this.m_containerOwner;
    }

    public void setProperties(ObjectPropertyMap props) {
        this.m_objPropList = props;
        this.m_changeFlags.setParameter(7L, true);
    }

    public ObjectPropertyMap getProperties() {
        return this.m_objPropList;
    }

    @Override
    public void clear() {
        super.clear();
        this.m_adminGrpList = null;
        this.m_label = null;
        this.m_description = null;
        this.m_references = null;
        this.m_containerOwner = null;
        this.m_objPropList = null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int nLen;
        int i;
        Container con = (Container)super.clone();
        if (this.m_adminGrpList != null) {
            con.m_adminGrpList = new ArrayList<Integer>(this.m_adminGrpList.size());
            for (i = 0; i < this.m_adminGrpList.size(); ++i) {
                con.m_adminGrpList.add(new Integer(this.m_adminGrpList.get(i)));
            }
        }
        if (this.m_label != null) {
            con.m_label = this.m_label;
        }
        if (this.m_description != null) {
            con.m_description = this.m_description;
        }
        if (this.m_references != null) {
            nLen = this.m_references.size();
            con.m_references = new ArrayList<Reference>(nLen);
            for (int count = 0; count < nLen; ++count) {
                con.m_references.add((Reference)this.m_references.get(count).clone());
            }
        }
        if (this.m_containerOwner != null) {
            nLen = this.m_containerOwner.size();
            con.m_containerOwner = new ArrayList<ContainerOwner>(nLen);
            for (i = 0; i < nLen; ++i) {
                con.m_containerOwner.add((ContainerOwner)this.m_containerOwner.get(i).clone());
            }
        }
        if (this.m_objPropList != null) {
            con.m_objPropList = new ObjectPropertyMap();
            Set keys = this.m_objPropList.keySet();
            for (Integer key : keys) {
                con.m_objPropList.put(key, (Value)((Value)this.m_objPropList.get(key)).clone());
            }
        }
        if (this.m_changeFlags != null) {
            con.m_changeFlags = (ContainerCriteria)this.m_changeFlags.clone();
        }
        this.calculateHashCode();
        return con;
    }

    public void activate() {
    }

    public void passivate() {
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Container)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Container rhs = (Container)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_adminGrpList, rhs.m_adminGrpList).append(this.m_label, rhs.m_label).append(this.m_description, rhs.m_description).append(this.m_references, rhs.m_references).append(this.m_containerOwner, rhs.m_containerOwner).append(this.m_objPropList, rhs.m_objPropList).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_adminGrpList).append(this.m_label).append(this.m_description).append(this.m_references).append(this.m_containerOwner).append(this.m_objPropList).toHashCode();
    }

    private void fromVariantDuringGet(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.setName(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 3)));
        this.setPermissions(ARTypeMgr.getInstance().ObjectListFromVariant(PermissionInfo.class, ARTypeMgr.GetAt((Object)rawData, 5), ctx));
        this.setAdminGroupList(ARTypeMgr.getInstance().ObjectListFromVariant(Integer.class, ARTypeMgr.GetAt((Object)rawData, 6), ctx));
        this.setContainerOwner(ARTypeMgr.getInstance().ObjectListFromVariant(ContainerOwner.class, ARTypeMgr.GetAt((Object)rawData, 7), ctx));
        this.setLabel(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 8)));
        this.setDescription(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 9)));
        this.setReferences(ARTypeMgr.getInstance().ObjectListFromVariant(Reference.class, ARTypeMgr.GetAt((Object)rawData, 11), ctx));
        this.setHelpText(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 12)));
        this.setOwner(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 13)));
        this.setLastUpdateTime(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 14)));
        this.setLastChangedBy(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 15)));
        this.setDiary(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 16)));
        this.setProperties(ARTypeMgr.getInstance().ObjectFromVariant(ObjectPropertyMap.class, ARTypeMgr.GetAt((Object)rawData, 17), ctx));
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.fromVariantDuringGet(rawData, ctx);
    }

    static Container createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        Container obj = null;
        int ContainerType2 = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 10));
        switch (ContainerType2) {
            case 1: {
                obj = ARTypeMgr.getInstance().NewObject(ActiveLinkGuide.class, ctx);
                break;
            }
            case 2: {
                obj = ARTypeMgr.getInstance().NewObject(ApplicationContainer.class, ctx);
                break;
            }
            case 3: {
                obj = ARTypeMgr.getInstance().NewObject(PackingList.class, ctx);
                break;
            }
            case 4: {
                obj = ARTypeMgr.getInstance().NewObject(FilterGuide.class, ctx);
                break;
            }
            default: {
                obj = ARTypeMgr.getInstance().NewObject(WebService.class, ctx);
            }
        }
        obj.fromVariant(rawData, ctx);
        return obj;
    }

    static List<Container> buildGMCOResponse(Object[] rawData, ARServerUser ctx) {
        int count;
        ArrayList<Container> objectList = new ArrayList<Container>();
        int n = count = rawData[9] != null ? ARTypeMgr.GetArrayLength(rawData[9]) : 0;
        assert (count == ARTypeMgr.GetArrayLength(rawData[10]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[11]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[12]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[13]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[14]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[15]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[16]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[17]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[18]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[19]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[20]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[21]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[22]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[23]));
        for (int i = 0; i < count; ++i) {
            Container obj = null;
            if (!ConversionUtil.getBooleanValue(ARTypeMgr.GetAt((Object)rawData, new int[]{9, i}))) continue;
            Object[] curRawData = new Object[]{0, null, ctx, ARTypeMgr.GetAt((Object)rawData, new int[]{10, i}), null, ARTypeMgr.GetAt((Object)rawData, new int[]{11, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{12, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{13, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{14, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{15, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{16, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{17, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{18, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{19, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{20, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{21, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{22, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{23, i})};
            obj = Container.createInstance(curRawData, ctx);
            objectList.add(obj);
        }
        return objectList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Admin Grp List", this.m_adminGrpList).append("Label", this.m_label).append("Description", this.m_description).append("References", this.m_references).append("Container Owner", this.m_containerOwner).append("Obj Prop List", this.m_objPropList).toString();
    }

    @Override
    void calculateHashCode() {
        if (this.hashValues == null) {
            this.hashValues = new Integer[16];
        }
        super.calculateHashCode();
        this.hashValues[8] = this.m_adminGrpList != null ? Integer.valueOf(this.m_adminGrpList.hashCode()) : null;
        this.hashValues[9] = this.m_containerOwner != null ? Integer.valueOf(this.m_containerOwner.hashCode()) : null;
        this.hashValues[13] = this.m_references != null ? Integer.valueOf(this.m_references.hashCode()) : null;
        this.hashValues[7] = this.m_objPropList != null ? Integer.valueOf(this.m_objPropList.hashCode()) : null;
    }

    @Override
    void calculateHashCodeOnGet(ObjectBaseCriteria criteria) {
        super.calculateHashCodeOnGet(criteria == null ? new ContainerCriteria() : criteria);
    }

    @Override
    void calculateChangeFlagsOnSet() {
        int hashCode;
        if (this.hashValues == null) {
            this.hashValues = new Integer[16];
        }
        super.calculateChangeFlagsOnSet();
        boolean[] changeFlags = this.m_changeFlags.getParameters();
        if (!changeFlags[8]) {
            if (this.m_adminGrpList != null) {
                hashCode = this.m_adminGrpList.hashCode();
                if (this.hashValues[8] == null || hashCode != this.hashValues[8]) {
                    this.m_changeFlags.setParameter(8L, true);
                    this.hashValues[8] = this.m_adminGrpList != null ? Integer.valueOf(hashCode) : null;
                }
            } else if (this.hashValues[8] != null) {
                this.m_changeFlags.setParameter(8L, true);
                this.hashValues[8] = null;
            }
        }
        if (!changeFlags[9]) {
            if (this.m_containerOwner != null) {
                hashCode = this.m_containerOwner.hashCode();
                if (this.hashValues[9] == null || hashCode != this.hashValues[9]) {
                    this.m_changeFlags.setParameter(9L, true);
                }
                this.hashValues[9] = this.m_containerOwner != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[9] != null) {
                this.m_changeFlags.setParameter(9L, true);
                this.hashValues[9] = null;
            }
        }
        if (!changeFlags[13]) {
            if (this.m_references != null) {
                hashCode = this.m_references.hashCode();
                if (this.hashValues[13] == null || hashCode != this.hashValues[13]) {
                    this.m_changeFlags.setParameter(13L, true);
                }
                this.hashValues[13] = this.m_references != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[13] != null) {
                this.m_changeFlags.setParameter(13L, true);
                this.hashValues[13] = null;
            }
        }
        if (!changeFlags[7]) {
            if (this.m_objPropList != null) {
                hashCode = this.m_objPropList.hashCode();
                if (this.hashValues[7] == null || hashCode != this.hashValues[7]) {
                    this.m_changeFlags.setParameter(7L, true);
                }
                this.hashValues[7] = this.m_objPropList != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[7] != null) {
                this.m_changeFlags.setParameter(7L, true);
                this.hashValues[7] = null;
            }
        }
    }

    public void removeReferenceByObject(Reference object) {
        if (this.m_references == null || this.m_references != null && this.m_references.isEmpty()) {
            return;
        }
        ArrayList<Integer> removeUs = new ArrayList<Integer>();
        for (int iLoop = 0; iLoop < this.m_references.size(); ++iLoop) {
            Reference reference = this.m_references.get(iLoop);
            if (reference != object || removeUs.contains(iLoop)) continue;
            removeUs.add(iLoop);
        }
        if (!removeUs.isEmpty()) {
            Collections.sort(removeUs, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return -o1.compareTo(2);
                }
            });
            for (Integer index : removeUs) {
                this.m_references.remove(index);
            }
        }
    }

    public List<PermissionInfo> getAssignedGroup() {
        return this.m_AssignedGroup;
    }

    void setAssignedGroup(List<PermissionInfo> assignedGroup) {
        this.m_AssignedGroup = assignedGroup;
    }
}

