/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldCriteria;
import com.bmc.arsys.api.FieldKey;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.SQLResult;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.OutputWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class OracleFunctionalIndexHelper
extends JavaDriver {
    static OutputWriter outputWriter = new OutputWriter();
    ARServerUser arServerUser;
    ArrayList<String> schemaNames;
    ArrayList<String> functionalIndexes;
    ArrayList<String> regularIndexes;
    private static final int COMMAND_OPTION_ADD_INDEX = 0;
    private static final int COMMAND_OPTION_DROP_INDEX = 1;
    private static final int COMMAND_OPTION_VIEW_INDEX = 2;
    private static final int COMMAND_OPTION_QUIT_APP = 3;
    private static final int COMMAND_OPTION_MAX_USED = 3;
    private static final int COMMAND_OPTION_REGULAR_INDEX = 0;
    private static final int COMMAND_OPTION_FUNCTIONAL_INDEX = 1;

    public OracleFunctionalIndexHelper() {
        this.initThreadControlBlockPtr();
        this.schemaNames = new ArrayList();
        this.functionalIndexes = new ArrayList();
        this.regularIndexes = new ArrayList();
    }

    public int getSchemaCount() {
        return this.schemaNames.size();
    }

    void readSchemaNames(String fileName) throws ARException, FileNotFoundException, IOException {
        if (fileName == null || fileName.length() == 0) {
            this.schemaNames = (ArrayList)this.arServerUser.getListForm(0L);
        } else {
            this.populateSchemaNamesFromFile(fileName);
        }
    }

    private int getSchemaIdForSchema(String schemaName) throws ARException {
        FormCriteria criteria = new FormCriteria();
        criteria.setPropertiesToRetrieve(FormCriteria.SCHEMA_TYPE);
        Form curForm = this.arServerUser.getForm(schemaName, criteria);
        if (curForm == null) {
            new ARException(2, 303, schemaName);
        }
        int schemaId = 0;
        StringBuilder sqlCommand = new StringBuilder("SELECT schemaId from arschema where name='" + schemaName + "'");
        SQLResult result = this.arServerUser.getListSQL(sqlCommand.toString(), 1, false);
        if (result == null) {
            throw new ARException(2, 303, schemaName);
        }
        List<List<Value>> valueListList = result.getContents();
        if (valueListList == null || valueListList.size() == 0) {
            throw new ARException(2, 303, schemaName);
        }
        schemaId = valueListList.get(0).get(0).getIntValue();
        if (schemaId == 0) {
            throw new ARException(2, 303, schemaName);
        }
        return schemaId;
    }

    private void populateSchemaNamesFromFile(String fileName) throws FileNotFoundException, IOException {
        JavaDriver.getThreadControlBlockPtr().setCurrentInputFile(fileName);
        String inputLine = null;
        BufferedReader currentInputFile = JavaDriver.getThreadControlBlockPtr().getCurrentInputFile();
        inputLine = currentInputFile.readLine();
        while (inputLine != null) {
            int index = 0;
            for (index = inputLine.length() - 1; index >= 0 && inputLine.charAt(index) == ' ' && inputLine.charAt(index) == '\t' && inputLine.charAt(index) == '\n'; --index) {
            }
            if (inputLine.length() >= 1 && inputLine.charAt(0) == '#') continue;
            this.schemaNames.add(inputLine);
            inputLine = currentInputFile.readLine();
        }
        JavaDriver.getThreadControlBlockPtr().closeCurrentInputFile();
    }

    void createDBIndexes(String nlsSortParam) {
        String curSchema = null;
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            curSchema = this.schemaNames.get(i);
            if (curSchema == null) continue;
            outputWriter.printHeader("", "Currently processing Form " + curSchema + "...", "\n");
            try {
                this.createDBIndexesForSchema(curSchema, nlsSortParam);
                continue;
            }
            catch (ARException ex) {
                outputWriter.printHeader("", "Error while processing schema " + curSchema + ".", "\n");
                outputWriter.printHeader("", "Error message " + ex.getMessage() + ".", "\n");
            }
        }
    }

    void dropDBIndexes(boolean functionalIndex) {
        String curSchema = null;
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            curSchema = this.schemaNames.get(i);
            if (curSchema == null) continue;
            outputWriter.printHeader("", "Currently processing Form " + curSchema + "...", "\n");
            try {
                this.dropDBIndexesForSchema(curSchema, functionalIndex);
                continue;
            }
            catch (ARException ex) {
                outputWriter.printHeader("", "Error while processing schema " + curSchema + ".", "\n");
                outputWriter.printHeader("", "Error message " + ex.getMessage() + ".", "\n");
            }
        }
    }

    void viewDBIndexes() {
        String curSchema = null;
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            curSchema = this.schemaNames.get(i);
            if (curSchema == null) continue;
            outputWriter.printHeader("\n", "Currently processing Form " + curSchema + "...", "\n");
            try {
                this.viewDBIndexesForSchema(curSchema);
                continue;
            }
            catch (ARException ex) {
                outputWriter.printHeader("", "Error while processing schema " + curSchema + ".", "\n");
                outputWriter.printHeader("", "Error message " + ex.getMessage() + ".", "\n");
            }
        }
    }

    void viewDBIndexesForSchema(String schemaName) throws ARException {
        int i;
        int schemaId = this.getSchemaIdForSchema(schemaName);
        if (schemaId == 0) {
            outputWriter.printHeader("", "Error while retrieving schema id for schema " + schemaName + ".", "\n");
            return;
        }
        this.retrieveExistingIndexes(schemaId);
        outputWriter.printHeader("\n", schemaName + " has " + this.regularIndexes.size() + " regular and " + this.functionalIndexes.size() + " functional indexes.", "\n");
        for (i = 1; i <= this.regularIndexes.size(); ++i) {
            outputWriter.printHeader("\n\t", " Regular Index# " + i + ": ", this.regularIndexes.get(i - 1));
        }
        for (i = 1; i <= this.functionalIndexes.size(); ++i) {
            outputWriter.printHeader("\n\t", " Functional Index# " + i + ": ", this.functionalIndexes.get(i - 1));
        }
    }

    private void retrieveExistingIndexes(int schemaId) {
        this.regularIndexes.clear();
        this.functionalIndexes.clear();
        StringBuilder sqlCommand = new StringBuilder("SELECT index_name, index_type from all_indexes where table_name = 'T" + schemaId + "'");
        try {
            SQLResult result = this.arServerUser.getListSQL(sqlCommand.toString(), 100, false);
            List<List<Value>> valueListList = result.getContents();
            for (int i = 0; i < valueListList.size(); ++i) {
                if (valueListList.get(i).get(1).toString().contains("FUNCTION-BASED")) {
                    this.functionalIndexes.add(valueListList.get(i).get(0).toString());
                    continue;
                }
                this.regularIndexes.add(valueListList.get(i).get(0).toString());
            }
        }
        catch (ARException aRException) {
            // empty catch block
        }
    }

    boolean isExistingIndex(String newName, String nlsSortParam) {
        return nlsSortParam != null ? this.functionalIndexes.contains(newName) || this.functionalIndexes.contains(newName + "_CI") : this.regularIndexes.contains(newName) || this.regularIndexes.contains(newName + "_CS");
    }

    private void createCurrentDBIndex(String schemaName, int schemaId, IndexInfo curIndex, String nlsSortParam) throws ARException {
        StringBuffer newIndexName = new StringBuffer(curIndex.getIndexName());
        if (this.isExistingIndex(newIndexName.toString(), nlsSortParam)) {
            outputWriter.printHeader("", " Index " + newIndexName + " already exists.", "\n");
            return;
        }
        newIndexName = nlsSortParam != null ? newIndexName.append("_CI") : newIndexName.append("_CS");
        String sqlCommand = this.BuildCreateIndexCommand(schemaName, schemaId, curIndex, newIndexName.toString(), nlsSortParam);
        if (sqlCommand != null) {
            this.arServerUser.getListSQL(sqlCommand, 1, false);
            List<StatusInfo> status = this.arServerUser.getLastStatus();
            if (!status.isEmpty()) {
                outputWriter.printHeader("", " Error while executing SQL Command: " + sqlCommand + status.get(0).getMessageNum(), "\n");
            }
        }
    }

    private void dropCurrentDBIndex(String curIndex) {
        String sqlCommand = this.BuildDropIndexCommand(curIndex);
        try {
            this.arServerUser.getListSQL(sqlCommand, 1, false);
        }
        catch (ARException aRException) {
            // empty catch block
        }
    }

    String BuildDropIndexCommand(String curIndex) {
        StringBuilder sqlCommand = new StringBuilder("DROP INDEX " + curIndex);
        return sqlCommand.toString();
    }

    String BuildCreateIndexCommand(String schemaName, int schemaId, IndexInfo curIndex, String newIndexName, String nlsSortParam) throws ARException {
        boolean visitedCharacterField = false;
        List<Integer> fields = curIndex.getIndexFields();
        String tableName = "T" + schemaId;
        String sqlCommand = new String();
        sqlCommand = curIndex.isUnique() ? "CREATE UNIQUE INDEX " : "CREATE INDEX ";
        sqlCommand = sqlCommand.concat(newIndexName + " ON " + tableName + " (");
        if (fields.size() == 1) {
            FieldKey key = new FieldKey(schemaName, fields.get(0));
            FieldCriteria crit = new FieldCriteria();
            crit.setPropertiesToRetrieve(FieldCriteria.DATATYPE);
            Field field = this.arServerUser.getField(key.getFormName(), key.getFieldID(), crit);
            if (field.getDataType() == 4) {
                visitedCharacterField = true;
            }
            if (nlsSortParam != null && field.getDataType() != 4) {
                return null;
            }
            sqlCommand = nlsSortParam != null && visitedCharacterField ? sqlCommand.concat("nlssort(C" + fields.get(0) + ", " + "'NLS_SORT=" + nlsSortParam + "'" + ")") : sqlCommand.concat("C" + fields.get(0));
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                FieldKey key = new FieldKey(schemaName, fields.get(i));
                FieldCriteria crit = new FieldCriteria();
                crit.setPropertiesToRetrieve(FieldCriteria.DATATYPE);
                Field field = this.arServerUser.getField(key.getFormName(), key.getFieldID(), crit);
                if (field.getDataType() == 4) {
                    visitedCharacterField = true;
                }
                if (i > 0) {
                    sqlCommand = sqlCommand.concat(", ");
                }
                sqlCommand = nlsSortParam != null && field.getDataType() == 4 ? sqlCommand.concat("(nlssort(C" + fields.get(i).toString() + ", " + "'NLS_SORT=" + nlsSortParam + "'" + "))") : sqlCommand.concat("C" + fields.get(i).toString());
            }
        }
        sqlCommand = sqlCommand.concat(")");
        if (nlsSortParam != null && !visitedCharacterField) {
            return null;
        }
        return sqlCommand;
    }

    private void createDBIndexesForSchema(String schemaName, String nlsSortParam) throws ARException {
        List<IndexInfo> indexList;
        FormCriteria criteria = new FormCriteria();
        criteria.setPropertiesToRetrieve(FormCriteria.INDEX_LIST);
        Form curForm = this.arServerUser.getForm(schemaName, criteria);
        if (curForm == null) {
            return;
        }
        int schemaId = this.getSchemaIdForSchema(schemaName);
        if (schemaId == 0) {
            outputWriter.printHeader("", "Error while retrieving schema id for schema " + schemaName + ".", "\n");
            return;
        }
        this.retrieveExistingIndexes(schemaId);
        if (nlsSortParam != null) {
            String indexName = "IT" + schemaId + "_CI";
            if (!this.functionalIndexes.contains(indexName)) {
                StringBuffer sqlCommand = new StringBuffer("CREATE UNIQUE INDEX " + indexName + " ON T" + schemaId + " (nlssort(C1, 'NLS_SORT=" + nlsSortParam + "'))");
                this.arServerUser.getListSQL(sqlCommand.toString(), 1, false);
                List<StatusInfo> status = this.arServerUser.getLastStatus();
                if (!status.isEmpty()) {
                    outputWriter.printHeader("", " Error while executing SQL Command: " + sqlCommand + status.get(0).getMessageNum(), "\n");
                }
            } else {
                outputWriter.printHeader("", " Index " + indexName + " already exists.", "\n");
            }
        }
        if ((indexList = curForm.getIndexInfo()) == null || indexList.size() == 0) {
            outputWriter.printHeader("There are 0 indexes on the form", " ...skipping this form", "\n");
            return;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            IndexInfo curDBIndex = indexList.get(i);
            if (curDBIndex == null) continue;
            this.createCurrentDBIndex(schemaName, schemaId, curDBIndex, nlsSortParam);
        }
    }

    private void dropDBIndexesForSchema(String schemaName, boolean functionalIndex) throws ARException {
        int i;
        int schemaId = this.getSchemaIdForSchema(schemaName);
        if (schemaId == 0) {
            outputWriter.printHeader("", "Error while retrieving schema id for schema " + schemaName + ".", "\n");
            return;
        }
        String C1IndexName = "IT" + schemaId;
        this.retrieveExistingIndexes(schemaId);
        if (functionalIndex) {
            if (this.functionalIndexes.size() == 0) {
                outputWriter.printHeader("There are 0 functional indexes on the form", " ... skipping this form", "\n");
                return;
            }
            for (i = 0; i < this.functionalIndexes.size(); ++i) {
                this.dropCurrentDBIndex(this.functionalIndexes.get(i));
            }
        } else {
            if (this.regularIndexes.size() == 0) {
                outputWriter.printHeader("There are 0 indexes on the form", " ... skipping this form", "\n");
                return;
            }
            for (i = 0; i < this.regularIndexes.size(); ++i) {
                if (this.regularIndexes.get(i).equals(C1IndexName)) continue;
                this.dropCurrentDBIndex(this.regularIndexes.get(i));
            }
        }
        if (!functionalIndex) {
            String C1 = new String(C1IndexName + "_CI");
            for (int i2 = 0; i2 < this.functionalIndexes.size(); ++i2) {
                String curIndexName = this.functionalIndexes.get(i2);
                if (curIndexName.equals(C1) || !curIndexName.endsWith("_CI") || this.functionalIndexes.get(i2).equals(C1)) continue;
                String newName = curIndexName.replace("_CI", "");
                StringBuffer sqlCommand = new StringBuffer("ALTER INDEX " + curIndexName + " RENAME TO " + newName);
                try {
                    this.arServerUser.getListSQL(sqlCommand.toString(), 1, false);
                    continue;
                }
                catch (ARException aRException) {
                    // empty catch block
                }
            }
        } else {
            String C1 = new String(C1IndexName + "_CS");
            for (int i3 = 0; i3 < this.regularIndexes.size(); ++i3) {
                String curIndexName = this.regularIndexes.get(i3);
                if (curIndexName.equals(C1) || !curIndexName.endsWith("_CS") || this.regularIndexes.get(i3).equals(C1)) continue;
                String newName = curIndexName.replace("_CS", "");
                StringBuffer sqlCommand = new StringBuffer("ALTER INDEX " + curIndexName + " RENAME TO " + newName);
                try {
                    this.arServerUser.getListSQL(sqlCommand.toString(), 1, false);
                    continue;
                }
                catch (ARException aRException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        OracleFunctionalIndexHelper indexHelper = new OracleFunctionalIndexHelper();
        String nlsSortParam = null;
        try {
            JavaDriver.getThreadControlBlockPtr().setPrimaryThread(true);
            JavaDriver.getThreadControlBlockPtr().setCurrentInputToStdIn();
            JavaDriver.getThreadControlBlockPtr().setOutputToStdOut();
            outputWriter.printHeader("\t\t\t", "Oracle Functional Index Helper Utility", "\n");
            outputWriter.printHeader("\n", "===================================================================================================", "");
            outputWriter.printHeader("\n", "This is an un-supported convenience program which is being provide on ASIS basis to help customers", "");
            outputWriter.printHeader("\n", "in converting regular indexes to functional indexes and vice-versa. This utility is supposed to be ", "");
            outputWriter.printHeader("\n", "used in context of Oracle case insensitive search configuration in AR Server. The utility accepts an", "");
            outputWriter.printHeader("\n", "optional input argument which controls the forms which will be considered for index conversion. If the", "");
            outputWriter.printHeader("\n", "command line argument \"Input File containing the form names\" is not specified, the utility will be", "");
            outputWriter.printHeader("\n", "run on all the forms available on the server. The utility supports ADD, DROP and VIEW operations for", "");
            outputWriter.printHeader("\n", "indexes on the server. For ADD and DROP operations, index type (functional or regular) must be specified.", "");
            outputWriter.printHeader("\n", "The utility supports NLS_SORT parameters [BINARY_CI(0),BINARY_AI(1), GENERIC_M(2)] for case insensitive", "");
            outputWriter.printHeader("\n", "searches. The default value is BINARY_CI.", "\n");
            outputWriter.printHeader("\n", "The utility accepts following input values:", "");
            outputWriter.printHeader("\n\t", "Server Host: < name of the server, default is localhost >", "");
            outputWriter.printHeader("\n\t", "Server Port: < server port, default is 0 >", "");
            outputWriter.printHeader("\n\t", "User Name: < valid AR Server admin user >", "");
            outputWriter.printHeader("\n\t", "Password:  < AR Server admin password >", "");
            outputWriter.printHeader("\n\t", "Input File containing the form names: < Provide this argument to run on specific forms only>", "");
            outputWriter.printHeader("\n\t", "Index Operation Type: <Index operation type[Add(0),Drop(1),View(2), Exit(3)]>  ", "");
            outputWriter.printHeader("\n", "===================================================================================================", "\n\n");
            String serverName = InputReader.getString("Server Host:", "localhost");
            int serverPort = InputReader.getInt("Server Port:", 0);
            String userName = InputReader.getString("User Name:", "Demo");
            String password = InputReader.getString("Password:", "");
            String locale = null;
            indexHelper.arServerUser = new ARServerUser(userName, password, locale, serverName, serverPort);
            try {
                indexHelper.arServerUser.login();
                if (!indexHelper.arServerUser.isAdministrator()) {
                    outputWriter.printHeader("*** ERROR ***", " Need AR Administrator privilege to run the utility", "\nIndex Helper utility stopped");
                    return;
                }
            }
            catch (ARException e) {
                String msg = e.getMessage();
                outputWriter.printHeader("*** ERROR ***: Login failed for user: ", userName, "\n");
                if (msg != null) {
                    outputWriter.printHeader(msg, "\n", "Index Helper utility stopped");
                }
                try {
                    indexHelper.arServerUser.logout();
                    return;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return;
                }
                finally {
                    System.exit(0);
                }
            }
            {
                indexHelper.arServerUser.setTimeoutNormal(28800);
                indexHelper.arServerUser.setTimeoutLong(28800);
                indexHelper.arServerUser.setTimeoutXLong(28800);
            }
            InputReader.setNullPromptOption(true);
            String fileName = InputReader.getString("Input File containing the form names:", "");
            int[] requestList = new int[]{1};
            ServerInfoMap serverInfoMap = indexHelper.arServerUser.getServerInfo(requestList);
            String dbType = ((Value)serverInfoMap.get(1)).toString();
            if (!dbType.equals("SQL -- Oracle")) {
                outputWriter.printHeader("*** ERROR ***: Utility supports only Oracle Databse, underline DB detected: ", dbType, "\nIndex Helper utility stopped");
                return;
            }
            int opType = 2;
            int indexType = 0;
            try {
                indexHelper.readSchemaNames(fileName);
            }
            catch (FileNotFoundException e) {
                String msg = e.getMessage();
                outputWriter.printHeader("*** ERROR ***: Invalid File: ", fileName != null ? fileName : "", "\n");
                if (msg != null) {
                    outputWriter.printHeader(msg, "\n", "Index Helper utility stopped");
                }
                try {
                    indexHelper.arServerUser.logout();
                    return;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    return;
                }
                finally {
                    System.exit(0);
                }
            }
            int invalidComandCount = 0;
            outputWriter.printHeader("", "Processing " + indexHelper.getSchemaCount() + " Forms.", "\n");
            while (opType != 3) {
                nlsSortParam = null;
                opType = InputReader.getInt("Index Operation Type: [Add(0),Drop(1),View(2), Exit(3)]", 2);
                if (opType < 0 || opType > 3) {
                    if (invalidComandCount > 3) {
                        outputWriter.printHeader("*** ERROR ***: Invalid command option: ", "Max attempt", "\nIndex Helper utility stopped");
                        return;
                    }
                    outputWriter.printHeader("*** ERROR ***: Invalid command option: ", "", "\n");
                    ++invalidComandCount;
                    continue;
                }
                invalidComandCount = 0;
                if (opType == 0) {
                    indexType = InputReader.getInt("Index type to add: [REGULAR(0),FUNCTIONAL(1)]", 1);
                }
                if (opType == 1 && (indexType = InputReader.getInt("Index type to drop: [REGULAR(0),FUNCTIONAL(1)]", 1)) == 0) {
                    nlsSortParam = null;
                }
                if (opType == 0 && indexType == 1) {
                    int nlsSortType = InputReader.getInt("NLS_SORT parameter: [BINARY_CI(0),BINARY_AI(1), GENERIC_M(2)", 0);
                    switch (nlsSortType) {
                        case 0: {
                            nlsSortParam = "BINARY_CI";
                            break;
                        }
                        case 1: {
                            nlsSortParam = "BINARY_AI";
                            break;
                        }
                        case 2: {
                            nlsSortParam = "GENERIC_M";
                            break;
                        }
                        default: {
                            nlsSortParam = "BINARY_CI";
                        }
                    }
                }
                Calendar now = Calendar.getInstance();
                long startTime = now.getTimeInMillis();
                switch (opType) {
                    case 0: {
                        indexHelper.createDBIndexes(nlsSortParam);
                        break;
                    }
                    case 1: {
                        if (indexType == 1) {
                            indexHelper.dropDBIndexes(true);
                            break;
                        }
                        indexHelper.dropDBIndexes(false);
                        break;
                    }
                    case 2: {
                        indexHelper.viewDBIndexes();
                        break;
                    }
                }
                now = Calendar.getInstance();
                long endTime = now.getTimeInMillis();
                long elapsedTime = (endTime - startTime) / 1000L;
                outputWriter.printHeader("", "\n", "\n");
                outputWriter.printHeader("", "Current Run Report         \n", "\n");
                outputWriter.printHeader("", "==========================================", "\n");
                outputWriter.printHeader("", "Processing Completed in " + elapsedTime + " seconds.", "\n");
                outputWriter.printHeader("", "==========================================", "\n");
            }
            return;
        }
        catch (Exception e) {
            outputWriter.printString("Error in executing the command: ", e.getMessage(), "\nIndex Helper utility stopped");
            return;
        }
        finally {
            try {
                indexHelper.arServerUser.logout();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                System.exit(0);
            }
        }
    }
}

