/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.mapping;

import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.mapping.ARSOperation;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ARSPort {
    protected Element element;
    protected String name;
    protected String targetNamespace;
    protected String locationURI;
    protected HashMap<String, ARSOperation> operations = new HashMap();
    protected LinkedList<ARSOperation> operationsList = new LinkedList();
    protected HashMap<String, ARSMapping> mappings = new HashMap();
    protected LinkedList<ARSMapping> mappingsList = new LinkedList();
    protected String bindingStyle = "document";
    protected String useStyle = "literal";

    public String getName() {
        return this.name;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public Collection getOperations() {
        return this.operationsList;
    }

    public Collection getMappings() {
        return this.mappingsList;
    }

    public ARSOperation getOperation(String name) {
        return this.operations.get(name);
    }

    public ARSMapping getMapping(String name) {
        return this.mappings.get(name);
    }

    public String getBindingStyle() {
        return this.bindingStyle;
    }

    public String getUseStyle() {
        return this.useStyle;
    }

    public ARSPort(String name, String locationURI, String namespace, String bindingStyle, String useStyle) {
        this.name = name;
        this.locationURI = locationURI;
        this.bindingStyle = bindingStyle;
        this.useStyle = useStyle;
        this.element = null;
        this.targetNamespace = namespace;
    }

    public ARSPort(Element elem, String serviceNamespace) {
        this.element = elem;
        this.parseXML(serviceNamespace);
    }

    public ARSPort(ARSPort oldPort, String schemaUri, String serviceNamespace, StringBuffer warnings) {
        XMLSchemaParser schemaParser = new XMLSchemaParser(schemaUri, warnings);
        Document doc = WsdlUtil.newDocument();
        doc.appendChild(doc.importNode(oldPort.element, true));
        this.element = doc.getDocumentElement();
        this.parseXML(serviceNamespace);
        NodeList nsList = this.element.getElementsByTagNameNS(null, "externalSchema");
        if (nsList != null && nsList.getLength() > 0) {
            ((Element)nsList.item(0)).setAttributeNS(null, "name", schemaUri);
        }
        for (int i = 0; i < this.mappingsList.size(); ++i) {
            ARSMapping mapping = this.mappingsList.get(i);
            ARSMapping oldMapping = oldPort.getMapping(mapping.getName());
            ARSMapping newMapping = null;
            try {
                QName qname;
                if (oldMapping.getMappingMode() == 3) {
                    qname = new QName(oldMapping.getExternalNamespace(), oldMapping.getExternalGlobalName());
                    newMapping = new ARSMapping(schemaParser, qname, "complexType", doc);
                    newMapping.setMappingName(oldMapping.getName());
                } else if (oldMapping.getMappingMode() == 2) {
                    qname = new QName(oldMapping.getExternalNamespace(), oldMapping.getExternalGlobalName());
                    newMapping = new ARSMapping(schemaParser, qname, "element", doc);
                    newMapping.setMappingName(oldMapping.getName());
                }
            }
            catch (ARWSException e) {
                newMapping = new ARSMapping(oldMapping.getName(), oldMapping.getTargetNamespace(), doc);
                oldMapping.warnChildren(warnings);
            }
            if (newMapping == null) continue;
            newMapping.resolveMapping(mapping, warnings);
            this.mappingsList.set(i, newMapping);
            this.mappings.put(newMapping.getName(), newMapping);
            mapping.getMappingElement().getParentNode().replaceChild(newMapping.getMappingElement(), mapping.getMappingElement());
        }
    }

    public void parseXML(String serviceNamespace) {
        if (!this.element.getLocalName().equals("port")) {
            throw new ARWSException("OTHER_ERROR", "ERROR: root element in parseWebServiceInfo should be webservice");
        }
        this.name = this.element.getAttribute("name");
        if (this.name == null) {
            throw new ARWSException("OTHER_ERROR", "ERROR: port should have a name attribute");
        }
        this.locationURI = this.element.getAttribute("locationURI");
        this.targetNamespace = this.element.getAttribute("targetNamespace");
        NodeList childNodes = this.element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            if (elem.getLocalName().equals("arDocMapping")) {
                ARSMapping mapping = new ARSMapping(elem);
                this.addMapping(mapping);
                if (this.targetNamespace != null) continue;
                this.targetNamespace = mapping.getTargetNamespace();
                continue;
            }
            if (elem.getLocalName().equals("operation")) {
                ARSOperation operation = new ARSOperation(elem);
                this.addOperation(operation);
                continue;
            }
            if (!elem.getLocalName().equals("portProperties")) continue;
            NodeList subChildNodes = elem.getChildNodes();
            for (int j = 0; j < subChildNodes.getLength(); ++j) {
                int index;
                String style;
                Element subElem;
                Node subNode = subChildNodes.item(j);
                if (subNode.getNodeType() != 1 || !(subElem = (Element)subNode).getLocalName().equals("portType") || (style = subElem.getAttribute("name")) == null || style.equals("") || (index = style.indexOf(32)) <= -1) continue;
                this.bindingStyle = style.substring(0, index);
                int lastIndex = style.lastIndexOf(32);
                if (lastIndex <= -1) continue;
                this.useStyle = style.substring(lastIndex + 1, style.length());
            }
        }
        if (this.targetNamespace == null || this.targetNamespace.equals("")) {
            this.targetNamespace = serviceNamespace;
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void generateXML(Document parent, Element serviceElem) {
        Element portElem = parent.createElementNS(null, "port");
        portElem.setAttributeNS(null, "name", this.getName());
        portElem.setAttributeNS(null, "targetNamespace", this.getTargetNamespace());
        portElem.setAttributeNS(null, "locationURI", this.getLocationURI());
        this.element = portElem;
        serviceElem.appendChild(portElem);
        Element portType = parent.createElementNS(null, "portType");
        portType.setAttributeNS(null, "name", this.getBindingStyle() + " - " + this.getUseStyle());
        Element portProperties = parent.createElementNS(null, "portProperties");
        portProperties.appendChild(portType);
        portElem.appendChild(portProperties);
        for (ARSMapping mapping : this.getMappings()) {
            mapping.generateXML(portElem);
        }
        for (ARSOperation operation : this.getOperations()) {
            operation.generateXML(portElem);
        }
    }

    public void addOperation(ARSOperation operation) {
        if (!this.operations.containsKey(operation.getName())) {
            this.operations.put(operation.getName(), operation);
            this.operationsList.add(operation);
        }
    }

    public void addMapping(ARSMapping mapping) {
        if (!this.mappings.containsKey(mapping.getName())) {
            this.mappings.put(mapping.getName(), mapping);
            this.mappingsList.add(mapping);
        }
    }
}

