/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.client;

import com.bmc.arsys.ws.client.PWCallback;
import com.bmc.arsys.ws.client.PolicyDetails;
import com.bmc.arsys.ws.client.WsPluginReceiver;
import com.bmc.arsys.ws.client.WsPluginSender;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axis.Handler;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;

class WSPolicyProcessor {
    public static final String SECURITY_ACTION_SIGN_ENCRYPT = "Signature Encrypt";

    WSPolicyProcessor() {
    }

    public static void processPolicy(PolicyDetails pd, Call call, String webSvcNmSpace) throws IOException {
        pd.setWebSvcNmSpace(webSvcNmSpace);
        Handler sender = WSPolicyProcessor.getRequestHandlers(pd, call);
        Handler receiver = WSPolicyProcessor.getResponseHandlers(pd, call);
        call.setClientHandlers(sender, receiver);
    }

    private static Handler getRequestHandlers(PolicyDetails pd, Call call) throws IOException {
        String action = "";
        String requestAction = pd.getRequestSecurityAction();
        if (requestAction == null) {
            return null;
        }
        WsPluginSender send = new WsPluginSender(pd);
        if (requestAction.indexOf("Timestamp") > -1) {
            action = "Timestamp";
        }
        if (requestAction.indexOf(SECURITY_ACTION_SIGN_ENCRYPT) > -1) {
            send.setOption("signatureKeyIdentifier", pd.getSignKeyID());
            byte[] bt = pd.getPropBytes();
            String str = new String(bt);
            Properties propprop = new Properties();
            ByteArrayInputStream bais = new ByteArrayInputStream(bt);
            propprop.load(bais);
            send.setOption("SignaturePropRefId", propprop);
            send.setOption("encryptionPropRefId", propprop);
            send.setOption("user", pd.getUserAlias());
            send.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(pd, requestAction));
            send.setOption("encryptionKeyIdentifier", pd.getEncKeyID());
            send.setOption("encryptionUser", pd.getEncryptionUserAlias());
            String encSymAlg = pd.getEncSymAlg();
            if (encSymAlg != null) {
                if (encSymAlg.equals("AES_192")) {
                    send.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
                }
                if (encSymAlg.equals("AES_256")) {
                    send.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
                }
                if (encSymAlg.equals("Triple DES")) {
                    send.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
                }
            }
            if (pd.isHeaderEncFlagSet()) {
                String signParts = null;
                if (action.indexOf("Timestamp") > -1) {
                    signParts = "{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;";
                }
                if (signParts != null) {
                    signParts = signParts + "{Content}{http://schemas.xmlsoap.org/soap/envelope/}Body";
                }
                if (signParts != null) {
                    send.setOption("signatureParts", signParts);
                }
            }
            action = action.length() > 0 ? action + ' ' + SECURITY_ACTION_SIGN_ENCRYPT : SECURITY_ACTION_SIGN_ENCRYPT;
        } else if (requestAction.indexOf("Signature") > -1) {
            send.setOption("signatureKeyIdentifier", pd.getSignKeyID());
            byte[] bt = pd.getPropBytes();
            String str = new String(bt);
            Properties propprop = new Properties();
            ByteArrayInputStream bais = new ByteArrayInputStream(bt);
            propprop.load(bais);
            send.setOption("SignaturePropRefId", propprop);
            if (pd.isHeaderEncFlagSet()) {
                String signParts = null;
                if (action.indexOf("Timestamp") > -1) {
                    signParts = "{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;";
                }
                if (signParts != null) {
                    signParts = signParts + "{Content}{http://schemas.xmlsoap.org/soap/envelope/}Body";
                }
                if (signParts != null) {
                    send.setOption("signatureParts", signParts);
                }
            }
            action = action.length() > 0 ? action + ' ' + "Signature" : "Signature";
            send.setOption("user", pd.getUserAlias());
            send.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(pd, requestAction));
        } else if (requestAction.indexOf("Encrypt") > -1) {
            send.setOption("encryptionKeyIdentifier", pd.getEncKeyID());
            byte[] bt = pd.getPropBytes();
            String str = new String(bt);
            Properties propprop = new Properties();
            ByteArrayInputStream bais = new ByteArrayInputStream(bt);
            propprop.load(bais);
            send.setOption("encryptionPropRefId", propprop);
            action = action.length() > 0 ? action + ' ' + "Encrypt" : "Encrypt";
            send.setOption("encryptionUser", pd.getEncryptionUserAlias());
            send.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(pd, requestAction));
            String encSymAlg = pd.getEncSymAlg();
            if (encSymAlg != null) {
                if (encSymAlg.equals("AES_192")) {
                    send.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
                }
                if (encSymAlg.equals("AES_256")) {
                    send.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
                }
                if (encSymAlg.equals("Triple DES")) {
                    send.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
                }
            }
            if (pd.isHeaderEncFlagSet()) {
                send.setOption("encryptionParts", "{Element}{" + pd.getWebSvcNmSpace() + "}AuthenticationInfo;{Content}{http://schemas.xmlsoap.org/soap/envelope/}Body");
            }
        } else {
            return null;
        }
        send.setOption("action", action);
        send.setOption("mustUnderstand", "false");
        return send;
    }

    private static Handler getResponseHandlers(PolicyDetails pd, Call call) throws IOException {
        String action = "";
        String resAction = pd.getResponseSecurityAction();
        if (resAction == null) {
            return null;
        }
        WsPluginReceiver recv = new WsPluginReceiver(pd);
        if (resAction.indexOf("Timestamp") > -1) {
            action = action + "Timestamp";
        }
        if (resAction.indexOf(SECURITY_ACTION_SIGN_ENCRYPT) > -1) {
            action = action.length() > 0 ? action + ' ' + SECURITY_ACTION_SIGN_ENCRYPT : SECURITY_ACTION_SIGN_ENCRYPT;
            byte[] bt = pd.getPropBytes();
            String str = new String(bt);
            Properties propprop = new Properties();
            ByteArrayInputStream bais = new ByteArrayInputStream(bt);
            propprop.load(bais);
            recv.setOption("SignaturePropRefId", propprop);
            recv.setOption("decryptionPropRefId", propprop);
            recv.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(pd, resAction));
        } else if (resAction.indexOf("Signature") > -1) {
            action = action.length() > 0 ? action + ' ' + "Signature" : "Signature";
            byte[] bt = pd.getPropBytes();
            String str = new String(bt);
            Properties propprop = new Properties();
            ByteArrayInputStream bais = new ByteArrayInputStream(bt);
            propprop.load(bais);
            recv.setOption("SignaturePropRefId", propprop);
            recv.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(pd, resAction));
        } else if (resAction.indexOf("Encrypt") > -1) {
            action = action.length() > 0 ? action + ' ' + "Encrypt" : "Encrypt";
            byte[] bt = pd.getPropBytes();
            String str = new String(bt);
            Properties propprop = new Properties();
            ByteArrayInputStream bais = new ByteArrayInputStream(bt);
            propprop.load(bais);
            recv.setOption("decryptionPropRefId", propprop);
            recv.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(pd, resAction));
        } else if (action.length() == 0) {
            return null;
        }
        recv.setOption("action", action);
        recv.setOption("mustUnderstand", "false");
        if (pd.getSignConfirm()) {
            recv.setOption("enableSignatureConfirmation", "false");
        } else {
            recv.setOption("enableSignatureConfirmation", "true");
        }
        return recv;
    }

    static CallbackHandler getPasswordCB(PolicyDetails pd, String action) {
        String passwd = null;
        if (action.indexOf("Signature") > -1) {
            passwd = pd.getUserAliasPassword();
        } else if (action.indexOf("Encrypt") > -1) {
            passwd = pd.getEncryptionUserAliasPassword();
        }
        return new PWCallback(passwd);
    }

    public static void dumpEnvelop(SOAPEnvelope envelop, PrintWriter writer) throws Exception {
        XMLUtils.PrettyElementToWriter(envelop.getAsDOM(), writer);
    }

    public static enum Action {
        TIMESTAMP,
        SIGN,
        ENCRYPT,
        SIGN_ENCRYPT,
        NONE;

    }
}

