/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.util;

import com.bmc.arsys.plugins.util.FileChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

public class FileMonitor {
    private static final FileMonitor instance = new FileMonitor();
    private Timer timer = new Timer(true);
    private Hashtable<String, FileMonitorTask> timerEntries = new Hashtable();

    public static FileMonitor getInstance() {
        return instance;
    }

    protected FileMonitor() {
    }

    public void addFileChangeListener(FileChangeListener listener, String fileName, long period) throws FileNotFoundException {
        if (fileName == null || fileName.length() <= 0 || !new File(fileName).exists()) {
            return;
        }
        this.removeFileChangeListener(listener, fileName);
        FileMonitorTask task = new FileMonitorTask(listener, fileName);
        this.timerEntries.put(fileName + listener.hashCode(), task);
        this.timer.schedule((TimerTask)task, period, period);
    }

    public void removeFileChangeListener(FileChangeListener listener, String fileName) {
        FileMonitorTask task = this.timerEntries.remove(fileName + listener.hashCode());
        if (task != null) {
            task.cancel();
        }
    }

    protected void fireFileChangeEvent(FileChangeListener listener, String fileName) {
        listener.fileChanged(fileName);
    }

    class FileMonitorTask
    extends TimerTask {
        FileChangeListener listener;
        String fileName;
        File monitoredFile;
        long lastModified;

        public FileMonitorTask(FileChangeListener listener, String fileName) throws FileNotFoundException {
            this.listener = listener;
            this.fileName = fileName;
            this.lastModified = 0L;
            this.monitoredFile = new File(fileName);
            if (!this.monitoredFile.exists()) {
                URL fileURL = listener.getClass().getClassLoader().getResource(fileName);
                if (fileURL != null) {
                    this.monitoredFile = new File(fileURL.getFile());
                } else {
                    throw new FileNotFoundException("File Not Found: " + fileName);
                }
            }
            this.lastModified = this.monitoredFile.lastModified();
        }

        @Override
        public void run() {
            long lastModified = this.monitoredFile.lastModified();
            if (lastModified != this.lastModified) {
                this.lastModified = lastModified;
                FileMonitor.this.fireFileChangeEvent(this.listener, this.fileName);
            }
        }
    }
}

