/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.sso;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.plugins.AREAPlugin;
import com.bmc.arsys.pluginsvr.plugins.AREAResponse;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.atrium.sso.common.AtriumSSOException;
import com.bmc.atrium.sso.sdk.Authentication;
import com.bmc.atrium.sso.sdk.Realms;
import com.bmc.atrium.sso.sdk.SSOPrincipal;
import com.bmc.atrium.sso.sdk.SSOServer;
import com.bmc.atrium.sso.sdk.SSOToken;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class AtriumSSOPlugin
extends AREAPlugin {
    private Authentication ssoContext;
    private Realms rootRealm;
    private int onEventFlag = 0;
    private boolean checkLocation = true;
    private String keyStorePasswordCopy = null;
    String atriumSSOLocation = null;
    private final ReentrantLock lock = new ReentrantLock();
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.AREA.ATRIUMSSO", (ARPluggable)this);

    public void initialize(ARPluginContext context) throws ARException {
        System.out.println("Intializing plug-in : " + context.getPluginInfo().getName());
        this.atriumSSOLocation = context.getARConfigEntry("Atrium-SSO-Location");
        String keyStoreLocation = context.getARConfigEntry("Atrium-SSO-Keystore-Path");
        String keyStorePassword = context.getARConfigEntry("Atrium-SSO-Keystore-Password");
        if (this.atriumSSOLocation == null || this.atriumSSOLocation.length() == 0) {
            context.logMessage(this.pluginInfo, 0, "Atrium SSO Server Location Is Null");
            return;
        }
        if (this.onEventFlag == 1) {
            this.checkLocation = true;
        } else {
            this.onEventFlag = 0;
        }
        try {
            if (keyStorePassword != null && (this.keyStorePasswordCopy == null || keyStorePassword.compareTo(this.keyStorePasswordCopy) != 0)) {
                this.keyStorePasswordCopy = new String(keyStorePassword);
                PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
                byte[] decPasswd = pwdEnc.decryptPasswordEx(keyStorePassword.getBytes());
                keyStorePassword = new String(decPasswd);
            }
        }
        catch (Exception e1) {
            context.logMessage(this.pluginInfo, 2, e1.toString());
            throw new ARException(2, 8753, e1.getMessage());
        }
        SSOServer server = null;
        try {
            server = SSOServer.getInstance((String)this.atriumSSOLocation);
            this.rootRealm = server.getRealms();
            if (keyStoreLocation != null) {
                try {
                    FileInputStream inputStream = new FileInputStream(keyStoreLocation);
                    KeyStore keystore = KeyStore.getInstance("jks");
                    char[] keyPass = keyStorePassword.toCharArray();
                    keystore.load(inputStream, keyPass);
                    server.setTrustStore(keystore);
                }
                catch (Exception e) {
                    context.logMessage(this.pluginInfo, 2, e.toString());
                    throw new ARException(2, 8753, e.getMessage());
                }
            } else {
                server.setAcceptAllServerCertificates(true);
            }
            context.logMessage(this.pluginInfo, 0, "Fetching Realms");
            this.ssoContext = server.getAuthentication();
        }
        catch (AtriumSSOException e) {
            context.logMessage(this.pluginInfo, 2, e.toString());
            throw new ARException(2, 8753, e.getMessage());
        }
        System.out.println("Intializing plugin " + context.getPluginInfo().getName());
    }

    public AREAResponse areaVerifyLogin(ARPluginContext context, String user, String password, String networkAddress, String authString) throws ARException {
        context.logMessage(this.pluginInfo, 0, "areaVerifyLogin()");
        AREAResponse resp = new AREAResponse();
        if (this.atriumSSOLocation == null || this.atriumSSOLocation.length() == 0) {
            resp.setLoginStatus(2);
            context.logMessage(this.pluginInfo, 2, "Login Failed as Atrium SSO Server Location is null");
            return resp;
        }
        if (ARPluginSvrThreadLocalStorageBlock.getTLB().getAPIClientType() == 38) {
            resp.setLoginStatus(2);
            context.logMessage(this.pluginInfo, 0, "Not authenticating calls initiated by Atrium SSO Server..returning");
            return resp;
        }
        try {
            String extGroups;
            String tokenId = null;
            if (authString == null || authString.length() == 0) {
                context.logMessage(this.pluginInfo, 0, "authString is null ");
                context.logMessage(this.pluginInfo, 0, "User Name : " + user);
                if (password == null || password.length() == 0) {
                    context.logMessage(this.pluginInfo, 0, "Password is null ");
                } else {
                    tokenId = this.ssoContext.connect(this.rootRealm.getRootRealm(), (CallbackHandler)new SSOAuthCallbackHandler(user, password));
                }
            } else {
                context.logMessage(this.pluginInfo, 0, "User Name : " + user);
                context.logMessage(this.pluginInfo, 0, "authString: " + authString);
                tokenId = authString;
            }
            SSOToken ssoToken = null;
            if (tokenId != null) {
                ssoToken = this.ssoContext.getToken(tokenId);
            }
            resp.setLoginStatus(1);
            if (ssoToken != null) {
                SSOPrincipal ssoPrinc = ssoToken.getPrincipal();
                resp.setLoginStatus(0);
                context.logMessage(this.pluginInfo, 0, "Login Successful");
                resp.setLicenseWrite(1);
                extGroups = null;
                for (String g : ssoPrinc.getGroups()) {
                    extGroups = extGroups == null ? new String(g) : extGroups.concat(g);
                    extGroups = extGroups.concat(";");
                }
            } else {
                context.logMessage(this.pluginInfo, 0, "Login Failed");
                StatusInfo info = null;
                info = tokenId != null ? new StatusInfo(2, 1000L, "Invalid tokenId for ", user) : new StatusInfo(2, 1000L, "tokenId is null for ", user);
                ArrayList<StatusInfo> list = new ArrayList<StatusInfo>();
                list.add(info);
                throw new ARException(list);
            }
            resp.setGroups(extGroups);
            context.logMessage(this.pluginInfo, 0, "AREA Response Details : ");
            context.logMessage(this.pluginInfo, 0, "GroupList : " + resp.getGroups());
            return resp;
        }
        catch (AtriumSSOException e) {
            context.logMessage(this.pluginInfo, 2, e.toString());
            throw new ARException(2, 8753, e.getMessage());
        }
        catch (Exception e1) {
            context.logMessage(this.pluginInfo, 2, e1.toString());
            throw new ARException(2, 8753, e1.getMessage());
        }
    }

    public boolean areaNeedSync(ARPluginContext context) throws ARException {
        return true;
    }

    public void onEvent(ARPluginContext context, int pEventID) throws ARException {
        context.logMessage(this.pluginInfo, 0, "on event called with event id " + String.valueOf(pEventID));
        this.lock.lock();
        try {
            if (pEventID == 10005) {
                this.onEventFlag = 1;
                this.initialize(context);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static class SSOAuthCallbackHandler
    implements CallbackHandler {
        private String user;
        private String password;

        public SSOAuthCallbackHandler(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.user);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

