/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.snmp.helper;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.snmp.helper.NetHelper;
import com.bmc.arsys.plugins.snmp.helper.RegexFileLineFilter;
import com.bmc.arsys.plugins.snmp.helper.SNMPConfFileHelper;
import com.bmc.arsys.plugins.snmp.helper.SNMPPluginConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SNMPConfFileCreate
implements SNMPPluginConstants {
    public static final String UTF_8 = "UTF-8";
    private static Logger log = Logger.getLogger(SNMPConfFileCreate.class);

    private boolean ipv4found(InetAddress[] addresses) {
        boolean ipv4Found = false;
        for (int j = 0; j < addresses.length; ++j) {
            String addr = addresses[j].getHostAddress();
            log.debug((Object)("In ipv4found:V4:" + addr));
            if (ipv4Found || !NetHelper.isValidIP(addr) || addresses[j].isLoopbackAddress()) continue;
            log.debug((Object)("In ipv4found:V4:" + addr));
            ipv4Found = true;
            break;
        }
        return ipv4Found;
    }

    private boolean ipv6found(InetAddress[] addresses) {
        boolean ipv6Found = false;
        for (int j = 0; j < addresses.length; ++j) {
            String addr = addresses[j].getHostAddress();
            log.debug((Object)("In ipv6found:V6:" + addr));
            if (ipv6Found || !NetHelper.isIPv6LiteralAddress(addr) || addresses[j].isLoopbackAddress()) continue;
            log.debug((Object)("In ipv6found:V6:" + addr));
            ipv6Found = true;
            break;
        }
        return ipv6Found;
    }

    public void createArsnmpdConfiguration(File arsnmpdfile, File armonitor, String sys_loc_str, String admin_contact_str, int snmp_port_int, String auth_mode_req_str, String read_only_community_str, String read_write_community_str, String user_name_usercomm_str, String access_mode_usercomm_str, String auth_mode_usercomm_str, String auth_pass_usercomm_str, String priv_key_pass_str, String enable_traps_str, String trap_version_str, String sys_receive_traps_str, String snmp_trap_community_str, int snmp_trap_port_int) throws Exception {
        try {
            String localhoststr = InetAddress.getLocalHost().getCanonicalHostName();
            InetAddress[] addresses = InetAddress.getAllByName(localhoststr);
            boolean ipv4Found = this.ipv4found(addresses);
            boolean ipv6Found = this.ipv6found(addresses);
            if (auth_mode_usercomm_str.equals("0")) {
                auth_mode_usercomm_str = "noauth";
            } else if (auth_mode_usercomm_str.equals("1")) {
                auth_mode_usercomm_str = "auth";
            } else if (auth_mode_usercomm_str.equals("2")) {
                auth_mode_usercomm_str = "priv";
            }
            if (trap_version_str.equals("0")) {
                trap_version_str = "trapsink";
            } else if (trap_version_str.equals("1")) {
                trap_version_str = "trap2sink";
            }
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("# System Information");
            lines.add("sysdescr " + SNMPConfFileHelper.getOsName() + " " + SNMPConfFileHelper.getOsVersion());
            lines.add("syslocation " + sys_loc_str);
            lines.add("syscontact " + admin_contact_str);
            lines.add("sysservices 64");
            lines.add("");
            lines.add("# Access Control: BMC_SNMP_AUTHENTICATION_TYPE");
            log.debug((Object)("In Community based:V4:" + ipv4Found + ":V6:" + ipv6Found));
            if (auth_mode_req_str.equals("0")) {
                if (ipv4Found && ipv6Found) {
                    lines.add("rocommunity " + read_only_community_str);
                    lines.add("rwcommunity " + read_write_community_str);
                    lines.add("rocommunity6 " + read_only_community_str);
                    lines.add("rwcommunity6 " + read_write_community_str);
                } else if (!ipv4Found && ipv6Found) {
                    lines.add("rocommunity6 " + read_only_community_str);
                    lines.add("rwcommunity6 " + read_write_community_str);
                } else {
                    lines.add("rocommunity " + read_only_community_str);
                    lines.add("rwcommunity " + read_write_community_str);
                }
                lines.add("");
            } else {
                log.debug((Object)("In User Based:V4:" + ipv4Found + ":V6:" + ipv6Found));
                if (access_mode_usercomm_str.equals("0")) {
                    lines.add("rouser " + user_name_usercomm_str + " " + auth_mode_usercomm_str);
                } else {
                    lines.add("rwuser " + user_name_usercomm_str + " " + auth_mode_usercomm_str);
                }
                lines.add("");
            }
            lines.add("# Trap Information");
            if (enable_traps_str.equals("0")) {
                lines.add("authtrapenable 1");
                if (NetHelper.isIPv6LiteralAddress(sys_receive_traps_str)) {
                    lines.add(trap_version_str + " " + "udp6:[" + sys_receive_traps_str + "]:" + snmp_trap_port_int + " " + snmp_trap_community_str);
                    lines.add("");
                } else if (!ipv4Found && ipv6Found) {
                    lines.add(trap_version_str + " " + "udp6:" + sys_receive_traps_str + " " + snmp_trap_community_str + " " + snmp_trap_port_int);
                    lines.add("");
                } else {
                    lines.add(trap_version_str + " " + sys_receive_traps_str + " " + snmp_trap_community_str + " " + snmp_trap_port_int);
                    lines.add("");
                }
            } else {
                lines.add("authtrapenable 2");
                lines.add("");
            }
            lines.add("# AR Monitor Config File");
            lines.add("arsmonitorfile \"" + armonitor.getAbsolutePath() + "\"");
            if (!arsnmpdfile.exists()) {
                SNMPConfFileCreate.createFile(arsnmpdfile);
            }
            if (arsnmpdfile != null && arsnmpdfile.exists() && arsnmpdfile.canWrite()) {
                SNMPConfFileCreate.writeLines(lines, arsnmpdfile);
                log.info((Object)("Updated SuccessFully" + ((Object)lines).toString()));
            } else {
                log.warn((Object)("Could Not Write in File" + arsnmpdfile.getAbsolutePath()));
            }
        }
        catch (UnknownHostException e) {
            log.warn((Object)("Could Not Detect Host" + e));
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to set arsnmpd.cfg entry.In method createArsnmpdConfiguration " + ex.getLocalizedMessage());
        }
    }

    public void createEntrySNMP(File arsnmpdFile, File armonitorFile, File snmpdFile, String arsnmpdstr, String arserverName, Entry entry) throws ARException {
        try {
            Value sys_loc = (Value)entry.get((Object)500007800);
            Value admin_contact = (Value)entry.get((Object)500007810);
            Value snmp_port = (Value)entry.get((Object)500007820);
            Value auth_mode_req = (Value)entry.get((Object)500007830);
            Value read_only_community = (Value)entry.get((Object)500007840);
            Value read_write_community = (Value)entry.get((Object)500007850);
            Value user_name_usercomm = (Value)entry.get((Object)500007860);
            Value access_mode_usercomm = (Value)entry.get((Object)500007870);
            Value auth_mode_usercomm = (Value)entry.get((Object)500007880);
            Value auth_pass_usercomm = (Value)entry.get((Object)500007890);
            Value priv_key_pass_usercomm = (Value)entry.get((Object)500007900);
            Value enable_traps = (Value)entry.get((Object)500007910);
            Value trap_version = (Value)entry.get((Object)500007920);
            Value sys_receive_traps = (Value)entry.get((Object)500007930);
            Value snmp_trap_community = (Value)entry.get((Object)500007940);
            Value snmp_trap_port = (Value)entry.get((Object)500007950);
            Value snmp_configure_option = (Value)entry.get((Object)500007960);
            String sys_loc_str = sys_loc != null && sys_loc.getValue() != null ? sys_loc.toString() : "<System Location>";
            String admin_contact_str = admin_contact != null && admin_contact.getValue() != null ? admin_contact.toString() : "<Contact Information>";
            int snmp_port_int = snmp_port != null && snmp_port.getValue() != null ? snmp_port.getIntValue() : 0;
            String auth_mode_req_str = auth_mode_req != null && auth_mode_req.getValue() != null ? auth_mode_req.toString() : "";
            String read_only_community_str = read_only_community != null && read_only_community.getValue() != null ? read_only_community.toString() : "<Read-Only>";
            String read_write_community_str = read_write_community != null && read_write_community.getValue() != null ? read_write_community.toString() : "<Read-Write>";
            String user_name_usercomm_str = user_name_usercomm != null && user_name_usercomm.getValue() != null ? user_name_usercomm.toString() : "";
            String access_mode_usercomm_str = access_mode_usercomm != null && access_mode_usercomm.getValue() != null ? access_mode_usercomm.toString() : "";
            String auth_mode_usercomm_str = auth_mode_usercomm != null && auth_mode_usercomm.getValue() != null ? auth_mode_usercomm.toString() : "noauth";
            String auth_pass_usercomm_str = auth_pass_usercomm != null && auth_pass_usercomm.getValue() != null ? auth_pass_usercomm.toString() : "";
            String priv_key_pass_str = priv_key_pass_usercomm != null && priv_key_pass_usercomm.getValue() != null ? priv_key_pass_usercomm.toString() : "";
            String enable_traps_str = enable_traps != null && enable_traps.getValue() != null ? enable_traps.toString() : "";
            String trap_version_str = trap_version != null && trap_version.getValue() != null ? trap_version.toString() : "";
            String sys_receive_traps_str = sys_receive_traps != null && sys_receive_traps.getValue() != null ? sys_receive_traps.toString() : "";
            String snmp_trap_community_str = snmp_trap_community != null && snmp_trap_community.getValue() != null ? snmp_trap_community.toString() : "";
            int snmp_trap_port_int = snmp_trap_port != null && snmp_trap_port.getValue() != null ? snmp_trap_port.getIntValue() : 0;
            int snmp_cfg_value = snmp_configure_option != null && snmp_configure_option.getValue() != null ? Integer.parseInt(snmp_configure_option.toString()) : 0;
            log.debug((Object)("Entries Given by User: Sys Location:" + sys_loc_str + ":admin contact:" + admin_contact_str + ":snmp port:" + snmp_port_int + ":Auth Mode:" + auth_mode_req_str + ":read_only_community_str:" + read_only_community_str + ":read_write_community_str:" + read_write_community_str + ":user_name_usercomm_str:" + user_name_usercomm_str + ":access_mode_usercomm_str:" + access_mode_usercomm_str + ":auth_mode_usercomm_str:" + auth_mode_usercomm_str + ":auth_pass_usercomm_str:" + auth_pass_usercomm_str + ":priv_key_pass_str:" + priv_key_pass_str + ":enable_traps_str:" + enable_traps_str + ":trap_version_str:" + trap_version_str + ":sys_receive_traps_str:" + sys_receive_traps_str + ":snmp_trap_community_str:" + snmp_trap_community_str + ":snmp_trap_port_int:" + snmp_trap_port_int + ":snmp_cfg_value:" + snmp_cfg_value));
            this.createArsnmpdConfiguration(arsnmpdFile, armonitorFile, sys_loc_str, admin_contact_str, snmp_port_int, auth_mode_req_str, read_only_community_str, read_write_community_str, user_name_usercomm_str, access_mode_usercomm_str, auth_mode_usercomm_str, auth_pass_usercomm_str, priv_key_pass_str, enable_traps_str, trap_version_str, sys_receive_traps_str, snmp_trap_community_str, snmp_trap_port_int);
            log.debug((Object)"After snmpFileHelper.createArsnmpdConfiguration");
            this.createSNMPDConfiguration(snmpdFile, auth_mode_req_str, user_name_usercomm_str, auth_mode_usercomm_str, auth_pass_usercomm_str, priv_key_pass_str);
            log.debug((Object)"After snmpFileHelper.createSNMPDConfiguration");
            this.configureSNMP(arsnmpdstr, armonitorFile, snmp_cfg_value, snmp_port_int, arserverName);
            log.debug((Object)"After snmpFileHelper.configureSNMP");
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to Create or Update File " + ex.getLocalizedMessage());
        }
    }

    public void createSNMPDConfiguration(File snmpdfile, String auth_mode_req_str, String user_name_usercomm_str, String auth_mode_usercomm_str, String auth_pass_usercomm_str, String priv_key_pass_str) throws Exception {
        try {
            if (auth_mode_req_str.equals("1")) {
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("# Net-SNMP Persistent Data File");
                if (auth_mode_usercomm_str.equals("0")) {
                    auth_mode_usercomm_str = "noauth";
                    lines.add("createUser " + user_name_usercomm_str);
                } else if (auth_mode_usercomm_str.equals("1")) {
                    auth_mode_usercomm_str = "auth";
                    lines.add("createUser " + user_name_usercomm_str + " MD5 " + auth_pass_usercomm_str);
                } else if (auth_mode_usercomm_str.equals("2")) {
                    auth_mode_usercomm_str = "priv";
                    lines.add("createUser " + user_name_usercomm_str + " MD5 " + auth_pass_usercomm_str + " DES " + priv_key_pass_str);
                }
                if (!snmpdfile.exists()) {
                    SNMPConfFileCreate.createFile(snmpdfile);
                }
                if (snmpdfile != null && snmpdfile.exists() && snmpdfile.canWrite()) {
                    SNMPConfFileCreate.writeLines(lines, snmpdfile);
                    log.info((Object)("Updated SuccessFully" + ((Object)lines).toString()));
                } else {
                    log.warn((Object)("Could Not Write in File" + snmpdfile.getAbsolutePath()));
                }
            } else {
                log.info((Object)("auth_mode_req_str:" + auth_mode_req_str));
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to set snmpd.conf.conf entry.In method createSNMPDConfiguration:" + ex.getLocalizedMessage());
        }
    }

    public void configureSNMP(String arhome, File armonitorFile, int snmp_cfg_value, int snmp_port_int, String arserverName) throws Exception {
        try {
            String osName = SNMPConfFileHelper.getOsName();
            if (SNMPConfFileHelper.isMemberWindows(osName) && arhome.contains("/")) {
                arhome = arhome.replace("/", SNMPConfFileHelper.getFileSeparator());
            }
            String localhoststr = InetAddress.getLocalHost().getCanonicalHostName();
            InetAddress[] addresses = InetAddress.getAllByName(localhoststr);
            boolean ipv4Found = this.ipv4found(addresses);
            boolean ipv6Found = this.ipv6found(addresses);
            String udp4def = "";
            String udp6def = "";
            String udpdef = "";
            udp4def = " udp:" + snmp_port_int;
            udp6def = " udp6:" + snmp_port_int;
            udpdef = ipv4Found && ipv6Found ? udp4def + udp6def : (!ipv4Found && ipv6Found ? udp6def : udp4def);
            String key = "SNMP-agent-enabled";
            String replaceValue_ = "SNMP-agent-enabled: T";
            String keyprocessWindows = "arsnmpd.exe";
            String keyprocessUnix = "arsnmpd --server";
            String searchvalueWindows = "\"" + arhome + SNMPConfFileHelper.getFileSeparator() + "arsnmpd.exe\"" + " -c " + "\"" + arhome + SNMPConfFileHelper.getFileSeparator() + "conf" + SNMPConfFileHelper.getFileSeparator() + "arsnmpd.cfg" + "\"" + udpdef;
            String searchvalueUnix = arhome + SNMPConfFileHelper.getFileSeparator() + "bin" + SNMPConfFileHelper.getFileSeparator() + "arsnmpd --server " + arserverName + " -f -c " + arhome + SNMPConfFileHelper.getFileSeparator() + "conf" + SNMPConfFileHelper.getFileSeparator() + "arsnmpd.conf" + udpdef;
            String keyProcessunset = "arsnmpd";
            if (snmp_cfg_value == 0) {
                this.createSNMPMonitorRentry(armonitorFile, key, replaceValue_);
                if (SNMPConfFileHelper.isMemberWindows(osName)) {
                    this.createSNMPMonitorRentry(armonitorFile, keyprocessWindows, searchvalueWindows);
                } else {
                    this.createSNMPMonitorRentry(armonitorFile, keyprocessUnix, searchvalueUnix);
                }
            } else {
                this.unsetSNMPMONITORentry(armonitorFile, key, replaceValue_);
                if (SNMPConfFileHelper.isMemberWindows(osName)) {
                    this.unsetSNMPMONITORentry(armonitorFile, keyProcessunset, searchvalueWindows);
                } else {
                    this.unsetSNMPMONITORentry(armonitorFile, keyProcessunset, searchvalueUnix);
                }
            }
        }
        catch (UnknownHostException e) {
            log.warn((Object)("Could Not Detect Host" + e));
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to set armonitor.conf entry.In method configureSNMP:" + ex.getLocalizedMessage());
        }
    }

    private void createSNMPMonitorRentry(File armonitorFile, String key, String replaceValue_) throws Exception {
        try {
            log.info((Object)"In Method createSNMPMonitorRentry");
            String pattern = ".*" + key + ".*";
            RegexFileLineFilter filterLine = new RegexFileLineFilter(pattern);
            List<String> lines = this.readLines(armonitorFile, null);
            ListIterator<String> listIterator = lines.listIterator();
            String line = "";
            boolean lineFound = false;
            while (listIterator.hasNext()) {
                line = listIterator.next();
                if (!filterLine.acceptLine(line)) continue;
                lineFound = true;
                if (!line.startsWith("#")) {
                    listIterator.set(replaceValue_);
                    continue;
                }
                listIterator.remove();
                listIterator.add(replaceValue_);
            }
            if (!lineFound) {
                lines.add(replaceValue_);
            }
            if (armonitorFile != null && armonitorFile.exists() && armonitorFile.canWrite()) {
                SNMPConfFileCreate.writeLines(lines, armonitorFile);
                log.info((Object)("Updated SuccessFully" + lines.toString()));
            } else {
                log.warn((Object)("Could Not Write in File" + armonitorFile.getAbsolutePath()));
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to set armonitor.conf entry.In method createSNMPMonitorRentry:" + ex.getLocalizedMessage());
        }
    }

    private void unsetSNMPMONITORentry(File armonitorFile, String searchValue_, String replaceValue_) throws Exception {
        try {
            log.info((Object)"In Method unsetSNMPMONITORentry");
            String pattern = ".*" + searchValue_ + ".*";
            RegexFileLineFilter filterLine = new RegexFileLineFilter(pattern);
            List<String> lines = this.readLines(armonitorFile, null);
            ListIterator<String> listIterator = lines.listIterator();
            String line = "";
            boolean lineFound = false;
            while (listIterator.hasNext()) {
                line = listIterator.next();
                if (!filterLine.acceptLine(line)) continue;
                lineFound = true;
                if (line.startsWith("#")) continue;
                listIterator.set("#" + line);
            }
            if (!lineFound) {
                lines.add("#" + replaceValue_);
            }
            if (armonitorFile != null && armonitorFile.exists() && armonitorFile.canWrite()) {
                SNMPConfFileCreate.writeLines(lines, armonitorFile);
                log.info((Object)("Updated SuccessFully" + lines.toString()));
            } else {
                log.warn((Object)("Could Not Write in File" + armonitorFile.getAbsolutePath()));
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to unset armonitor.conf entry.In method unsetSNMPMONITORentry:" + ex.getLocalizedMessage());
        }
    }

    public String readArMonitorforPort(File armonitorFile) throws Exception {
        String portFound = "";
        try {
            String keysearch = "";
            String osName = SNMPConfFileHelper.getOsName();
            List<String> lines = this.readLines(armonitorFile, null);
            ListIterator<String> listIterator = lines.listIterator();
            keysearch = SNMPConfFileHelper.isMemberWindows(osName) ? "arsnmpd.exe" : "arsnmpd --server";
            String pattern = ".*" + keysearch + ".*";
            RegexFileLineFilter filterLine = new RegexFileLineFilter(pattern);
            String line = "";
            while (listIterator.hasNext()) {
                line = listIterator.next();
                if (!filterLine.acceptLine(line)) continue;
                portFound = line.contains("udp6:") ? (line.indexOf("udp6:") != 0 ? line.substring(line.indexOf("udp6:") + 5, line.length()) : "0") : (line.contains("udp:") ? (line.indexOf("udp:") != 0 ? line.substring(line.indexOf("udp:") + 4, line.length()) : "0") : "0");
                break;
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to read armonitor.conf .In method readArMonitorforPort:" + ex.getLocalizedMessage());
        }
        return portFound;
    }

    public boolean readArMonitorforConfig(File armonitorFile) throws Exception {
        boolean isSet = false;
        try {
            String keysearch = "SNMP-agent-enabled: T";
            List<String> lines = this.readLines(armonitorFile, null);
            ListIterator<String> listIterator = lines.listIterator();
            String pattern = ".*" + keysearch + ".*";
            RegexFileLineFilter filterLine = new RegexFileLineFilter(pattern);
            String line = "";
            while (listIterator.hasNext()) {
                line = listIterator.next();
                if (!filterLine.acceptLine(line) || line.startsWith("#")) continue;
                isSet = true;
                break;
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to read armonitor.conf .In method readArMonitorforConfig:" + ex.getLocalizedMessage());
        }
        return isSet;
    }

    public Properties readArSNMPD(File arsnmpdFile) throws Exception {
        Properties oldmap = new Properties();
        try {
            oldmap.load(new FileInputStream(arsnmpdFile.getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
            throw new ARException(2, 8750, "arsnmpd.conf file does not exist.In method readArSNMPD:" + e.getLocalizedMessage());
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to read arsnmd.conf .In method readArSNMPD:" + ex.getLocalizedMessage());
        }
        return oldmap;
    }

    public static void writeLines(List<String> lines, File outputFile) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter writer = null;
        try {
            SNMPConfFileCreate.createFile(outputFile);
            fos = new FileOutputStream(outputFile);
            osw = new OutputStreamWriter((OutputStream)fos, UTF_8);
            writer = new BufferedWriter(osw);
            for (String current : lines) {
                writer.write(current);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (Throwable throwable) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static boolean createFile(File file) throws IOException {
        boolean result = false;
        if (file != null) {
            result = true;
            if (!file.exists()) {
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    result = parentFile.mkdirs();
                }
                if (result) {
                    try {
                        result = file.createNewFile();
                    }
                    catch (IOException ioe) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        result = file.createNewFile();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readLines(File file, String charsetName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        FileInputStream fis = null;
        InputStreamReader isw = null;
        BufferedReader reader = null;
        try {
            String line;
            fis = new FileInputStream(file);
            isw = charsetName == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, charsetName);
            reader = new BufferedReader(isw);
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
            if (isw != null) {
                try {
                    isw.close();
                }
                catch (Throwable throwable) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }
}

