/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.rsa;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.util.ARUtilEgcp;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;

public class RSAKeyPairGenerator
extends ARFilterAPIPlugin {
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.RSAKEYPAIRGENERATOR", (ARPluggable)this);
    private final int CIPHER_KEY_LENGTH = 2048;
    private final String CIPHER_ALGORITHM_RSA = "RSA";
    private static final String CIPHER_TOKEN_KEY = "ARSYSTEM_DVF_PRIVATE_KEY";

    public List<Value> filterAPICall(ARPluginContext context, List<Value> inValues) throws ARException {
        return this.generateRSAKeyPair(context);
    }

    public List<Value> generateRSAKeyPair(ARPluginContext context) {
        ArrayList<Value> list = new ArrayList<Value>();
        try {
            KeyPairGenerator keypairGen = KeyPairGenerator.getInstance("RSA");
            keypairGen.initialize(2048);
            KeyPair keyPair = keypairGen.genKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec pubKeySpec = keyFactory.getKeySpec(publicKey, RSAPublicKeySpec.class);
            RSAPrivateKeySpec privKeySpec = keyFactory.getKeySpec(privateKey, RSAPrivateKeySpec.class);
            String privKeyString = privKeySpec.getModulus() + "\n" + privKeySpec.getPrivateExponent();
            String encryptedPrivateKey = new ARUtilEgcp().funcEUtil(privKeyString, CIPHER_TOKEN_KEY);
            Value pubKeyVal = new Value(pubKeySpec.getModulus().toString() + "\n" + pubKeySpec.getPublicExponent());
            Value privKeyVal = new Value(encryptedPrivateKey);
            list.add(pubKeyVal);
            list.add(privKeyVal);
            return list;
        }
        catch (NoSuchAlgorithmException nsae) {
            context.logMessage(this.pluginInfo, 0, nsae.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            context.logMessage(this.pluginInfo, 0, ikse.getMessage());
        }
        catch (Exception e) {
            context.logMessage(this.pluginInfo, 0, e.getMessage());
        }
        return null;
    }
}

