/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.arreporting.ARDataStructure;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.plugins.processors.ServerContext;
import com.bmc.arsys.plugins.report.IReportForm;
import com.bmc.arsys.plugins.report.ReportInfo;
import com.bmc.arsys.plugins.report.ReportService;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ReportJobProcessor
implements IReportForm {
    private ArrayList<ARVendorField> getFormFieldInfo(VendorForm form) {
        ArrayList<ARVendorField> list = new ArrayList<ARVendorField>();
        ARVendorField field1 = null;
        CharacterFieldLimit limit = null;
        try {
            field1 = new ARVendorField("Report Publish Parameters", ReportConstants.JOBPROCESSOR_JOB_PARAMETERS.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            list.add(field1);
            limit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            field1 = new ARVendorField("Report Name", ReportConstants.JOBPROCESSOR_JOBITEM_NAME.toInt(), 4, (FieldLimit)limit);
            list.add(field1);
            field1 = new ARVendorField("Report Parameters", ReportConstants.JOBPROCESSOR_JOBITEM_PARAMETERS.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            list.add(field1);
        }
        catch (Exception e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error fetching Columnnames for the table " + form.getTableName(), e.getMessage())));
        }
        return list;
    }

    @Override
    public List<ARVendorField> getMultipleFields(ARPluginContext context, ARServerUser usrContext, VendorForm form) throws ARException {
        return this.getFormFieldInfo(form);
    }

    @Override
    public List<Entry> getListEntryWithFields(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fields, long transid, QualifierInfo qual, List<SortInfo> sortList, List<EntryListFieldInfo> fieldList, int startAt, int maxReturn, OutputInteger numMatches) throws ARException {
        context.logMessage(0, "Get List Entry");
        return null;
    }

    @Override
    public Entry getEntry(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int[] idList) throws ARException {
        return null;
    }

    @Override
    public String createEntry(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        String entryID = this.publishReport(context, ServerContext.getServerUser(), tableName, fieldsList, transId, entry);
        return entryID;
    }

    @Override
    public void setEntry(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, Entry entry, Timestamp getTimestamp) throws ARException {
    }

    private String publishReport(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        ReportInfo reportInfo = new ReportInfo();
        block5: for (int i = 0; i < fieldsList.size(); ++i) {
            ARVendorField field = fieldsList.get(i);
            if (field == null || field.getFieldId() == 1) continue;
            ReportConstants constant = ReportConstants.fromFieldId(field.getFieldId());
            if (!entry.containsKey((Object)field.getFieldId())) continue;
            Value value = (Value)entry.get((Object)field.getFieldId());
            if (constant == null) continue;
            switch (constant) {
                case JOBPROCESSOR_JOB_PARAMETERS: {
                    HashMap<String, String> ohmJobParams = ARDataStructure.processAsMap((String)value.getValue());
                    reportInfo.setEmailList(ohmJobParams.get("emailto"));
                    reportInfo.setStatusEmailList(ohmJobParams.get("statusemailto"));
                    reportInfo.setExportOptions(ohmJobParams.get("exportopt"));
                    reportInfo.setPublishOptions(ohmJobParams.get("publishopt"));
                    reportInfo.setRunAs(ohmJobParams.get("runas"));
                    reportInfo.setTimeZone(ohmJobParams.get("tz"));
                    reportInfo.setWebURL(ohmJobParams.get("weburl"));
                    reportInfo.setOverrideQuery(ohmJobParams.get("overridequery"));
                    reportInfo.setExternalQual(ohmJobParams.get("externalqual"));
                    context.logMessage(0, "JOB PARAMETERS =" + value.getValue().toString());
                    continue block5;
                }
                case JOBPROCESSOR_JOBITEM_NAME: {
                    reportInfo.setReportName((String)value.getValue());
                    context.logMessage(0, "JOB ITEM NAME=" + reportInfo.getReportName());
                    continue block5;
                }
                case JOBPROCESSOR_JOBITEM_PARAMETERS: {
                    reportInfo.setReportParams((String)value.getValue());
                    context.logMessage(0, "JOB ITEM PARAMETERS =" + reportInfo.getReportParams());
                }
            }
        }
        ReportService oService = new ReportService(context);
        String entryID = oService.publishReport(usrContext, reportInfo);
        context.logMessage(0, "Report added in Publish queue successfully-" + entryID);
        return entryID;
    }
}

