/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.arreporting.ReportDelegator;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.plugins.processors.ServerContext;
import com.bmc.arsys.plugins.report.FieldInfoTable;
import com.bmc.arsys.plugins.report.IReportForm;
import com.bmc.arsys.plugins.report.PluginLogListener;
import com.bmc.arsys.plugins.report.ReportDesigner;
import com.bmc.arsys.plugins.report.ReportJobProcessor;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class ReportForms
extends ARDBCPlugin {
    private static final String FORM_FIELD_INFO_TABLE = "AR System Form Field Info";
    private static final String REPORT_DESIGNER_TABLE = "AR System Report Designer";
    private static final String REPORT_JOB_PROCESSOR_TABLE = "AR System Report Job Processor";
    private static HashMap<String, IReportForm> MReportForms = new HashMap();
    private static boolean copyBirtLibraries = false;
    private String serverName = "localhost";
    private static ReportDelegator delegator;
    private ARServerUser serverUser = null;

    public static void init(ARPluginContext context) {
        if (delegator != null) {
            return;
        }
        MReportForms.put(FORM_FIELD_INFO_TABLE, new FieldInfoTable());
        MReportForms.put(REPORT_JOB_PROCESSOR_TABLE, new ReportJobProcessor());
        try {
            Properties props = new Properties();
            String path = context.getConfigItem(context.getPluginInfo(), "birtinstallpath");
            if (path != null && path.length() > 0) {
                context.logMessage(0, "Birt runtime path - " + path);
                File pathDir = new File(path);
                String birtEnginePath = pathDir.getAbsolutePath() + System.getProperty("file.separator") + "ReportEngine";
                String birtTemplatepath = birtEnginePath + System.getProperty("file.separator") + "templates";
                String logpath = pathDir.getAbsolutePath() + System.getProperty("file.separator") + "logs";
                String reportpath = pathDir.getAbsolutePath() + System.getProperty("file.separator") + "reports";
                String librariespath = pathDir.getAbsolutePath() + System.getProperty("file.separator") + "libraries";
                props.setProperty("birt.engine", birtEnginePath);
                props.setProperty("birt.template.dir", birtTemplatepath);
                props.setProperty("birt.log.dir", logpath);
                props.setProperty("birt.reports.dir", reportpath);
                props.setProperty("birt.libraries.dir", librariespath);
            }
            delegator = new ReportDelegator(props, new PluginLogListener(context));
            delegator.initializeEngines();
            MReportForms.put(REPORT_DESIGNER_TABLE, new ReportDesigner(delegator));
            ReportForms.setDelegator(delegator);
            context.logMessage(0, "Delegator Intialized");
        }
        catch (ARException arex) {
            context.logMessage(2, arex.getMessage());
        }
    }

    public static ReportDelegator getDelegator() {
        return delegator;
    }

    public static void setDelegator(ReportDelegator delegator) {
        ReportForms.delegator = delegator;
    }

    public void initialize(ARPluginContext context) throws ARException {
        try {
            int i;
            ServerContext.initializeServerUser(context);
            String[] args = context.getCmdLineArgs();
            String message = "initialize method was invoked with args = ";
            if (args.length >= 0) {
                for (i = 0; i < args.length; ++i) {
                    message = message + " " + args[i];
                }
            }
            context.logMessage(0, message);
            for (i = 0; i < args.length; ++i) {
                if (!args[i].equals("-x")) continue;
                this.serverName = args[i + 1];
                i = args.length;
            }
            context.logMessage(0, "Server name = " + this.serverName);
        }
        catch (Throwable th) {
            context.logMessage(1, th.getMessage());
        }
    }

    public List<ARVendorField> getMultipleFields(ARPluginContext context, VendorForm form) throws ARException {
        context.logMessage(0, "getMultipleFields()");
        this.initServerUser(context);
        IReportForm vForm = MReportForms.get(form.getTableName());
        if (vForm != null) {
            return vForm.getMultipleFields(context, this.serverUser, form);
        }
        return null;
    }

    public List<Entry> getListEntryWithFields(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, QualifierInfo qual, List<SortInfo> sortList, List<EntryListFieldInfo> fieldList, int startAt, int maxReturn, OutputInteger numMatches) throws ARException {
        context.logMessage(0, "getListEntryWithFields()");
        context.logMessage(0, "getListEntryWithFields() " + qual.toString());
        this.initServerUser(context);
        IReportForm vForm = MReportForms.get(tableName);
        if (vForm != null) {
            return vForm.getListEntryWithFields(context, this.serverUser, tableName, fields, transid, qual, sortList, fieldList, startAt, maxReturn, numMatches);
        }
        return null;
    }

    public List<VendorForm> getListForms(ARPluginContext context) throws ARException {
        context.logMessage(0, "getListForms()");
        String PLUGIN_NAME = context.getPluginInfo().getName();
        ArrayList<VendorForm> vendorForms = new ArrayList<VendorForm>();
        vendorForms.add(new VendorForm(PLUGIN_NAME, FORM_FIELD_INFO_TABLE));
        vendorForms.add(new VendorForm(PLUGIN_NAME, REPORT_DESIGNER_TABLE));
        vendorForms.add(new VendorForm(PLUGIN_NAME, REPORT_JOB_PROCESSOR_TABLE));
        return vendorForms;
    }

    public Entry getEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int[] idList) throws ARException {
        context.logMessage(0, "getEntry()");
        this.initServerUser(context);
        IReportForm vForm = MReportForms.get(tableName);
        if (vForm != null) {
            return vForm.getEntry(context, this.serverUser, tableName, fieldsList, transId, entryId, idList);
        }
        return null;
    }

    public String createEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        context.logMessage(0, "getEntry()");
        this.initServerUser(context);
        IReportForm vForm = MReportForms.get(tableName);
        if (vForm != null) {
            return vForm.createEntry(context, this.serverUser, tableName, fieldsList, transId, entry);
        }
        return null;
    }

    public void setEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, Entry entry, Timestamp getTimestamp) throws ARException {
        context.logMessage(0, "setEntry()");
        this.initServerUser(context);
        IReportForm vForm = MReportForms.get(tableName);
        if (vForm != null) {
            vForm.setEntry(context, this.serverUser, tableName, fieldsList, transId, entryId, entry, getTimestamp);
        }
    }

    private void initServerUser(ARPluginContext context) throws ARException {
        context.logMessage(0, "initServerUser()");
        if (this.serverUser == null) {
            this.serverUser = new ARServerUser((ARNativeAuthenticationInfo)context, "", this.serverName);
            int port = Utilities.getIntegerValue(context.getARConfigEntry("TCD-Specific-Port"));
            this.serverUser.setPort(port);
            int rpcnumber = Utilities.getIntegerValue(context.getARConfigEntry("Plugin-Loopback-RPC-Socket"));
            if (rpcnumber > 0) {
                this.serverUser.usePrivateRpcQueue(rpcnumber);
            }
            this.serverUser.setVUIType(1);
        }
        this.serverUser.setUserContext((ARNativeAuthenticationInfo)context);
    }

    public static boolean isCopyBirtLibraries() {
        return copyBirtLibraries;
    }

    public static void setCopyBirtLibraries(boolean copyBirtLibraries) {
        ReportForms.copyBirtLibraries = copyBirtLibraries;
    }
}

