/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.arreporting.ARDataStructure;
import com.bmc.arsys.arreporting.Aggregation;
import com.bmc.arsys.arreporting.ChartType;
import com.bmc.arsys.arreporting.FieldInfo;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.arreporting.ReportDelegator;
import com.bmc.arsys.arreporting.ReportParameters;
import com.bmc.arsys.arreporting.ReportStyle;
import com.bmc.arsys.arreporting.ReportType;
import com.bmc.arsys.plugins.report.FormMetadata;
import com.bmc.arsys.plugins.report.IReportForm;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ReportDesigner
implements IReportForm {
    private String tempDir = null;
    private final ReportDelegator delegator;
    private final HashMap<String, DataType> datatypes = new HashMap();

    public ReportDesigner(ReportDelegator delegator) {
        this.delegator = delegator;
        this.tempDir = System.getenv("BIRT_TEMP");
        if (this.tempDir == null || this.tempDir.length() <= 0) {
            this.tempDir = System.getProperty("java.io.tmpdir");
        }
        if (!this.tempDir.endsWith(System.getProperty("file.separator"))) {
            this.tempDir = this.tempDir + System.getProperty("file.separator");
        }
        this.datatypes.put("0", DataType.NULL);
        this.datatypes.put("1", DataType.KEYWORD);
        this.datatypes.put("2", DataType.INTEGER);
        this.datatypes.put("3", DataType.REAL);
        this.datatypes.put("4", DataType.CHAR);
        this.datatypes.put("5", DataType.DIARY);
        this.datatypes.put("6", DataType.ENUM);
        this.datatypes.put("7", DataType.TIME);
        this.datatypes.put("10", DataType.DECIMAL);
        this.datatypes.put("11", DataType.ATTACHMENT);
        this.datatypes.put("12", DataType.CURRENCY);
        this.datatypes.put("13", DataType.DATE);
        this.datatypes.put("14", DataType.TIME_OF_DAY);
    }

    @Override
    public List<Entry> getListEntryWithFields(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fields, long transid, QualifierInfo qual, List<SortInfo> sortList, List<EntryListFieldInfo> fieldList, int startAt, int maxReturn, OutputInteger numMatches) throws ARException {
        String rName = null;
        String entryID = null;
        if (qual == null) {
            throw new ARException(2, -1, "Qualification is null");
        }
        if (qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals("Report Name") || qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()).toString())) {
            rName = qual.getRelationalOperationInfo().getRightOperand().getValue().toString();
            if (rName == null || rName.length() == 0) {
                throw new ARException(2, -1, "Report Name cannot be null");
            }
        } else if ((qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals("Request ID") || qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(CoreFieldId.EntryId.getFieldId()).toString())) && ((entryID = qual.getRelationalOperationInfo().getRightOperand().getValue().toString()) == null || entryID.length() == 0)) {
            throw new ARException(2, -1, "Entry ID is null");
        }
        if (!(entryID != null && entryID.length() != 0 || rName != null && rName.length() != 0)) {
            throw new ARException(2, -1, "Query parameters do not have either entry id or report name ");
        }
        Entry entry = null;
        if (entryID != null) {
            context.logMessage(0, "getListEntryWithFields() - Qual Entry ID = " + entryID);
            entry = this.delegator.getReportEntryByEntryID(usrContext, entryID);
        } else if (rName != null) {
            context.logMessage(0, "getListEntryWithFields() - Qual report name = " + rName);
            context.logMessage(0, "getListEntryWithFields() - after replace, report name = " + rName);
            entry = this.delegator.getReportEntry(usrContext, rName);
        }
        if (entry == null) {
            return null;
        }
        entryID = entry.getEntryId();
        ArrayList<Entry> entryList = new ArrayList<Entry>();
        Entry newentry = new Entry();
        newentry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()), new Value(this.delegator.getReportName(entry)));
        newentry.put(Integer.valueOf(1), new Value(entryID));
        entry.setEntryId(entryID);
        entryList.add(entry);
        numMatches.setValue(entryList.size());
        context.logMessage(0, "nummatches  = " + numMatches.intValue());
        return entryList;
    }

    @Override
    public Entry getEntry(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int[] idList) throws ARException {
        String categoryID;
        String chartSeriesID;
        context.logMessage(0, "Get Entry: entryId" + entryId);
        if (entryId == null || entryId.length() == 0) {
            throw new ARException(2, -1, "Entry ID is null");
        }
        ReportParameters parameters = this.delegator.getParametersByEntryID(usrContext, entryId);
        if (parameters == null) {
            throw new ARException(2, -1, "Report does not exist");
        }
        String reportName = parameters.getName();
        Entry entry = new Entry();
        entry.put(Integer.valueOf(1), new Value(entryId));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()), new Value(reportName));
        ReportStyle style = parameters.getStyle();
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()), new Value((Object)style.getEnumValue(), DataType.ENUM));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_FORM_NAME_ID.toInt()), new Value(parameters.getForm()));
        String primQual = parameters.getEncodedPrimaryQual();
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt()), new Value(primQual.equals("1=1") ? "" : primQual));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()), new Value(parameters.getEncodedSecondaryQual()));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()), new Value(parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()))));
        String fieldInfoStr = parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt()));
        if (parameters.isIncludeList() && fieldInfoStr != null && fieldInfoStr.length() > 0) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt()), new Value(fieldInfoStr));
        } else {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt()), new Value(""));
        }
        String sortInfoStr = parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_SORTINFO_ID.toInt()));
        if (parameters.isIncludeList() && sortInfoStr != null && sortInfoStr.length() > 0) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_SORTINFO_ID.toInt()), new Value(sortInfoStr));
        } else {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_SORTINFO_ID.toInt()), new Value(""));
        }
        ChartType chartType = parameters.getChartType();
        if (parameters.isIncludeChart() && chartType != null) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()), new Value((Object)chartType.getEnumValue(), DataType.ENUM));
        } else {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()), new Value());
        }
        Aggregation aggregation = parameters.getAggregation();
        if (parameters.isIncludeChart() && aggregation != null) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()), new Value((Object)aggregation.getEnumValue(), DataType.ENUM));
        }
        if ((chartSeriesID = parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()))) != null && chartSeriesID.length() > 0 && !chartSeriesID.equals("0")) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()), new Value(chartSeriesID));
        }
        if ((categoryID = parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()))) != null && categoryID.length() > 0 && !categoryID.equals("0")) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()), new Value(categoryID));
        }
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()), new Value(parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_TITLE_ID.toInt()), new Value(parameters.getTitle()));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()), new Value(parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_FORM_METADATA_ID.toInt()), new Value(parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_FORM_METADATA_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_FORM_VUI_ID.toInt()), new Value(parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORM_VUI_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()), new Value(parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_DESC_ID.toInt()), new Value(parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_DESC_ID.toInt()))));
        if (parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt())) != null) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()), new Value((Object)Integer.parseInt(parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()))), DataType.ENUM));
        }
        if (parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt())) != null) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt()), new Value((Object)Integer.parseInt(parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt()))), DataType.ENUM));
        }
        entry.put(Integer.valueOf(2), new Value(parameters.getProperties().getProperty(Integer.toString(2))));
        return entry;
    }

    private ArrayList<ARVendorField> getFormFieldInfo(VendorForm form) {
        ArrayList<ARVendorField> list = new ArrayList<ARVendorField>();
        ARVendorField field1 = null;
        CharacterFieldLimit limit = null;
        try {
            limit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            field1 = new ARVendorField("Report Name", ReportConstants.DESIGNER_REPORT_NAME_ID.toInt(), 4, (FieldLimit)limit);
            list.add(field1);
            field1 = new ARVendorField("Form Name", ReportConstants.DESIGNER_FORM_NAME_ID.toInt(), 4, (FieldLimit)limit);
            list.add(field1);
            field1 = new ARVendorField("Report Fields", ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            list.add(field1);
            field1 = new ARVendorField("Query", ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            list.add(field1);
            field1 = new ARVendorField("Secondary Query", ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            list.add(field1);
            field1 = new ARVendorField("SortInfo", ReportConstants.DESIGNER_SORTINFO_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            list.add(field1);
            field1 = new ARVendorField("FormMetadata", ReportConstants.DESIGNER_FORM_METADATA_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            list.add(field1);
            list.add(field1);
        }
        catch (Exception e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error fetching Columnnames for the table " + form.getTableName(), e.getMessage())));
        }
        return list;
    }

    @Override
    public List<ARVendorField> getMultipleFields(ARPluginContext context, ARServerUser usrContext, VendorForm form) throws ARException {
        return this.getFormFieldInfo(form);
    }

    private void extractFieldInfo(ARPluginContext context, String flds, FormMetadata fmd, ReportParameters parameters) {
        ArrayList<String> arrList;
        if (flds != null && flds.length() > 0) {
            parameters.clearFields();
        }
        if ((arrList = ARDataStructure.processAsList(flds)).size() > 1) {
            for (int i = 1; i < arrList.size(); ++i) {
                FormMetadata.FieldData fd;
                int id = 0;
                String header = null;
                String idValue = null;
                String val = (String)arrList.get(i);
                if (val == null || val.length() <= 0) continue;
                HashMap<String, String> map = ARDataStructure.processAsMap(val);
                if (map.size() > 0) {
                    idValue = (String)map.get("id");
                    if (idValue != null && idValue.length() > 0) {
                        id = Integer.parseInt(idValue);
                    }
                    header = (String)map.get("header");
                }
                if (id <= 0) continue;
                if (header == null) {
                    header = "";
                }
                String dataType = "4";
                if (fmd != null && (fd = fmd.getFieldData("" + id)) != null) {
                    dataType = "" + fd.getDataType();
                }
                context.logMessage(0, "ID = " + id + " Datatype = " + dataType + " Header = " + header);
                parameters.addField(new FieldInfo(id, this.datatypes.get(dataType), header));
            }
        }
    }

    private void extractGroupnSortInfo(ARPluginContext context, String sortInfo, ReportParameters parameters) {
        ArrayList<String> arrList;
        if (sortInfo != null && sortInfo.length() > 0) {
            parameters.clearGroups();
        }
        if ((arrList = ARDataStructure.processAsList(sortInfo)).size() > 1) {
            for (int i = 1; i < arrList.size(); ++i) {
                String id = null;
                String sortDir = null;
                String groupOn = null;
                String val = (String)arrList.get(i);
                if (val == null || val.length() <= 0) continue;
                HashMap<String, String> map = ARDataStructure.processAsMap(val);
                if (map.size() > 0) {
                    id = (String)map.get("id");
                    sortDir = (String)map.get("dir");
                    groupOn = (String)map.get("group");
                }
                if (id == null || id.length() <= 0) continue;
                parameters.addGroup(new FieldInfo(Integer.parseInt(id), null, sortDir != null && sortDir.length() > 0 ? Integer.parseInt(sortDir) : 0, groupOn != null && groupOn.length() > 0 ? Integer.parseInt(groupOn) : 0));
            }
        }
    }

    private void createOrUpdateReportParameters(ARPluginContext context, ARServerUser usrContext, List<ARVendorField> fieldsList, Entry entry, ReportParameters parameters, boolean bCreatemode) throws ARException {
        boolean bFormMeta = false;
        String reportName = null;
        String formName = null;
        String listFieldString = null;
        String queryString = null;
        String secQueryString = null;
        String formMetaData = null;
        String title = null;
        int reportFormat = 0;
        String sortInfo = null;
        int chartSeriesID = 0;
        int chartCategoryID = 0;
        String chartSeriesLabel = "";
        String chartCategoryLabel = "";
        String vuid = "";
        String locale = "";
        String visibleInConsole = "1";
        if (bCreatemode) {
            parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt()), "1=1");
            parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()), "");
        }
        block23: for (int i = 0; i < fieldsList.size(); ++i) {
            ARVendorField field = fieldsList.get(i);
            if (field == null || field.getFieldId() == 1) continue;
            ReportConstants constant = ReportConstants.fromFieldId(field.getFieldId());
            if (!entry.containsKey((Object)field.getFieldId())) continue;
            Value value = (Value)entry.get((Object)field.getFieldId());
            if (constant != ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID && constant != ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID && (value == null || value.getValue() == null)) {
                context.logMessage(0, "Null Value for field id " + field.getFieldId());
                parameters.getProperties().setProperty(Integer.toString(constant.toInt()), "");
                if (constant == ReportConstants.DESIGNER_REPORT_NAME_ID || constant == ReportConstants.DESIGNER_FORM_NAME_ID || constant == ReportConstants.DESIGNER_REPORT_DESC_ID) continue;
            }
            if (constant == null) continue;
            switch (constant) {
                case DESIGNER_REPORT_NAME_ID: {
                    reportName = value.getValue().toString();
                    parameters.setReportSet(reportName);
                    context.logMessage(0, "Report Name =" + reportName);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()), reportName);
                    continue block23;
                }
                case DESIGNER_FORM_NAME_ID: {
                    formName = value.getValue().toString();
                    context.logMessage(0, "Form Name =" + formName);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_FORM_NAME_ID.toInt()), formName);
                    continue block23;
                }
                case DESIGNER_REPORT_DESC_ID: {
                    String desc = value.getValue().toString();
                    desc = ReportDesigner.StripOffScriptTag(desc);
                    desc = ReportDesigner.URLParamsEscape(desc);
                    context.logMessage(0, "Report Description =" + desc);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_DESC_ID.toInt()), desc);
                    continue block23;
                }
                case DESIGNER_REPORT_TITLE_ID: {
                    if (value == null || value.getValue() == null) {
                        parameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_REPORT_TITLE_ID.toInt()));
                        continue block23;
                    }
                    title = value.getValue().toString();
                    title = ReportDesigner.StripOffScriptTag(title);
                    title = ReportDesigner.URLParamsEscape(title);
                    context.logMessage(0, "Report Title =" + title);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TITLE_ID.toInt()), title);
                    continue block23;
                }
                case DESIGNER_REPORT_FORMAT_ID: {
                    reportFormat = value != null && value.getValue() != null ? (Integer)value.getValue() : 0;
                    context.logMessage(0, "Report Format =" + reportFormat);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()), Integer.toString(reportFormat));
                    continue block23;
                }
                case DESIGNER_REPORT_TEMPLATE_ID: {
                    int reportStyle;
                    int n = reportStyle = value != null && value.getValue() != null ? (Integer)value.getValue() : 0;
                    if (reportStyle >= 0 && reportStyle <= 2) {
                        parameters.setStyle(ReportStyle.fromInt(reportStyle));
                    } else {
                        parameters.setStyle(ReportStyle.LIST);
                    }
                    context.logMessage(0, "Template Value =" + reportStyle);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()), Integer.toString(reportStyle));
                    continue block23;
                }
                case DESIGNER_REPORT_CHART_ID: {
                    if (value != null && value.getDataType() != DataType.NULL && value.getValue() != null) {
                        int chartStyle = (Integer)value.getValue();
                        context.logMessage(0, "Chart Style =" + chartStyle);
                        parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()), Integer.toString(chartStyle));
                        continue block23;
                    }
                    parameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()));
                    continue block23;
                }
                case DESIGNER_CHART_AGGREGATE_BY: {
                    if (value != null && value.getDataType() != DataType.NULL && value.getValue() != null) {
                        int aggregate = (Integer)value.getValue();
                        context.logMessage(0, "Aggregate by =" + aggregate);
                        parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()), Integer.toString(aggregate));
                        continue block23;
                    }
                    parameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()));
                    continue block23;
                }
                case DESIGNER_REPORT_FIELDS_ID: {
                    if (value != null && value.getValue() != null) {
                        listFieldString = value.getValue().toString();
                        if (listFieldString != null && listFieldString.length() > 0) {
                            context.logMessage(0, "Fields =" + listFieldString);
                            parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt()), listFieldString);
                            continue block23;
                        }
                        parameters.clearFields();
                        continue block23;
                    }
                    parameters.clearFields();
                    continue block23;
                }
                case DESIGNER_FORM_METADATA_ID: {
                    formMetaData = value.getValue().toString();
                    context.logMessage(0, "FormMetaData =" + formMetaData);
                    bFormMeta = true;
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_FORM_METADATA_ID.toInt()), formMetaData);
                    continue block23;
                }
                case DESIGNER_REPORT_MAIN_QUERY_ID: {
                    String string = queryString = value != null && value.getValue() != null ? value.getValue().toString() : "";
                    if (queryString.length() == 0) {
                        queryString = "1=1";
                    }
                    context.logMessage(0, "Query =" + queryString);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt()), queryString);
                    continue block23;
                }
                case DESIGNER_REPORT_SECONDARY_QUERY_ID: {
                    secQueryString = value != null && value.getValue() != null ? value.getValue().toString() : "";
                    context.logMessage(0, "Sec Query =" + secQueryString);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()), secQueryString);
                    continue block23;
                }
                case DESIGNER_SORTINFO_ID: {
                    if (value != null && value.getValue() != null) {
                        sortInfo = value.getValue() != null ? value.getValue().toString() : "";
                        context.logMessage(0, "Sort Info =" + sortInfo);
                        parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_SORTINFO_ID.toInt()), sortInfo);
                        continue block23;
                    }
                    parameters.clearGroups();
                    continue block23;
                }
                case DESIGNER_CHART_SERIES_ID: {
                    chartSeriesID = Integer.parseInt(value.getValue() != null ? value.getValue().toString() : "0");
                    context.logMessage(0, "Chart Series ID =" + chartSeriesID);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()), Integer.toString(chartSeriesID));
                    continue block23;
                }
                case DESIGNER_CHART_CATEGORY_ID: {
                    chartCategoryID = Integer.parseInt(value.getValue() != null ? value.getValue().toString() : "0");
                    context.logMessage(0, "Chart Series ID =" + chartCategoryID);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()), Integer.toString(chartCategoryID));
                    continue block23;
                }
                case DESIGNER_CHART_SERIES_LABEL_ID: {
                    chartSeriesLabel = value.getValue() != null ? value.getValue().toString() : "";
                    context.logMessage(0, "Chart Series Label =" + chartSeriesLabel);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()), chartSeriesLabel);
                    continue block23;
                }
                case DESIGNER_CHART_CATEGORY_LABEL_ID: {
                    chartCategoryLabel = value.getValue() != null ? value.getValue().toString() : "";
                    context.logMessage(0, "Chart Category Label =" + chartCategoryLabel);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()), chartCategoryLabel);
                    continue block23;
                }
                case DESIGNER_REPORT_FORM_VUI_ID: {
                    vuid = value.getValue() != null ? value.getValue().toString() : "";
                    context.logMessage(0, "VUID =" + vuid);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORM_VUI_ID.toInt()), vuid);
                    continue block23;
                }
                case DESIGNER_REPORT_LOCALE_ID: {
                    locale = value.getValue() != null ? value.getValue().toString() : "";
                    context.logMessage(0, "Locale =" + locale);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()), locale);
                    continue block23;
                }
                case DESIGNER_REPORT_PRIVACY_ID: {
                    if (value == null || value.getDataType() == DataType.NULL || value.getValue() == null) continue block23;
                    int privacy = (Integer)value.getValue();
                    context.logMessage(0, "Privacy =" + privacy);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt()), Integer.toString(privacy));
                    continue block23;
                }
                case DESIGNER_VISIBLE_IN_CONSOLE: {
                    if (value == null || value.getDataType() == DataType.NULL || value.getValue() == null) continue block23;
                    visibleInConsole = value.getValue().toString();
                    context.logMessage(0, "Visible In Console =" + visibleInConsole);
                    parameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_VISIBLE_IN_CONSOLE.toInt()), visibleInConsole);
                    continue block23;
                }
            }
        }
        FormMetadata fmd = null;
        if (bFormMeta) {
            fmd = new FormMetadata(formMetaData);
        } else {
            formMetaData = parameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_FORM_METADATA_ID.toInt()));
            if (formMetaData != null && formMetaData.length() > 0) {
                fmd = new FormMetadata(formMetaData);
            }
        }
        if (listFieldString != null && listFieldString.length() > 0) {
            this.extractFieldInfo(context, listFieldString, fmd, parameters);
        }
        if (fmd != null && sortInfo != null && sortInfo.length() > 0) {
            this.extractGroupnSortInfo(context, sortInfo, parameters);
            List<FieldInfo> groupList = parameters.getGroups();
            for (FieldInfo fieldInfo : groupList) {
                FormMetadata.FieldData fieldData = fmd.getFieldData("" + fieldInfo.getFieldId());
                if (fieldData == null) continue;
                fieldInfo.setDataType(this.datatypes.get(fieldData.getDataType()));
            }
        }
        if (parameters.getStyle() == ReportStyle.LIST) {
            this.cleanUpChartProps(parameters);
        }
        if (!parameters.isIncludeList()) {
            parameters.getProperties().remove((Object)ReportConstants.DESIGNER_REPORT_FIELDS_ID);
            parameters.getProperties().remove((Object)ReportConstants.DESIGNER_SORTINFO_ID);
            parameters.clearFields();
            parameters.clearGroups();
        }
    }

    private void cleanUpChartProps(ReportParameters parameters) {
        parameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()));
        parameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()));
        parameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()));
        parameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()));
        parameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()));
    }

    @Override
    public String createEntry(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        if (this.delegator == null) {
            throw new ARException(2, -1, "Report delegator is null");
        }
        ReportParameters parameters = new ReportParameters();
        parameters.setType(ReportType.BIRT);
        String requestID = null;
        this.createOrUpdateReportParameters(context, usrContext, fieldsList, entry, parameters, true);
        String errorMsg = this.validateReportFields(parameters);
        if (errorMsg != null) {
            throw new ARException(2, -1, errorMsg);
        }
        String reportFileName = this.makeValidFileName(parameters.getName());
        String fileName = this.tempDir + reportFileName + ".rptdesign";
        requestID = this.delegator.createReport(usrContext, ReportType.BIRT, parameters, fileName, true);
        return requestID;
    }

    @Override
    public void setEntry(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, Entry entry, Timestamp getTimestamp) throws ARException {
        context.logMessage(0, "Set Entry: entryId" + entryId);
        if (entryId == null || entryId.length() == 0) {
            throw new ARException(2, -1, "Entry ID is null");
        }
        ReportParameters parameters = this.delegator.getParametersByEntryID(usrContext, entryId);
        if (parameters == null) {
            throw new ARException(2, -1, "Report does not exist");
        }
        this.createOrUpdateReportParameters(context, usrContext, fieldsList, entry, parameters, false);
        String errorMsg = this.validateReportFields(parameters);
        if (errorMsg != null) {
            throw new ARException(2, -1, errorMsg);
        }
        this.delegator.updateReport(usrContext, parameters.getName(), parameters);
    }

    public String makeValidFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return fileName.replaceAll("(\\[|#|/|\\\\|\\:|\\*|\\?|\"|<|>|\\||\\]|\\s)+", "_");
    }

    private String validateReportFields(ReportParameters parameters) {
        String form;
        StringBuffer sb = new StringBuffer();
        String reportName = parameters.getName();
        if (reportName == null) {
            sb.append("Report name is required.\n");
        }
        if ((form = parameters.getForm()) == null) {
            sb.append("Form is required.\n");
        }
        if (parameters.isIncludeChart()) {
            boolean chartCategorySet;
            boolean chartStyleSet = parameters.getChartType() != null;
            boolean chartAggregateSet = parameters.getAggregation() != null;
            boolean chartSeriesSet = parameters.getSeriesField() > 0;
            boolean bl = chartCategorySet = parameters.getCategoryField() > 0;
            if (!(chartStyleSet && chartSeriesSet && chartCategorySet && chartAggregateSet)) {
                sb.append("Required chart fields are not set.\n");
            }
        }
        if (parameters.isIncludeList() && (parameters.getFields() == null || parameters.getFields().size() == 0)) {
            sb.append("Fields needed for table are not set.\n");
        }
        if (sb.length() != 0) {
            return sb.toString();
        }
        return null;
    }

    public static final String URLParamsEscape(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length());
        char[] chars = str.toCharArray();
        int po = 0;
        block4: for (int ii = 0; ii < chars.length; ++ii) {
            switch (chars[ii]) {
                case '<': {
                    sb.append(chars, po, ii - po);
                    sb.append("&lt;");
                    po = ii + 1;
                    continue block4;
                }
                case '>': {
                    sb.append(chars, po, ii - po);
                    sb.append("&gt;");
                    po = ii + 1;
                    continue block4;
                }
            }
        }
        sb.append(chars, po, chars.length - po);
        return sb.toString();
    }

    public static final String StripOffScriptTag(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("<script>", "").replaceAll("</script>", "").replaceAll("%3Cscript%3E", "").replaceAll("%2Fscript%3E", "").replaceAll("<iframe", "").replaceAll("%3Ciframe", "").replaceAll("<IMG", "").replaceAll("<img", "").replaceAll("alert\\(", "").replaceAll("alert%28", "");
    }
}

