/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.registry;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import com.bmc.webservices.uddiapi.Criteria;
import com.bmc.webservices.uddiapi.CriteriaArrayList;
import com.bmc.webservices.uddiapi.RegistryServerInfo;
import com.bmc.webservices.uddiapi.RegistryServerInfoFactory;
import com.bmc.webservices.uddiapi.Service;
import com.bmc.webservices.uddiapi.ServiceAccessPoint;
import com.bmc.webservices.uddiapi.ServiceArrayList;
import com.bmc.webservices.uddiapi.UDDIRegistry;
import com.bmc.webservices.uddiapi.UDDIRegistryFactory;
import com.bmc.webservices.uddiapi.User;
import com.bmc.webservices.uddiapi.UserFactory;
import com.bmc.webservices.uddiapi.impl.CriteriaImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ARDBCRegistryQuery
extends ARDBCPlugin {
    private String sBNKeyword = "BN";
    private String sANKeyword = "AN";
    private String sWSKeyword = "W";
    private String sWSVKeyword = "WV";
    private String sIVKeyword = "IV";
    private String sCLKeyword = "CL";
    private RegistryServerInfo serverInfo;
    private UDDIRegistry uddiRegistry;
    private User user;
    private String registryLocation = null;
    private String tempRegLocation = null;
    private String registryAdminUser;
    private String registryAdminPassword;
    private URL securityServiceAccessPoint;
    private URL inquiryAccessPoint;
    private URL publishingAccessPoint;
    private URL subscriptionAccessPoint;
    private int onEventFlag = 0;
    private boolean checkLocation = true;
    private ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARDBC.REGISTRY", (ARPluggable)this);
    private final ReentrantLock lock = new ReentrantLock();
    String urlWsdl = "";
    String urlEP = "";
    String keyKey = "";
    String applicationName = "";
    String businessName = "";
    String webService = "";
    String webServiceVersion = "";
    String criteriaList = "";
    String interfaceVersion = "";

    public static void init(ARPluginContext context) {
        context.logMessage(context.getPluginInfo(), 0, "Static initialize method invoked");
        context.logMessage(context.getPluginInfo(), 0, "UserDefined value for ARRegistry " + context.getConfigItem("ARRegistry"));
    }

    public List<VendorForm> getListForms(ARPluginContext context) throws ARException {
        context.logMessage(this.pluginInfo, 0, "getListForms()");
        ArrayList<VendorForm> list = new ArrayList<VendorForm>();
        VendorForm RegistryQueryForm = new VendorForm("ARSYS.ARDBC.REGISTRY", "AR System WebService Registry Query");
        try {
            list.add(RegistryQueryForm);
        }
        catch (Exception e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error fetching table names from the datasource", e.getMessage())));
        }
        return list;
    }

    public List<ARVendorField> getMultipleFields(ARPluginContext context, VendorForm form) throws ARException {
        context.logMessage(this.pluginInfo, 0, "getMultipleFields()");
        ArrayList<ARVendorField> list = new ArrayList<ARVendorField>();
        ARVendorField field1 = null;
        CharacterFieldLimit limit = null;
        try {
            limit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            field1 = new ARVendorField("Business Name", 8033, 4, (FieldLimit)limit);
            list.add(field1);
            field1 = new ARVendorField("Application Name", 8034, 4, (FieldLimit)limit);
            list.add(field1);
            limit = new CharacterFieldLimit(255, 2, 1, "WebServiceList", null, 0);
            field1 = new ARVendorField("Web Service", 8037, 4, (FieldLimit)limit);
            list.add(field1);
            limit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            field1 = new ARVendorField("Application Version", 8038, 4, (FieldLimit)limit);
            list.add(field1);
            field1 = new ARVendorField("WSDL URL", 8059, 4, (FieldLimit)limit);
            list.add(field1);
            field1 = new ARVendorField("End Point URL", 8061, 4, (FieldLimit)limit);
            list.add(field1);
            limit = new CharacterFieldLimit(0, 2, 1, null, null, 0);
            field1 = new ARVendorField("Category List", 8086, 4, (FieldLimit)limit);
            list.add(field1);
            limit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            field1 = new ARVendorField("Interface Version", 8088, 4, (FieldLimit)limit);
            list.add(field1);
        }
        catch (Exception e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error fetching Columnnames for the table " + form.getTableName(), e.getMessage())));
        }
        return list;
    }

    private void parseQualifierToGetKey(QualifierInfo qual) throws ARException {
        try {
            if (qual == null) {
                return;
            }
            switch (qual.getOperation()) {
                case 1: 
                case 2: {
                    this.parseQualifierToGetKey(qual.getLeftOperand());
                    this.parseQualifierToGetKey(qual.getRightOperand());
                    return;
                }
                case 3: {
                    return;
                }
                case 5: {
                    return;
                }
                case 0: {
                    return;
                }
                case 4: {
                    if (qual.getRelationalOperationInfo().getOperation() == 1 || qual.getRelationalOperationInfo().getOperation() == 7) {
                        if (this.businessName == "" && (qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sBNKeyword) || qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8033L).toString()))) {
                            this.businessName = qual.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.applicationName == "" && (qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sANKeyword) || qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8034L).toString()))) {
                            this.applicationName = qual.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.webService == "" && (qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sWSKeyword) || qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8037L).toString()))) {
                            this.webService = qual.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.webServiceVersion == "" && (qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sWSVKeyword) || qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8038L).toString()))) {
                            this.webServiceVersion = qual.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.interfaceVersion == "" && (qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sIVKeyword) || qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8088L).toString()))) {
                            this.interfaceVersion = qual.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.criteriaList == "" && (qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sCLKeyword) || qual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8086L).toString()))) {
                            this.criteriaList = qual.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        }
                    }
                    return;
                }
            }
            throw new ARException(2, 142, Integer.toString(qual.getOperation()));
        }
        catch (Exception e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error parsing qualification", e.getMessage())));
            return;
        }
    }

    public List<Entry> getListEntryWithFields(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, QualifierInfo qual, List<SortInfo> sortList, List<EntryListFieldInfo> fieldList, int startAt, int maxReturn, OutputInteger numMatches) throws ARException {
        ArrayList<Entry> entries;
        block47: {
            context.logMessage(this.pluginInfo, 0, "getListEntryWithFields()");
            entries = new ArrayList<Entry>();
            Entry e1 = null;
            ServiceArrayList serviceList = null;
            CriteriaArrayList inCriteriaArrayList = null;
            String tmpBuff = "";
            try {
                int i;
                this.businessName = "";
                this.applicationName = "";
                this.webService = "";
                this.webServiceVersion = "";
                this.criteriaList = "";
                this.interfaceVersion = "";
                inCriteriaArrayList = null;
                this.parseQualifierToGetKey(qual);
                context.logMessage(this.pluginInfo, 0, "businessName=" + this.businessName);
                context.logMessage(this.pluginInfo, 0, "applicationName=" + this.applicationName);
                context.logMessage(this.pluginInfo, 0, "webService=" + this.webService);
                context.logMessage(this.pluginInfo, 0, "webServiceVersion=" + this.webServiceVersion);
                context.logMessage(this.pluginInfo, 0, "criteriaList=" + this.criteriaList);
                context.logMessage(this.pluginInfo, 0, "interfaceVersion=" + this.interfaceVersion);
                if (this.businessName != "") {
                    this.businessName = this.businessName.replace("\\Q", "\\\\Q");
                    this.businessName = this.businessName.replace("\\E", "\\\\E");
                    if (this.businessName.startsWith("%") && this.businessName.endsWith("%")) {
                        tmpBuff = ".*\\Q";
                        this.businessName = this.businessName.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.businessName);
                        tmpBuff = tmpBuff.concat("\\E.*");
                    } else if (this.businessName.endsWith("%")) {
                        tmpBuff = "^\\Q";
                        this.businessName = this.businessName.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.businessName);
                        tmpBuff = tmpBuff.concat("\\E");
                    } else {
                        tmpBuff = "^\\Q";
                        this.businessName = this.businessName.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.businessName);
                        tmpBuff = tmpBuff.concat("\\E$");
                    }
                    this.businessName = tmpBuff;
                }
                if (this.applicationName != "") {
                    this.applicationName = this.applicationName.replace("\\Q", "\\\\Q");
                    this.applicationName = this.applicationName.replace("\\E", "\\\\E");
                    if (this.applicationName.startsWith("%") && this.applicationName.endsWith("%")) {
                        tmpBuff = ".*\\Q";
                        this.applicationName = this.applicationName.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.applicationName);
                        tmpBuff = tmpBuff.concat("\\E.*");
                    } else if (this.applicationName.endsWith("%")) {
                        tmpBuff = "^\\Q";
                        this.applicationName = this.applicationName.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.applicationName);
                        tmpBuff = tmpBuff.concat("\\E");
                    } else {
                        tmpBuff = "^\\Q";
                        this.applicationName = this.applicationName.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.applicationName);
                        tmpBuff = tmpBuff.concat("\\E$");
                    }
                    this.applicationName = tmpBuff;
                }
                if (this.webService != "") {
                    this.webService = this.webService.replace("\\Q", "\\\\Q");
                    this.webService = this.webService.replace("\\E", "\\\\E");
                    if (this.webService.startsWith("%") && this.webService.endsWith("%")) {
                        tmpBuff = ".*\\Q";
                        this.webService = this.webService.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.webService);
                        tmpBuff = tmpBuff.concat("\\E.*");
                    } else if (this.webService.endsWith("%")) {
                        tmpBuff = "^\\Q";
                        this.webService = this.webService.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.webService);
                        tmpBuff = tmpBuff.concat("\\E");
                    } else {
                        tmpBuff = "^\\Q";
                        this.webService = this.webService.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.webService);
                        tmpBuff = tmpBuff.concat("\\E$");
                    }
                    this.webService = tmpBuff;
                }
                if (this.webServiceVersion != "") {
                    this.webServiceVersion = this.webServiceVersion.replace("\\Q", "\\\\Q");
                    this.webServiceVersion = this.webServiceVersion.replace("\\E", "\\\\E");
                    if (this.webServiceVersion.startsWith("%") && this.webServiceVersion.endsWith("%")) {
                        tmpBuff = ".*\\Q";
                        this.webServiceVersion = this.webServiceVersion.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.webServiceVersion);
                        tmpBuff = tmpBuff.concat("\\E.*");
                    } else if (this.webServiceVersion.endsWith("%")) {
                        tmpBuff = "^\\Q";
                        this.webServiceVersion = this.webServiceVersion.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.webServiceVersion);
                        tmpBuff = tmpBuff.concat("\\E");
                    } else {
                        tmpBuff = "^\\Q";
                        this.webServiceVersion = this.webServiceVersion.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.webServiceVersion);
                        tmpBuff = tmpBuff.concat("\\E$");
                    }
                    this.webServiceVersion = tmpBuff;
                }
                if (this.interfaceVersion != "") {
                    this.interfaceVersion = this.interfaceVersion.replace("\\Q", "\\\\Q");
                    this.interfaceVersion = this.interfaceVersion.replace("\\E", "\\\\E");
                    if (this.interfaceVersion.startsWith("%") && this.interfaceVersion.endsWith("%")) {
                        tmpBuff = ".*\\Q";
                        this.interfaceVersion = this.interfaceVersion.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.interfaceVersion);
                        tmpBuff = tmpBuff.concat("\\E.*");
                    } else if (this.interfaceVersion.endsWith("%")) {
                        tmpBuff = "^\\Q";
                        this.interfaceVersion = this.interfaceVersion.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.interfaceVersion);
                        tmpBuff = tmpBuff.concat("\\E");
                    } else {
                        tmpBuff = "^\\Q";
                        this.interfaceVersion = this.interfaceVersion.replace("%", "");
                        tmpBuff = tmpBuff.concat(this.interfaceVersion);
                        tmpBuff = tmpBuff.concat("\\E$");
                    }
                    this.interfaceVersion = tmpBuff;
                }
                if (this.criteriaList != "") {
                    if (this.criteriaList.startsWith("%") && this.criteriaList.endsWith("%")) {
                        this.criteriaList = tmpBuff = this.criteriaList.substring(1, this.criteriaList.length() - 1);
                    }
                    inCriteriaArrayList = new CriteriaArrayList();
                    String[] arrayCriteria = this.criteriaList.split(";");
                    context.logMessage(this.pluginInfo, 0, "arrayCriteria.length=" + arrayCriteria.length);
                    for (i = 0; i < arrayCriteria.length; ++i) {
                        if (i == 0 && this.criteriaList.startsWith(";")) continue;
                        String[] keyNameValue = arrayCriteria[i].split("=");
                        context.logMessage(this.pluginInfo, 0, "Before replace");
                        context.logMessage(this.pluginInfo, 0, "keyNameValue.length=" + keyNameValue.length);
                        context.logMessage(this.pluginInfo, 0, "keyNameValue[0]=" + keyNameValue[0] + ";keyNameValue[1]=" + keyNameValue[1]);
                        if (keyNameValue[0].contains("%")) {
                            keyNameValue[0] = keyNameValue[0].replace("%", "");
                        }
                        keyNameValue[1] = keyNameValue[1].replace("\\Q", "\\\\Q");
                        keyNameValue[1] = keyNameValue[1].replace("\\E", "\\\\E");
                        if (keyNameValue[1].startsWith("%") && keyNameValue[1].endsWith("%")) {
                            tmpBuff = ".*\\Q";
                            keyNameValue[1] = keyNameValue[1].replace("%", "");
                            tmpBuff = tmpBuff.concat(keyNameValue[1]);
                            tmpBuff = tmpBuff.concat("\\E.*");
                        } else if (keyNameValue[1].endsWith("%")) {
                            tmpBuff = "^\\Q";
                            keyNameValue[1] = keyNameValue[1].replace("%", "");
                            tmpBuff = tmpBuff.concat(keyNameValue[1]);
                            tmpBuff = tmpBuff.concat("\\E");
                        } else {
                            tmpBuff = "^\\Q";
                            keyNameValue[1] = keyNameValue[1].replace("%", "");
                            tmpBuff = tmpBuff.concat(keyNameValue[1]);
                            tmpBuff = tmpBuff.concat("\\E$");
                        }
                        keyNameValue[1] = tmpBuff;
                        context.logMessage(this.pluginInfo, 0, "After replace");
                        context.logMessage(this.pluginInfo, 0, "keyNameValue.length=" + keyNameValue.length);
                        context.logMessage(this.pluginInfo, 0, "keyNameValue[0]=" + keyNameValue[0] + ";keyNameValue[1]=" + keyNameValue[1]);
                        CriteriaImpl tmpCrit = new CriteriaImpl(keyNameValue[0], keyNameValue[1]);
                        inCriteriaArrayList.add((Object)tmpCrit);
                    }
                }
                context.logMessage(this.pluginInfo, 0, "after replace");
                context.logMessage(this.pluginInfo, 0, "businessName=" + this.businessName);
                context.logMessage(this.pluginInfo, 0, "applicationName=" + this.applicationName);
                context.logMessage(this.pluginInfo, 0, "webService=" + this.webService);
                context.logMessage(this.pluginInfo, 0, "webServiceVersion=" + this.webServiceVersion);
                context.logMessage(this.pluginInfo, 0, "interfaceVersion=" + this.interfaceVersion);
                serviceList = this.uddiRegistry.findServices(this.user, this.businessName, this.applicationName, this.webService, this.webServiceVersion, this.interfaceVersion, inCriteriaArrayList);
                this.businessName = "";
                this.applicationName = "";
                this.webService = "";
                this.webServiceVersion = "";
                this.criteriaList = "";
                this.interfaceVersion = "";
                inCriteriaArrayList = null;
                if (serviceList == null) break block47;
                context.logMessage(this.pluginInfo, 0, "serviceList.size()=" + serviceList.size());
                numMatches.setValue(serviceList.size());
                for (i = 0; i < serviceList.size(); ++i) {
                    this.businessName = ((Service)serviceList.get(i)).getBusinessName();
                    this.applicationName = ((Service)serviceList.get(i)).getApplicationName();
                    this.webService = ((Service)serviceList.get(i)).getName();
                    this.webServiceVersion = ((Service)serviceList.get(i)).getVersion();
                    this.interfaceVersion = ((Service)serviceList.get(i)).getInterfaceVersion() != null ? ((Service)serviceList.get(i)).getInterfaceVersion() : "";
                    context.logMessage(this.pluginInfo, 0, "i=" + i);
                    context.logMessage(this.pluginInfo, 0, "businessName=" + this.businessName);
                    context.logMessage(this.pluginInfo, 0, "applicationName=" + this.applicationName);
                    context.logMessage(this.pluginInfo, 0, "webService=" + this.webService);
                    context.logMessage(this.pluginInfo, 0, "webServiceVersion=" + this.webServiceVersion);
                    context.logMessage(this.pluginInfo, 0, "interfaceVersion=" + this.interfaceVersion);
                    context.logMessage(this.pluginInfo, 0, "serviceList.get(i).getAccessPoints().size()" + ((Service)serviceList.get(i)).getAccessPoints().size());
                    if (((Service)serviceList.get(i)).getAccessPoints() != null && ((Service)serviceList.get(i)).getAccessPoints().size() > 0) {
                        for (int j = 0; j < ((Service)serviceList.get(i)).getAccessPoints().size(); ++j) {
                            this.urlWsdl = "";
                            this.urlEP = "";
                            context.logMessage(this.pluginInfo, 0, "j=" + j);
                            if (((ServiceAccessPoint)((Service)serviceList.get(i)).getAccessPoints().get(j)).getWsdlAccessPointUrl() != null) {
                                this.urlWsdl = ((ServiceAccessPoint)((Service)serviceList.get(i)).getAccessPoints().get(j)).getWsdlAccessPointUrl().toString();
                            }
                            if (((ServiceAccessPoint)((Service)serviceList.get(i)).getAccessPoints().get(j)).getAccessPointUrl() != null) {
                                this.urlEP = ((ServiceAccessPoint)((Service)serviceList.get(i)).getAccessPoints().get(j)).getAccessPointUrl().toString();
                            }
                            e1 = new Entry();
                            e1.put(Integer.valueOf(8033), new Value(this.businessName));
                            e1.put(Integer.valueOf(8034), new Value(this.applicationName));
                            e1.put(Integer.valueOf(8037), new Value(this.webService));
                            e1.put(Integer.valueOf(8038), new Value(this.webServiceVersion));
                            e1.put(Integer.valueOf(8088), new Value(this.interfaceVersion));
                            e1.put(Integer.valueOf(8059), new Value(this.urlWsdl));
                            e1.put(Integer.valueOf(8061), new Value(this.urlEP));
                            if (((ServiceAccessPoint)((Service)serviceList.get(i)).getAccessPoints().get(j)).getCriteriaArrayList() != null && ((ServiceAccessPoint)((Service)serviceList.get(i)).getAccessPoints().get(j)).getCriteriaArrayList().size() > 0) {
                                this.criteriaList = "";
                                CriteriaArrayList tmpCriteriaArrayList = ((ServiceAccessPoint)((Service)serviceList.get(i)).getAccessPoints().get(j)).getCriteriaArrayList();
                                context.logMessage(this.pluginInfo, 0, "i=" + i + ";j=" + j);
                                context.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.size()=" + tmpCriteriaArrayList.size());
                                for (int k = 0; k < tmpCriteriaArrayList.size(); ++k) {
                                    if (((Criteria)tmpCriteriaArrayList.get(k)).getKeyName() != null && ((Criteria)tmpCriteriaArrayList.get(k)).getKeyValue() != null) {
                                        if (this.criteriaList == "") {
                                            this.criteriaList = ((Criteria)tmpCriteriaArrayList.get(k)).getKeyName() + "=" + ((Criteria)tmpCriteriaArrayList.get(k)).getKeyValue() + ";";
                                        } else {
                                            String tmpString = ((Criteria)tmpCriteriaArrayList.get(k)).getKeyName() + "=" + ((Criteria)tmpCriteriaArrayList.get(k)).getKeyValue() + ";";
                                            this.criteriaList = this.criteriaList.concat(tmpString);
                                            tmpString = null;
                                        }
                                    }
                                    context.logMessage(this.pluginInfo, 0, "k=" + k);
                                    context.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.get(k).getKeyName()=" + ((Criteria)tmpCriteriaArrayList.get(k)).getKeyName());
                                    context.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.get(k).getKeyValue()=" + ((Criteria)tmpCriteriaArrayList.get(k)).getKeyValue());
                                    context.logMessage(this.pluginInfo, 0, "criteriaList=" + this.criteriaList);
                                }
                                e1.put(Integer.valueOf(8086), new Value(this.criteriaList));
                                this.keyKey = "#8033#:" + this.businessName + ";" + "#" + 8034L + "#:" + this.applicationName + ";" + "#" + 8037L + "#:" + this.webService + ";" + "#" + 8038L + "#:" + this.webServiceVersion + ";" + "#" + 8086L + "#:" + this.criteriaList;
                            } else {
                                this.keyKey = "#8033#:" + this.businessName + ";" + "#" + 8034L + "#:" + this.applicationName + ";" + "#" + 8037L + "#:" + this.webService + ";" + "#" + 8038L + "#:" + this.webServiceVersion + ";";
                            }
                            e1.put(Integer.valueOf(1), new Value(this.keyKey));
                            entries.add(e1);
                            this.keyKey = "";
                            this.applicationName = "";
                            this.businessName = "";
                            this.webService = "";
                            this.webServiceVersion = "";
                            this.urlWsdl = "";
                            this.urlEP = "";
                            this.interfaceVersion = "";
                        }
                        continue;
                    }
                    e1 = new Entry();
                    e1.put(Integer.valueOf(8033), new Value(this.businessName));
                    e1.put(Integer.valueOf(8034), new Value(this.applicationName));
                    e1.put(Integer.valueOf(8037), new Value(this.webService));
                    e1.put(Integer.valueOf(8038), new Value(this.webServiceVersion));
                    e1.put(Integer.valueOf(8088), new Value(this.interfaceVersion));
                    this.urlWsdl = ((Service)serviceList.get(i)).getWsdlURL() != null ? ((Service)serviceList.get(i)).getWsdlURL().toExternalForm() : "";
                    e1.put(Integer.valueOf(8059), new Value(this.urlWsdl));
                    this.urlEP = ((Service)serviceList.get(i)).getAccessPointURL() != null ? ((Service)serviceList.get(i)).getAccessPointURL().toExternalForm() : "";
                    e1.put(Integer.valueOf(8061), new Value(this.urlEP));
                    this.keyKey = "#8033#:" + this.businessName + ";" + "#" + 8034L + "#:" + this.applicationName + ";" + "#" + 8037L + "#:" + this.webService + ";" + "#" + 8038L + "#:" + this.webServiceVersion + ";";
                    e1.put(Integer.valueOf(1), new Value(this.keyKey));
                    entries.add(e1);
                    this.keyKey = "";
                    this.applicationName = "";
                    this.businessName = "";
                    this.webService = "";
                    this.webServiceVersion = "";
                    this.urlWsdl = "";
                    this.urlEP = "";
                    this.interfaceVersion = "";
                }
            }
            catch (Exception e) {
                new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error fetching entries for given qualification from table " + tableName, e.getMessage())));
            }
        }
        if (entries == null || entries.size() == 0) {
            new ARException(Arrays.asList(new StatusInfo(2, 1005L, "No entries for table " + tableName, "")));
        }
        return entries;
    }

    public Entry getEntry(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, String entryId, int[] fieldIds) throws ARException {
        context.logMessage(this.pluginInfo, 0, "getEntry()");
        Entry e1 = null;
        Service serviceRecord = null;
        String urlWsdl = new String();
        CriteriaArrayList inCriteriaArrayList = null;
        String[] keyAttr = new String[5];
        try {
            context.logMessage(this.pluginInfo, 0, "Get Entry: entryId" + entryId);
            this.getKeyAttrValues(entryId, keyAttr);
            context.logMessage(this.pluginInfo, 0, "Business-keyAttr[0]:" + keyAttr[0]);
            context.logMessage(this.pluginInfo, 0, "App-keyAttr[1]:" + keyAttr[1]);
            context.logMessage(this.pluginInfo, 0, "WS-keyAttr[2]:" + keyAttr[2]);
            context.logMessage(this.pluginInfo, 0, "WSV-keyAttr[3]:" + keyAttr[3]);
            context.logMessage(this.pluginInfo, 0, "WSV-keyAttr[4]:" + keyAttr[4]);
            if (keyAttr[4] != "") {
                inCriteriaArrayList = new CriteriaArrayList();
                String[] arrayCriteria = keyAttr[4].split(";");
                context.logMessage(this.pluginInfo, 0, " Get Entry: arrayCriteria.length=" + arrayCriteria.length);
                for (int i = 0; i < arrayCriteria.length; ++i) {
                    String[] keyNameValue = arrayCriteria[i].split("=");
                    context.logMessage(this.pluginInfo, 0, "keyNameValue.length=" + keyNameValue.length);
                    context.logMessage(this.pluginInfo, 0, "keyNameValue[0]=" + keyNameValue[0] + ";keyNameValue[1]=" + keyNameValue[1]);
                    CriteriaImpl tmpCrit = new CriteriaImpl(keyNameValue[0], keyNameValue[1]);
                    inCriteriaArrayList.add((Object)tmpCrit);
                }
            }
            if ((serviceRecord = this.uddiRegistry.findService(this.user, keyAttr[0], keyAttr[1], keyAttr[2], keyAttr[3], inCriteriaArrayList)) != null) {
                e1 = new Entry();
                e1.put(Integer.valueOf(1), new Value(serviceRecord.getKey()));
                e1.put(Integer.valueOf(8033), new Value(serviceRecord.getBusinessName()));
                e1.put(Integer.valueOf(8034), new Value(serviceRecord.getApplicationName()));
                e1.put(Integer.valueOf(8037), new Value(serviceRecord.getName()));
                e1.put(Integer.valueOf(8038), new Value(serviceRecord.getVersion()));
                if (serviceRecord.getInterfaceVersion() != null) {
                    e1.put(Integer.valueOf(8088), new Value(serviceRecord.getInterfaceVersion()));
                } else {
                    e1.put(Integer.valueOf(8088), new Value(""));
                }
                if (serviceRecord.getWsdlURL() != null) {
                    urlWsdl = serviceRecord.getWsdlURL().toString();
                    e1.put(Integer.valueOf(8059), new Value(urlWsdl));
                } else if (((ServiceAccessPoint)serviceRecord.getAccessPoints().get(0)).getWsdlAccessPointUrl() != null) {
                    urlWsdl = ((ServiceAccessPoint)serviceRecord.getAccessPoints().get(0)).getWsdlAccessPointUrl().toString();
                    e1.put(Integer.valueOf(8059), new Value(urlWsdl));
                }
                if (serviceRecord.getAccessPointURL() != null) {
                    urlWsdl = serviceRecord.getAccessPointURL().toString();
                    e1.put(Integer.valueOf(8061), new Value(urlWsdl));
                } else if (((ServiceAccessPoint)serviceRecord.getAccessPoints().get(0)).getAccessPointUrl() != null) {
                    urlWsdl = ((ServiceAccessPoint)serviceRecord.getAccessPoints().get(0)).getAccessPointUrl().toString();
                    e1.put(Integer.valueOf(8061), new Value(urlWsdl));
                }
                if (((ServiceAccessPoint)serviceRecord.getAccessPoints().get(0)).getCriteriaArrayList() != null) {
                    String tmpString = new String();
                    String criteriaList = "";
                    CriteriaArrayList tmpCriteriaArrayList = null;
                    tmpCriteriaArrayList = ((ServiceAccessPoint)serviceRecord.getAccessPoints().get(0)).getCriteriaArrayList();
                    context.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.size()=" + tmpCriteriaArrayList.size());
                    for (int k = 0; k < tmpCriteriaArrayList.size(); ++k) {
                        if (((Criteria)tmpCriteriaArrayList.get(k)).getKeyName() != null && ((Criteria)tmpCriteriaArrayList.get(k)).getKeyValue() != null) {
                            if (criteriaList.equals("")) {
                                criteriaList = ((Criteria)tmpCriteriaArrayList.get(k)).getKeyName() + "=" + ((Criteria)tmpCriteriaArrayList.get(k)).getKeyValue() + ";";
                            } else {
                                tmpString = ((Criteria)tmpCriteriaArrayList.get(k)).getKeyName() + "=" + ((Criteria)tmpCriteriaArrayList.get(k)).getKeyValue() + ";";
                                criteriaList = criteriaList.concat(tmpString);
                            }
                        }
                        context.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.get(k).getKeyName()=" + ((Criteria)tmpCriteriaArrayList.get(k)).getKeyName());
                        context.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.get(k).getKeyValue()=" + ((Criteria)tmpCriteriaArrayList.get(k)).getKeyValue());
                        context.logMessage(this.pluginInfo, 0, "criteriaList=" + criteriaList);
                    }
                    e1.put(Integer.valueOf(8086), new Value(criteriaList));
                }
            }
        }
        catch (Exception e) {
            StatusInfo info = new StatusInfo(2, 1004L, "Error fetching entry " + entryId + " from table " + tableName, e.getMessage());
            ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
            status.add(info);
            throw new ARException(status);
        }
        if (e1 == null) {
            new ARException(Arrays.asList(new StatusInfo(2, 1006L, "No such entry " + entryId + " for table " + tableName, "")));
        }
        return e1;
    }

    private void getKeyAttrValues(String entryId, String[] keyAttr) throws ARException {
        int indexStart = 0;
        int indexEnd = 0;
        String tmpAttr = "";
        try {
            if (entryId != null) {
                tmpAttr = "#8033#";
                if (entryId.contains(tmpAttr)) {
                    indexStart = entryId.indexOf(tmpAttr);
                    indexEnd = entryId.indexOf(";#", indexStart = indexStart + tmpAttr.length() + 1);
                    if (indexEnd == 0) {
                        indexEnd = entryId.length() - 1;
                    }
                    keyAttr[0] = indexEnd <= indexStart ? "" : entryId.substring(indexStart, indexEnd);
                }
                indexStart = 0;
                indexEnd = 0;
                tmpAttr = "#8034#";
                if (entryId.contains(tmpAttr)) {
                    indexStart = entryId.indexOf(tmpAttr);
                    indexEnd = entryId.indexOf(";#", indexStart = indexStart + tmpAttr.length() + 1);
                    if (indexEnd == 0) {
                        indexEnd = entryId.length() - 1;
                    }
                    keyAttr[1] = indexEnd <= indexStart ? "" : entryId.substring(indexStart, indexEnd);
                }
                indexStart = 0;
                indexEnd = 0;
                tmpAttr = "#8037#";
                if (entryId.contains(tmpAttr)) {
                    indexStart = entryId.indexOf(tmpAttr);
                    indexEnd = entryId.indexOf(";#", indexStart = indexStart + tmpAttr.length() + 1);
                    if (indexEnd == 0) {
                        indexEnd = entryId.length() - 1;
                    }
                    keyAttr[2] = indexEnd <= indexStart ? "" : entryId.substring(indexStart, indexEnd);
                }
                indexStart = 0;
                indexEnd = 0;
                tmpAttr = "#8038#";
                if (entryId.contains(tmpAttr)) {
                    indexStart = entryId.indexOf(tmpAttr);
                    indexEnd = entryId.indexOf(";#", indexStart = indexStart + tmpAttr.length() + 1);
                    if (indexEnd == -1) {
                        indexEnd = entryId.length() - 1;
                    }
                    keyAttr[3] = indexEnd <= indexStart ? "" : entryId.substring(indexStart, indexEnd);
                }
                indexStart = 0;
                indexEnd = 0;
                keyAttr[4] = "";
                tmpAttr = "#8086#";
                if (entryId.contains(tmpAttr)) {
                    indexStart = entryId.indexOf(tmpAttr);
                    indexEnd = entryId.indexOf(";#", indexStart = indexStart + tmpAttr.length() + 1);
                    if (indexEnd == -1) {
                        indexEnd = entryId.length() - 1;
                    }
                    keyAttr[4] = indexEnd <= indexStart ? "" : entryId.substring(indexStart, indexEnd);
                }
            }
        }
        catch (Exception e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error parsing entry ID " + entryId, e.getMessage())));
        }
    }

    public void initialize(ARPluginContext context) throws ARException {
        try {
            this.tempRegLocation = context.getARConfigEntry("Registry-Location");
            context.logMessage(this.pluginInfo, 0, "tempRegLocation " + this.tempRegLocation);
            if (this.registryLocation == null && this.tempRegLocation == null || this.tempRegLocation != null && this.tempRegLocation.equals(this.registryLocation)) {
                this.checkLocation = false;
            } else {
                this.registryLocation = this.tempRegLocation;
                this.checkLocation = true;
            }
            if (this.onEventFlag == 1) {
                this.checkLocation = true;
            } else {
                this.onEventFlag = 0;
            }
            context.logMessage(this.pluginInfo, 0, "registry location " + this.registryLocation);
            if (this.registryLocation == null || this.registryLocation.length() == 0) {
                if (this.checkLocation) {
                    context.logMessage(this.pluginInfo, 0, "Null registry location");
                    return;
                }
                return;
            }
            this.registryAdminUser = context.getARConfigEntry("Registry-Admin-User");
            context.logMessage(this.pluginInfo, 0, "registry admin user " + this.registryAdminUser);
            this.registryAdminPassword = context.getARConfigEntry("Registry-Admin-Password");
            if (this.registryAdminPassword != null) {
                PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
                byte[] decPasswd = pwdEnc.decryptPasswordEx(this.registryAdminPassword.getBytes());
                this.registryAdminPassword = new String(decPasswd);
            }
            if (this.registryLocation.contains("/uddi")) {
                this.securityServiceAccessPoint = new URL(this.registryLocation + "/services/security");
                this.inquiryAccessPoint = new URL(this.registryLocation + "/services/inquiry");
                this.publishingAccessPoint = new URL(this.registryLocation + "/services/publication");
                this.subscriptionAccessPoint = new URL(this.registryLocation + "/services/subscription");
            } else {
                this.securityServiceAccessPoint = new URL(this.registryLocation + "/uddi/services/security");
                this.inquiryAccessPoint = new URL(this.registryLocation + "/uddi/services/inquiry");
                this.publishingAccessPoint = new URL(this.registryLocation + "/uddi/services/publication");
                this.subscriptionAccessPoint = new URL(this.registryLocation + "/uddi/services/subscription");
            }
            this.serverInfo = RegistryServerInfoFactory.newInstance((URL)this.securityServiceAccessPoint, (URL)this.inquiryAccessPoint, (URL)this.publishingAccessPoint, (URL)this.subscriptionAccessPoint);
            this.uddiRegistry = UDDIRegistryFactory.newInstance((RegistryServerInfo)this.serverInfo);
            this.user = UserFactory.newInstance((String)this.registryAdminUser, (String)this.registryAdminPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ARException(2, 9134, e.toString());
        }
    }

    public void onEvent(ARPluginContext context, int pEventID) throws ARException {
        context.logMessage(this.pluginInfo, 0, "onEvent()");
        this.lock.lock();
        try {
            if (pEventID == 10005) {
                this.onEventFlag = 1;
                this.initialize(context);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String createEntry(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, Entry newEntry) throws ARException {
        new ARException(Arrays.asList(new StatusInfo(2, 8750L, "")));
        return null;
    }

    public void deleteEntry(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, String entryId) throws ARException {
        new ARException(Arrays.asList(new StatusInfo(2, 8752L, "")));
    }

    public void setEntry(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, String entryId, Entry entry, Timestamp lastModified) throws ARException {
        new ARException(Arrays.asList(new StatusInfo(2, 8751L, "")));
    }
}

