/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.processors;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.ARDataStructure;
import com.bmc.arsys.plugins.processors.Job;
import com.bmc.arsys.plugins.processors.JobItem;
import com.bmc.arsys.plugins.processors.SchedulerException;
import com.bmc.arsys.plugins.processors.ServerContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JobService {
    private static String SchemaJob = null;
    private static String SchemaPendingJob = null;
    private static String SchemaJobItem = null;
    private static final int JOB_PANEL_ID = 90029;
    private static final int PENDING_JOB_PANEL_ID = 90028;
    private static final int JOB_ITEM_PANEL_ID = 90032;
    private static final int JOB_ID_GUID = 179;
    private static final int JOB_ID = 90015;
    private static final int JOB_TYPE = 90021;
    private static final int JOB_NAME = 8;
    private static final int JOB_STATUS_MESSAGE = 90033;
    private static final int JOB_PARAMETERS = 90014;
    private static final int JOB_ITEM_PARAMETERS = 90016;
    private static final int[] mJobListFieldIds = new int[]{90029};
    private static final int[] mJobPendingListFieldIds = new int[]{90028};
    private static final int[] mJobItemListFieldIds = new int[]{90032};
    private static final int[] JOB_FIELDIDS = new int[]{179, 90021, 8, 90014};
    private static final int[] JOB_PENDING_FIELDIDS = new int[]{90015, CoreFieldId.EntryId.getFieldId()};
    private static final int[] JOB_ITEM_FIELDIDS = new int[]{90015, CoreFieldId.ShortDescription.getFieldId(), 90016};
    private static final ArithmeticOrRelationalOperand JOB_OP_FOR_JOB = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 179);
    private static final ArithmeticOrRelationalOperand JOB_OP = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 90015);
    private static final ArithmeticOrRelationalOperand PENDING_JOB_OP = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 179);
    private ARPluginContext mPluginContext = null;

    public JobService(ARPluginContext context) {
        this.mPluginContext = context;
    }

    public Job getJobDetails(String jobId) throws ARException, SchedulerException {
        Job oJob = new Job();
        this.mPluginContext.logMessage(0, "Fetching Job Information - " + jobId);
        ARServerUser context = ServerContext.getServerUser();
        this.getJobListSchema(context);
        if (SchemaJob != null) {
            QualifierInfo qualInfo = this.buildQualifier(jobId);
            try {
                List entries = context.getListEntryObjects(SchemaJob, qualInfo, 0, 0, new ArrayList(), JOB_FIELDIDS, false, null);
                if (entries != null && entries.size() > 0) {
                    Iterator itrEntry = entries.iterator();
                    Entry oEntry = null;
                    Value avalue = null;
                    if (itrEntry.hasNext()) {
                        oEntry = (Entry)itrEntry.next();
                        avalue = (Value)oEntry.get((Object)179);
                        if (avalue != null) {
                            oJob.setJobId((String)avalue.getValue());
                        }
                        if ((avalue = (Value)oEntry.get((Object)90021)) != null) {
                            oJob.setType((String)avalue.getValue());
                        }
                        if ((avalue = (Value)oEntry.get((Object)8)) != null) {
                            oJob.setName((String)avalue.getValue());
                        }
                        if ((avalue = (Value)oEntry.get((Object)90014)) != null) {
                            oJob.setParams(ARDataStructure.processAsMap((String)avalue.getValue()));
                        }
                    }
                    oJob.setJobItems(this.getJobItems(jobId));
                }
            }
            catch (ARException e) {
                this.mPluginContext.logMessage(2, "Error getting Job " + jobId + " - " + e.getMessage());
                throw new SchedulerException("Error getting Job " + jobId + " - " + e.getMessage());
            }
        }
        return oJob;
    }

    public String getJobListSchema(ARServerUser context) throws ARException {
        if (SchemaJob == null) {
            List schemas = context.getListForm(0L, FormType.ALL.toInt() | 0x400, null, mJobListFieldIds);
            if (schemas.size() > 0) {
                SchemaJob = (String)schemas.get(0);
            } else {
                this.mPluginContext.logMessage(2, "Unable to get Job Schema name");
            }
        }
        return SchemaJob;
    }

    public String getJobPendingListSchema(ARServerUser context) throws ARException {
        if (SchemaPendingJob == null) {
            List schemas = context.getListForm(0L, FormType.ALL.toInt() | 0x400, null, mJobPendingListFieldIds);
            if (schemas.size() > 0) {
                SchemaPendingJob = (String)schemas.get(0);
            } else {
                this.mPluginContext.logMessage(2, "Unable to get Pending Job Schema name");
            }
        }
        return SchemaPendingJob;
    }

    public String getSchemaJobItem(ARServerUser context) throws ARException {
        if (SchemaJobItem == null) {
            List schemas = context.getListForm(0L, FormType.ALL.toInt() | 0x400, null, mJobItemListFieldIds);
            if (schemas.size() > 0) {
                SchemaJobItem = (String)schemas.get(0);
            } else {
                this.mPluginContext.logMessage(2, "Unable to get Job Item Schema name");
            }
        }
        return SchemaJobItem;
    }

    public synchronized QualifierInfo buildQualifier(String jobId) {
        RelationalOperationInfo jobOp = new RelationalOperationInfo(1, JOB_OP_FOR_JOB, new ArithmeticOrRelationalOperand(new Value(jobId)));
        QualifierInfo qualifier = new QualifierInfo(jobOp);
        return qualifier;
    }

    public synchronized QualifierInfo buildPendingJobQualifier(String szGUID) {
        RelationalOperationInfo jobOp = new RelationalOperationInfo(1, PENDING_JOB_OP, new ArithmeticOrRelationalOperand(new Value(szGUID)));
        QualifierInfo qualifier = new QualifierInfo(jobOp);
        return qualifier;
    }

    public synchronized QualifierInfo buildJobItemQualifier(String jobId) {
        RelationalOperationInfo jobOp = new RelationalOperationInfo(1, JOB_OP, new ArithmeticOrRelationalOperand(new Value(jobId)));
        QualifierInfo qualifier = new QualifierInfo(jobOp);
        return qualifier;
    }

    public String getPendingJobInfo(ARServerUser context, String szGUID) throws ARException {
        QualifierInfo qualInfo = this.buildPendingJobQualifier(szGUID);
        List entries = context.getListEntryObjects(this.getJobPendingListSchema(context), qualInfo, 0, 0, new ArrayList(), JOB_PENDING_FIELDIDS, false, null);
        if (entries != null && entries.size() > 0) {
            Iterator itrEntry = entries.iterator();
            Entry oEntry = null;
            Value avalue = null;
            if (itrEntry.hasNext() && (avalue = (Value)(oEntry = (Entry)itrEntry.next()).get((Object)CoreFieldId.EntryId.getFieldId())) != null) {
                return (String)avalue.getValue();
            }
        }
        return null;
    }

    public void updateJob(ARServerUser context, Job oJob) throws ARException {
        Entry entry = this.getJobStatustoSave(oJob);
        this.mPluginContext.logMessage(0, "Getting Pending Job with GUID - " + oJob.getPendingGUID());
        String entryId = this.getPendingJobInfo(context, oJob.getPendingGUID());
        this.mPluginContext.logMessage(0, "Updating Job with entry id - " + entryId);
        context.setEntry(this.getJobPendingListSchema(context), entryId, entry, new Timestamp(), 1);
    }

    private Entry getJobStatustoSave(Job oJob) {
        Entry entry = new Entry();
        entry.put(Integer.valueOf(CoreFieldId.Status.getFieldId()), new Value(oJob.getStatus()));
        if (oJob.getMessage() != null) {
            entry.put(Integer.valueOf(90033), new Value(oJob.getMessage()));
        }
        return entry;
    }

    public ArrayList<JobItem> getJobItems(String szJobID) throws ARException {
        this.mPluginContext.logMessage(0, "Fetching Job Items - " + szJobID);
        ArrayList<JobItem> lstJobItems = new ArrayList<JobItem>();
        ARServerUser context = ServerContext.getServerUser();
        QualifierInfo qualInfo = this.buildJobItemQualifier(szJobID);
        List entries = context.getListEntryObjects(this.getSchemaJobItem(context), qualInfo, 0, 0, new ArrayList(), JOB_ITEM_FIELDIDS, false, null);
        if (entries != null && entries.size() > 0) {
            Iterator itrEntry = entries.iterator();
            Entry oEntry = null;
            Value avalue = null;
            JobItem oJobItem = null;
            while (itrEntry.hasNext()) {
                oEntry = (Entry)itrEntry.next();
                oJobItem = new JobItem();
                oJobItem.setJobId(szJobID);
                avalue = (Value)oEntry.get((Object)CoreFieldId.ShortDescription.getFieldId());
                if (avalue != null) {
                    oJobItem.setName((String)avalue.getValue());
                }
                if ((avalue = (Value)oEntry.get((Object)90016)) != null) {
                    oJobItem.setParameters((String)avalue.getValue());
                }
                lstJobItems.add(oJobItem);
            }
        }
        return lstJobItems;
    }
}

