/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.jreflect;

import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.plugins.jreflect.JavaReflectionPlugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public class JavaMethodInvoker {
    public static final String CTR_TOKEN = ".NEW_INSTANCE";
    public static final String EO_C_ARGS = "EO_C_ARGS";
    public static final String DOT_STR = ".";
    public static final String OPAREN_STR = "(";
    public static final String CPAREN_STR = ")";
    public static final String COMMA_STR = ",";
    public static final String PKG_CLASS_SEP = ".";
    public static final String CLASS_METH_SEP = ".";
    public static final String METH_ARG_START_STR = "(";
    public static final String METH_ARG_END_STR = ")";
    public static final String METH_ARG_SEP = ",";
    private static String PARAN_START_STR = "(";
    private static String PARAN_END_STR = ")";
    private static String PARAN_SEP_TKN = ",";
    private ClassLoader clazzLoader;
    private Class clazz = JavaMethodInvoker.class;
    private Hashtable<String, Method> methodMap;
    private Hashtable<String, Constructor> ctrMap;

    public JavaMethodInvoker() {
        this(JavaMethodInvoker.class);
    }

    public JavaMethodInvoker(Class clazz) {
        this(clazz.getClassLoader(), clazz);
    }

    public JavaMethodInvoker(ClassLoader clazzLoader, Class clazz) {
        this.clazzLoader = clazzLoader;
        assert (this.clazzLoader != null);
        this.clazz = clazz;
        assert (this.clazz != null);
        this.methodMap = new Hashtable();
        this.ctrMap = new Hashtable();
    }

    private String generateSignature(String methodName, Object ... args) {
        int count;
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append("(");
        int n = count = args != null ? args.length : 0;
        for (int i = 0; i < count; ++i) {
            Object arg = args[i];
            if (arg == null) {
                sb.append("(null)");
            } else {
                sb.append(arg.getClass().toString());
            }
            if (i >= count - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean isPrimitiveMatch(String lhs, String rhs) {
        String[][] primitiveMappings = new String[][]{{"int", "java.lang.Integer"}, {"long", "java.lang.Long"}, {"boolean", "java.lang.Boolean"}, {"double", "java.lang.Double"}, {"short", "java.lang.Short"}, {"float", "java.lang.Float"}, {"char", "java.lang.Char"}, {"byte", "java.lang.Byte"}};
        int count = primitiveMappings.length;
        for (int i = 0; i < count; ++i) {
            if (!lhs.equals(primitiveMappings[i][0]) && !lhs.equals(primitiveMappings[i][1]) || !rhs.equals(primitiveMappings[i][1])) continue;
            return true;
        }
        return false;
    }

    private Class getClassForName(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (name == null || name.length() <= 0) {
            throw new ClassNotFoundException("Class name not supplied");
        }
        if (name.contains(".")) {
            return Class.forName(name);
        }
        try {
            clazz = Class.forName("java.lang." + name);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName("com.bmc.arsys.api." + name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class name not supplied");
        }
        return clazz;
    }

    private Class[] getParameterTypes(String proto) throws ClassNotFoundException {
        Class[] paramTypes = null;
        if (proto == null) {
            return paramTypes;
        }
        int paranStart = proto.indexOf(PARAN_START_STR);
        int paranEnd = proto.indexOf(PARAN_END_STR);
        proto = proto.substring(paranStart >= 0 ? paranStart + 1 : 0, paranEnd > 0 ? paranEnd : proto.length());
        if ((proto = proto.trim()).length() <= 0) {
            return paramTypes;
        }
        String[] paramSpecs = proto.split(PARAN_SEP_TKN);
        if (paramSpecs == null || paramSpecs.length <= 0) {
            return paramTypes;
        }
        int count = paramSpecs.length;
        paramTypes = new Class[count];
        for (int i = 0; i < count; ++i) {
            String[] splitData = paramSpecs[i].split("\\s", 2);
            String typStr = splitData != null && splitData.length > 0 ? paramSpecs[0] : paramSpecs[i];
            paramTypes[i] = typStr == null || typStr.length() <= 0 || typStr.equalsIgnoreCase("any") || typStr.equalsIgnoreCase("object") ? Object.class : this.getClassForName(typStr);
        }
        return paramTypes;
    }

    private Class[] getParameterTypes(Object ... args) {
        Class[] paramTypes = null;
        if (args == null) {
            return paramTypes;
        }
        paramTypes = new Class[args.length];
        int count = args.length;
        for (int i = 0; i < count; ++i) {
            paramTypes[i] = args[i] != null ? args[i].getClass() : null;
        }
        return paramTypes;
    }

    private Method findMatchingMethod(String methodName, Class[] paramTypes, Object ... args) throws SecurityException, ClassNotFoundException {
        String signature = this.generateSignature(methodName, args);
        System.out.println("Signature : " + signature);
        if (this.methodMap.contains(signature)) {
            return this.methodMap.get(signature);
        }
        Method method = this.findMatchingMethodImpl(methodName, paramTypes, args);
        if (method != null) {
            this.methodMap.put(signature, method);
        }
        return method;
    }

    private Method findMatchingMethodImpl(String methodName, Class[] paramTypes, Object ... args) throws SecurityException, ClassNotFoundException {
        try {
            Method method = this.clazz.getMethod(methodName, paramTypes);
            if (method != null) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.clazz.getDeclaredMethods()));
        int argCount = paramTypes != null ? paramTypes.length : (args != null ? args.length : 0);
        Method fallbackOp = null;
        Method firstOp = null;
        boolean prevNumArgsMatched = false;
        for (Method curMethod : methods) {
            Class<?>[] curMethodParamTypes;
            int paramCount;
            int curNumArgsMatched = 0;
            System.out.println(curMethod.getName());
            if (!curMethod.getName().equals(methodName)) continue;
            if (firstOp == null) {
                firstOp = curMethod;
            }
            if (argCount != (paramCount = (curMethodParamTypes = curMethod.getParameterTypes()) != null ? curMethodParamTypes.length : 0)) continue;
            if (fallbackOp == null) {
                fallbackOp = curMethod;
            }
            boolean match = true;
            for (int j = 0; j < paramCount; ++j) {
                String pName = curMethodParamTypes[j].getName();
                String aName = paramTypes[j].getName();
                System.out.println(String.format("Comparing params: %s %s %s", pName, aName, args[j].getClass().getName()));
                if (!(pName.equals(aName) || this.isPrimitiveMatch(pName, aName) || paramTypes[j].equals(Object.class))) {
                    match = false;
                    break;
                }
                ++curNumArgsMatched;
            }
            if (match) {
                return curMethod;
            }
            if (prevNumArgsMatched >= curNumArgsMatched) continue;
            fallbackOp = curMethod;
        }
        return fallbackOp != null ? fallbackOp : firstOp;
    }

    private Constructor findMatchingConstructor(Class[] ctrArgTypes, Object ... args) {
        String ctrName = this.clazz.getSimpleName();
        String signature = this.generateSignature(ctrName, args);
        System.out.println("Signature : " + signature);
        if (this.methodMap.contains(signature)) {
            return this.ctrMap.get(signature);
        }
        Constructor ctr = this.findMatchingConstructorImpl(ctrArgTypes, args);
        this.ctrMap.put(signature, ctr);
        return ctr;
    }

    private Constructor findMatchingConstructorImpl(Class[] ctrArgTypes, Object ... args) {
        try {
            Constructor constructor = this.clazz.getDeclaredConstructor(ctrArgTypes);
            if (constructor != null) {
                return constructor;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        ArrayList constructors = new ArrayList(Arrays.asList(this.clazz.getDeclaredConstructors()));
        int argCount = ctrArgTypes != null ? ctrArgTypes.length : (args != null ? args.length : 0);
        Constructor fallbackOp = null;
        Constructor firstOp = null;
        boolean prevNumArgsMatched = false;
        for (Constructor constructor : constructors) {
            Class<?>[] curConstructorParamTypes;
            int paramCount;
            int curNumArgsMatched = 0;
            System.out.println(constructor.getName());
            if (firstOp == null) {
                firstOp = constructor;
            }
            if (argCount != (paramCount = (curConstructorParamTypes = constructor.getParameterTypes()) != null ? curConstructorParamTypes.length : 0)) continue;
            if (fallbackOp == null) {
                fallbackOp = constructor;
            }
            boolean match = true;
            for (int j = 0; j < paramCount; ++j) {
                String pName = curConstructorParamTypes[j].getName();
                String aName = ctrArgTypes[j].getName();
                System.out.println(String.format("Comparing params: %s %s %s", pName, aName, args[j].getClass().getName()));
                if (!(pName.equals(aName) || this.isPrimitiveMatch(pName, aName) || ctrArgTypes[j].equals(Object.class))) {
                    match = false;
                    break;
                }
                ++curNumArgsMatched;
            }
            if (match) {
                return constructor;
            }
            if (prevNumArgsMatched >= curNumArgsMatched) continue;
            fallbackOp = constructor;
        }
        return fallbackOp != null ? fallbackOp : firstOp;
    }

    private Object coerce(Class paramType, Object param) {
        if (paramType.equals(Integer.class)) {
            return ConversionUtil.getIntValue((Object)param);
        }
        if (paramType.equals(Long.class) || paramType.equals(Long.TYPE)) {
            return ConversionUtil.getLongValue((Object)param);
        }
        if (paramType.equals(Short.class)) {
            return ConversionUtil.getShortValue((Object)param);
        }
        if (paramType.equals(Double.class)) {
            return ConversionUtil.getDoubleValue((Object)param);
        }
        if (paramType.equals(Float.class)) {
            return Float.valueOf(ConversionUtil.getFloatValue((Object)param));
        }
        if (paramType.equals(Byte.class)) {
            return ConversionUtil.getByteValue((Object)param);
        }
        if (paramType.equals(BigDecimal.class)) {
            return ConversionUtil.getBigDecimalValue((Object)param);
        }
        if (paramType.equals(String.class)) {
            return ConversionUtil.getStringValue((Object)param);
        }
        return param;
    }

    private Object[] coerce(Class[] paramTypes, Object[] params) {
        Object[] newArgs = params;
        if (paramTypes != null && params != null && paramTypes.length < params.length) {
            newArgs = new Object[paramTypes.length];
            System.arraycopy(params, 0, newArgs, 0, paramTypes.length);
            int count = newArgs.length;
            for (int i = 0; i < count; ++i) {
                newArgs[i] = this.coerce(paramTypes[i], newArgs[i]);
            }
            params = newArgs;
        }
        return newArgs;
    }

    public Object invoke(String ctrPrototype, String methPrototype, String methodName, Object ... args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException, InstantiationException, ClassNotFoundException {
        Object[] methArgs;
        Object[] ctrArgs;
        int totalArgCount = args != null ? args.length : 0;
        Class[] ctrArgTypes = null;
        boolean ctrArgSepFound = false;
        int ctrArgSepAt = 0;
        if (ctrPrototype == null) {
            int i;
            for (i = 0; i < totalArgCount; ++i) {
                if (args[i] == null || !EO_C_ARGS.equalsIgnoreCase(args[i].toString())) continue;
                ctrArgSepFound = true;
                break;
            }
            if (ctrArgSepFound) {
                ctrArgSepAt = i;
                ctrArgs = new Object[i];
                System.arraycopy(args, 0, ctrArgs, 0, i);
                methArgs = new Object[args.length - (i + 1)];
                System.arraycopy(args, i + 1, methArgs, 0, args.length - (i + 1));
            } else {
                ctrArgs = null;
                methArgs = args;
            }
        } else {
            ctrArgTypes = this.getParameterTypes(ctrPrototype);
            if (ctrArgTypes != null) {
                ctrArgSepFound = true;
                ctrArgSepAt = ctrArgTypes.length;
                ctrArgs = new Object[ctrArgSepAt];
                System.arraycopy(args, 0, ctrArgs, 0, ctrArgSepAt);
                methArgs = new Object[args.length - ctrArgSepAt];
                System.arraycopy(args, ctrArgSepAt, methArgs, 0, args.length - ctrArgSepAt);
            } else {
                ctrArgs = null;
                methArgs = args;
            }
        }
        ctrArgTypes = this.getParameterTypes(ctrArgs);
        Class[] paramTypes = methPrototype != null ? this.getParameterTypes(methPrototype) : this.getParameterTypes(args);
        Method method = this.findMatchingMethod(methodName, paramTypes, methArgs);
        if (method == null) {
            return null;
        }
        Object[] coercedArgs = this.coerce(method.getParameterTypes(), methArgs);
        if ((method.getModifiers() & 8) != 0) {
            return method.invoke(null, coercedArgs);
        }
        Constructor constructor = this.findMatchingConstructor(ctrArgTypes, ctrArgs);
        Object[] coercedCtrArgs = this.coerce(constructor.getParameterTypes(), ctrArgs);
        Object obj = constructor.newInstance(coercedCtrArgs);
        return method.invoke(obj, coercedArgs);
    }

    public void performSomeWork(int i, int j) {
        System.out.println(" " + i + " " + j);
    }

    public String doSomeThing(String str, int startAt, int length, String replaceStr) {
        String retStr = str.substring(0, startAt);
        retStr = retStr.concat(replaceStr);
        retStr = retStr.concat(str.substring(length));
        return retStr;
    }

    public static void main(String[] args) {
        JavaMethodInvoker tester = new JavaMethodInvoker(JavaMethodInvoker.class);
        String str = tester.doSomeThing("Hello World", 6, 7, " Beautiful ");
        System.out.println(str);
        try {
            Object ret = tester.invoke(null, null, "doSomeThing", "Hello World", 6, 7, " Beautiful ");
            System.out.println(ret.toString());
            ret = tester.invoke(null, null, "performSomeWork", 6, 7);
            JavaMethodInvoker jmi2 = new JavaMethodInvoker(JavaReflectionPlugin.class);
            ret = jmi2.invoke(null, null, "performSomeWorkToo", 100, "hello", EO_C_ARGS, 60, 70);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

