/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper.shared;

import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class XPATHHelper {
    public static List<Node> getNodes(Node rootNode, String xpathString) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (rootNode != null && xpathString != null && !xpathString.equals("")) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                NodeList nodeList = (NodeList)xpath.evaluate(xpathString, rootNode, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    nodes.add(nodeList.item(i));
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return nodes;
    }

    public static Node getNode(Node rootNode, String xpathString) {
        Node result = null;
        List<Node> nodes = XPATHHelper.getNodes(rootNode, xpathString);
        if (nodes.size() != 0) {
            result = nodes.iterator().next();
        }
        return result;
    }

    public static String getStringValue(Node rootNode, String xpathString, String defaultValue) {
        String returnString = defaultValue;
        List<String> strings = XPATHHelper.getStringValues(rootNode, xpathString);
        if (strings.size() > 0) {
            returnString = strings.iterator().next();
        }
        return returnString;
    }

    public static String getStringValue(Node rootNode, String xpathString) {
        return XPATHHelper.getStringValue(rootNode, xpathString, null);
    }

    public static List<String> getStringValues(Node rootNode, String xpathString) {
        List<Node> nodes = XPATHHelper.getNodes(rootNode, xpathString);
        ArrayList<String> strings = new ArrayList<String>();
        for (Node node : nodes) {
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                strings.add(attr.getValue());
                continue;
            }
            if (!(node instanceof Text)) continue;
            Text text = (Text)node;
            strings.add(text.getNodeValue());
        }
        return strings;
    }

    public static List<Attr> attrFilter(Collection<Node> nodes) {
        ArrayList<Attr> attrNodes = new ArrayList<Attr>();
        for (Node node : nodes) {
            if (!(node instanceof Attr)) continue;
            attrNodes.add((Attr)node);
        }
        return attrNodes;
    }

    public static List<Attr> attrFilter(Collection<Node> nodes, String attributeName) {
        ArrayList<Attr> attrNodes = new ArrayList<Attr>();
        for (Node node : nodes) {
            Attr attr;
            if (!(node instanceof Attr) || !FTSConfFileHelper.nullableEquals(attributeName, (attr = (Attr)node).getName())) continue;
            attrNodes.add(attr);
        }
        return attrNodes;
    }

    public static List<Comment> commentFilter(Collection<Node> nodes) {
        ArrayList<Comment> commentNodes = new ArrayList<Comment>();
        for (Node node : nodes) {
            if (!(node instanceof Comment)) continue;
            commentNodes.add((Comment)node);
        }
        return commentNodes;
    }

    public static List<Element> elementFilter(Collection<Node> nodes) {
        ArrayList<Element> elementNodes = new ArrayList<Element>();
        for (Node node : nodes) {
            if (!(node instanceof Element)) continue;
            elementNodes.add((Element)node);
        }
        return elementNodes;
    }

    public static List<ProcessingInstruction> processingInstructionFilter(Collection<Node> nodes) {
        ArrayList<ProcessingInstruction> processingInstructionNodes = new ArrayList<ProcessingInstruction>();
        for (Node node : nodes) {
            if (!(node instanceof ProcessingInstruction)) continue;
            processingInstructionNodes.add((ProcessingInstruction)node);
        }
        return processingInstructionNodes;
    }

    public static List<Text> textFilter(Collection<Node> nodes) {
        ArrayList<Text> textNodes = new ArrayList<Text>();
        for (Node node : nodes) {
            if (!(node instanceof Text)) continue;
            textNodes.add((Text)node);
        }
        return textNodes;
    }

    private XPATHHelper() {
    }
}

