/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper.shared;

import java.util.Locale;

public final class UnicodeHelper {
    private static final String SPECIAL_CHARACTERS = "=: \t\r\n\f#!";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeString(String s, boolean escapeSpace) {
        int length = s.length();
        StringBuffer result = new StringBuffer(length * 2);
        block8: for (int x = 0; x < length; ++x) {
            char c = s.charAt(x);
            switch (c) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        result.append('\\');
                    }
                    result.append(' ');
                    continue block8;
                }
                case '\\': {
                    result.append('\\');
                    result.append('\\');
                    continue block8;
                }
                case '\t': {
                    result.append('\\');
                    result.append('t');
                    continue block8;
                }
                case '\n': {
                    result.append('\\');
                    result.append('n');
                    continue block8;
                }
                case '\r': {
                    result.append('\\');
                    result.append('r');
                    continue block8;
                }
                case '\f': {
                    result.append('\\');
                    result.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        result.append('\\');
                        result.append('u');
                        result.append(UnicodeHelper.toHex(c >> 12 & 0xF));
                        result.append(UnicodeHelper.toHex(c >> 8 & 0xF));
                        result.append(UnicodeHelper.toHex(c >> 4 & 0xF));
                        result.append(UnicodeHelper.toHex(c & 0xF));
                        continue block8;
                    }
                    if (SPECIAL_CHARACTERS.indexOf(c) != -1) {
                        result.append('\\');
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String decodeString(String s) {
        int length = s.length();
        StringBuffer result = new StringBuffer(length);
        int x = 0;
        while (x < length) {
            char c;
            if ((c = s.charAt(x++)) == '\\') {
                if (x < length) {
                    if ((c = s.charAt(x++)) == 'u') {
                        boolean unicode = false;
                        if (x + 4 <= length) {
                            unicode = UnicodeHelper.isUnicode(s.substring(x, x + 4).toUpperCase(Locale.US));
                        }
                        int value = 0;
                        if (unicode) {
                            block6: for (int i = 0; i < 4; ++i) {
                                c = s.charAt(x++);
                                switch (c) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        value = (value << 4) + c - 48;
                                        continue block6;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        value = (value << 4) + 10 + c - 97;
                                        continue block6;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        value = (value << 4) + 10 + c - 65;
                                        continue block6;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                }
                            }
                            result.append((char)value);
                            continue;
                        }
                        result.append('\\');
                        result.append('u');
                        continue;
                    }
                    if (c == 't') {
                        c = '\t';
                        result.append(c);
                        continue;
                    }
                    if (c == 'r') {
                        c = '\r';
                        result.append(c);
                        continue;
                    }
                    if (c == 'n') {
                        c = '\n';
                        result.append(c);
                        continue;
                    }
                    if (c == 'f') {
                        c = '\f';
                        result.append(c);
                        continue;
                    }
                    result.append('\\');
                    result.append(c);
                    continue;
                }
                result.append(c);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static boolean isUnicode(String str) {
        String hexChars = "0123456789ABCDEF";
        boolean result = true;
        for (int i = 0; i < 4; ++i) {
            if (hexChars.indexOf(str.charAt(i)) != -1) continue;
            result = false;
            break;
        }
        return result;
    }

    private static char toHex(int nibble) {
        return HEX_DIGITS[nibble & 0xF];
    }

    private UnicodeHelper() {
    }
}

