/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.configchecker;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.configchecker.CheckResultNotifier;
import com.bmc.arsys.plugins.configchecker.CheckStatus;
import com.bmc.arsys.plugins.configchecker.Messages;
import com.bmc.arsys.plugins.configchecker.ServerContext;
import com.bmc.arsys.plugins.configchecker.UDMCheckBase;
import com.bmc.arsys.plugins.configchecker.UdmChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class UDMDataManagementFilePath
extends UDMCheckBase {
    private static final int REPO_PATH_FIELD_ID = 304317480;

    public UDMDataManagementFilePath(UdmChecker.UDMChecks name, ServerContext serverContext, CheckResultNotifier notifyUpdate) {
        super(name, serverContext, notifyUpdate);
    }

    @Override
    public void run() throws Exception {
        this.querySystemSetting();
    }

    private void querySystemSetting() {
        block7: {
            ArithmeticOrRelationalOperand op1 = new ArithmeticOrRelationalOperand(new Value(1));
            ArithmeticOrRelationalOperand op2 = new ArithmeticOrRelationalOperand(new Value(1));
            RelationalOperationInfo relOp = new RelationalOperationInfo(1, op1, op2);
            QualifierInfo defaultQualifier = new QualifierInfo(relOp);
            SortInfo sortInfo = new SortInfo(1, 1);
            ArrayList<SortInfo> sortList = new ArrayList<SortInfo>(1);
            sortList.add(sortInfo);
            int[] fieldIds = new int[]{1, 7, 304317480};
            try {
                List entryList = this.serverContext.getUser().getListEntryObjects("SYS:System Settings", defaultQualifier, 0, 0, sortList, fieldIds, false, null);
                if (entryList != null && entryList.size() > 0) {
                    for (Entry entry : entryList) {
                        Value valStatus = (Value)entry.get((Object)7);
                        if (valStatus.getIntValue() != 1) continue;
                        Value val = (Value)entry.get((Object)304317480);
                        String repoPath = val.toString();
                        if (repoPath != null) {
                            logger.debug((Object)("Data mng file path: '" + repoPath + "'"));
                            File sample = new File(repoPath);
                            if (!sample.canWrite()) {
                                this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_DMFP_WRITE.toString(), repoPath), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_DMFP_HINT.toString()));
                            }
                        } else {
                            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_DMFP_EMPTY.toString(), repoPath), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_DMFP_HINT.toString()));
                        }
                        break block7;
                    }
                    break block7;
                }
                this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_DMFP_EMPTY.toString(), ""), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_DMFP_HINT.toString()));
            }
            catch (ARException e) {
                this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_DMFP_SETTING.toString(), e.getMessage()), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_DMFP_HINT.toString()));
            }
        }
    }
}

