/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.configchecker;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.plugins.configchecker.ArConfHelper;
import com.bmc.arsys.plugins.configchecker.CheckResultNotifier;
import com.bmc.arsys.plugins.configchecker.CheckStatus;
import com.bmc.arsys.plugins.configchecker.Messages;
import com.bmc.arsys.plugins.configchecker.ServerContext;
import com.bmc.arsys.plugins.configchecker.UDMCheckBase;
import com.bmc.arsys.plugins.configchecker.UdmChecker;
import java.io.File;
import java.util.Map;

public class UDMCheckRAppPassword
extends UDMCheckBase {
    public static final String RAPP_USER_NAME = "Remedy Application Service";

    public UDMCheckRAppPassword(UdmChecker.UDMChecks name, ServerContext serverContext, CheckResultNotifier notifyUpdate) {
        super(name, serverContext, notifyUpdate);
    }

    @Override
    public void run() throws Exception {
        Map<String, String> serPassColl = null;
        try {
            serPassColl = ArConfHelper.getServerRAppPaswordColl(this.serverContext.getUser());
        }
        catch (Exception ex) {
            logger.debug((Object)ex.toString());
            this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_FAIL_RAPP_QUERY.toString() + ": " + ex.getMessage(), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_QUERY.toString()));
            return;
        }
        if (serPassColl == null || serPassColl.size() == 0) {
            this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_FAIL_RAPP_FORM_EMPTY.toString(), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_PAAWD_EMPTY.toString()));
            return;
        }
        String arConfFile = this.serverContext.getInstallDir() + File.separator + ArConfHelper.getArConfName();
        String localHostName = ArConfHelper.getLocalServerName(arConfFile);
        String localRap = serPassColl.get(localHostName);
        if (localRap == null) {
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_RAPP_LH_MISSING.toString(), localHostName), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_LH_MISSING.toString()));
        }
        for (Map.Entry<String, String> entry : serPassColl.entrySet()) {
            String memberName = entry.getKey();
            String password = entry.getValue();
            if (password != null && password.length() > 0) {
                try {
                    ARServerUser user = new ARServerUser(RAPP_USER_NAME, password, null, memberName, this.serverContext.getUser().getPort());
                    user.login();
                    user.logout();
                }
                catch (Exception e) {
                    logger.debug((Object)e.getMessage());
                    this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_RAPP_USER_FAILED.toString(), RAPP_USER_NAME, memberName, e.getMessage()), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_USER_FAILED.toString()));
                }
                continue;
            }
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_RAPP_PAAWD_EMPTY.toString(), RAPP_USER_NAME, memberName), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_PAAWD_EMPTY.toString()));
        }
    }
}

