/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.arealdap;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.plugins.arealdap.LDAPConstants;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;

public class LDAPProps
implements LDAPConstants {
    private final int LDAP_DFLT_PLAIN_PORT = 389;
    private final int LDAP_DFLT_SLL_PORT = 636;
    private String authHost;
    private int authPort;
    private String bindUser;
    private String bindPasswd;
    private String URL;
    private int timeout = 40;
    private String userBase;
    private String userFilter;
    private String chaseReferral;
    private boolean useSSL = false;
    private String keyStorePath;
    private String emailAttribName;
    private String defaultEmail;
    private int useGroups;
    private String rolesAttribName;
    private String defaultRoles;
    private String notifyMechAttribName;
    private int defaultNotifyMech;
    private String licenseMaskAttribName;
    private int defaultLicenseMask;
    private String licenseTypeAttribName;
    private int defaultLicenseType;
    private int defaultReservedLicense;
    private String licenseFTSAttribName;
    private String licenseRes1AttribName;
    private String licenseAppAttribName;
    private String defaultLicenseApp;
    private String groupBase;
    private String groupFilter;
    private String defaultGroups;

    public boolean init(ARPluginContext pluginContext, int i) throws AREncryptionException {
        String resLicense;
        String host;
        String index = "";
        if (i != 0) {
            index = "_" + i;
        }
        if ((host = pluginContext.getARConfigEntry("AREA-LDAP-Hostname" + index)) == null) {
            return false;
        }
        if (host.contains(":") && !host.startsWith("[")) {
            host = "[" + host + "]";
        }
        this.setAuthHost(host);
        this.setUseSSL(pluginContext.getARConfigEntry("AREA-LDAP-UseSSL" + index));
        try {
            this.setAuthPort(Integer.parseInt(pluginContext.getARConfigEntry("AREA-LDAP-Port" + index)));
        }
        catch (Exception e) {
            if (this.useSSL()) {
                this.setAuthPort(636);
            }
            this.setAuthPort(389);
        }
        this.setBindUser(pluginContext.getARConfigEntry("AREA-LDAP-Bind-User" + index));
        this.setBindPasswd(pluginContext.getARConfigEntry("AREA-LDAP-Bind-Password" + index));
        this.setTimeout(pluginContext.getARConfigEntry("External-Authentication-RPC-Timeout"), pluginContext.getARConfigEntry("AREA-LDAP-Connect-Timeout" + index));
        if (this.useSSL()) {
            this.setURL("ldaps://" + this.getAuthHost() + ":" + this.getAuthPort() + "/");
        } else {
            this.setURL("ldap://" + this.getAuthHost() + ":" + this.getAuthPort() + "/");
        }
        this.setUserBase(pluginContext.getARConfigEntry("AREA-LDAP-User-Base" + index));
        this.setUserFilter(pluginContext.getARConfigEntry("AREA-LDAP-User-Filter" + index));
        this.setChaseReferral(pluginContext.getARConfigEntry("AREA-LDAP-Chase-Referral" + index));
        if (this.useSSL()) {
            this.setCertKeyStore(pluginContext.getARConfigEntry("AREA-LDAP-Cert-DB" + index));
        }
        this.setEmailAttribName(pluginContext.getARConfigEntry("AREA-LDAP-Email" + index));
        this.setDefaultEmail(pluginContext.getARConfigEntry("AREA-LDAP-Email-Default" + index));
        this.setUseGroups(pluginContext.getARConfigEntry("AREA-LDAP-Use-Groups" + index));
        this.setRolesAttribName(pluginContext.getARConfigEntry("AREA-LDAP-Roles" + index));
        this.setDefaultRoles(pluginContext.getARConfigEntry("AREA-LDAP-Roles-Default" + index));
        this.setNotifyMeth(pluginContext.getARConfigEntry("AREA-LDAP-Notify-Meth" + index));
        this.setDefaultNotifyMech(pluginContext.getARConfigEntry("AREA-LDAP-Notify-Meth-Default" + index));
        this.setLicenseMaskAttribName(pluginContext.getARConfigEntry("AREA-LDAP-LicMask" + index));
        String mask = pluginContext.getARConfigEntry("AREA-LDAP-LicMask-Default" + index);
        if (mask != null && !mask.isEmpty()) {
            this.setDefaultLicenseMask(Integer.parseInt(mask));
        }
        this.setLicenseTypeAttribName(pluginContext.getARConfigEntry("AREA-LDAP-Lic" + index));
        String licType = pluginContext.getARConfigEntry("AREA-LDAP-Lic-Default" + index);
        if (licType != null && !licType.isEmpty()) {
            this.setDefaultLicenseType(Integer.parseInt(licType));
        }
        if ((resLicense = pluginContext.getARConfigEntry("AREA-LDAP-LicRes1-Default" + index)) != null && !resLicense.isEmpty()) {
            this.setDefaultReservedLicense(Integer.parseInt(resLicense));
        }
        this.setLicenseFTSAttribName(pluginContext.getARConfigEntry("AREA-LDAP-LicFTS" + index));
        this.setLicenseRes1AttribName(pluginContext.getARConfigEntry("AREA-LDAP-LicRes1" + index));
        this.setLicenseAppAttribName(pluginContext.getARConfigEntry("AREA-LDAP-LicAPP" + index));
        this.setDefaultLicenseApp(pluginContext.getARConfigEntry("AREA-LDAP-LicAPP-Default" + index));
        this.setGroupBase(pluginContext.getARConfigEntry("AREA-LDAP-Group-Base" + index));
        this.setGroupFilter(pluginContext.getARConfigEntry("AREA-LDAP-Group-Filter" + index));
        this.setDefaultGroups(pluginContext.getARConfigEntry("AREA-LDAP-Group-Default" + index));
        return true;
    }

    public void setAuthHost(String authHost) {
        this.authHost = authHost;
    }

    public String getAuthHost() {
        return this.authHost;
    }

    public void setAuthPort(int authPort) {
        this.authPort = authPort;
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public void setBindUser(String bindUser) {
        this.bindUser = bindUser;
    }

    public String getBindUser() {
        return this.bindUser;
    }

    public void setBindPasswd(String bindPasswd) throws AREncryptionException {
        String bndPass = null;
        if (bindPasswd != null && !bindPasswd.isEmpty()) {
            PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
            byte[] decPasswd = null;
            decPasswd = pwdEnc.decryptPasswordEx(bindPasswd.getBytes());
            bndPass = new String(decPasswd);
        }
        this.bindPasswd = bndPass;
    }

    public String getBindPasswd() {
        return this.bindPasswd;
    }

    public void setURL(String uRL) {
        this.URL = uRL;
    }

    public String getURL() {
        return this.URL;
    }

    public void setTimeout(String extAuthTimeout, String connectTimeout) {
        int eaTimeout = 0;
        int ldapTimeout = 0;
        try {
            eaTimeout = Integer.parseInt(extAuthTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            ldapTimeout = Integer.parseInt(connectTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (eaTimeout > 0 && eaTimeout < ldapTimeout) {
            if (ldapTimeout > 0 && ldapTimeout < eaTimeout) {
                this.timeout = ldapTimeout < eaTimeout ? ldapTimeout : eaTimeout;
            }
        } else if (ldapTimeout > 0) {
            this.timeout = ldapTimeout;
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setChaseReferral(String chaseReferral) {
        this.chaseReferral = chaseReferral;
    }

    public String getChaseReferral() {
        return this.chaseReferral;
    }

    public void setUseSSL(String useSSL) {
        if ("T".equalsIgnoreCase(useSSL)) {
            this.useSSL = true;
        }
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public void setCertKeyStore(String storePath) {
        if (storePath != null && !storePath.isEmpty()) {
            this.keyStorePath = storePath;
            if (this.keyStorePath.contains(";")) {
                this.keyStorePath = this.keyStorePath.replaceAll(";", "");
                this.keyStorePath = this.keyStorePath.trim();
            }
        }
    }

    public String getCertKeyStore() {
        return this.keyStorePath;
    }

    public void setEmailAttribName(String emailAttribName) {
        this.emailAttribName = emailAttribName;
    }

    public String getEmailAttribName() {
        return this.emailAttribName;
    }

    public void setUseGroups(String useGroups) {
        try {
            this.useGroups = Integer.parseInt(useGroups);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getUseGroups() {
        return this.useGroups;
    }

    public void setRolesAttribName(String rolesAttribName) {
        this.rolesAttribName = rolesAttribName;
    }

    public String getRolesAttribName() {
        return this.rolesAttribName;
    }

    public void setNotifyMeth(String notifyMeth) {
        this.notifyMechAttribName = notifyMeth;
    }

    public String getNotifyMeth() {
        return this.notifyMechAttribName;
    }

    public void setLicenseMaskAttribName(String licenseMaskAttribName) {
        this.licenseMaskAttribName = licenseMaskAttribName;
    }

    public String getLicenseMaskAttribName() {
        return this.licenseMaskAttribName;
    }

    public void setDefaultLicenseType(int defaultLicenseType) {
        this.defaultLicenseType = defaultLicenseType;
    }

    public int getDefaultLicenseType() {
        return this.defaultLicenseType;
    }

    public void setDefaultReservedLicense(int defaultReservedLicense) {
        this.defaultReservedLicense = defaultReservedLicense;
    }

    public int getDefaultReservedLicense() {
        return this.defaultReservedLicense;
    }

    public void setLicenseTypeAttribName(String licenseTypeAttribName) {
        this.licenseTypeAttribName = licenseTypeAttribName;
    }

    public void setDefaultLicenseMask(int defaultLicenseMask) {
        this.defaultLicenseMask = defaultLicenseMask;
    }

    public int getDefaultLicenseMask() {
        return this.defaultLicenseMask;
    }

    public String getLicenseTypeAttribName() {
        return this.licenseTypeAttribName;
    }

    public void setDefaultEmail(String defaultEmail) {
        this.defaultEmail = defaultEmail;
    }

    public String getDefaultEmail() {
        return this.defaultEmail;
    }

    public void setDefaultNotifyMech(String defaultNotifyMech) {
        try {
            this.defaultNotifyMech = Integer.parseInt(defaultNotifyMech);
        }
        catch (NumberFormatException ne) {
            this.defaultNotifyMech = 0;
        }
    }

    public int getDefaultNotifyMech() {
        return this.defaultNotifyMech;
    }

    public void setDefaultRoles(String defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public String getDefaultRoles() {
        return this.defaultRoles;
    }

    public void setLicenseFTSAttribName(String licenseFTSAttribName) {
        this.licenseFTSAttribName = licenseFTSAttribName;
    }

    public String getLicenseFTSAttribName() {
        return this.licenseFTSAttribName;
    }

    public void setLicenseRes1AttribName(String licenseRes1AttribName) {
        this.licenseRes1AttribName = licenseRes1AttribName;
    }

    public String getLicenseRes1AttribName() {
        return this.licenseRes1AttribName;
    }

    public void setLicenseAppAttribName(String licenseAppAttribName) {
        this.licenseAppAttribName = licenseAppAttribName;
    }

    public String getLicenseAppAttribName() {
        return this.licenseAppAttribName;
    }

    public void setDefaultLicenseApp(String defaultLicenseApp) {
        this.defaultLicenseApp = defaultLicenseApp;
    }

    public String getDefaultLicenseApp() {
        return this.defaultLicenseApp;
    }

    public void setGroupBase(String groupBase) {
        this.groupBase = groupBase;
    }

    public String getGroupBase() {
        return this.groupBase;
    }

    public void setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public void setDefaultGroups(String defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    public String getDefaultGroups() {
        return this.defaultGroups;
    }
}

