/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ardbcldap;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.plugins.ardbcldap.DBCLdapProperties;
import com.bmc.arsys.plugins.ardbcldap.RootDSE;
import com.bmc.arsys.plugins.customssl.ARLDAPSSLFactory;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;

public class ARDBCLDAPContext {
    private static final String COM_SUN_JNDI_LDAP_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String JNDI_LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_SCHEMA_URL_SUB_SCOPE = "sub";
    private static final int LDAP_DFLT_PLAIN_PORT = 389;
    private static final int LDAP_DFLT_SLL_PORT = 636;
    private DBCLdapProperties dbcLdapProps = new DBCLdapProperties();

    String getBaseDN(RootDSE rootDSE) {
        String cfgBaseDN = this.dbcLdapProps.getBaseDN();
        String baseDN = null;
        baseDN = cfgBaseDN != null && !cfgBaseDN.isEmpty() ? cfgBaseDN : rootDSE.getDefaultNamingContext();
        return baseDN;
    }

    public void populateProperties(ARPluginContext context) {
        this.dbcLdapProps.setBindUser(context.getARConfigEntry("ARDBC-LDAP-User-DN"));
        this.dbcLdapProps.setBindPassword(context.getARConfigEntry("ARDBC-LDAP-Password"));
        this.setHostNames(context.getARConfigEntry("ARDBC-LDAP-Hostname"));
        String useSSL = context.getARConfigEntry("ARDBC-LDAP-UsingSSL");
        if (useSSL != null && useSSL.equals("T")) {
            this.dbcLdapProps.setUseSSL(true);
            String storePath = context.getARConfigEntry("ARDBC-LDAP-Cert-DB");
            if (storePath != null && !storePath.isEmpty()) {
                if (storePath.contains(";")) {
                    storePath = storePath.replaceAll(";", "");
                }
                this.dbcLdapProps.setCertificateDB(storePath.trim());
            }
        }
        String ldapPort = context.getARConfigEntry("ARDBC-LDAP-Port");
        int port = 0;
        try {
            port = Integer.parseInt(ldapPort);
        }
        catch (Exception e) {
            port = this.dbcLdapProps.isUseSSL() ? 636 : 389;
            context.logMessage(context.getPluginInfo(), 1, "Invalid Port specified:" + ldapPort + ",using port:" + port);
        }
        this.dbcLdapProps.setPortNumber(port);
        this.dbcLdapProps.setCertName(context.getARConfigEntry("ARDBC-LDAP-Cert-Name"));
        this.dbcLdapProps.setKeyDB(context.getARConfigEntry("ARDBC-LDAP-Key-DB"));
        this.dbcLdapProps.setKeyPassword(context.getARConfigEntry("ARDBC-LDAP-Key-Password"));
        this.dbcLdapProps.setPageSize(context.getARConfigEntry("ARDBC-LDAP-Page-Size"));
        this.dbcLdapProps.setChaseReferrals(true);
        this.dbcLdapProps.setTimeFormat(context.getARConfigEntry("ARDBC-LDAP-Time-Format"));
        this.dbcLdapProps.setConnectTimeout(context.getARConfigEntry("Server-Plugin-Default-Timeout"), context.getARConfigEntry("ARDBC-LDAP-Connect-Timeout"));
        this.dbcLdapProps.setBaseDN(context.getARConfigEntry("ARDBC-LDAP-Base-Dn"));
        String useCashe = context.getARConfigEntry("ARDBC-LDAP-Use-Cache");
        if (useCashe != null && useCashe.equals("T")) {
            this.dbcLdapProps.setUseCache(true);
        }
        this.dbcLdapProps.setCacheTTL(context.getARConfigEntry("ARDBC-LDAP-Cache-TTL"));
        String maxCacheSize = context.getARConfigEntry("ARDBC-LDAP-Cache-MaxSize");
        if (maxCacheSize == null || "".equals(maxCacheSize)) {
            this.dbcLdapProps.setMaxCacheSize(0);
        } else {
            this.dbcLdapProps.setMaxCacheSize(Integer.parseInt(maxCacheSize));
        }
        String dnTimeout = context.getARConfigEntry("ARDBC-LDAP-DN-Timeout");
        if (dnTimeout == null || "".equals(dnTimeout)) {
            this.dbcLdapProps.setDnTimeout(0);
        } else {
            this.dbcLdapProps.setDnTimeout(Integer.parseInt(dnTimeout));
        }
    }

    public Set<String> findSubDIT(String basedn, LdapContext ldapContext) throws NamingException {
        HashSet<String> subDIT = new HashSet<String>();
        String filter = "(objectclass=*)";
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(new String[]{"objectclass"});
        sCntrl.setSearchScope(2);
        NamingEnumeration<SearchResult> subTree = ldapContext.search(basedn, filter, sCntrl);
        while (subTree.hasMoreElements()) {
            SearchResult node = (SearchResult)subTree.nextElement();
            NamingEnumeration<? extends Attribute> attrs = node.getAttributes().getAll();
            while (attrs.hasMoreElements()) {
                Attribute attr = (Attribute)attrs.nextElement();
                for (int i = 0; i < attr.size(); ++i) {
                    subDIT.add(attr.get(i).toString());
                }
            }
        }
        return subDIT;
    }

    public List<VendorForm> getTableNames(ARPluginContext context, LdapContext ldapContext, StringBuilder ldapURL, RootDSE rootDSE) throws NamingException {
        String baseDN = this.getBaseDN(rootDSE);
        Set<String> subDIT = this.findSubDIT(baseDN, ldapContext);
        ArrayList<VendorForm> tableList = new ArrayList<VendorForm>(subDIT.size());
        if (!subDIT.isEmpty()) {
            for (String objectClassNm : subDIT) {
                StringBuilder tableURL = new StringBuilder();
                tableURL.append((CharSequence)ldapURL).append(baseDN).append("??").append(LDAP_SCHEMA_URL_SUB_SCOPE).append("?(objectclass=").append(objectClassNm).append(")");
                String url = tableURL.toString();
                context.logMessage(context.getPluginInfo(), 0, url);
                VendorForm form = new VendorForm("ARSYS.ARDBC.LDAP", url);
                tableList.add(form);
            }
        }
        return tableList;
    }

    List<String> ifEntriesExist(LdapContext ldapContext, String objClassName, String baseDN) throws NamingException {
        ArrayList<String> baseNames = new ArrayList<String>();
        String filter = "(objectclass=" + objClassName + ")";
        String[] attrIds = new String[]{"1.1"};
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(attrIds);
        sCntrl.setSearchScope(2);
        NamingEnumeration<SearchResult> enm = ldapContext.search(baseDN, filter, sCntrl);
        while (enm.hasMoreElements()) {
            SearchResult result = (SearchResult)enm.nextElement();
            String resultDN = result.getNameInNamespace();
            if (!resultDN.equalsIgnoreCase(baseDN)) {
                int index = resultDN.indexOf(44) + 1;
                resultDN = resultDN.substring(index);
            }
            if (baseNames.contains(resultDN)) continue;
            baseNames.add(resultDN);
        }
        return baseNames;
    }

    String getObjectClassName(String value) {
        int nameIndex = value.indexOf("NAME");
        String name = null;
        if (nameIndex != -1) {
            int start = value.indexOf("'", nameIndex) + 1;
            int end = value.indexOf("'", start);
            name = value.substring(start, end);
        }
        return name;
    }

    Enumeration<SearchResult> searchLDAP(String basedn, LdapContext ldapContext, String[] attrIds) throws NamingException {
        String filter = "(objectclass=*)";
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(attrIds);
        sCntrl.setSearchScope(0);
        NamingEnumeration<SearchResult> enm = ldapContext.search(basedn, filter, sCntrl);
        return enm;
    }

    LdapContext getInitialContext(ARPluginContext context) throws NamingException, IOException, ARException {
        int pageSize;
        if (this.dbcLdapProps.getHostNames() == null) {
            throw new ARException(2, 3377, "LDAP Server Host name not configured !");
        }
        Properties env = new Properties();
        if (this.dbcLdapProps.isUseSSL()) {
            String certDb = this.dbcLdapProps.getCertificateDB();
            if (certDb == null || certDb.isEmpty()) {
                throw new ARException(2, 3377, "TLS is enabled but No certificate keystore provided!");
            }
            ARLDAPSSLFactory.setKeyStorePath(this.dbcLdapProps.getCertificateDB());
            env.put("java.naming.ldap.factory.socket", "com.bmc.arsys.plugins.customssl.ARLDAPSSLFactory");
            env.put("java.naming.security.protocol", "tls");
            context.logMessage(context.getPluginInfo(), 0, "Setting Context.SECURITY_PROTOCOL: " + env.getProperty("java.naming.security.protocol"));
        } else {
            env.put(COM_SUN_JNDI_LDAP_CONNECT_TIMEOUT, Integer.toString(this.dbcLdapProps.getConnectTimeout() * 1000));
        }
        env.put("java.naming.factory.initial", JNDI_LDAP_CTX_FACTORY);
        env.put("java.naming.security.authentication", "simple");
        if (this.dbcLdapProps.getBindUser() != null && !this.dbcLdapProps.getBindUser().isEmpty()) {
            env.put("java.naming.security.principal", this.dbcLdapProps.getBindUser());
            if (this.dbcLdapProps.getBindPassword() != null) {
                env.put("java.naming.security.credentials", this.dbcLdapProps.getBindPassword());
            }
        } else {
            context.logMessage(context.getPluginInfo(), 0, "Bind user is not configured so trying anonymous access!");
        }
        LdapContext initCtx = null;
        int count = 1;
        String sslLog = "";
        if (this.dbcLdapProps.isUseSSL()) {
            sslLog = "(Using " + env.getProperty("java.naming.security.protocol") + ")";
        }
        for (String host : this.dbcLdapProps.getHostNames()) {
            String protocol = "ldap";
            if (this.dbcLdapProps.isUseSSL()) {
                protocol = "ldaps";
            }
            String url = new StringBuffer().append(protocol + "://").append(host).append(":").append(this.dbcLdapProps.getPortNumber()).toString();
            context.logMessage(context.getPluginInfo(), 0, "Connecting to LDAP server:" + sslLog + url);
            env.put("java.naming.provider.url", url);
            try {
                initCtx = new InitialLdapContext(env, null);
            }
            catch (NamingException ne) {
                initCtx = null;
                if (this.dbcLdapProps.getHostNames().size() > count) {
                    ++count;
                    context.logMessage(context.getPluginInfo(), 2, ne.toString());
                }
                throw ne;
            }
            if (initCtx == null) continue;
            this.dbcLdapProps.setResolvedHost(host);
            break;
        }
        if ((pageSize = this.dbcLdapProps.getPageSize()) != 0) {
            initCtx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, true)});
        }
        return initCtx;
    }

    RootDSE getBaseName(LdapContext ldapContext) {
        RootDSE rootDSE = new RootDSE();
        try {
            String[] attrIds = new String[]{"subschemaSubentry", "defaultNamingContext", "namingContexts", ""};
            Enumeration<SearchResult> enm = this.searchLDAP("", ldapContext, attrIds);
            if (enm.hasMoreElements()) {
                SearchResult result = enm.nextElement();
                Attributes attrs = result.getAttributes();
                NamingEnumeration<String> attrEnum = attrs.getIDs();
                boolean ncFound = false;
                while (attrEnum.hasMoreElements()) {
                    String attrID = (String)attrEnum.nextElement();
                    if ("subschemaSubentry".equals(attrID)) {
                        rootDSE.setSubSchemaSubentry(attrs.get(attrID).get().toString());
                        continue;
                    }
                    if ("defaultNamingContext".equals(attrID)) {
                        rootDSE.setDefaultNamingContext(attrs.get(attrID).get().toString());
                        ncFound = true;
                        continue;
                    }
                    if (!"namingContexts".equals(attrID) || ncFound) continue;
                    rootDSE.setDefaultNamingContext(attrs.get(attrID).get(0).toString());
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return rootDSE;
    }

    public void setDbcLdapProps(DBCLdapProperties dbcLdapProps) {
        this.dbcLdapProps = dbcLdapProps;
    }

    public DBCLdapProperties getDbcLdapProps() {
        return this.dbcLdapProps;
    }

    List<ARVendorField> getObjectAttributes(String tableName, RootDSE rootDSE, LdapContext ldapContext) throws NamingException {
        ArrayList<ARVendorField> fields = new ArrayList<ARVendorField>();
        String filter = ARDBCLDAPContext.getFilter(tableName);
        String[] attrs = new String[]{"*", "createTimestamp", "modifyTimestamp", "creatorsName", "modifiersName"};
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(attrs);
        sCntrl.setSearchScope(2);
        sCntrl.setCountLimit(1L);
        NamingEnumeration<SearchResult> enm = ldapContext.search(this.getBaseDN(rootDSE), filter, sCntrl);
        if (enm.hasMoreElements()) {
            SearchResult result = (SearchResult)enm.nextElement();
            Attributes attributes = result.getAttributes();
            NamingEnumeration<? extends Attribute> attrEnum = attributes.getAll();
            while (attrEnum.hasMoreElements()) {
                String syntaxValue;
                Attribute nextElement = (Attribute)attrEnum.nextElement();
                ARVendorField field = new ARVendorField();
                DirContext attrCtx = nextElement.getAttributeDefinition();
                field.setName(nextElement.getID());
                Attribute syntaxAttrib = attrCtx.getAttributes("").get("SYNTAX");
                field.setDataType(4);
                if (syntaxAttrib != null && (syntaxValue = (String)syntaxAttrib.get()) != null) {
                    if (syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.27") || syntaxValue.equals("Integer")) {
                        field.setDataType(2);
                    } else if (syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.24") || syntaxValue.equals("GeneralizedTime")) {
                        field.setDataType(7);
                    } else if (syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.1") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.4") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.5") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.8") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.9") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.10") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.23") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.28") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.49") || syntaxValue.equals("ACIItem") || syntaxValue.equals("Audio") || syntaxValue.equals("Binary") || syntaxValue.equals("Certificate") || syntaxValue.equals("CertificateList") || syntaxValue.equals("CertificatePair") || syntaxValue.equals("Fax") || syntaxValue.equals("JPEG") || syntaxValue.equals("SupportedAlgorithm")) {
                        field.setDataType(11);
                    }
                }
                fields.add(field);
            }
        }
        return fields;
    }

    static String getFilter(String tableName) {
        String[] parts = tableName.split("\\?");
        return parts[parts.length - 1];
    }

    private void setHostNames(String hostNames) {
        if (hostNames == null) {
            return;
        }
        ArrayList<String> hosts = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(hostNames);
        while (st.hasMoreTokens()) {
            String host = st.nextToken();
            if (host.contains(":") && !host.startsWith("[")) {
                host = "[" + host + "]";
            }
            hosts.add(host);
        }
        this.dbcLdapProps.setHostNames(hosts);
    }

    private void setCertificate() {
    }
}

