/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.alert.twitter;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.alert.AlertDeliveryContext;
import com.bmc.arsys.plugins.alert.AlertDeliveryPlugin;
import com.bmc.arsys.plugins.alert.twitter.TwitterOAuthorizer;
import com.bmc.arsys.plugins.alert.twitter.TwitterProxyUtil;
import com.bmc.arsys.plugins.alert.utils.ExpiringMap;
import com.bmc.arsys.plugins.proxy.ProxyInfo;
import com.bmc.arsys.plugins.proxy.ProxyUtil;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterAlertDeliveryPlugin
extends AlertDeliveryPlugin {
    private static Map<String, TwitterOAuthorizer> authorizers = new ExpiringMap<String, TwitterOAuthorizer>(600000);
    private static final String GET_AUTHORIZATION_URL_ACTION = "GET-AUTHORIZATION-URL";
    private static final String SET_PIN_ACTION = "SET-PIN";
    private static ProxyInfo proxyInfo = null;
    private String secret = null;
    private String key = null;

    public void initialize(ARPluginContext pluginContext) throws ARException {
        this.secret = pluginContext.getARConfigEntry("Twitter-Consumer-Secret");
        this.key = pluginContext.getARConfigEntry("Twitter-Consumer-Key");
        if (this.secret == null || "".equals(this.secret.trim())) {
            pluginContext.logMessage(0, "Consumer Secret is NULL in the configuration file so considering the default one.");
            this.secret = "a7ISsw17kUKuRx2doSxsMDXT8ADAw3nSQqlaVgnRY";
        }
        if (this.key == null || "".equals(this.key.trim())) {
            pluginContext.logMessage(0, "Consumer Key is NULL in the configuration file so considering the default one.");
            this.key = "9HEcXm9rTSil55VzFOQcA";
        }
        try {
            proxyInfo = ProxyUtil.getProxyInfo(pluginContext);
        }
        catch (ARException e) {
            pluginContext.logMessage(1, " Error while Plugin initialization. Will initialize later." + e.getMessage());
        }
    }

    private boolean isOAuthConfigCall(List<Value> pInValues) {
        Value value;
        int paramCount = pInValues != null ? pInValues.size() : 0;
        String action = null;
        if (paramCount >= 1 && (value = pInValues.get(0)) != null) {
            action = value.toString();
        }
        return GET_AUTHORIZATION_URL_ACTION.compareToIgnoreCase(action) == 0 || SET_PIN_ACTION.compareToIgnoreCase(action) == 0;
    }

    @Override
    public List<Value> filterAPICall(ARPluginContext pluginContext, List<Value> pInValues) throws ARException {
        if (this.isOAuthConfigCall(pInValues)) {
            String action = pInValues.get(0).toString();
            try {
                if (GET_AUTHORIZATION_URL_ACTION.compareToIgnoreCase(action) == 0) {
                    String authorizerId = UUID.randomUUID().toString();
                    pluginContext.logMessage(0, "Consumer Secret: " + this.secret);
                    pluginContext.logMessage(0, "Consumer Key: " + this.key);
                    if (proxyInfo == null) {
                        this.initialize(pluginContext);
                    }
                    TwitterOAuthorizer authorizer = new TwitterOAuthorizer(this.key, this.secret, proxyInfo);
                    assert (authorizer != null);
                    authorizers.put(authorizerId, authorizer);
                    pluginContext.logMessage(0, "Stashing away authorizer with id: " + authorizerId);
                    return Arrays.asList(new Value(action), new Value(authorizerId), new Value(authorizer.getAuthorizationURL()));
                }
                if (SET_PIN_ACTION.compareToIgnoreCase(action) == 0) {
                    pluginContext.logMessage(0, "Raw In Values: " + pInValues.toString());
                    String authorizerId = pInValues.get(1).toString();
                    pluginContext.logMessage(0, "Retrieving authorizer with id: " + authorizerId + " from the map of size : " + authorizers.size());
                    TwitterOAuthorizer authorizer = authorizers.get(authorizerId);
                    if (authorizer == null) {
                        throw new ARException(2, 8753, "Twitter authorizer not found for authorizer ID" + authorizerId);
                    }
                    String pin = pInValues.get(2).toString();
                    authorizer.setPin(pin);
                    return Arrays.asList(new Value(action), new Value(authorizerId), new Value(pin), new Value(authorizer.getAccessToken()), new Value(authorizer.getAccessTokenSecret()), new Value(authorizer.getConsumerKey()), new Value(authorizer.getConsumerSecret()));
                }
            }
            catch (TwitterException e) {
                pluginContext.logMessage(2, e.toString());
                throw new ARException(2, 8753, e.toString());
            }
        }
        return super.filterAPICall(pluginContext, pInValues);
    }

    @Override
    public void onAlert(AlertDeliveryContext context) throws ARException {
        context.getInnerContext().logMessage(0, "onAlert: Begin");
        context.getInnerContext().logMessage(0, "onAlert: inValues " + context.getRawInValueList().toString());
        Map<String, String> argMap = context.getPluginArgs();
        String consumerKey = argMap.get("consumer-key");
        if (consumerKey == null || consumerKey.length() == 0) {
            throw new ARException(2, 8753, "consumer-key is null or empty");
        }
        String consumerSecret = argMap.get("consumer-secret");
        if (consumerSecret == null || consumerSecret.length() == 0) {
            throw new ARException(2, 8753, "consumer-secret is null or empty");
        }
        String accessToken = argMap.get("access-token");
        if (accessToken == null || accessToken.length() == 0) {
            throw new ARException(2, 8753, "access-token is null or empty");
        }
        String accessTokenSecret = argMap.get("access-token-secret");
        if (accessTokenSecret == null || accessTokenSecret.length() == 0) {
            throw new ARException(2, 8753, "access-token-secret is null or empty");
        }
        this.tweet(context.getInnerContext(), consumerKey, consumerSecret, accessToken, accessTokenSecret, context.getAlertText());
        context.getInnerContext().logMessage(0, "onAlert: End");
    }

    private void tweet(ARPluginContext pc, String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret, String text) throws ARException {
        pc.logMessage(0, "consumerKey: " + consumerKey);
        pc.logMessage(0, "consumerSecret: " + consumerSecret);
        pc.logMessage(0, "accessToken: " + accessToken);
        pc.logMessage(0, "accessTokenSecret: " + accessTokenSecret);
        if (proxyInfo != null) {
            pc.logMessage(0, "Proxy parameters: host=" + proxyInfo.getHttpProxyHost() + ", port=" + proxyInfo.getHttpProxyPort() + ", user=" + proxyInfo.getHttpProxyUser());
        }
        pc.logMessage(0, "text: " + text);
        if (text.length() > 140) {
            text = text.substring(0, 137) + "...";
            pc.logMessage(1, "text is truncated since it has more than 140 characters: " + text);
        }
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb = TwitterProxyUtil.getConfigBuilderWithProxyAndSSL(cb, proxyInfo);
        cb.setDebugEnabled(true).setOAuthConsumerKey(consumerKey).setOAuthConsumerSecret(consumerSecret).setOAuthAccessToken(accessToken).setOAuthAccessTokenSecret(accessTokenSecret);
        try {
            TwitterFactory tf = new TwitterFactory(cb.build());
            Twitter twitter = tf.getInstance();
            Status status = twitter.updateStatus(text);
            pc.logMessage(0, "Successfully updated the status to [" + status.getText() + "].");
        }
        catch (TwitterException e) {
            pc.logMessage(2, e.toString());
            throw new ARException(2, 8753, text + "\n" + e.toString());
        }
        catch (Exception e) {
            pc.logMessage(2, e.toString());
            throw new ARException(2, 8753, text + "\n" + e.toString());
        }
    }
}

