/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.query;

import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.lucene.LuceneFTSService;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzer;
import com.bmc.arsys.fts.impl.lucene.query.WildcardPhraseQuery;
import com.bmc.thirdparty.org.apache.commons.lang.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class FTSQueryParser {
    private final FTSAnalyzer analyzer;
    private static final Logger LOGGER = Logger.getLogger(LuceneFTSService.class);
    private static final int kAND = 1;
    private static final int kOR = 2;
    private static final int kNOT = 3;
    private static final int kParenth = 4;
    private static final int kPlainToken = 1;
    private static final int kParenthToken = 2;
    private static final int kOp = 3;
    private final int kEqualType = 1;
    private final int kGreaterEqualType = 2;
    private final int kLesserEqualType = 3;
    private final int kGreaterType = 4;
    private final int kLesserlType = 5;

    public FTSQueryParser(FTSAnalyzer analyzer) {
        BooleanQuery.setMaxClauseCount((int)2048);
        this.analyzer = analyzer;
    }

    public Query docIdQuery(Hashtable<String, String> returnEntries) {
        LOGGER.debug((Object)("The number of entrys that should be returned are: " + returnEntries.size()));
        ArrayList<Term> termsList = new ArrayList<Term>();
        Iterator<String> i = returnEntries.keySet().iterator();
        while (i.hasNext()) {
            Term term = new Term("docId", i.next());
            termsList.add(term);
        }
        if (!termsList.isEmpty()) {
            TermsFilter termsFilter = new TermsFilter(termsList);
            return new ConstantScoreQuery((Filter)termsFilter);
        }
        return null;
    }

    public Query docIdSchemaIdQuery(Map<String, Map<String, String>> returnSchemaEntriesMap) {
        BooleanQuery globalQuery = new BooleanQuery();
        for (Map.Entry<String, Map<String, String>> entry : returnSchemaEntriesMap.entrySet()) {
            BooleanQuery bq = new BooleanQuery();
            String schemaId = entry.getKey();
            Term schemaTerm = new Term("schemaId", schemaId);
            TermQuery termQuery = new TermQuery(schemaTerm);
            ArrayList<Term> termsList = new ArrayList<Term>(entry.getValue().size());
            for (Map.Entry<String, String> entryScore : entry.getValue().entrySet()) {
                String entryId = entryScore.getKey();
                Term term = new Term("docId", entryId);
                termsList.add(term);
            }
            if (termsList.isEmpty()) continue;
            TermsFilter termsFilter = new TermsFilter(termsList);
            ConstantScoreQuery q = new ConstantScoreQuery((Filter)termsFilter);
            bq.add((Query)termQuery, BooleanClause.Occur.MUST);
            bq.add((Query)q, BooleanClause.Occur.MUST);
            globalQuery.add((Query)bq, BooleanClause.Occur.SHOULD);
        }
        return globalQuery;
    }

    public Query createDeleteFieldQuery(String fieldName, String[] queryFieldNames, String[] queryFieldValues) {
        if (queryFieldNames == null || queryFieldNames.length == 1 && queryFieldNames[0].equals("schemaId")) {
            queryFieldNames = null;
            return this.unqualifiedWildcardQuery();
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        if (queryFieldNames != null) {
            for (int x = 0; x < queryFieldNames.length; ++x) {
                if (queryFieldNames[x] == null || queryFieldValues[x] == null || queryFieldNames.equals("schemaId")) continue;
                Term term = new Term(queryFieldNames[x], queryFieldValues[x]);
                TermQuery termQuery = new TermQuery(term);
                booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
            }
        }
        return booleanQuery;
    }

    public Query createQuery(String schemaId, String[] queryFieldNames, String[] queryFieldValues, BitSet[] fullTextOptions, boolean isCaseSensitive) {
        BooleanQuery booleanQuery = new BooleanQuery();
        boolean isNOT = false;
        for (int x = 0; x < queryFieldNames.length; ++x) {
            if (queryFieldValues[x] == null || queryFieldValues[x].length() <= 0) continue;
            String value = queryFieldValues[x].replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\\\_", "_").replaceAll("%\"", "\"").replaceAll("\"%", "\"").replaceAll("%'", "").replaceAll("'%", "").trim();
            LOGGER.debug((Object)("Query Field/Value: " + queryFieldNames[x] + "/" + value));
            if (value == null || value.length() <= 0) continue;
            if (value.startsWith("NOT ")) {
                isNOT = true;
                value = value.substring(4);
            } else {
                isNOT = false;
            }
            Query query = this.buildQuery(schemaId, queryFieldNames[x], value, fullTextOptions[x], isCaseSensitive);
            if (query == null) continue;
            if (isNOT) {
                booleanQuery.add(query, BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(query, BooleanClause.Occur.MUST);
        }
        return booleanQuery;
    }

    public Filter createGlobalFilter(String filterQuery, List<FTSService.QuerySchemas> querySchemas, boolean isCaseSensitive) throws FTSServiceException {
        Query query = this.syntaxGlobalQuery(filterQuery, null, isCaseSensitive, true, querySchemas);
        if (query != null) {
            return new QueryWrapperFilter(query);
        }
        return null;
    }

    public Query unqualifiedWildcardQuery() {
        String wildcardValue = "*";
        Term term = this.analyzer.analyzeSearchTerm("entryId", wildcardValue, true);
        WildcardQuery wildcardQuery = new WildcardQuery(term);
        return wildcardQuery;
    }

    public Query createGlobalQuery(String shouldQueryValue, String mustQueryValue, String notQueryValue, FTSService.QuerySchemas querySchemas, boolean isCaseSensitive, String[] accrueValuesShould, String[] accrueValuesMust, String[] accrueValuesNo) throws FTSServiceException {
        BooleanQuery booleanQuery = new BooleanQuery();
        if (shouldQueryValue != null && shouldQueryValue != "") {
            shouldQueryValue = this.createOptimizedShouldQuery(shouldQueryValue);
            booleanQuery.add(this.createGlobalQuery(shouldQueryValue, querySchemas, isCaseSensitive, false, accrueValuesShould), BooleanClause.Occur.SHOULD);
        }
        if (mustQueryValue != null && mustQueryValue != "") {
            booleanQuery.add(this.createGlobalQuery(mustQueryValue, querySchemas, isCaseSensitive, true, accrueValuesMust), BooleanClause.Occur.MUST);
        }
        if (notQueryValue != null && notQueryValue != "") {
            if (mustQueryValue == null && shouldQueryValue == null) {
                TermQuery tq = new TermQuery(new Term("schemaId", querySchemas.schemaId));
                booleanQuery.add((Query)tq, BooleanClause.Occur.MUST);
            }
            booleanQuery.add(this.createGlobalQuery(notQueryValue, querySchemas, isCaseSensitive, false, accrueValuesNo), BooleanClause.Occur.MUST_NOT);
        }
        return booleanQuery;
    }

    public String[] getAccrueValues(String queryValue, boolean isMust) {
        String[] accrueValues = new String[]{};
        if (isMust && StringUtils.isNotBlank((String)queryValue) && (queryValue.indexOf(",") > -1 || queryValue.indexOf("\"") == -1 && queryValue.indexOf(" ") > -1)) {
            queryValue = queryValue.replaceAll(" ", ",");
            accrueValues = queryValue.split(",");
            return accrueValues;
        }
        if (StringUtils.isNotBlank((String)queryValue)) {
            accrueValues = new String[]{queryValue};
        }
        return accrueValues;
    }

    private Query createGlobalQuery(String queryValue, FTSService.QuerySchemas qs, boolean isCaseSensitive, boolean isMust, String[] accrueValues) throws FTSServiceException {
        BooleanQuery booleanQuery = new BooleanQuery();
        BooleanQuery bq = new BooleanQuery();
        bq.add(this.buildGlobalQuery(queryValue, qs, isCaseSensitive, isMust, accrueValues), BooleanClause.Occur.MUST);
        booleanQuery.add((Query)bq, BooleanClause.Occur.SHOULD);
        return booleanQuery;
    }

    private Query buildGlobalQuery(String queryValue, FTSService.QuerySchemas querySchema, boolean isCaseSensitive, boolean isMust, String[] accrueValues) throws FTSServiceException {
        if (queryValue.indexOf("(") > -1 || queryValue.indexOf(" AND ") > -1 || queryValue.indexOf(" OR ") > -1 || queryValue.indexOf(" NOT ") > -1) {
            Query query = null;
            query = this.syntaxGlobalQuery(queryValue, querySchema, isCaseSensitive, false, null);
            return query;
        }
        if (isMust && queryValue.indexOf(",") > -1) {
            return this.mustAccrueQuery(queryValue, querySchema, isCaseSensitive, accrueValues);
        }
        if (isMust && queryValue.indexOf("\"") == -1 && queryValue.indexOf(" ") > -1) {
            return this.mustAccrueQuery(queryValue, querySchema, isCaseSensitive, accrueValues);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        List<String> queryFieldNames = querySchema.queryFieldNames;
        List<BitSet> fullTextOptions = querySchema.fullTextOptions;
        int count = 0;
        for (String queryFieldName : queryFieldNames) {
            Query query = this.buildQuery(querySchema.schemaId, queryFieldName, queryValue, fullTextOptions.get(count), isCaseSensitive, true);
            if (query != null) {
                booleanQuery.add(query, BooleanClause.Occur.SHOULD);
            }
            ++count;
        }
        return booleanQuery;
    }

    private Query mustAccrueQuery(String queryValue, FTSService.QuerySchemas querySchema, boolean isCaseSensitive, String[] accrueValues) {
        BooleanQuery booleanQuery = new BooleanQuery();
        List<String> queryFieldNames = querySchema.queryFieldNames;
        List<BitSet> fullTextOptions = querySchema.fullTextOptions;
        for (int x = 0; x < accrueValues.length; ++x) {
            BooleanQuery bq = new BooleanQuery();
            int count = 0;
            String trimmedAccrueValue = accrueValues[x].trim();
            for (String queryFieldName : queryFieldNames) {
                Query query = this.buildQuery(querySchema.schemaId, queryFieldName, trimmedAccrueValue, fullTextOptions.get(count), isCaseSensitive);
                if (query != null) {
                    bq.add(query, BooleanClause.Occur.SHOULD);
                }
                ++count;
            }
            if (bq.clauses().size() == 0) continue;
            booleanQuery.add((Query)bq, BooleanClause.Occur.MUST);
        }
        return booleanQuery;
    }

    private Query buildQuery(String schemaId, String queryFieldName, String queryFieldValue, BitSet fullTextOption, boolean isCaseSensitive) {
        return this.buildQuery(schemaId, queryFieldName, queryFieldValue, fullTextOption, isCaseSensitive, false);
    }

    private Query buildQuery(String schemaId, String queryFieldName, String queryFieldValue, BitSet fullTextOption, boolean isCaseSensitive, boolean isGlobal) {
        Query returnQuery = null;
        String trimmedValue = queryFieldValue.trim();
        returnQuery = queryFieldValue.indexOf(",") > -1 && !fullTextOption.get(1) ? this.accrueQuery(schemaId, queryFieldName, trimmedValue, fullTextOption, isCaseSensitive) : (queryFieldValue.indexOf(" OR ") > -1 ? this.orQuery(schemaId, queryFieldName, trimmedValue, fullTextOption, isCaseSensitive) : (!fullTextOption.get(1) && queryFieldValue.matches(".*[\u3100-\u312f\u3040-\u309f\u30a0-\u30ff\u31f0-\u31ff\u3300-\u337f\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\uff65-\uff9f]+.*") ? (isGlobal && queryFieldValue.indexOf(" ") > -1 ? this.accrueQuery(schemaId, queryFieldName, trimmedValue.replace(" ", ", "), fullTextOption, isCaseSensitive) : this.phraseQuery(schemaId, queryFieldName, trimmedValue.replaceAll("%", ""), fullTextOption, isCaseSensitive)) : (isGlobal && queryFieldValue.indexOf("%") > -1 && trimmedValue.indexOf(" ") > -1 && !fullTextOption.get(1) && queryFieldValue.indexOf("\"") == -1 ? this.accrueQuery(schemaId, queryFieldName, trimmedValue.replace(" ", ", "), fullTextOption, isCaseSensitive) : (queryFieldValue.indexOf("%") > -1 && !fullTextOption.get(1) && trimmedValue.indexOf(" ") > -1 || queryFieldValue.indexOf("%") > -1 && !fullTextOption.get(1) && trimmedValue.matches(".*[_\\W&&[^%]]+.*") ? this.wildcardPhraseQuery(schemaId, queryFieldName, trimmedValue, fullTextOption, isCaseSensitive) : (queryFieldValue.indexOf("%") > -1 ? this.wildcardQuery(schemaId, queryFieldName, trimmedValue, fullTextOption, isCaseSensitive) : (isGlobal && queryFieldValue.indexOf("\"") > -1 && !fullTextOption.get(1) ? this.phraseQuery(schemaId, queryFieldName, trimmedValue, fullTextOption, isCaseSensitive) : (isGlobal && queryFieldValue.indexOf(" ") > -1 && !fullTextOption.get(1) ? this.accrueQuery(schemaId, queryFieldName, trimmedValue.replace(" ", ", "), fullTextOption, isCaseSensitive) : (!isGlobal && queryFieldValue.indexOf(" ") > -1 && !fullTextOption.get(1) ? this.phraseQuery(schemaId, queryFieldName, trimmedValue, fullTextOption, isCaseSensitive) : this.termQuery(schemaId, queryFieldName, trimmedValue, fullTextOption, isCaseSensitive)))))))));
        return returnQuery;
    }

    private WordToken getNextToken(String queryValue) throws FTSServiceException {
        if (queryValue == null || queryValue.equals("")) {
            return null;
        }
        queryValue = queryValue.trim();
        WordToken wordToken = new WordToken();
        int firstPos = queryValue.length();
        int firstType = 0;
        int andPos = this.getKeywordPos(" AND ", queryValue);
        if (queryValue.indexOf("AND ") == 0) {
            andPos = 0;
        }
        int orPos = this.getKeywordPos(" OR ", queryValue);
        if (queryValue.indexOf("OR ") == 0) {
            orPos = 0;
        }
        int notPos = this.getKeywordPos(" NOT ", queryValue);
        if (queryValue.indexOf("NOT ") == 0) {
            notPos = 0;
        }
        int parenthPos = this.getKeywordPos("(", queryValue);
        if (andPos > -1 && andPos < firstPos) {
            firstPos = andPos;
            firstType = 1;
        }
        if (orPos > -1 && orPos < firstPos) {
            firstPos = orPos;
            firstType = 2;
        }
        if (notPos > -1 && notPos < firstPos) {
            firstPos = notPos;
            firstType = 3;
        }
        if (parenthPos > -1 && parenthPos < firstPos) {
            firstPos = parenthPos;
            firstType = 4;
        }
        if (firstType == 0) {
            wordToken.token = queryValue;
            wordToken.position = firstPos;
            wordToken.type = 1;
            wordToken.remainingText = null;
        } else if ((firstType == 1 || firstType == 2 || firstType == 3) && firstPos == 0) {
            wordToken.token = queryValue.substring(0, this.getOpCharCount(firstType, firstPos)).trim();
            wordToken.position = firstPos;
            wordToken.type = 3;
            wordToken.remainingText = this.getRemainingText(queryValue, this.getOpCharCount(firstType, firstPos));
        } else if (firstPos == 0 && firstType == 4) {
            int endParenth = this.getClosingParenth(queryValue);
            wordToken.token = queryValue.substring(firstPos, endParenth + 1).trim();
            wordToken.position = firstPos;
            wordToken.type = 2;
            wordToken.remainingText = this.getRemainingText(queryValue, endParenth);
        } else {
            wordToken.token = queryValue.substring(0, firstPos).trim();
            wordToken.position = firstPos;
            wordToken.type = 1;
            wordToken.remainingText = this.getRemainingText(queryValue, firstPos - 1);
        }
        return wordToken;
    }

    private int getKeywordPos(String keyword, String queryValue) {
        int quoteStart = -1;
        int quoteEnd = -1;
        boolean continueSearch = true;
        int keywordPos = -1;
        while (continueSearch) {
            if (quoteStart < queryValue.length()) {
                keywordPos = queryValue.indexOf(keyword, quoteStart);
                if (keywordPos > -1) {
                    quoteStart = queryValue.indexOf("\"", quoteStart);
                    quoteEnd = queryValue.indexOf("\"", quoteStart + 1);
                    if (keywordPos > quoteStart && keywordPos < quoteEnd) {
                        quoteStart = quoteEnd + 1;
                        keywordPos = -1;
                        continue;
                    }
                    continueSearch = false;
                    continue;
                }
                continueSearch = false;
                continue;
            }
            continueSearch = false;
        }
        return keywordPos;
    }

    private int getOpCharCount(int type, int pos) {
        if (pos == 0) {
            if (type == 2) {
                return 2;
            }
            return 3;
        }
        if (type == 2) {
            return 3;
        }
        return 4;
    }

    private String getRemainingText(String queryValue, int endPos) {
        if (endPos == queryValue.length()) {
            return null;
        }
        return queryValue.substring(endPos + 1).trim();
    }

    private ArrayList<WordToken> tokenize(String queryValue) throws FTSServiceException {
        ArrayList<WordToken> tokens = new ArrayList<WordToken>();
        String value = queryValue = queryValue.replaceAll("LIKE", "").replaceAll("AND NOT", "NOT");
        boolean isNext = true;
        WordToken wt = null;
        while (isNext) {
            wt = this.getNextToken(value);
            if (wt == null) {
                isNext = false;
                break;
            }
            value = wt.remainingText;
            tokens.add(wt);
        }
        BooleanClause.Occur setOccur = BooleanClause.Occur.SHOULD;
        for (int x = 0; x < tokens.size(); ++x) {
            WordToken wordToken = tokens.get(x);
            wordToken.operator = setOccur;
            if (wordToken.type != 3) continue;
            if (wordToken.token.equals("OR")) {
                setOccur = BooleanClause.Occur.SHOULD;
                continue;
            }
            if (wordToken.token.equals("NOT")) {
                setOccur = BooleanClause.Occur.MUST_NOT;
                continue;
            }
            if (!wordToken.token.equals("AND")) continue;
            setOccur = BooleanClause.Occur.MUST;
            if (x == 0) continue;
            tokens.get((int)(x - 1)).operator = setOccur;
        }
        return tokens;
    }

    public Query syntaxGlobalQuery(String queryValue, FTSService.QuerySchemas querySchema, boolean isCaseSensitive, boolean isFilter, List<FTSService.QuerySchemas> querySchemas) throws FTSServiceException {
        BooleanQuery booleanQuery = new BooleanQuery();
        ArrayList<WordToken> tokens = this.tokenize(queryValue);
        if (tokens.size() != 0 && tokens.get((int)0).type == 3) {
            throw new FTSServiceException(this.getClass().getName() + ": Illegal construct, a segment should not begin with \"AND\", \"OR\", \"AND NOT\", or \"NOT\": " + queryValue);
        }
        BitSet litBitSet = new BitSet(1);
        litBitSet.set(1);
        String upperRangeField = null;
        String lowerRangeField = null;
        long upperRangeValue = 0L;
        long lowerRangeValue = 0L;
        String lastField = null;
        boolean inclusive = false;
        FieldTermPair fieldTermPair = null;
        BooleanClause.Occur tokenOperator = null;
        for (WordToken token : tokens) {
            tokenOperator = token.operator;
            if (token.type == 2) {
                Query query = this.syntaxGlobalQuery(token.token.substring(1, token.token.length() - 1), querySchema, isCaseSensitive, isFilter, querySchemas);
                if (query == null) continue;
                booleanQuery.add(query, token.operator);
                continue;
            }
            if (token.token == null || token.token.equals("") || token.type == 3) continue;
            if (isFilter) {
                fieldTermPair = this.getFieldTermPair(token.token);
                if (fieldTermPair.opType > 1 && (fieldTermPair.field.equals("createTime") || fieldTermPair.field.equals("modifiedTime"))) {
                    NumericRangeQuery rangeQuery;
                    boolean setFieldAndType = true;
                    if (lastField == null || lastField.equals(fieldTermPair.field)) {
                        if (this.isUpperRange(fieldTermPair)) {
                            upperRangeField = fieldTermPair.field;
                            upperRangeValue = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                        } else {
                            lowerRangeField = fieldTermPair.field;
                            lowerRangeValue = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                        }
                    }
                    if (upperRangeField != null && lowerRangeField != null && lastField.equals(fieldTermPair.field)) {
                        rangeQuery = NumericRangeQuery.newLongRange((String)upperRangeField, (Long)lowerRangeValue, (Long)upperRangeValue, (boolean)this.isInclusive(fieldTermPair), (boolean)this.isInclusive(fieldTermPair));
                        booleanQuery.add((Query)rangeQuery, tokenOperator);
                        upperRangeField = null;
                        upperRangeValue = 0L;
                        lowerRangeField = null;
                        lowerRangeValue = 0L;
                        lastField = null;
                        setFieldAndType = false;
                    } else if (lastField != null && !lastField.equals(fieldTermPair.field)) {
                        rangeQuery = null;
                        rangeQuery = upperRangeField != null ? NumericRangeQuery.newLongRange((String)upperRangeField, null, (Long)upperRangeValue, (boolean)inclusive, (boolean)inclusive) : NumericRangeQuery.newLongRange((String)lowerRangeField, (Long)lowerRangeValue, null, (boolean)inclusive, (boolean)inclusive);
                        booleanQuery.add((Query)rangeQuery, tokenOperator);
                        if (this.isUpperRange(fieldTermPair)) {
                            upperRangeField = fieldTermPair.field;
                            upperRangeValue = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                            lowerRangeField = null;
                            lowerRangeValue = 0L;
                        } else {
                            lowerRangeField = fieldTermPair.field;
                            lowerRangeValue = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                            upperRangeField = null;
                            upperRangeValue = 0L;
                        }
                    }
                    if (setFieldAndType) {
                        lastField = fieldTermPair.field;
                    }
                    inclusive = this.isInclusive(fieldTermPair);
                    continue;
                }
                if (fieldTermPair.opType == 1 && (fieldTermPair.field.equals("createTime") || fieldTermPair.field.equals("modifiedTime"))) {
                    Long date = this.convertDate(fieldTermPair.field, fieldTermPair.term);
                    booleanQuery.add((Query)NumericRangeQuery.newLongRange((String)fieldTermPair.field, (Long)date, (Long)date, (boolean)true, (boolean)true), tokenOperator);
                    continue;
                }
                if (fieldTermPair.term == null || fieldTermPair.term.length() <= 0) continue;
                booleanQuery.add(this.termQuery(null, fieldTermPair.field, fieldTermPair.term, litBitSet, isCaseSensitive), tokenOperator);
                continue;
            }
            String[] accrueValues = this.getAccrueValues(token.token, false);
            booleanQuery.add(this.buildGlobalQuery(token.token, querySchema, isCaseSensitive, false, accrueValues), token.operator);
        }
        if (lastField != null && (upperRangeField != null || lowerRangeField != null)) {
            NumericRangeQuery rangeQuery = null;
            rangeQuery = upperRangeField != null && lowerRangeField == null ? NumericRangeQuery.newLongRange(upperRangeField, null, (Long)upperRangeValue, (boolean)inclusive, (boolean)inclusive) : (upperRangeField == null && lowerRangeField != null ? NumericRangeQuery.newLongRange(lowerRangeField, (Long)lowerRangeValue, null, (boolean)inclusive, (boolean)inclusive) : NumericRangeQuery.newLongRange(upperRangeField, (Long)lowerRangeValue, (Long)upperRangeValue, (boolean)inclusive, (boolean)inclusive));
            booleanQuery.add((Query)rangeQuery, tokenOperator);
            upperRangeField = null;
            upperRangeValue = 0L;
            lowerRangeField = null;
            lowerRangeValue = 0L;
            lastField = null;
        }
        if (booleanQuery.getClauses().length > 0) {
            return booleanQuery;
        }
        return null;
    }

    private long convertDate(String field, String value) {
        long nReturn = 0L;
        if (field.equals("createTime") || field.endsWith("modifiedTime")) {
            try {
                String strFormat = null;
                if (value.indexOf(":") > -1) {
                    strFormat = "MM/dd/yyyy hh:mm:ss aa";
                } else if (value.indexOf("/") > -1) {
                    strFormat = "MM/dd/yyyy";
                } else {
                    if (value.startsWith("J")) {
                        Double nDouble = (Double.parseDouble(value.substring(1)) - 2440587.5) * 86400.0;
                        return nDouble.longValue();
                    }
                    return Long.parseLong(value);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(strFormat);
                Date date = simpleDateFormat.parse(value);
                nReturn = date.getTime() / 1000L;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Problem converting date " + e.getLocalizedMessage()));
            }
        }
        return nReturn;
    }

    private boolean isUpperRange(FieldTermPair fieldTermPair) {
        boolean bReturn = false;
        if (fieldTermPair.opType == 2 || fieldTermPair.opType == 4) {
            if (!fieldTermPair.isFieldLeft) {
                bReturn = true;
            }
        } else if (fieldTermPair.isFieldLeft) {
            bReturn = true;
        }
        return bReturn;
    }

    private boolean isInclusive(FieldTermPair fieldTermPair) {
        boolean bReturn = false;
        if (fieldTermPair != null && (fieldTermPair.opType == 2 || fieldTermPair.opType == 3)) {
            bReturn = true;
        }
        return bReturn;
    }

    private FieldTermPair getFieldTermPair(String token) throws FTSServiceException {
        FieldTermPair fieldTermPair = new FieldTermPair();
        int startField = token.indexOf("'");
        int endField = token.indexOf("'", startField + 1);
        if (startField == -1 || endField == -1) {
            throw new FTSServiceException(this.getClass().getName() + ": The filter parser identified a missing single quote in the construct: " + token);
        }
        fieldTermPair.field = token.substring(startField + 1, endField);
        int startTerm = token.indexOf("\"");
        int endTerm = token.indexOf("\"", startTerm + 1);
        if (startTerm == -1 || endTerm == -1) {
            throw new FTSServiceException(this.getClass().getName() + ": The filter parser identified a missing double quote in the construct: " + token);
        }
        fieldTermPair.term = token.substring(startTerm + 1, endTerm);
        if (token.indexOf(">=") > -1 || token.indexOf("=>") > -1) {
            fieldTermPair.opType = 2;
        } else if (token.indexOf("<=") > -1 || token.indexOf("=<") > -1) {
            fieldTermPair.opType = 3;
        } else if (token.indexOf(">") > -1) {
            fieldTermPair.opType = 4;
        } else if (token.indexOf("<") > -1) {
            fieldTermPair.opType = 5;
        } else if (token.indexOf("=") > -1) {
            fieldTermPair.opType = 1;
        } else {
            throw new FTSServiceException(this.getClass().getName() + ": The filter parser identified an invalid operator in the construct: " + token);
        }
        fieldTermPair.isFieldLeft = startField < startTerm;
        return fieldTermPair;
    }

    private int getClosingParenth(String queryValue) throws FTSServiceException {
        int nBegin = 0;
        int nEnd = 0;
        int nLevel = 1;
        int nTempBegin = nBegin = queryValue.indexOf("(", nBegin);
        int nTempClose = nBegin;
        int nTestCloseParenth = 0;
        int nTestNewParenth = queryValue.length();
        while (nLevel != 0) {
            nTestCloseParenth = queryValue.indexOf(")", nTempClose);
            if (queryValue.indexOf("(", nTempBegin + 1) > -1) {
                nTestNewParenth = queryValue.indexOf("(", nTempBegin + 1);
            }
            if (nTestCloseParenth < nTestNewParenth) {
                nEnd = nTestCloseParenth;
                --nLevel;
                continue;
            }
            ++nLevel;
            nTempBegin = nTestNewParenth;
            nTestNewParenth = queryValue.length();
            nTempClose = nTestCloseParenth + 1;
        }
        if (nEnd < 1) {
            throw new FTSServiceException(this.getClass().getName() + ": The parser identified miss-matched parenthesis in the construct: " + queryValue);
        }
        return nEnd;
    }

    private Query accrueQuery(String schemaId, String queryFieldName, String queryFieldValue, BitSet fullTextOption, boolean isCaseSensitive) {
        BooleanQuery booleanQuery = new BooleanQuery();
        String[] accrueValues = queryFieldValue.split(",");
        for (int x = 0; x < accrueValues.length; ++x) {
            Query query = this.buildQuery(schemaId, queryFieldName, accrueValues[x].trim(), fullTextOption, isCaseSensitive);
            if (query == null) continue;
            booleanQuery.add(query, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    private Query orQuery(String schemaId, String queryFieldName, String queryFieldValue, BitSet fullTextOption, boolean isCaseSensitive) {
        BooleanQuery booleanQuery = new BooleanQuery();
        String[] accrueValues = queryFieldValue.split("OR");
        for (int x = 0; x < accrueValues.length; ++x) {
            Query query = this.buildQuery(schemaId, queryFieldName, accrueValues[x].trim(), fullTextOption, isCaseSensitive);
            if (query == null) continue;
            booleanQuery.add(query, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    private Query wildcardPhraseQuery(String schemaId, String queryFieldName, String queryFieldValue, BitSet fullTextOption, boolean isCaseSensitive) {
        String value = queryFieldValue.replaceAll("%", "*");
        String fullFieldName = this.getFullFieldName(queryFieldName, fullTextOption, isCaseSensitive, true);
        Iterator<Term> iterator = this.analyzer.analyzeSearchPhrase(fullFieldName, value, true).iterator();
        WildcardPhraseQuery wildcardPhraseQuery = new WildcardPhraseQuery();
        while (iterator.hasNext()) {
            wildcardPhraseQuery.add(iterator.next());
        }
        return wildcardPhraseQuery;
    }

    private Query wildcardQuery(String schemaId, String queryFieldName, String queryFieldValue, BitSet fullTextOption, boolean isCaseSensitive) {
        String value = queryFieldValue.replaceAll("%", "*");
        Term term = this.analyzer.analyzeSearchTerm(this.getFullFieldName(queryFieldName, fullTextOption, isCaseSensitive, true), value, true);
        WildcardQuery wildcardQuery = new WildcardQuery(term);
        return wildcardQuery;
    }

    private Query phraseQuery(String schemaId, String queryFieldName, String queryFieldValue, BitSet fullTextOption, boolean isCaseSensitive) {
        String fullFieldName = this.getFullFieldName(queryFieldName, fullTextOption, isCaseSensitive, false);
        Iterator<Term> iterator = this.analyzer.analyzeSearchPhrase(fullFieldName, queryFieldValue, false).iterator();
        PhraseQuery phraseQuery = new PhraseQuery();
        int posCount = 0;
        while (iterator.hasNext()) {
            Term term = iterator.next();
            if (term != null) {
                phraseQuery.add(term, posCount);
            }
            ++posCount;
        }
        return phraseQuery;
    }

    private Query termQuery(String schemaId, String queryFieldName, String queryFieldValue, BitSet fullTextOption, boolean isCaseSensitive) {
        String strTemp;
        if (this.analyzer.useSearchAnalyzer && queryFieldValue.matches(".*[\u3100-\u312f\u3040-\u309f\u30a0-\u30ff\u31f0-\u31ff\u3300-\u337f\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\uff65-\uff9f]+.*") && !(strTemp = this.analyzer.prepareCNJPString(queryFieldValue)).equals(queryFieldValue)) {
            return this.buildQuery(schemaId, queryFieldName, strTemp, fullTextOption, isCaseSensitive, true);
        }
        Term term = this.analyzer.analyzeSearchTerm(this.getFullFieldName(queryFieldName, fullTextOption, isCaseSensitive, false), queryFieldValue, false);
        TermQuery termQuery = null;
        if (term != null) {
            termQuery = new TermQuery(term);
        }
        return termQuery;
    }

    public Query schemaQuery(String schemaId) {
        Term term = new Term("schemaId", schemaId);
        TermQuery termQuery = new TermQuery(term);
        return termQuery;
    }

    public static Query createTitleQuery(Query query) {
        HashSet<String> searchStrings = new HashSet<String>();
        HashSet terms = new HashSet();
        query.extractTerms(terms);
        BooleanQuery booleanQuery = new BooleanQuery();
        Iterator i = terms.iterator();
        while (i.hasNext()) {
            String searchString = ((Term)i.next()).text();
            if (!searchStrings.add(searchString)) continue;
            Term term = new Term("title", searchString);
            TermQuery termQuery = new TermQuery(term);
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    public static Query createQueryForSpecificField(Query query, String strFieldName) {
        HashSet<String> searchStrings = new HashSet<String>();
        HashSet terms = new HashSet();
        query.extractTerms(terms);
        BooleanQuery booleanQuery = new BooleanQuery();
        Iterator i = terms.iterator();
        while (i.hasNext()) {
            String searchString = ((Term)i.next()).text();
            if (!searchStrings.add(searchString)) continue;
            Term term = new Term(strFieldName, searchString);
            TermQuery termQuery = new TermQuery(term);
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    private String getFullFieldName(String queryFieldName, BitSet fullTextOption, boolean isCaseSensitive, boolean isWildcard) {
        String fieldName = null;
        fieldName = queryFieldName.equals("entryId") || queryFieldName.equals("docId") || queryFieldName.equals("schemaId") || queryFieldName.equals("createTime") || queryFieldName.equals("modifiedTime") ? queryFieldName : (fullTextOption.get(1) ? (isCaseSensitive ? queryFieldName + "_literalCase" : queryFieldName + "_literal") : (isCaseSensitive ? queryFieldName + "_case" : queryFieldName));
        return fieldName;
    }

    public Query getMultiSchemaQuery(String shouldQueryValue, String mustQueryValue, String notQueryValue, List<FTSService.QuerySchemas> querySchemas, boolean caseSensitive) throws FTSServiceException {
        BooleanQuery query = null;
        String[] accrueValuesShould = this.getAccrueValues(shouldQueryValue, false);
        String[] accrueValuesMust = this.getAccrueValues(mustQueryValue, true);
        String[] accrueValuesNo = this.getAccrueValues(notQueryValue, false);
        if (StringUtils.isNotBlank((String)shouldQueryValue) || StringUtils.isNotBlank((String)mustQueryValue)) {
            FTSService.QuerySchemas singleGlobalQuerySchemas = this.createSingleGlobalQuerySchemas(querySchemas);
            query = this.createGlobalQuery(shouldQueryValue, mustQueryValue, notQueryValue, singleGlobalQuerySchemas, caseSensitive, accrueValuesShould, accrueValuesMust, accrueValuesNo);
            if (LOGGER.isDebugEnabled()) {
                String queryStr = query != null ? query.toString() : "null";
                LOGGER.debug((Object)("query = : " + queryStr));
            }
        } else {
            BooleanQuery boolQuery = new BooleanQuery();
            for (FTSService.QuerySchemas qs : querySchemas) {
                Query tmpQuery = this.createGlobalQuery(shouldQueryValue, mustQueryValue, notQueryValue, qs, caseSensitive, accrueValuesShould, accrueValuesMust, accrueValuesNo);
                boolQuery.add(tmpQuery, BooleanClause.Occur.SHOULD);
                if (!LOGGER.isDebugEnabled()) continue;
                String queryStr = query != null ? query.toString() : "null";
                LOGGER.debug((Object)("query = : " + queryStr));
            }
            query = boolQuery;
        }
        return query;
    }

    public FTSService.QuerySchemas createSingleGlobalQuerySchemas(List<FTSService.QuerySchemas> querySchemas) {
        FTSService.QuerySchemas retVal = null;
        HashSet<Pair> uniquePairs = new HashSet<Pair>();
        for (FTSService.QuerySchemas qs : querySchemas) {
            for (int i = 0; i < qs.queryFieldNames.size(); ++i) {
                Pair pair = new Pair(qs.queryFieldNames.get(i), qs.fullTextOptions.get(i));
                uniquePairs.add(pair);
            }
        }
        ArrayList<String> fieldList = new ArrayList<String>(uniquePairs.size());
        ArrayList<BitSet> fto = new ArrayList<BitSet>(uniquePairs.size());
        for (Pair pair : uniquePairs) {
            fieldList.add(pair.fieldName);
            fto.add(pair.fto);
        }
        retVal = new FTSService.QuerySchemas(null, fieldList, fto);
        return retVal;
    }

    public String createOptimizedShouldQuery(String shouldQueryValue) {
        StringBuffer retValue = new StringBuffer();
        if (shouldQueryValue == null) {
            return shouldQueryValue;
        }
        String newShouldQueryValue = shouldQueryValue.trim();
        if (newShouldQueryValue.length() == 0) {
            return shouldQueryValue;
        }
        if (newShouldQueryValue.indexOf("(") > -1 || newShouldQueryValue.indexOf(" AND ") > -1 || newShouldQueryValue.indexOf(" OR ") > -1 || newShouldQueryValue.indexOf(" NOT ") > -1 || newShouldQueryValue.startsWith("NOT ") || newShouldQueryValue.indexOf(",") > -1 || newShouldQueryValue.indexOf("\"") > -1) {
            return shouldQueryValue;
        }
        String[] tokens = newShouldQueryValue.split("\\s+");
        if (tokens.length <= 1) {
            return shouldQueryValue;
        }
        retValue.append("(\"" + newShouldQueryValue + "\")").append(" OR (" + newShouldQueryValue + ")");
        return retValue.toString();
    }

    private class Pair {
        private String fieldName;
        private BitSet fto;

        public Pair(String fieldName, BitSet fto) {
            this.fieldName = fieldName == null ? "" : fieldName;
            this.fto = fto == null ? new BitSet(0) : fto;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                Pair p1 = (Pair)obj;
                if (p1.fieldName.equals(this.fieldName) && p1.fto.equals(this.fto)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.fieldName.hashCode() + 31 * this.fto.hashCode();
            return hashCode;
        }
    }

    private class WordToken {
        public String token;
        public int type;
        public BooleanClause.Occur operator;
        public int position;
        public String remainingText;

        private WordToken() {
        }
    }

    private class GetOccur {
        private BooleanClause.Occur lastOccur = BooleanClause.Occur.SHOULD;

        private GetOccur() {
        }

        private BooleanClause.Occur getOccur(int which) {
            BooleanClause.Occur returnOccur = null;
            switch (which) {
                case 0: {
                    returnOccur = this.lastOccur;
                    break;
                }
                case 1: {
                    returnOccur = BooleanClause.Occur.MUST;
                    break;
                }
                case 2: {
                    returnOccur = BooleanClause.Occur.SHOULD;
                    break;
                }
                case 3: {
                    returnOccur = BooleanClause.Occur.MUST_NOT;
                }
            }
            if (returnOccur == BooleanClause.Occur.MUST_NOT) {
                returnOccur = this.lastOccur;
                this.lastOccur = BooleanClause.Occur.MUST_NOT;
            } else if (this.lastOccur == BooleanClause.Occur.MUST_NOT) {
                this.lastOccur = returnOccur;
                returnOccur = BooleanClause.Occur.MUST_NOT;
            } else if (this.lastOccur == BooleanClause.Occur.MUST) {
                this.lastOccur = returnOccur;
                returnOccur = BooleanClause.Occur.MUST;
            } else {
                this.lastOccur = returnOccur;
            }
            return returnOccur;
        }
    }

    private class FieldTermPair {
        String field;
        String term;
        int opType;
        boolean isFieldLeft;

        private FieldTermPair() {
        }
    }
}

