/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.tartarus.snowball.SnowballProgram;

public class FTSStemmingFilter
extends TokenFilter {
    private static final Logger LOGGER = Logger.getLogger(FTSStemmingFilter.class);
    private SnowballProgram stemmer;
    private Hashtable<String, String> rootTable;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private boolean addStemmedTerm = false;
    private String stemmedTerm = "";

    public FTSStemmingFilter(TokenStream input, SnowballProgram stemmer, Hashtable<String, String> rootTable) {
        super(input);
        this.stemmer = stemmer;
        this.rootTable = rootTable;
    }

    public FTSStemmingFilter(TokenStream in, String name) {
        super(in);
        try {
            Class<?> stemClass = Class.forName("org.tartarus.snowball.ext." + name + "Stemmer");
            this.stemmer = (SnowballProgram)stemClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " rewrite: Failed to get the " + name + " stemmer"), (Throwable)e);
        }
    }

    public final boolean incrementToken() throws IOException {
        try {
            if (this.addStemmedTerm) {
                this.addStemmedTerm = false;
                this.termAtt.setEmpty();
                this.termAtt.append(this.stemmedTerm);
                this.posIncAtt.setPositionIncrement(0);
                return true;
            }
            if (this.input.incrementToken()) {
                String nextToken = this.termAtt.toString();
                if (nextToken == null) {
                    return false;
                }
                String finalTerm = null;
                if (this.rootTable.containsKey(nextToken)) {
                    finalTerm = this.rootTable.get(nextToken);
                } else {
                    this.stemmer.setCurrent(nextToken);
                    this.stemmer.stem();
                    finalTerm = this.stemmer.getCurrent();
                }
                if (!nextToken.equals(finalTerm)) {
                    this.termAtt.setEmpty();
                    this.termAtt.append(finalTerm);
                    this.addStemmedTerm = true;
                    this.stemmedTerm = nextToken;
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSStemmingFilter: failed to get next term "), (Throwable)e);
            }
            return false;
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.addStemmedTerm = false;
    }
}

