/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.ArrayUtil;

public final class FTSRootCharacterFilter
extends TokenFilter {
    private Hashtable<String, String> rootCharTable;
    private char[] output = new char[512];
    private int outputPos;
    private CharTermAttribute termAtt;

    public FTSRootCharacterFilter(TokenStream input, Hashtable<String, String> rootCharTable) {
        super(input);
        this.rootCharTable = rootCharTable;
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            for (int i = 0; i < length; ++i) {
                char c = buffer[i];
                if (c < '\u0080') continue;
                this.foldToASCII(buffer, length);
                this.termAtt.setEmpty();
                this.termAtt.copyBuffer(this.output, 0, this.outputPos);
                break;
            }
            return true;
        }
        return false;
    }

    public void foldToASCII(char[] input, int length) {
        int maxSizeNeeded = 4 * length;
        if (this.output.length < maxSizeNeeded) {
            this.output = new char[ArrayUtil.oversize((int)maxSizeNeeded, (int)2)];
        }
        this.outputPos = 0;
        for (int pos = 0; pos < length; ++pos) {
            char c = input[pos];
            if (c < '\u0080') {
                this.output[this.outputPos++] = c;
                continue;
            }
            String strCharString = Character.toString(c);
            if (this.rootCharTable.containsKey(strCharString)) {
                char[] tempCharArray = this.rootCharTable.get(strCharString).toCharArray();
                for (int x = 0; x < tempCharArray.length; ++x) {
                    this.output[this.outputPos++] = tempCharArray[x];
                }
                continue;
            }
            this.output[this.outputPos++] = c;
        }
    }
}

