/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.AlreadyClosedException;

public class FTSSearcherManager {
    private static final Logger LOGGER = Logger.getLogger(FTSSearcherManager.class);
    private ConcurrentMap<SearcherManager, IndexSearcher> smMap = new ConcurrentHashMap<SearcherManager, IndexSearcher>();
    private IndexReader[] subReaders;
    private IndexSearcher current;

    public FTSSearcherManager(List<SearcherManager> schemaSeacherManagers) {
        int size = schemaSeacherManagers.size();
        this.subReaders = new IndexReader[size];
        int cnt = 0;
        for (SearcherManager searcherManager : schemaSeacherManagers) {
            try {
                IndexSearcher searcher = (IndexSearcher)searcherManager.acquire();
                this.smMap.putIfAbsent(searcherManager, searcher);
                this.subReaders[cnt] = searcher.getIndexReader();
                ++cnt;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error occured while creating FTSSearcherManager", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        MultiReader multiReader = new MultiReader(this.subReaders, false);
        this.current = new IndexSearcher((IndexReader)multiReader);
    }

    public FTSSearcherManager(SearcherManager schemaSearcherManager) {
        try {
            this.current = (IndexSearcher)schemaSearcherManager.acquire();
            this.smMap.putIfAbsent(schemaSearcherManager, this.current);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occured while creating FTSSearcherManager", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void maybeRefresh() {
        for (SearcherManager sm : this.smMap.keySet()) {
            try {
                sm.maybeRefresh();
            }
            catch (AlreadyClosedException e) {
                LOGGER.debug((Object)"SM is already closed so ignore it.");
            }
            catch (IOException e) {
                LOGGER.error((Object)("IOException while performing refresh: " + e), (Throwable)e);
            }
        }
        LOGGER.debug((Object)"maybeRefresh() called ...");
    }

    public final IndexSearcher acquire() {
        return this.current;
    }

    public final void release() throws IOException {
        for (Map.Entry entry : this.smMap.entrySet()) {
            ((SearcherManager)entry.getKey()).release(entry.getValue());
        }
    }

    public final Query queryRewrite(Query query) throws IOException {
        Query query2 = query.rewrite(this.current.getIndexReader());
        return query2;
    }
}

