/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.annotation;

import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryAware;
import com.bmc.thirdparty.org.springframework.context.EnvironmentAware;
import com.bmc.thirdparty.org.springframework.context.annotation.Bean;
import com.bmc.thirdparty.org.springframework.context.annotation.Configuration;
import com.bmc.thirdparty.org.springframework.context.annotation.EnableMBeanExport;
import com.bmc.thirdparty.org.springframework.context.annotation.ImportAware;
import com.bmc.thirdparty.org.springframework.context.annotation.Role;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationAttributes;
import com.bmc.thirdparty.org.springframework.core.env.Environment;
import com.bmc.thirdparty.org.springframework.core.type.AnnotationMetadata;
import com.bmc.thirdparty.org.springframework.jmx.MBeanServerNotFoundException;
import com.bmc.thirdparty.org.springframework.jmx.export.annotation.AnnotationMBeanExporter;
import com.bmc.thirdparty.org.springframework.jmx.support.RegistrationPolicy;
import com.bmc.thirdparty.org.springframework.jmx.support.WebSphereMBeanServerFactoryBean;
import com.bmc.thirdparty.org.springframework.jndi.JndiLocatorDelegate;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.util.Map;
import javax.management.MBeanServer;
import javax.naming.NamingException;

@Configuration
public class MBeanExportConfiguration
implements ImportAware,
EnvironmentAware,
BeanFactoryAware {
    private static final String MBEAN_EXPORTER_BEAN_NAME = "mbeanExporter";
    private AnnotationAttributes attributes;
    private Environment environment;
    private BeanFactory beanFactory;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map<String, Object> map = importMetadata.getAnnotationAttributes(EnableMBeanExport.class.getName());
        this.attributes = AnnotationAttributes.fromMap(map);
        if (this.attributes == null) {
            throw new IllegalArgumentException("@EnableMBeanExport is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Bean(name={"mbeanExporter"})
    @Role(value=2)
    public AnnotationMBeanExporter mbeanExporter() {
        AnnotationMBeanExporter exporter = new AnnotationMBeanExporter();
        this.setupDomain(exporter);
        this.setupServer(exporter);
        this.setupRegistrationPolicy(exporter);
        return exporter;
    }

    private void setupDomain(AnnotationMBeanExporter exporter) {
        String defaultDomain = this.attributes.getString("defaultDomain");
        if (defaultDomain != null && this.environment != null) {
            defaultDomain = this.environment.resolvePlaceholders(defaultDomain);
        }
        if (StringUtils.hasText(defaultDomain)) {
            exporter.setDefaultDomain(defaultDomain);
        }
    }

    private void setupServer(AnnotationMBeanExporter exporter) {
        String server = this.attributes.getString("server");
        if (server != null && this.environment != null) {
            server = this.environment.resolvePlaceholders(server);
        }
        if (StringUtils.hasText(server)) {
            exporter.setServer(this.beanFactory.getBean(server, MBeanServer.class));
        } else {
            SpecificPlatform specificPlatform = SpecificPlatform.get();
            if (specificPlatform != null) {
                exporter.setServer(specificPlatform.getMBeanServer());
            }
        }
    }

    private void setupRegistrationPolicy(AnnotationMBeanExporter exporter) {
        RegistrationPolicy registrationPolicy = (RegistrationPolicy)((Object)this.attributes.getEnum("registration"));
        exporter.setRegistrationPolicy(registrationPolicy);
    }

    public static enum SpecificPlatform {
        WEBLOGIC("weblogic.management.Helper"){

            @Override
            public MBeanServer getMBeanServer() {
                try {
                    return new JndiLocatorDelegate().lookup("java:comp/env/jmx/runtime", MBeanServer.class);
                }
                catch (NamingException ex) {
                    throw new MBeanServerNotFoundException("Failed to retrieve WebLogic MBeanServer from JNDI", ex);
                }
            }
        }
        ,
        WEBSPHERE("com.ibm.websphere.management.AdminServiceFactory"){

            @Override
            public MBeanServer getMBeanServer() {
                WebSphereMBeanServerFactoryBean fb = new WebSphereMBeanServerFactoryBean();
                fb.afterPropertiesSet();
                return fb.getObject();
            }
        };

        private final String identifyingClass;

        private SpecificPlatform(String identifyingClass) {
            this.identifyingClass = identifyingClass;
        }

        public abstract MBeanServer getMBeanServer();

        public static SpecificPlatform get() {
            ClassLoader classLoader = MBeanExportConfiguration.class.getClassLoader();
            for (SpecificPlatform environment : SpecificPlatform.values()) {
                if (!ClassUtils.isPresent(environment.identifyingClass, classLoader)) continue;
                return environment;
            }
            return null;
        }
    }
}

