/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.framework;

import com.bmc.thirdparty.org.springframework.aop.SpringProxy;
import com.bmc.thirdparty.org.springframework.aop.TargetClassAware;
import com.bmc.thirdparty.org.springframework.aop.TargetSource;
import com.bmc.thirdparty.org.springframework.aop.framework.Advised;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisedSupport;
import com.bmc.thirdparty.org.springframework.aop.support.AopUtils;
import com.bmc.thirdparty.org.springframework.aop.target.SingletonTargetSource;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.util.Arrays;

public abstract class AopProxyUtils {
    public static Class<?> ultimateTargetClass(Object candidate) {
        Assert.notNull(candidate, "Candidate object must not be null");
        Object current = candidate;
        Class<?> result = null;
        while (current instanceof TargetClassAware) {
            TargetSource targetSource;
            result = ((TargetClassAware)current).getTargetClass();
            Object nested = null;
            if (current instanceof Advised && (targetSource = ((Advised)current).getTargetSource()) instanceof SingletonTargetSource) {
                nested = ((SingletonTargetSource)targetSource).getTarget();
            }
            current = nested;
        }
        if (result == null) {
            result = AopUtils.isCglibProxy(candidate) ? candidate.getClass().getSuperclass() : candidate.getClass();
        }
        return result;
    }

    public static Class<?>[] completeProxiedInterfaces(AdvisedSupport advised) {
        Class<?> targetClass;
        Class<?>[] specifiedInterfaces = advised.getProxiedInterfaces();
        if (specifiedInterfaces.length == 0 && (targetClass = advised.getTargetClass()) != null && targetClass.isInterface()) {
            specifiedInterfaces = new Class[]{targetClass};
        }
        boolean addSpringProxy = !advised.isInterfaceProxied(SpringProxy.class);
        boolean addAdvised = !advised.isOpaque() && !advised.isInterfaceProxied(Advised.class);
        int nonUserIfcCount = 0;
        if (addSpringProxy) {
            ++nonUserIfcCount;
        }
        if (addAdvised) {
            ++nonUserIfcCount;
        }
        Class[] proxiedInterfaces = new Class[specifiedInterfaces.length + nonUserIfcCount];
        System.arraycopy(specifiedInterfaces, 0, proxiedInterfaces, 0, specifiedInterfaces.length);
        if (addSpringProxy) {
            proxiedInterfaces[specifiedInterfaces.length] = SpringProxy.class;
        }
        if (addAdvised) {
            proxiedInterfaces[proxiedInterfaces.length - 1] = Advised.class;
        }
        return proxiedInterfaces;
    }

    public static Class<?>[] proxiedUserInterfaces(Object proxy) {
        Class<?>[] proxyInterfaces = proxy.getClass().getInterfaces();
        int nonUserIfcCount = 0;
        if (proxy instanceof SpringProxy) {
            ++nonUserIfcCount;
        }
        if (proxy instanceof Advised) {
            ++nonUserIfcCount;
        }
        Object[] userInterfaces = new Class[proxyInterfaces.length - nonUserIfcCount];
        System.arraycopy(proxyInterfaces, 0, userInterfaces, 0, userInterfaces.length);
        Assert.notEmpty(userInterfaces, "JDK proxy must implement one or more interfaces");
        return userInterfaces;
    }

    public static boolean equalsInProxy(AdvisedSupport a, AdvisedSupport b) {
        return a == b || AopProxyUtils.equalsProxiedInterfaces(a, b) && AopProxyUtils.equalsAdvisors(a, b) && a.getTargetSource().equals(b.getTargetSource());
    }

    public static boolean equalsProxiedInterfaces(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getProxiedInterfaces(), b.getProxiedInterfaces());
    }

    public static boolean equalsAdvisors(AdvisedSupport a, AdvisedSupport b) {
        return Arrays.equals(a.getAdvisors(), b.getAdvisors());
    }
}

