/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import com.bmc.arsys.utils.StringByteUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;

public class ReadRegistry {
    static final int KEY_READ = 131097;

    public static String getUserValue(String registryPath, String arKey) {
        String debugMessage = "Failed to get Windows registry value: '" + registryPath + "\\" + arKey + "'";
        Preferences userRoot = Preferences.systemRoot();
        String value = "";
        try {
            int openedKeyHandle = ReadRegistry.openKey(registryPath, userRoot);
            value = ReadRegistry.WindowsRegQueryValueEx(openedKeyHandle, arKey, userRoot);
            ReadRegistry.closeKey(openedKeyHandle, userRoot);
        }
        catch (SecurityException e) {
            throw new WindowsRegistryException(debugMessage, e);
        }
        catch (IllegalArgumentException e) {
            throw new WindowsRegistryException(debugMessage, e);
        }
        catch (NoSuchMethodException e) {
            throw new WindowsRegistryException(debugMessage, e);
        }
        catch (IllegalAccessException e) {
            throw new WindowsRegistryException(debugMessage, e);
        }
        catch (InvocationTargetException e) {
            throw new WindowsRegistryException(debugMessage, e);
        }
        return value;
    }

    private static void closeKey(int openedKeyHandle, Preferences preferences) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> windowsPreferences = preferences.getClass();
        Class[] methodParameters = new Class[]{Integer.TYPE};
        Method method = windowsPreferences.getDeclaredMethod("closeKey", methodParameters);
        method.setAccessible(true);
        Object[] methodParameterValues = new Object[]{openedKeyHandle};
        method.invoke((Object)preferences, methodParameterValues);
    }

    private static int openKey(String registryPath, Preferences preferences) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> windowsPreferences = preferences.getClass();
        Class[] methodParameters = new Class[]{byte[].class, Integer.TYPE, Integer.TYPE};
        Method method = windowsPreferences.getDeclaredMethod("openKey", methodParameters);
        method.setAccessible(true);
        Object[] methodParameterValues = new Object[]{StringByteUtil.stringToByteArray(registryPath), new Integer(131097), new Integer(131097)};
        int openedKeyHandle = (Integer)method.invoke((Object)preferences, methodParameterValues);
        return openedKeyHandle;
    }

    private static String WindowsRegQueryValueEx(int key, String arKey, Preferences preferences) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> windowsPreferences = preferences.getClass();
        Class[] methodParameters = new Class[]{Integer.TYPE, byte[].class};
        Method method = windowsPreferences.getDeclaredMethod("WindowsRegQueryValueEx", methodParameters);
        method.setAccessible(true);
        Object[] methodParameterValues = new Object[]{key, StringByteUtil.stringToByteArray(arKey)};
        byte[] bytes = (byte[])method.invoke((Object)preferences, methodParameterValues);
        String value = bytes != null ? new String(bytes).trim() : null;
        return value;
    }

    public static class WindowsRegistryException
    extends RuntimeException {
        private static final long serialVersionUID = -6815678053485588986L;

        public WindowsRegistryException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

