/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.Value;

public class DSOPoolAssignmentEncoder {
    static final String FILE_DELIMITER = "\\";
    static final int ASSIGN_TYPE_MARKER = 100;
    static final int ERROR_UNEXPECTED_VALUE = -1;
    AssignInfo asgnInfo;
    private StringBuffer result;

    public DSOPoolAssignmentEncoder(AssignInfo asgnInfo) throws ARException {
        this.asgnInfo = asgnInfo;
        if (this.asgnInfo == null) {
            throw new ARException(2, 0, "AssignInfo is null.");
        }
    }

    public DSOPoolAssignmentEncoder(FieldAssignInfo fieldAsgnInfo) throws ARException {
        this(fieldAsgnInfo.getAssignment());
        this.init(fieldAsgnInfo);
    }

    public String encode() throws ARException {
        return this.encodeAssignInfo(this.asgnInfo);
    }

    private void init(FieldAssignInfo fieldAsgnInfo) throws ARException {
        if (fieldAsgnInfo == null) {
            throw new ARException(2, 0, "FieldAssignInfo is null.");
        }
        this.result = new StringBuffer();
        this.result.append(FILE_DELIMITER).append(this.asgnInfo.getField().getFieldId()).append(FILE_DELIMITER);
    }

    private String encodeAssignInfo(AssignInfo info) throws ARException {
        StringBuffer encStr = new StringBuffer();
        encStr.append(100 + info.getAssignType()).append(FILE_DELIMITER);
        switch (info.getAssignType()) {
            case 1: {
                encStr.append(this.encodeValue(info.getValue()));
                break;
            }
            case 2: {
                encStr.append(this.encodeAssignFieldInfo(info.getField()));
                break;
            }
            case 3: {
                encStr.append(this.encodeProcess(info.getProcess()));
                break;
            }
            case 4: {
                encStr.append(this.encodeArithOpAssignInfo(info.getArithOp()));
                break;
            }
            case 5: {
                encStr.append(this.encodeFunctionAssignInfo(info.getFunction()));
                break;
            }
            case 6: {
                encStr.append(this.encodeDDEAction(info.getDde()));
                break;
            }
            case 7: {
                encStr.append(this.encodeAssignSQLInfo(info.getSql()));
            }
        }
        return encStr.toString();
    }

    private String encodeValue(Value info) {
        StringBuffer encStr = new StringBuffer();
        encStr.append(info.getDataType().toInt()).append(FILE_DELIMITER);
        if (info.getDataType().toInt() == 4 || info.getDataType().toInt() == 5) {
            encStr.append(info.getValue().toString().length()).append(FILE_DELIMITER);
            encStr.append(info.getValue().toString()).append(FILE_DELIMITER);
        } else if (Keyword.toKeyword(info.getValue().toString()) != null) {
            encStr.append(Keyword.toKeyword(info.getValue().toString()).toInt()).append(FILE_DELIMITER);
        } else {
            encStr.append(info.getValue().toString()).append(FILE_DELIMITER);
        }
        return encStr.toString();
    }

    private String encodeAssignFieldInfo(AssignFieldInfo info) throws ARException {
        StringBuffer encStr = new StringBuffer();
        encStr.append("*".length()).append(FILE_DELIMITER);
        encStr.append("*").append(FILE_DELIMITER);
        encStr.append("*".length()).append(FILE_DELIMITER);
        encStr.append("*").append(FILE_DELIMITER);
        encStr.append(info.getTag()).append(FILE_DELIMITER);
        switch (info.getTag()) {
            case 1: {
                encStr.append(info.getFieldId()).append(FILE_DELIMITER);
                break;
            }
            case 6: {
                CurrencyPartInfo currencyInfo = info.getCurrencyPart();
                encStr.append(currencyInfo.getFieldId() + FILE_DELIMITER);
                encStr.append(currencyInfo.getPartTag() + FILE_DELIMITER);
                if (currencyInfo.getPartTag() != 4) break;
                encStr.append(currencyInfo.getCurrencyCode() + FILE_DELIMITER);
                break;
            }
            case 4: {
                StatusHistoryValueIndicator statuHist = info.getStatHistory();
                encStr.append(statuHist.getEnumValue() + FILE_DELIMITER);
                encStr.append(statuHist.getType() + FILE_DELIMITER);
            }
        }
        encStr.append(0).append(FILE_DELIMITER);
        return encStr.toString();
    }

    private String encodeArithOpAssignInfo(ArithOpAssignInfo info) throws ARException {
        StringBuffer encStr = new StringBuffer();
        encStr.append(info.getOperation()).append(FILE_DELIMITER);
        if (info.getOperation() != 6) {
            encStr.append(this.encodeAssignInfo(info.getOperandLeft()));
        }
        encStr.append(this.encodeAssignInfo(info.getOperandRight()));
        return encStr.toString();
    }

    private String encodeFunctionAssignInfo(FunctionAssignInfo info) throws ARException {
        StringBuffer encStr = new StringBuffer();
        encStr.append(info.getFunctionCode()).append(FILE_DELIMITER);
        encStr.append(info.getNumItems()).append(FILE_DELIMITER);
        for (int i = 0; i < info.getNumItems(); ++i) {
            encStr.append(this.encodeAssignInfo(info.getParameterList().get(i)));
        }
        return encStr.toString();
    }

    private String encodeProcess(String process) {
        StringBuffer encStr = new StringBuffer();
        encStr.append(process.length()).append(FILE_DELIMITER);
        encStr.append(process).append(FILE_DELIMITER);
        return encStr.toString();
    }

    private String encodeDDEAction(DDEAction ddeAction) throws ARException {
        StringBuffer encStr = new StringBuffer();
        encStr.append(ddeAction.getServiceName().length()).append(FILE_DELIMITER);
        encStr.append(ddeAction.getServiceName()).append(FILE_DELIMITER);
        encStr.append(ddeAction.getTopic().length()).append(FILE_DELIMITER);
        encStr.append(ddeAction.getTopic()).append(FILE_DELIMITER);
        encStr.append(ddeAction.getAction()).append(FILE_DELIMITER);
        encStr.append(ddeAction.getPathToProgram().length()).append(FILE_DELIMITER);
        encStr.append(ddeAction.getPathToProgram()).append(FILE_DELIMITER);
        if (ddeAction.getCommand() != null) {
            encStr.append(ddeAction.getCommand().length()).append(FILE_DELIMITER);
            encStr.append(ddeAction.getCommand()).append(FILE_DELIMITER);
        }
        if (ddeAction.getItem() != null) {
            encStr.append(ddeAction.getItem().length()).append(FILE_DELIMITER);
            encStr.append(ddeAction.getItem()).append(FILE_DELIMITER);
        }
        return encStr.toString();
    }

    private String encodeAssignSQLInfo(AssignSQLInfo info) throws ARException {
        StringBuffer encStr = new StringBuffer();
        encStr.append(info.getServer().length()).append(FILE_DELIMITER);
        encStr.append(info.getServer()).append(FILE_DELIMITER);
        encStr.append(info.getSqlCommand().length()).append(FILE_DELIMITER);
        encStr.append(info.getSqlCommand()).append(FILE_DELIMITER);
        encStr.append(info.getValueIndex()).append(FILE_DELIMITER);
        encStr.append(info.getNoMatchOption()).append(FILE_DELIMITER);
        encStr.append(info.getMultiMatchOption()).append(FILE_DELIMITER);
        return encStr.toString();
    }
}

