/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.PerfThreadControlBlock;
import com.bmc.arsys.demo.javadriver.PerfThreadControlLocalStorage;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Stack;

public class PerfJavaDriver
extends JavaDriver {
    static long OUT_MODE_PERF_LOG = 2L;
    static long OUT_MODE_PERF_LOG_MEM = 4L;
    static long OUT_MODE_ANY = 7L;
    private static long outputSetting;
    static int fileCount;
    static long driverStartTime;

    public static void main(String[] args) {
        try {
            ProxyManager.setUseConnectionPooling(false);
            PerfJavaDriver driver = new PerfJavaDriver();
            driver.setCommandLineArgs(args);
            driver.setPrimaryThread(true);
            javaDriverOnly = false;
            driver.start();
        }
        catch (Exception e) {
            outputWriter.printString("Error in executing the command\n");
        }
    }

    @Override
    protected ThreadControlBlock initThreadControlBlockPtr() {
        localStorage = new PerfThreadControlLocalStorage();
        return (ThreadControlBlock)localStorage.get();
    }

    @Override
    public void initCommandProcessing() {
        super.initCommandProcessing();
        if ((PerfJavaDriver.getOutputSetting() & (OUT_MODE_PERF_LOG | OUT_MODE_PERF_LOG_MEM)) != 0L) {
            driverStartTime = System.currentTimeMillis();
            if (PerfJavaDriver.isForOutputFile()) {
                PerfJavaDriver.setFileCount(this.getOutputCount());
            }
        }
    }

    protected static boolean isForOutputFile() {
        boolean flag = false;
        if ((PerfJavaDriver.getOutputSetting() & OUT_MODE_PERF_LOG) != 0L && (PerfJavaDriver.getOutputSetting() & OUT_MODE_PERF_LOG_MEM) == 0L) {
            flag = true;
        }
        return flag;
    }

    static synchronized void setFileCount(int count) {
        fileCount = count;
    }

    static synchronized int getAndIncrementTheFileCount() {
        return fileCount++;
    }

    @Override
    protected void logResult(List<StatusInfo> statusList, long startTime) throws IOException {
        super.logResult(statusList, startTime);
        if ((PerfJavaDriver.getOutputSetting() & (OUT_MODE_PERF_LOG | OUT_MODE_PERF_LOG_MEM)) != 0L) {
            long errorCode = 0L;
            if (statusList != null && statusList.size() != 0 && statusList.get(0).getMessageType() == 2) {
                errorCode = statusList.get(0).getMessageNum();
            }
            this.logPerfResults(errorCode, startTime);
        }
    }

    protected void logPerfResults(long errorCode, long startTime) throws IOException {
        PerfThreadControlBlock threadControlBlockObj = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        if (!threadControlBlockObj.isResultFileOpened()) {
            threadControlBlockObj.initLogMethod();
        }
        long elapsedTimeMilliSec = startTime - driverStartTime;
        String statString = PerfJavaDriver.getStatString(elapsedTimeMilliSec, threadControlBlockObj.getCurrentCommand(), errorCode, threadControlBlockObj.getAuxCount());
        threadControlBlockObj.writeInResultFile(statString);
    }

    static String getStatString(long startTime, String command, long errorCode, long endTime) {
        String stTime = "" + startTime;
        int i = 0;
        StringBuilder prefix = new StringBuilder();
        for (i = stTime.length(); i < 8; ++i) {
            prefix.append("0");
        }
        StringBuilder statString = new StringBuilder();
        statString.append(prefix.toString()).append(stTime).append(" ").append(command);
        for (i = command.length(); i < 6; ++i) {
            statString.append(" ");
        }
        statString.append(" ");
        String errString = "" + errorCode;
        StringBuilder prefixErr = new StringBuilder();
        for (i = errString.length(); i < 10; ++i) {
            prefixErr.append(" ");
        }
        statString.append(prefixErr.toString()).append(errString).append(" ");
        String endString = "" + endTime * 1000L;
        StringBuilder prefixEnd = new StringBuilder();
        for (i = endString.length(); i < 10; ++i) {
            prefixEnd.append(" ");
        }
        statString.append(prefixEnd.toString()).append(endString);
        return statString.toString();
    }

    @Override
    protected void destroyThreadControlBlockPtr(boolean noWait) throws IOException {
        try {
            super.destroyThreadControlBlockPtr(noWait);
        }
        finally {
            this.processResultFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResultFile() throws IOException {
        PerfThreadControlBlock threadControlBlockObj = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        try {
            String tmp;
            Stack<String> resultStack;
            Stack<String> newStack = new Stack<String>();
            if ((PerfJavaDriver.getOutputSetting() & OUT_MODE_PERF_LOG_MEM) != 0L && (resultStack = threadControlBlockObj.getResultStack()) != null && !resultStack.empty()) {
                while (!resultStack.empty()) {
                    tmp = resultStack.pop();
                    newStack.push(tmp);
                }
            }
            if (PerfJavaDriver.isForOutputFile()) {
                PrintWriter fp = threadControlBlockObj.getResultFile();
                if (threadControlBlockObj.getOutputFileName() != null && fp != null) {
                    fp.println();
                    fp.println("Corresponding Output File: " + threadControlBlockObj.getOutputFileName());
                    fp.flush();
                }
                while (!newStack.empty()) {
                    tmp = (String)newStack.pop();
                    fp.println(tmp);
                }
            }
        }
        finally {
            threadControlBlockObj.closeResultFile();
            threadControlBlockObj.closeResultStack();
        }
    }

    @Override
    protected void setOutputCount(String tempPtr) {
        PerfThreadControlBlock perfThreadControlBlockPtr = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        perfThreadControlBlockPtr.setResultFileCount(new Integer(tempPtr));
    }

    protected int getOutputCount() {
        PerfThreadControlBlock perfThreadControlBlockPtr = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        return perfThreadControlBlockPtr.getResultFileCount();
    }

    @Override
    void printAuxillaryStatus() {
        PerfThreadControlBlock threadControlBlockObj = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        outputWriter.printResult("Elapsed micro seconds: " + threadControlBlockObj.getAuxCount() * 1000L + "\n");
    }

    @Override
    protected JavaDriver instantiateJavaDriver() {
        return new PerfJavaDriver();
    }

    @Override
    public void beginAPICall() {
        if ((PerfJavaDriver.getOutputSetting() & OUT_MODE_ANY) != 0L) {
            PerfThreadControlBlock threadControlBlockObj = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
            threadControlBlockObj.setAuxCount(System.currentTimeMillis());
        }
    }

    @Override
    public void endAPICall(List<StatusInfo> statusList) {
        try {
            if ((PerfJavaDriver.getOutputSetting() & OUT_MODE_ANY) != 0L) {
                PerfThreadControlBlock threadControlBlockObj = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
                long startTime = threadControlBlockObj.getAuxCount();
                threadControlBlockObj.setAuxCount(System.currentTimeMillis() - startTime);
                this.logResult(statusList, startTime);
            }
        }
        catch (Exception e) {
            System.out.println("Problem in end API Call...");
        }
    }

    protected static long getOutputSetting() {
        return outputSetting;
    }

    @Override
    protected void setOutputSetting(String tempPtr) {
        super.setOutputSetting(tempPtr);
        outputSetting = new Long(tempPtr);
    }

    static {
        fileCount = 0;
    }
}

