/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ArNioXdrTcpEncodingStream
extends ArXdrTcpEncodingStream {
    private static Logger log = Logger.getLogger(ArNioXdrTcpEncodingStream.class);
    private SocketChannel channel;
    private int transmissionTimeout;
    private int transmissionTimeoutEnc;
    private int encryptionCallSoTimeOutFactor = 1;

    public ArNioXdrTcpEncodingStream(SocketChannel streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket.socket(), bufferSize);
        this.channel = streamingSocket;
    }

    @Override
    protected void streamFlush(boolean lastFragment) throws IOException {
        if (!this.isArProcessOn() || this.isArProcessDone()) {
            ByteBuffer output = ByteBuffer.wrap(this.getBuffer(), 0, this.getBufferIndex());
            while (output.hasRemaining()) {
                int bytesWritten = this.channel.write(output);
                log.trace("Number of bytes written " + bytesWritten + " Bytes remaining " + output.remaining());
            }
            this.resetArFlags(lastFragment);
        } else {
            this.holdStreamFlush();
        }
    }

    public int getTransmissionTimeout() {
        if (this.isArProcessOn()) {
            return this.transmissionTimeoutEnc;
        }
        return this.transmissionTimeout;
    }

    public void setTransmissionTimeout(int transmissionTimeout) {
        this.transmissionTimeout = transmissionTimeout;
        this.transmissionTimeoutEnc = transmissionTimeout * this.encryptionCallSoTimeOutFactor;
    }

    @Override
    public void close() throws OncRpcException, IOException {
        if (this.channel != null) {
            if (this.channel.socket() != null) {
                this.channel.socket().close();
            }
            this.channel.close();
        }
        super.close();
    }
}

