/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncKeyBase;

final class ARKeyMask {
    static final int MAX_K_IDX = 4;
    static final int MAX_S_IDX = 4;

    private ARKeyMask() {
    }

    static final byte[] getMaskedKeyBytes(int s_idx, Idx k_idx, boolean isMasked) {
        byte[] rst = k_idx == Idx.K ? ARKeyMask.getMaskedKeyBytes(s_idx, 0, isMasked, null) : (k_idx == Idx.I ? ARKeyMask.getMaskedKeyBytes(s_idx, 1, isMasked, null) : (k_idx == Idx.S ? ARKeyMask.getMaskedKeyBytes(s_idx, 2, isMasked, null) : (k_idx == Idx.M ? ARKeyMask.getMaskedKeyBytes(s_idx, 3, isMasked, null) : (k_idx == Idx.EDFC ? ARKeyMask.getMaskedKeyBytes(s_idx, 4, false, null) : ARKeyMask.getMaskedKeyBytes(s_idx, 4, isMasked, null)))));
        return rst;
    }

    static final byte[] getMaskedKeyBytes(int s_idx, int k_idx, boolean isMasked, byte[] bytesToMask) {
        if (k_idx > 4) {
            k_idx = 4;
        }
        if (s_idx > 4) {
            s_idx = 4;
        }
        byte[][] mask = new byte[][]{{-119, 23, -119, 4, 1, 16, 3, 114}, {112, 20, -105, 16, 7, 8, 5, 16}, {103, 4, -105, 20, 8, 1, 21, -119}, {112, 20, -105, 16, 7, 8, 5, 16}, {-119, 23, -119, 4, 1, 16, 3, 114}};
        byte[][][] keyBytes = new byte[][][]{new byte[][]{{-57, 69, -8, 0, 0, 0, 0, -21}, {-117, 77, -8, -119, 77, -4, -117, 85}, {-117, 77, -4, 59, 77, -8, 126, 9}, {85, -117, -20, 106, -1, 104, -7, -66}, {-99, 115, -102, 107, -1, 103, -7, -66}}, new byte[][]{{9, -117, 69, -8, -125, -64, 1, -119}, {-4, -63, -6, 7, -119, 85, -4, -117}, {-117, 85, -8, -63, -6, 6, -119, 85}, {68, 0, 100, -95, 0, 0, 0, 0}, {50, 8, 51, -95, -51, 0, -16, 82}}, new byte[][]{{-126, -89, -58, 101, -121, -88, 109, 31}, {69, -4, -125, -64, 1, -119, 69, -4}, {-4, -21, -58, 104, 28, 32, 66, 0}, {80, 100, -119, 37, 0, 0, 0, 0}, {80, 58, -119, 82, 2, 17, 100, -84}}, new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0}}, new byte[][]{{37, 98, 70, 51, 68, 51, 95, 48, 36, 66, 56, 52, 101, 100, 52, 35, 49, 65, 42, 56, 54, 50, 55, 68, 45, 57, 50, 49, 94, 55, 0}}};
        if (!isMasked) {
            if (bytesToMask != null) {
                return bytesToMask;
            }
            return keyBytes[k_idx][s_idx];
        }
        byte[] rst = new byte[8];
        for (int i = 0; i < 8; ++i) {
            rst[i] = bytesToMask != null ? (byte)(mask[k_idx][i] ^ bytesToMask[i]) : (byte)(mask[k_idx][i] ^ keyBytes[k_idx][s_idx][i]);
        }
        return rst;
    }

    static final byte[] getUnMaskedKeyBytes(AREncKeyBase encKey, Idx k_idx) {
        byte[] rst = k_idx == Idx.K ? ARKeyMask.getUnMaskedKeyBytes(encKey.getKey(), 0, encKey.isKeyMasked()) : (k_idx == Idx.I ? ARKeyMask.getUnMaskedKeyBytes(encKey.getIv(), 1, encKey.isIvMasked()) : (k_idx == Idx.S && encKey instanceof ARDataKey ? ARKeyMask.getUnMaskedKeyBytes(((ARDataKey)encKey).getSaltIv(), 2, ((ARDataKey)encKey).isSaltIvMasked()) : (k_idx == Idx.M && encKey instanceof ARDataKey ? ARKeyMask.getUnMaskedKeyBytes(((ARDataKey)encKey).getMacKey(), 3, ((ARDataKey)encKey).isMacMasked()) : ARKeyMask.getUnMaskedKeyBytes(encKey.getKey(), 4, encKey.isKeyMasked()))));
        return rst;
    }

    private static final byte[] getUnMaskedKeyBytes(byte[] maskedBytes, int k_idx, boolean isMasked) {
        if (maskedBytes == null) {
            return maskedBytes;
        }
        if (k_idx > 4) {
            k_idx = 4;
        }
        byte[][] mask = new byte[][]{{-119, 23, -119, 4, 1, 16, 3, 114}, {112, 20, -105, 16, 7, 8, 5, 16}, {103, 4, -105, 20, 8, 1, 21, -119}, {112, 20, -105, 16, 7, 8, 5, 16}, {-119, 23, -119, 4, 1, 16, 3, 114}};
        byte[] rst = new byte[maskedBytes.length];
        for (int i = 0; i < maskedBytes.length; ++i) {
            rst[i] = isMasked && maskedBytes.length == 8 ? (byte)(mask[k_idx][i] ^ maskedBytes[i]) : maskedBytes[i];
        }
        return rst;
    }

    static enum Idx {
        K,
        I,
        S,
        M,
        EDFC,
        O;

    }
}

