/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.apitransport.connection.ApiProxyManager;
import com.bmc.arsys.apitransport.session.ClientTypeRpcQueueMapping;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ARServerContext {
    private String serverName;
    private int port;
    private String serverLicense;
    private String serverId;
    private String serverIdent;
    private boolean encryptEnabled = true;
    private String serverCharSetName;
    private String alertEventsForm;
    private boolean localizedServerFlag;
    private int twoDigitYearCutoff = -1;
    private int serverMajorVersion = 0;
    private int serverMinorVersion = 0;
    private int serverMaintVersion = 0;
    private int serverPatchVersion = 0;
    private String serverBuildTimestampStr = null;
    private int rpcClientXDRSizeLimit;
    private int currentXDRBufferSize;
    private int[] dbQueues;
    private int serverCmtMax = 0;
    private int serverCmtTimeout = 0;
    private boolean useControlStructPropList;
    private static Map<String, ClientTypeRpcQueueMapping> clientTypeToRpcQueueMap = new HashMap<String, ClientTypeRpcQueueMapping>();
    private static Logger logger = Logger.getLogger(ARServerContext.class);

    public String getAlertEventsForm() {
        return this.alertEventsForm;
    }

    protected void setAlertEventsForm(String alertEventsForm) {
        this.alertEventsForm = alertEventsForm;
    }

    public String getServerCharSetName() {
        return this.serverCharSetName;
    }

    protected void setServerCharSetName(String serverCharSetName) {
        this.serverCharSetName = serverCharSetName;
    }

    protected boolean isLocalizedServerFlag() {
        return this.localizedServerFlag;
    }

    protected void setLocalizedServerFlag(boolean localizedServerFlag) {
        this.localizedServerFlag = localizedServerFlag;
    }

    protected int getRpcClientXDRSizeLimit() {
        return this.rpcClientXDRSizeLimit;
    }

    protected void setRpcClientXDRSizeLimit(int rpcClientXDRSizeLimit) {
        this.rpcClientXDRSizeLimit = rpcClientXDRSizeLimit;
    }

    protected String getServer() {
        return this.serverName;
    }

    protected void setServer(String server) {
        this.serverName = server;
    }

    protected String getServerId() {
        return this.serverId;
    }

    protected void setServerId(String serverId) {
        this.serverId = serverId;
    }

    protected String getServerIdent() {
        return this.serverIdent;
    }

    protected void setServerIdent(String serverIdent) {
        this.serverIdent = serverIdent;
    }

    protected String getServerLicense() {
        return this.serverLicense;
    }

    protected void setServerLicense(String serverLicense) {
        this.serverLicense = serverLicense;
    }

    public int getServerMaintVersion() {
        return this.serverMaintVersion;
    }

    public int getServerMajorVersion() {
        return this.serverMajorVersion;
    }

    public int getServerMinorVersion() {
        return this.serverMinorVersion;
    }

    public int getServerPatchVersion() {
        return this.serverPatchVersion;
    }

    protected int getTwoDigitYearCutoff() {
        return this.twoDigitYearCutoff;
    }

    protected void setTwoDigitYearCutoff(int twoDigitYearCutoff) {
        this.twoDigitYearCutoff = twoDigitYearCutoff;
    }

    protected boolean isUseControlStructPropList() {
        return this.useControlStructPropList;
    }

    protected void setUseControlStructPropList(boolean useControlStructPropList) {
        this.useControlStructPropList = useControlStructPropList;
    }

    public void recordServerProductVersion(String serverVersionInfo) {
        int end1 = serverVersionInfo.indexOf(".");
        if (end1 < 1) {
            logger.error("Server Product version with wrong format: " + serverVersionInfo);
            return;
        }
        StringTokenizer t = new StringTokenizer(serverVersionInfo, " ");
        try {
            if (t.hasMoreTokens()) {
                StringTokenizer t1 = new StringTokenizer(t.nextToken(), ".");
                if (t1.hasMoreTokens()) {
                    this.serverMajorVersion = new Integer(t1.nextToken());
                }
                if (t1.hasMoreTokens()) {
                    this.serverMinorVersion = new Integer(t1.nextToken());
                }
                if (t1.hasMoreTokens()) {
                    this.serverMaintVersion = new Integer(t1.nextToken());
                }
            }
            while (t.hasMoreTokens()) {
                String txt = t.nextToken();
                if (txt.toLowerCase().equals("build") || txt.toLowerCase().equals("beta")) continue;
                if (txt.toLowerCase().equals("patch")) {
                    if (!t.hasMoreTokens()) continue;
                    this.serverPatchVersion = new Integer(t.nextToken());
                    continue;
                }
                if (txt.length() <= 0 || this.serverBuildTimestampStr != null) continue;
                this.serverBuildTimestampStr = txt;
            }
        }
        catch (Exception e) {
            logger.error("Server Product version with wrong format: " + serverVersionInfo, e);
            return;
        }
    }

    protected int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    protected void setEncryptionEnabled(boolean flag) {
        this.encryptEnabled = flag;
    }

    boolean isEncryptionEnabled() {
        return this.encryptEnabled;
    }

    public String getServerBuildTimestampStr() {
        return this.serverBuildTimestampStr;
    }

    public int getCurrentXDRBufferSize() {
        return this.currentXDRBufferSize;
    }

    void setCurrentXDRBufferSize(int currentXDRBufferSize) {
        this.currentXDRBufferSize = currentXDRBufferSize;
    }

    void setDbQueues(int[] dbQueues) {
        this.dbQueues = dbQueues;
    }

    public int[] getDbQueues() {
        return this.dbQueues;
    }

    public int getServerCmtMax() {
        return this.serverCmtMax;
    }

    void setServerCmtMax(int serverCmtMax) {
        if (this.serverCmtMax < serverCmtMax) {
            this.serverCmtMax = serverCmtMax;
            ApiProxyManager.setMaxConnectedServerCMTAllowed(serverCmtMax);
        }
    }

    public int getServerCmtTimeout() {
        return this.serverCmtTimeout;
    }

    void setServerCmtTimeout(int cmtTimeout) {
        int converToMilli = cmtTimeout * 1000;
        if (this.serverCmtTimeout < converToMilli) {
            this.serverCmtTimeout = converToMilli;
            ApiProxyManager.setServerCmtTimeout(this.serverCmtTimeout);
        }
    }

    public void setClientTypeToRpcQueueMap(String mappingStr) {
        if (this.serverIdent != null) {
            if (mappingStr == null || mappingStr.isEmpty()) {
                clientTypeToRpcQueueMap.remove(this.serverIdent);
            } else if (clientTypeToRpcQueueMap.get(this.serverIdent) != null) {
                clientTypeToRpcQueueMap.get(this.serverIdent).putAll(mappingStr);
            } else {
                ClientTypeRpcQueueMapping newMapping = new ClientTypeRpcQueueMapping();
                newMapping.putAll(mappingStr);
                clientTypeToRpcQueueMap.put(this.serverIdent, newMapping);
            }
        }
    }

    public boolean isRpcQueueByClientTypeMapEmpty() {
        return clientTypeToRpcQueueMap == null || clientTypeToRpcQueueMap.get(this.getServerIdent()) == null || clientTypeToRpcQueueMap.get(this.getServerIdent()).isEmpty();
    }

    public Integer getRpcQueueByClientType(int clientType) {
        if (clientTypeToRpcQueueMap.get(this.serverIdent) != null) {
            return clientTypeToRpcQueueMap.get(this.serverIdent).getRpcQueueByClientType(clientType);
        }
        return 0;
    }
}

