/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.FieldOperandInfo;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.RegularComplexQuery;
import com.bmc.arsys.api.Value;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntryValueList
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5612978453923059756L;
    private static Logger logger = Logger.getLogger(EntryValueList.class);
    private final Map<ArithmeticOrRelationalOperand, Value> values = new LinkedHashMap<ArithmeticOrRelationalOperand, Value>();

    public Value get(ArithmeticOrRelationalOperand operand) {
        return this.values.get(operand);
    }

    public Value get(int fieldId) {
        FieldOperandInfo operand = new FieldOperandInfo(fieldId);
        return this.get(new ArithmeticOrRelationalOperand(operand));
    }

    static List<EntryValueList> buildGLVFEResponse(ARServerUser context, byte[] inbuf, List<ArithmeticOrRelationalOperand> selectionList, String serverCharSetName, OutputInteger nMatches) throws ARException {
        return EntryValueList.buildResponse(inbuf, selectionList, serverCharSetName, nMatches, "GLVFE", null);
    }

    static List<EntryValueList> buildGLVFMSEResponse(ARServerUser context, byte[] inbuf, RegularComplexQuery query, String serverCharSetName, OutputInteger nMatches) throws ARException {
        return EntryValueList.buildResponse(inbuf, query.getSelectionList(), serverCharSetName, nMatches, "GLVFMSE", query.getFromSources());
    }

    private static List<EntryValueList> buildResponse(byte[] inbuf, List<ArithmeticOrRelationalOperand> selectionList, String serverCharSetName, OutputInteger nMatches, String apiName, List<IQuerySource> sources) throws ARException {
        ArrayList<EntryValueList> valuesListFromEntries = new ArrayList<EntryValueList>();
        if (inbuf == null) {
            return valuesListFromEntries;
        }
        String bufStr = null;
        try {
            bufStr = new String(inbuf, serverCharSetName);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ARException(2, 9061, ex.getLocalizedMessage());
        }
        logger.debug("build" + apiName + "Response: buffer len=" + bufStr.length());
        int numEntries = 0;
        int numFieldsPerEntry = 0;
        int bIndex = 0;
        int eIndex = bufStr.indexOf("\n", bIndex);
        if (eIndex > 0) {
            try {
                numEntries = new Integer(bufStr.substring(bIndex, eIndex));
            }
            catch (NumberFormatException nfe) {
                logger.debug("NFE occurs at index [" + bIndex + "] for # of entries. ");
                EntryValueList.logBuffer(bufStr);
                throw nfe;
            }
        } else {
            logger.error("ERROR: Unable to parse " + apiName + " result buffer for the # of entries. " + bufStr.substring(bIndex));
            return valuesListFromEntries;
        }
        bIndex = eIndex + 1;
        eIndex = bufStr.indexOf("\n", bIndex);
        if (eIndex > 0) {
            if (nMatches != null) {
                try {
                    nMatches.setValue(new Integer(bufStr.substring(bIndex, eIndex)));
                }
                catch (NumberFormatException nfe) {
                    logger.debug("NFE occurs at index [" + bIndex + "] for the # of matches. ");
                    EntryValueList.logBuffer(bufStr);
                    throw nfe;
                }
            }
        } else {
            logger.error("ERROR: Unable to parse " + apiName + " result buffer for the # of matches. " + bufStr.substring(bIndex));
            return valuesListFromEntries;
        }
        if (selectionList == null || selectionList.isEmpty()) {
            bIndex = eIndex + 1;
            if ((eIndex = bufStr.indexOf("\n", bIndex)) > 0) {
                try {
                    numFieldsPerEntry = new Integer(bufStr.substring(bIndex, eIndex));
                }
                catch (NumberFormatException nfe) {
                    logger.debug("NFE occurs at index [" + bIndex + "] for # of fields per entry. " + bufStr.substring(bIndex));
                    EntryValueList.logBuffer(bufStr);
                    throw nfe;
                }
            } else {
                logger.error("ERROR: Unable to parse " + apiName + " result buffer for the # of fields per entry. " + bufStr.substring(bIndex));
                return valuesListFromEntries;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("build" + apiName + "Response: numEntries=" + numEntries + " nMatches=" + (nMatches != null ? nMatches : Integer.valueOf(0)) + " numFieldsPerEntry=" + numFieldsPerEntry);
            }
            selectionList = new LinkedList<ArithmeticOrRelationalOperand>();
            for (int i = 0; i < numFieldsPerEntry; ++i) {
                bIndex = eIndex + 1;
                if ((eIndex = bufStr.indexOf("\n", bIndex)) > 0) {
                    try {
                        if (apiName.equals("GLVFE")) {
                            selectionList.add(new ArithmeticOrRelationalOperand(new FieldOperandInfo(new Integer(bufStr.substring(bIndex, eIndex)))));
                            continue;
                        }
                        String[] tmpBuf = bufStr.substring(bIndex, eIndex).split("\\\\", 2);
                        Integer fieldId = new Integer(tmpBuf[0]);
                        String schemaAlias = tmpBuf[1];
                        IQuerySource querySource = null;
                        int j = 0;
                        if (j < sources.size() && schemaAlias != "" && sources.get(j).getAlias().equals(schemaAlias)) {
                            querySource = sources.get(j);
                        }
                        selectionList.add(new ArithmeticOrRelationalOperand(new FieldOperandInfo(fieldId, querySource)));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug("NFE occurs at index [" + bIndex + "] for field Ids. " + bufStr.substring(bIndex));
                        EntryValueList.logBuffer(bufStr);
                        throw nfe;
                    }
                }
                logger.error("ERROR: Unable to parse " + apiName + " result buffer for field Ids. " + bufStr.substring(bIndex));
                return valuesListFromEntries;
            }
        }
        OutputInteger len = new OutputInteger();
        int lenDiff = 0;
        for (int i = 0; i < numEntries; ++i) {
            EntryValueList valuesFromEntry = new EntryValueList();
            for (ArithmeticOrRelationalOperand operand : selectionList) {
                int valJavaLen;
                Value value;
                int valSvrLen;
                int dataType;
                bIndex = eIndex + 1;
                if ((eIndex = bufStr.indexOf("\\", bIndex)) > 0) {
                    try {
                        dataType = new Integer(bufStr.substring(bIndex, eIndex));
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug("NFE occurs at index [" + bIndex + "] for the datatype." + bufStr.substring(bIndex));
                        EntryValueList.logBuffer(bufStr);
                        throw nfe;
                    }
                } else {
                    logger.error("ERROR: Unable to parse " + apiName + " result buffer for the dataType. " + bufStr.substring(bIndex));
                    return valuesListFromEntries;
                }
                bIndex = eIndex + 1;
                eIndex = bufStr.indexOf("\\", bIndex);
                if (eIndex > 0) {
                    try {
                        valSvrLen = new Integer(bufStr.substring(bIndex, eIndex));
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug("NFE occurs at index [" + bIndex + "] for the value length." + bufStr.substring(bIndex));
                        EntryValueList.logBuffer(bufStr);
                        throw nfe;
                    }
                } else {
                    logger.error("ERROR: Unable to parse " + apiName + " result buffer for the value length. " + bufStr.substring(bIndex));
                    return valuesListFromEntries;
                }
                bIndex = eIndex + 1;
                if (valSvrLen > 0) {
                    value = Value.deserializeFromBytesBuffer(inbuf, bIndex + lenDiff, valSvrLen, dataType, serverCharSetName, len);
                    valJavaLen = len.intValue();
                    lenDiff += valSvrLen - valJavaLen;
                } else {
                    value = new Value();
                    valJavaLen = 0;
                }
                eIndex = bIndex + valJavaLen;
                valuesFromEntry.values.put(operand, value);
            }
            valuesListFromEntries.add(valuesFromEntry);
        }
        return valuesListFromEntries;
    }

    private static void logBuffer(String buff) {
        String log = buff.replace("\\", "\\\\");
        log = log.replace("\n", "\\n");
        logger.debug("The complete buffer contents=" + log);
    }
}

