/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.RunProcessAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DSOAction
extends RunProcessAction {
    public static final int DSOACTION_TYPE_TRANSFER = 0;
    public static final int DSOACTION_TYPE_RETURN = 1;
    public static final int DSOACTION_TYPE_DELETE = 2;
    public static final String DSOACTION_CMD_TRANSFER = "Distributed-Transfer";
    public static final String DSOACTION_CMD_RETURN = "Distributed-Return";
    public static final String DSOACTION_CMD_DELETE = "Distributed-Delete";
    private static final long serialVersionUID = 26429601219023574L;
    private int type;
    private String server;
    private String form;
    private String dsoMapping;
    private String dsoPool;
    private boolean overrideLoopDetection;
    private String field;

    public DSOAction() {
        this.type = 0;
        this.dsoMapping = "";
        this.dsoPool = "";
        this.server = "";
        this.form = "";
        this.overrideLoopDetection = false;
    }

    public DSOAction(String commandLine) {
        super(commandLine);
        this.setCommandLine(commandLine);
    }

    private String[] extractTagValues(String[] tags, String from) {
        Pattern pattern = Pattern.compile("[-][a-z]([ ]*(\"[^\"]+\"))?");
        Matcher matcher = pattern.matcher(from);
        String[] values = new String[tags.length];
        block0: while (matcher.find()) {
            String found = matcher.group().trim();
            int counter = 0;
            for (String tag : tags) {
                if (found.indexOf(tag) == 0) {
                    String value = found.substring(tag.length()).trim();
                    if (value.length() > 0 && value.charAt(0) == '\"') {
                        value = value.substring(1);
                    }
                    if (value.length() > 0 && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(0, value.length() - 1);
                    }
                    values[counter] = value;
                    continue block0;
                }
                ++counter;
            }
        }
        return values;
    }

    @Override
    public void setCommandLine(String commandLine) {
        super.setCommandLine(commandLine);
        String[] values = null;
        if (commandLine.indexOf(DSOACTION_CMD_TRANSFER) == 0) {
            this.type = 0;
            values = this.extractTagValues(new String[]{"-m", "-s", "-x", "-p", "-o"}, commandLine);
            this.dsoMapping = values[0] == null ? "" : values[0];
            this.form = values[1] == null ? "" : values[1];
            this.server = values[2] == null ? "" : values[2];
            this.dsoPool = values[3] == null ? "" : values[3];
            this.overrideLoopDetection = values[4] != null;
        } else if (commandLine.indexOf(DSOACTION_CMD_DELETE) == 0) {
            this.type = 2;
            values = this.extractTagValues(new String[]{"-e", "-s", "-x", "-p"}, commandLine);
            this.field = values[0] == null ? "" : values[0];
            this.form = values[1] == null ? "" : values[1];
            this.server = values[2] == null ? "" : values[2];
            this.dsoPool = values[3] == null ? "" : values[3];
        } else if (commandLine.indexOf(DSOACTION_CMD_RETURN) == 0) {
            this.type = 1;
            values = this.extractTagValues(new String[]{"-p", "-o"}, commandLine);
            this.dsoPool = values[0] == null ? "" : values[0];
            this.overrideLoopDetection = values[1] != null;
        } else {
            throw new IllegalArgumentException("Specified command is not associated with a valid DSO action process.");
        }
    }

    protected void updateCommandLine() {
        StringBuilder builder = new StringBuilder();
        switch (this.type) {
            case 0: {
                builder.append(DSOACTION_CMD_TRANSFER);
                if (this.dsoMapping != null && !"".equals(this.dsoMapping)) {
                    builder.append(" -m \"");
                    builder.append(this.dsoMapping);
                    builder.append("\"");
                }
                if (this.form != null && !"".equals(this.form)) {
                    builder.append(" -s \"");
                    builder.append(this.form);
                    builder.append("\"");
                }
                if (this.server != null && !"".equals(this.server)) {
                    builder.append(" -x \"");
                    builder.append(this.server);
                    builder.append("\"");
                }
                if (this.dsoPool != null && !"".equals(this.dsoPool)) {
                    builder.append(" -p \"");
                    builder.append(this.dsoPool);
                    builder.append("\"");
                }
                if (!this.overrideLoopDetection) break;
                builder.append(" -o");
                break;
            }
            case 2: {
                builder.append(DSOACTION_CMD_DELETE);
                if (this.field != null && !"".equals(this.field)) {
                    builder.append(" -e \"");
                    builder.append(this.field);
                    builder.append("\"");
                }
                if (this.form != null && !"".equals(this.form)) {
                    builder.append(" -s \"");
                    builder.append(this.form);
                    builder.append("\"");
                }
                if (this.server != null && !"".equals(this.server)) {
                    builder.append(" -x \"");
                    builder.append(this.server);
                    builder.append("\"");
                }
                if (this.dsoPool == null || "".equals(this.dsoPool)) break;
                builder.append(" -p \"");
                builder.append(this.dsoPool);
                builder.append("\"");
                break;
            }
            case 1: {
                builder.append(DSOACTION_CMD_RETURN);
                if (this.dsoPool != null && !"".equals(this.dsoPool)) {
                    builder.append(" -p \"");
                    builder.append(this.dsoPool);
                    builder.append("\"");
                }
                if (!this.overrideLoopDetection) break;
                builder.append(" -o");
            }
        }
        super.setCommandLine(builder.toString());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.updateCommandLine();
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
        this.updateCommandLine();
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
        this.updateCommandLine();
    }

    public String getDSOMapping() {
        return this.dsoMapping;
    }

    public void setDSOMapping(String dsoMapping) {
        this.dsoMapping = dsoMapping;
        this.updateCommandLine();
    }

    public boolean isOverrideLoopDetection() {
        return this.overrideLoopDetection;
    }

    public void setOverrideLoopDetection(boolean overrideLoopDetection) {
        this.overrideLoopDetection = overrideLoopDetection;
        this.updateCommandLine();
    }

    public String getDSOPool() {
        return this.dsoPool;
    }

    public void setDSOPool(String dsoPool) {
        this.dsoPool = dsoPool;
        this.updateCommandLine();
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
        this.updateCommandLine();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DSOAction)) {
            return false;
        }
        return super.equals(obj);
    }
}

