/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.ContainerType;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ContainerListInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2265754968285667059L;
    String m_containerKey;
    ContainerType m_containerType;
    List<ContainerOwner> m_containerOwner;

    public ContainerListInfo(String name, int nType, List<ContainerOwner> owner) {
        this.m_containerKey = name;
        this.m_containerType = ContainerType.toContainerType(nType);
        this.m_containerOwner = owner;
    }

    private ContainerListInfo() {
    }

    public String getKey() {
        return this.m_containerKey;
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.m_containerKey = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this.m_containerType = ContainerType.toContainerType(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 1)));
        this.m_containerOwner = ARTypeMgr.getInstance().ObjectListFromVariant(ContainerOwner.class, ARTypeMgr.GetAt((Object)rawData, 2), ctx);
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[]{this.m_containerKey, new Integer(this.m_containerType.toInt()), ARTypeMgr.getInstance().ObjectToVariant(this.m_containerOwner, ctx)};
        return var;
    }

    static ContainerListInfo createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        ContainerListInfo obj = new ContainerListInfo();
        if (rawData.length == 3) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Container Key", this.m_containerKey).append("Container Type", this.m_containerType).append("Container Owner", this.m_containerOwner).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_containerKey).append(this.m_containerType).append(this.m_containerOwner).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContainerListInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ContainerListInfo rhs = (ContainerListInfo)obj;
        return new EqualsBuilder().append(this.m_containerKey, rhs.m_containerKey).append(this.m_containerType, rhs.m_containerType).append(this.m_containerOwner, rhs.m_containerOwner).isEquals();
    }

    public Object clone() throws CloneNotSupportedException {
        ContainerListInfo obj = (ContainerListInfo)super.clone();
        if (this.m_containerOwner != null) {
            int nLen = this.m_containerOwner.size();
            obj.m_containerOwner = new ArrayList<ContainerOwner>(nLen);
            for (int i = 0; i < nLen; ++i) {
                obj.m_containerOwner.add(i, (ContainerOwner)this.m_containerOwner.get(i).clone());
            }
        }
        return obj;
    }
}

