/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ConfigKey;
import com.bmc.arsys.apitransport.ApiConfig;
import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringStyle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.log4j.Logger;

public class Config
extends ApiConfig {
    private static Logger log = Logger.getLogger(Config.class);
    private static final Config INSTANCE = new Config();
    protected boolean stringizeFieldAssignments;
    protected boolean stringizeSetIfQualification;
    protected boolean useLegacyQualParser;
    protected boolean useLegacyAssignParser;
    protected boolean useLegacyQualFormatter;
    protected boolean useLegacyAssignFormatter;
    protected ToStringStyle toStringStyle;

    public static Config getInstance() {
        return INSTANCE;
    }

    public synchronized void refresh() {
        try {
            this.applyDefaults();
            this.applyConfigFileSettings();
        }
        catch (Throwable e) {
            log.error("Can not refresh Config ", e);
        }
    }

    private Config() {
        super("ARApiConfig", "arsys_base.xml");
    }

    @Override
    protected void applyConfigFileSettings() {
        super.applyConfigFileSettings();
        this.setParserMode(this.config);
        this.setQualAssignFormatterMode(this.config);
        this.stringizeFieldAssignments = this.config.getBoolean(ConfigKey.StringizeFieldAssignments.getKey(), this.stringizeFieldAssignments);
        this.stringizeSetIfQualification = this.config.getBoolean(ConfigKey.StringizeSetIfQualification.getKey(), this.stringizeSetIfQualification);
        this.logConfigValues();
    }

    @Override
    protected void applyDefaults() {
        super.applyDefaults();
        this.useLegacyQualParser = Boolean.parseBoolean(ConfigKey.QualificationParserMode.getDefaultValue());
        this.useLegacyAssignParser = Boolean.parseBoolean(ConfigKey.AssignmentParserMode.getDefaultValue());
        this.useLegacyQualFormatter = Boolean.parseBoolean(ConfigKey.QualificationFormatterMode.getDefaultValue());
        this.useLegacyAssignFormatter = Boolean.parseBoolean(ConfigKey.AssignmentFormatterMode.getDefaultValue());
        this.stringizeFieldAssignments = Boolean.parseBoolean(ConfigKey.StringizeFieldAssignments.getDefaultValue());
        this.stringizeSetIfQualification = Boolean.parseBoolean(ConfigKey.StringizeSetIfQualification.getDefaultValue());
        try {
            this.setToStringStyle(ConfigKey.ToStringStyle.getDefaultValue());
        }
        catch (Exception e) {
            log.error("Can not initialize Config item 'ToStringSyle'", e);
        }
    }

    private void setToStringStyle(String toStringStyleName) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (toStringStyleName != null && toStringStyleName.length() > 0) {
            int sepAt = toStringStyleName.lastIndexOf(".");
            String className = toStringStyleName.substring(0, sepAt);
            String memName = toStringStyleName.substring(sepAt + 1);
            Class<?> clazz = Class.forName(className);
            Field field = clazz.getDeclaredField(memName);
            if (Modifier.isStatic(field.getModifiers()) && field.getType().asSubclass(ToStringStyle.class) != null) {
                ToStringStyle val = (ToStringStyle)field.get(null);
                this.setToStringStyle(val);
            }
        }
    }

    public boolean isStringizeFieldAssignments() {
        return this.stringizeFieldAssignments;
    }

    void setStringizeFieldAssignments(boolean stringizeFieldAssignments) {
        this.stringizeFieldAssignments = stringizeFieldAssignments;
    }

    public boolean isStringizeSetIfQualification() {
        return this.stringizeSetIfQualification;
    }

    void setStringizeSetIfQualification(boolean stringizeSetIfQualification) {
        this.stringizeSetIfQualification = stringizeSetIfQualification;
    }

    private void setParserMode(Configuration config) {
        this.useLegacyQualParser = config.getBoolean(ConfigKey.QualificationParserMode.getKey(), this.useLegacyQualParser);
        this.useLegacyAssignParser = config.getBoolean(ConfigKey.AssignmentParserMode.getKey(), this.useLegacyAssignParser);
    }

    private void setQualAssignFormatterMode(Configuration config) {
        this.useLegacyQualFormatter = config.getBoolean(ConfigKey.QualificationFormatterMode.getKey(), this.useLegacyQualFormatter);
        this.useLegacyAssignFormatter = config.getBoolean(ConfigKey.AssignmentFormatterMode.getKey(), this.useLegacyAssignFormatter);
    }

    void setUseLegacyQualParser(boolean parserMode) {
        log.info("setUseLegacyQualParser: " + parserMode);
        this.useLegacyQualParser = parserMode;
    }

    public boolean getUseLegacyQualParser() {
        return this.useLegacyQualParser;
    }

    void setUseLegacyAssignParser(boolean parserMode) {
        log.info("setUseLegacyAssignParser: " + parserMode);
        this.useLegacyAssignParser = parserMode;
    }

    public boolean getUseLegacyAssignParser() {
        return this.useLegacyAssignParser;
    }

    void setUseLegacyQualFormatter(boolean formatterMode) {
        log.info("setUseLegacyQualFormatter: " + this.useLegacyQualFormatter);
        this.useLegacyQualFormatter = formatterMode;
    }

    public boolean getUseLegacyQualFormatter() {
        return this.useLegacyQualFormatter;
    }

    void setUseLegacyAssignFormatter(boolean formatterMode) {
        log.info("setUseLegacyAssignFormatter: " + this.useLegacyAssignFormatter);
        this.useLegacyAssignFormatter = formatterMode;
    }

    public boolean getUseLegacyAssignFormatter() {
        return this.useLegacyAssignFormatter;
    }

    public ToStringStyle getToStringStyle() {
        return this.toStringStyle;
    }

    protected void setToStringStyle(ToStringStyle toStringStyle) {
        this.toStringStyle = toStringStyle;
    }

    private void logConfigValues() {
        log.info("jniLoadMode: " + this.jniLoadMode);
        log.info("apiRecordingMode: " + this.apiRecordingMode);
        log.info("useConnectionPooling: " + this.useConnectionPooling);
        log.info("maxProxiesPerServer: " + this.maxProxiesPerServer);
        log.info("idleConnectionsPerServer: " + this.idleConnectionsPerServer);
        log.info("connectionTimeout: " + this.connectionTimeout);
        log.info("connectionLifespan: " + this.connectionLifespan);
        log.info("timeUnit: " + this.timeUnitStr);
        log.info("minimumSupportedServerRpcVersion: " + this.minimumSupportedServerRpcVersion);
        log.info("connectionMaxRetries: " + this.connectionMaxRetries);
        log.info("timeLagBetweenRetriesMillSec: " + this.timeLagBetweenRetriesMillSec);
        log.info("stringizeFieldAssignments: " + this.stringizeFieldAssignments);
        log.info("stringizeSetIfQualification: " + this.stringizeSetIfQualification);
        log.info("useLegacyQualParser: " + this.useLegacyQualParser);
        log.info("useLegacyAssignParser: " + this.useLegacyAssignParser);
        log.info("useLegacyQualFormatter: " + this.useLegacyQualFormatter);
        log.info("useLegacyAssignFormatter: " + this.useLegacyAssignFormatter);
    }
}

