/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.utils.ARFileHandler;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class AttachmentValue
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8184114329665152992L;
    static final int AR_LOC_NULL = 0;
    public static final int AR_LOC_FILENAME = 1;
    public static final int AR_LOC_BUFFER = 2;
    private String _name;
    private long _origSize;
    private long _compSize;
    private int locationType;
    private byte[] content;
    private String filePath;

    public AttachmentValue() {
        this._compSize = 0L;
    }

    public AttachmentValue(byte[] loc) {
        this("", loc);
    }

    public AttachmentValue(String name, byte[] loc) {
        this();
        this._name = name;
        this.setValue(loc);
    }

    public AttachmentValue(String filePath) throws IOException {
        this(filePath, filePath);
    }

    public AttachmentValue(String name, String filePath) throws IOException {
        this._name = name;
        this.setValue(filePath);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public long getOriginalSize() {
        return this._origSize;
    }

    public void setOriginalSize(long size) {
        this._origSize = size;
    }

    public long getCompressedSize() {
        return this._compSize;
    }

    public void setCompressedSize(long size) {
        this._compSize = size;
    }

    public String getValueFileName() {
        return this.filePath != null ? this.filePath : this._name;
    }

    public byte[] getContent() {
        return this.getValue();
    }

    public byte[] getValue() {
        return this.content;
    }

    public void setValue(byte[] content) {
        this.locationType = 2;
        this._origSize = content != null ? (long)content.length : 0L;
        this._compSize = this._origSize;
        this.content = content;
    }

    public void setValue(String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists()) {
            this.setValue(ARFileHandler.readBytesFromFile(file));
        }
    }

    public void setLocationType(int type) {
        this.locationType = type;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this._name = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this._origSize = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 1));
        this._compSize = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 2));
        this.locationType = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, new int[]{3, 0}));
        if (this.locationType == 2) {
            this.content = (byte[])ARTypeMgr.GetAt((Object)rawData, new int[]{3, 1});
        } else if (this.locationType == 1) {
            this.filePath = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, new int[]{3, 1}));
        }
    }

    Object toVariant(ARServerUser ctx) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[4];
        objectArray2[0] = this._name;
        objectArray2[1] = this._origSize;
        objectArray2[2] = this._compSize;
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = this.locationType;
        if (this.locationType == 2) {
            Object[] objectArray4 = new Object[2];
            objectArray4[0] = this.content.length;
            objectArray = objectArray4;
            objectArray4[1] = this.content;
        } else {
            objectArray = this.filePath;
        }
        objectArray3[1] = objectArray;
        objectArray2[3] = objectArray3;
        Object[] var = objectArray2;
        return var;
    }

    static AttachmentValue createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        AttachmentValue obj = new AttachmentValue();
        if (rawData.length == 4) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Name", this._name).append("Orig Size", this._origSize).append("Comp Size", this._compSize).append("Location Type", this.locationType).append("Content", this.content).append("File Path", this.filePath).toString();
    }

    public Object clone() throws CloneNotSupportedException {
        AttachmentValue retObj = (AttachmentValue)super.clone();
        if (this.content != null) {
            retObj.content = (byte[])this.content.clone();
        }
        return retObj;
    }

    public int getLocationType() {
        return this.locationType;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this._name).append(this._origSize).append(this._compSize).append(this.locationType).append(this.content).append(this.filePath).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AttachmentValue)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AttachmentValue rhs = (AttachmentValue)obj;
        return new EqualsBuilder().append(this._name, rhs._name).append(this._origSize, rhs._origSize).append(this._compSize, rhs._compSize).append(this.locationType, rhs.locationType).append(this.content, rhs.content).append(this.filePath, rhs.filePath).isEquals();
    }

    static AttachmentValue deserializeFromObjectStr(String valueStrToExtract) {
        int ia1 = valueStrToExtract.indexOf(";");
        String attachName = null;
        int orgSize = 0;
        int compSize = 0;
        String subLineA1 = null;
        if (ia1 < valueStrToExtract.length()) {
            orgSize = new Integer(valueStrToExtract.substring(0, ia1));
            subLineA1 = valueStrToExtract.substring(ia1 + 1);
            int ia2 = subLineA1.indexOf(";");
            if (ia2 < subLineA1.length()) {
                compSize = new Integer(subLineA1.substring(0, ia2));
                if (ia2 + 1 < subLineA1.length()) {
                    attachName = subLineA1.substring(ia2 + 1);
                }
            }
        }
        AttachmentValue attachInfo = new AttachmentValue();
        attachInfo.setOriginalSize(orgSize);
        attachInfo.setCompressedSize(compSize);
        if (attachName != null) {
            attachInfo.setName(attachName);
        }
        return attachInfo;
    }
}

