/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.artranscode;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ARCharSet {
    static Map<String, String> langCharSetMap;
    static Map<String, String> serverCharsetStringMap;
    static final Pattern pWindows;
    static final Pattern pUnix;
    private static Logger logger;

    public static String getServerCharSetName(String serverLanguage) {
        logger.debug((Object)("serverLanguage = " + serverLanguage));
        int idx = serverLanguage.indexOf(";");
        String svrCharSetJavaName = null;
        String svrCharSetARName = null;
        if (idx > -1) {
            svrCharSetARName = serverLanguage.substring(idx + 1);
        }
        if (svrCharSetARName != null) {
            String tempStr = langCharSetMap.get(svrCharSetARName);
            if (tempStr != null) {
                svrCharSetJavaName = tempStr;
            } else {
                tempStr = ARCharSet.getServerCharSetNameFromMatchPattern(svrCharSetARName);
                if (tempStr != null) {
                    svrCharSetJavaName = tempStr;
                } else if (svrCharSetARName.contains("UTF_8") || svrCharSetARName.contains("UTF-8")) {
                    svrCharSetJavaName = "UTF-8";
                } else if (svrCharSetARName.contains("UTF_16") || svrCharSetARName.contains("UTF-16")) {
                    svrCharSetJavaName = "UTF-16";
                } else if (svrCharSetARName.contains("WESTERN")) {
                    svrCharSetJavaName = "windows-1252";
                } else if (svrCharSetARName.equals("SJIS")) {
                    svrCharSetJavaName = "windows-31j";
                } else if (svrCharSetARName.contains("Shift-JIS") || svrCharSetARName.contains("Shift_JIS")) {
                    svrCharSetJavaName = "windows-31j";
                } else if (svrCharSetARName.contains("EUC_C") || svrCharSetARName.contains("EUC_ZH")) {
                    svrCharSetJavaName = "EUC_CN";
                } else if (svrCharSetARName.contains("EUC_H") || svrCharSetARName.contains("EUC_TW")) {
                    svrCharSetJavaName = "EUC_TW";
                } else if (svrCharSetARName.contains("EUC_K") || svrCharSetARName.contains("EUC-K")) {
                    svrCharSetJavaName = "EUC_KR";
                } else if (svrCharSetARName.contains("EUC")) {
                    svrCharSetJavaName = "EUC_JP";
                } else if (svrCharSetARName.contains("GB")) {
                    svrCharSetJavaName = "GB2312";
                } else if (svrCharSetARName.contains("BIG5")) {
                    svrCharSetJavaName = "Big5";
                } else if (svrCharSetARName.contains("KSC_5601")) {
                    svrCharSetJavaName = "EUC_KR";
                } else if (svrCharSetARName.contains("874")) {
                    svrCharSetJavaName = "windows-874";
                }
            }
        }
        if (svrCharSetJavaName == null) {
            svrCharSetJavaName = "utf-8";
        }
        logger.debug((Object)("svrCharSetJavaName = " + svrCharSetJavaName));
        return svrCharSetJavaName;
    }

    private static String getServerCharSetNameFromMatchPattern(String svrCharSetARName) {
        String result = null;
        Matcher m = pWindows.matcher(svrCharSetARName);
        if (m.find() || (m = pUnix.matcher(svrCharSetARName)).find()) {
            String matchStr = m.group(1);
            logger.debug((Object)matchStr);
            result = langCharSetMap.get(matchStr);
        }
        return result;
    }

    public static String getServerKnownCodeSet(String javaCharSetName) {
        if ("windows-31j".equalsIgnoreCase(javaCharSetName) || "SJIS".equalsIgnoreCase(javaCharSetName)) {
            return "shift_jis";
        }
        return ARCharSet.getServerKnownCharSetString(javaCharSetName);
    }

    public static String getServerKnownCharSetString(String javaCharSetName) {
        String rtn = null;
        rtn = serverCharsetStringMap.get(javaCharSetName.toLowerCase());
        if (rtn == null) {
            rtn = "utf-8".toUpperCase();
        }
        return rtn;
    }

    static {
        pWindows = Pattern.compile("(125\\d)");
        pUnix = Pattern.compile("(8859[\\-_]\\d+)");
        logger = Logger.getLogger(ARCharSet.class);
        langCharSetMap = new HashMap<String, String>();
        langCharSetMap.put("8859-11", "windows-874");
        langCharSetMap.put("8859_11", "windows-874");
        langCharSetMap.put("8859-15", "windows-1252");
        langCharSetMap.put("8859_15", "windows-1252");
        langCharSetMap.put("8859-1", "windows-1252");
        langCharSetMap.put("8859_1", "windows-1252");
        langCharSetMap.put("8859-2", "windows-1250");
        langCharSetMap.put("8859_2", "windows-1250");
        langCharSetMap.put("8859-3", "ISO-8859-3");
        langCharSetMap.put("8859-4", "windows-1257");
        langCharSetMap.put("8859_4", "windows-1257");
        langCharSetMap.put("8859-5", "windows-1251");
        langCharSetMap.put("8859_5", "windows-1251");
        langCharSetMap.put("8859-6", "windows-1256");
        langCharSetMap.put("8859_6", "windows-1256");
        langCharSetMap.put("8859-7", "windows-1253");
        langCharSetMap.put("8859_7", "windows-1253");
        langCharSetMap.put("8859-8", "windows-1255");
        langCharSetMap.put("8859_8", "windows-1255");
        langCharSetMap.put("8859-9", "windows-1254");
        langCharSetMap.put("8859_9", "windows-1254");
        langCharSetMap.put("1250", "windows-1250");
        langCharSetMap.put("1251", "windows-1251");
        langCharSetMap.put("1252", "windows-1252");
        langCharSetMap.put("1253", "windows-1253");
        langCharSetMap.put("1254", "windows-1254");
        langCharSetMap.put("1255", "windows-1255");
        langCharSetMap.put("1256", "windows-1256");
        langCharSetMap.put("1257", "windows-1257");
        langCharSetMap.put("1258", "windows-1258");
        langCharSetMap.put("SJIS", "windows-31j");
        langCharSetMap.put("Shift-JIS", "windows-31j");
        langCharSetMap.put("Shift_JIS", "windows-31j");
        langCharSetMap.put("shift_jis", "windows-31j");
        langCharSetMap.put("UTF-8", "UTF-8");
        langCharSetMap.put("UTF_8", "UTF-8");
        langCharSetMap.put("UTF-16", "UTF-16");
        langCharSetMap.put("UTF_16", "UTF-16");
        langCharSetMap.put("WESTERN", "windows-1252");
        langCharSetMap.put("EUC_C", "EUC_CN");
        langCharSetMap.put("EUC_ZH", "EUC_CN");
        langCharSetMap.put("EUC_H", "EUC_TW");
        langCharSetMap.put("ENC_TW", "EUC_TW");
        langCharSetMap.put("EUC-K", "EUC_KR");
        langCharSetMap.put("EUC_K", "EUC_KR");
        langCharSetMap.put("EUC", "EUC_JP");
        langCharSetMap.put("GB", "GB2312");
        langCharSetMap.put("GB2312", "GB2312");
        langCharSetMap.put("GB-2312", "GB2312");
        langCharSetMap.put("GB_2312", "GB2312");
        langCharSetMap.put("GB2313", "GB2312");
        langCharSetMap.put("GB-2313", "GB2312");
        langCharSetMap.put("GB_2313", "GB2312");
        langCharSetMap.put("BIG5", "Big5");
        langCharSetMap.put("KSC_5601", "windows-1258");
        langCharSetMap.put("874", "windows-874");
        serverCharsetStringMap = new HashMap<String, String>();
        serverCharsetStringMap.put("utf-8", "UTF-8");
        serverCharsetStringMap.put("utf-16", "UTF-16");
        serverCharsetStringMap.put("cp1252", "windows-1252");
        serverCharsetStringMap.put("windows-1252", "windows-1252");
        serverCharsetStringMap.put("euc-tw", "EUC_H");
        serverCharsetStringMap.put("euc-cn", "EUC_C");
        serverCharsetStringMap.put("euc-jp", "EUC_JP");
        serverCharsetStringMap.put("shift_jis", "Shift_JIS");
        serverCharsetStringMap.put("jis", "JIS");
        serverCharsetStringMap.put("gb2312", "GB2312");
        serverCharsetStringMap.put("big5", "Big5");
        serverCharsetStringMap.put("cp949", "KSC_5601_92");
        serverCharsetStringMap.put("windows-1250", "windows-1250");
        serverCharsetStringMap.put("windows-1251", "windows-1251");
        serverCharsetStringMap.put("windows-1253", "windows-1253");
        serverCharsetStringMap.put("windows-1254", "windows-1254");
        serverCharsetStringMap.put("windows-1255", "windows-1255");
        serverCharsetStringMap.put("windows-1256", "windows-1256");
        serverCharsetStringMap.put("windows-1257", "windows-1257");
        serverCharsetStringMap.put("windows-1258", "windows-1258");
        serverCharsetStringMap.put("iso-8859-1", "ISO-8859-1");
        serverCharsetStringMap.put("iso-8859-2", "ISO-8859-2");
        serverCharsetStringMap.put("iso-8859-3", "ISO-8859-3");
        serverCharsetStringMap.put("iso-8859-4", "ISO-8859-4");
        serverCharsetStringMap.put("iso-8859-5", "ISO-8859-5");
        serverCharsetStringMap.put("iso-8859-6", "ISO-8859-6");
        serverCharsetStringMap.put("iso-8859-7", "ISO-8859-7");
        serverCharsetStringMap.put("iso-8859-8", "ISO-8859-8");
        serverCharsetStringMap.put("iso-8859-9", "ISO-8859-9");
        serverCharsetStringMap.put("cp874", "windows-874");
    }
}

