/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARKeyMask;
import com.bmc.arsys.arencrypt.PasswordEncryption;
import com.bmc.arsys.utils.ARCommonConfig;
import org.apache.log4j.Logger;

public class PasswordReserveFieldEncryption
extends PasswordEncryption {
    private ARDataKey aServerSeedKey;
    private ARDataKey aExportSeedKey;
    private static Logger logger = Logger.getLogger(PasswordReserveFieldEncryption.class);

    @Override
    protected boolean isDebugEnabled() {
        return ARCommonConfig.getInstance().getLogBytes() && logger.isDebugEnabled();
    }

    public PasswordReserveFieldEncryption(boolean debug) {
        super(debug);
        this.setSeedType(4);
        this.prepareServerKey(0);
    }

    protected void prepareServerKey(int seedType) {
        this.aServerSeedKey = new ARDataKey();
        this.aServerSeedKey.setEncAlgorithmStr("DES");
        this.aServerSeedKey.setEncType("Enc");
        this.aServerSeedKey.setEncXForm("DES/CBC/PKCS5Padding");
        this.aServerSeedKey.setKeySize(56);
        boolean macMasked = true;
        this.aServerSeedKey.setMacKey(ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.M, macMasked));
        this.aServerSeedKey.setMacMasked(macMasked);
        this.aServerSeedKey.setSeedType(seedType);
    }

    protected void prepareExportKey(int seedType) {
        this.aExportSeedKey = new ARDataKey();
        this.aExportSeedKey.setEncAlgorithmStr("DES");
        this.aExportSeedKey.setEncType("Enc");
        this.aExportSeedKey.setEncXForm("DES/CBC/PKCS5Padding");
        this.aExportSeedKey.setKeySize(56);
        boolean macMasked = true;
        this.aExportSeedKey.setMacKey(ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.M, macMasked));
        this.aExportSeedKey.setMacMasked(macMasked);
        this.aExportSeedKey.setSeedType(seedType);
    }

    @Override
    public byte[] decryptPasswordEx(byte[] fromBuf) throws AREncryptionException {
        byte[] rst = null;
        try {
            rst = this.decryptPasswordEx(this.getArDataKey(), fromBuf);
        }
        catch (AREncryptionException e1) {
            try {
                rst = this.decryptPasswordEx(this.getArDecryptPasswordKey(), fromBuf);
            }
            catch (AREncryptionException e2) {
                rst = this.decryptPasswordEx(this.getArDecryptExportPasswordKey(), fromBuf);
            }
        }
        return rst;
    }

    public boolean isEncryptionNeededField(int fieldId) {
        boolean needEnc = false;
        if (fieldId == 123) {
            needEnc = true;
        }
        return needEnc;
    }

    public boolean isEncryptedPasswordBytes(byte[] bs) {
        boolean encrypted = false;
        if (bs != null && bs.length == 120) {
            encrypted = true;
        }
        return encrypted;
    }

    protected ARDataKey getArDecryptPasswordKey() {
        return this.aServerSeedKey;
    }

    private ARDataKey getArDecryptExportPasswordKey() {
        if (this.aExportSeedKey == null) {
            this.prepareExportKey(3);
        }
        return this.aExportSeedKey;
    }
}

