/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncEngineFactory;
import com.bmc.arsys.arencrypt.AREncryptionException;
import java.security.MessageDigest;

class ARMdCrypto {
    private ARDataKey sha1Key = new ARDataKey("MD", "SHA1");
    private final ARDataKey md5Key = new ARDataKey("MD", "MD5");

    protected ARMdCrypto() {
    }

    protected byte[] genMD(ARDataKey encDataKey, byte[] dataBytes, int offSet, int len) throws AREncryptionException {
        byte[] mdbytes = new byte[]{};
        MessageDigest md = null;
        try {
            md = (MessageDigest)AREncEngineFactory.getInstance().getEncEngineInstance("MD", encDataKey);
            AREncEngineFactory.getInstance().initEngine(md, "MD", encDataKey);
            md.update(dataBytes, offSet, len);
            mdbytes = md.digest();
        }
        catch (Throwable e) {
            if (e instanceof AREncryptionException) {
                throw (AREncryptionException)e;
            }
            throw new AREncryptionException(e, 9007);
        }
        finally {
            AREncEngineFactory.getInstance().releaseEncEngineInstance(encDataKey, md);
        }
        return mdbytes;
    }

    protected byte[] SHA1(byte[] dataBytes, String provider) throws AREncryptionException {
        if (provider != null) {
            this.sha1Key.setProvider(provider);
        }
        return this.genMD(this.sha1Key, dataBytes, 0, dataBytes.length);
    }

    protected byte[] MD5(byte[] dataBytes) throws AREncryptionException {
        return this.MD5(dataBytes, 0, dataBytes.length);
    }

    protected byte[] MD5(byte[] dataBytes, int offSet, int len) throws AREncryptionException {
        return this.genMD(this.md5Key, dataBytes, offSet, len);
    }
}

