/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.DefinitionOptions;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.ViewItemData;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;

public class CommandLineBase {
    protected static final String CHARSET_TAG = "char-set: ";
    protected static final String ACTLINK_ALL_FLAG = "-A";
    protected static final String ACTLINK_FLAG = "-a";
    protected static final String ALGUIDE_ALL_FLAG = "-G";
    protected static final String ALGUIDE_FLAG = "-g";
    protected static final String APP_INDIVIDUAL_FLAG = "-n";
    protected static final String APP_ALL_FLAG = "-N";
    protected static final String APP_EXPORT_RELATED_FLAG = "-expapp";
    protected static final String APP_IMPORT_RELATED_FLAG = "-impapp";
    protected static final String LOCALES_FLAG = "-loc";
    protected static final String LOCALE_ONLY = "-loconly";
    protected static final String INTEGRATION_FLAG = "-int";
    protected static final String SHARED_WORKFLOW_FLAG = "-shared";
    protected static final String AUTHENTICATION_FLAG = "-w";
    protected static final String DSOMAP_ALL_FLAG = "-D";
    protected static final String DSOMAP_FLAG = "-d";
    protected static final String DSOPOOL_ALL_FLAG = "-B";
    protected static final String DSOPOOL_FLAG = "-b";
    protected static final String ESCAL_ALL_FLAG = "-Q";
    protected static final String ESCAL_FLAG = "-q";
    protected static final String EXPORTFILE_FLAG = "-e";
    protected static final String FILGUIDE_ALL_FLAG = "-H";
    protected static final String FILGUIDE_FLAG = "-h";
    protected static final String FILTER_ALL_FLAG = "-T";
    protected static final String FILTER_FLAG = "-t";
    protected static final String FORM_ALL_FLAG = "-F";
    protected static final String FORM_FLAG = "-f";
    protected static final String IMPORTFILE_FLAG = "-i";
    protected static final String INPLACE = "-inplace";
    protected static final String LOCK = "-lock";
    protected static final String MENU_ALL_FLAG = "-M";
    protected static final String MENU_FLAG = "-m";
    protected static final String PACKLIST_ALL_FLAG = "-K";
    protected static final String PACKLIST_FLAG = "-k";
    protected static final String PASSWORD_FLAG = "-p";
    protected static final String SERVER_FLAG = "-x";
    protected static final String USER_FLAG = "-u";
    protected static final String VERSION = "--version";
    protected static final String WEBSERVICE_ALL_FLAG = "-Z";
    protected static final String WEBSERVICE_FLAG = "-z";
    protected static final String XML_PACKLIST = "-l";
    protected static final String PORT_NUM = "-portnum";
    protected static final String LOG_FILE = "-o";
    protected static final String CHAR_SET = "-charset";
    protected static final String FLASHBOARD_FLAG = "-fb";
    protected static final String FLASHBOARD_ALL_FLAG = "-FB";
    protected static final String FLASHBOARD_ALARM_FLAG = "-fa";
    protected static final String FLASHBOARD_ALARM_ALL_FLAG = "-FA";
    protected static final String FLASHBOARD_VARIABLE_FLAG = "-fv";
    protected static final String FLASHBOARD_VARIABLE_ALL_FLAG = "-FV";
    protected static final String OVERLAY_GROUP = "-og";
    private static final List<String> TAGS = new ArrayList<String>(Arrays.asList("-l", "--version", "-inplace", "-lock", "-Z", "-z", "-T", "-t", "-Q", "-q", "-n", "-N", "-expapp", "-impapp", "-M", "-m", "-K", "-k", "-H", "-h", "-G", "-g", "-F", "-f", "-D", "-d", "-B", "-b", "-A", "-a", "-i", "-e", "-w", "-p", "-u", "-x", "-FA", "-fa", "-FB", "-fb", "-FV", "-fv", "-loc", "-loconly", "-shared", "-int", "-og"));
    protected static final int MODULE_NAME = 41000;
    protected static final int NAME = 41050;
    protected static final int SUB_DEFINITION = 41051;
    protected static final int SUB_TYPE = 41052;
    protected static final int DEFINTION_SMALL = 41053;
    protected static final int APPLICATION = 61001;
    protected String dataVisualizationForm = null;
    protected String dsoPoolForm = null;
    protected String dsoMapForm = null;
    protected static final String FLASHBOARD_TYPE = "FLASHBOARD";
    protected static final String VARIABLE_TYPE = "VARIABLE";
    protected static final String ALARM_TYPE = "ALARM";
    protected static final String FLASHBOARD_MODULE = "Flashboard";
    private static Logger logger = Logger.getLogger((String)"com.bmc.arsys.api.definition");
    private DefinitionOptions options = null;

    public DefinitionOptions getOptions() {
        return this.options;
    }

    public String getTypeName(int type) {
        int stripType = type;
        if ((type & 0x40000000) == 0x40000000) {
            stripType = type -= 0x40000001;
        }
        switch (stripType) {
            case 1: {
                return "Form";
            }
            case 2: {
                return "Form (User Cache)";
            }
            case 3: {
                return "Form View";
            }
            case 4: {
                return "Mail Template";
            }
            case 5: {
                return "Filter";
            }
            case 6: {
                return "Active Link";
            }
            case 7: {
                return "Admin Extension";
            }
            case 8: {
                return "Menu";
            }
            case 9: {
                return "Escalation";
            }
            case 10: {
                return "Distributed Mapping";
            }
            case 11: {
                return "View (User Cache)";
            }
            case 12: {
                return "Container";
            }
            case 13: {
                return "Distributed Pool";
            }
            case 14: {
                return "View";
            }
            case 15: {
                return "Field";
            }
            case 16: {
                return "Application";
            }
            case 30: {
                return "Form (Data)";
            }
            case 103: {
                return "View (All)";
            }
        }
        return "Object";
    }

    public String getTypeName(DefinitionItemType type) {
        switch (type) {
            case FORM: {
                return "Form";
            }
            case FORM_DEFN: {
                return "Form (User Cache)";
            }
            case FORM_VIEW: {
                return "Form View";
            }
            case FORM_MAIL: {
                return "Mail Template";
            }
            case FILTER: {
                return "Filter";
            }
            case ACTIVE_LINK: {
                return "Active Link";
            }
            case ADMIN_EXT: {
                return "Admin Extension";
            }
            case MENU: {
                return "Menu";
            }
            case ESCALATION: {
                return "Escalation";
            }
            case DISTRIBUTED_MAPPING: {
                return "Distributed Mapping";
            }
            case FORM_VIEW_MIN: {
                return "View (User Cache)";
            }
            case CONTAINER: {
                return "Container";
            }
            case DISTRIBUTED_POOL: {
                return "Distributed Pool";
            }
            case VIEW: {
                return "View";
            }
            case APPLICATION: {
                return "Application";
            }
            case FORM_DATA: {
                return "Form (Data)";
            }
            case ACTIVE_LINK_GUIDE: {
                return "Active Link Guide";
            }
            case FILTER_GUIDE: {
                return "Filter Guide";
            }
            case FLASHBOARD: {
                return FLASHBOARD_MODULE;
            }
            case FLASHBOARD_ALARM: {
                return "Flashboard Alarm";
            }
            case FLASHBOARD_VARIABLE: {
                return "Flashboard Variable";
            }
            case GROUPS: {
                return "Group";
            }
            case PACKING_LIST: {
                return "Packing List";
            }
            case WEB_SERVICE: {
                return "Web Service";
            }
        }
        return "Object";
    }

    public void setOptions(DefinitionOptions options) {
        this.options = options;
    }

    private int extractNames(String[] args, int startIndex, List<String> names) {
        int result = startIndex;
        for (int iLoop = startIndex; iLoop < args.length; ++iLoop) {
            if (TAGS.contains(args[iLoop])) {
                result = iLoop - names.size();
                break;
            }
            names.add(args[iLoop]);
        }
        return result;
    }

    protected DefinitionOptions parseCommandLine(String[] args) throws DefinitionException {
        DefinitionOptions options = new DefinitionOptions();
        int debugLevel = 2;
        for (int iLoop = 0; iLoop < args.length; ++iLoop) {
            ArrayList<String> names;
            String argument = args[iLoop];
            if (argument.equals(SERVER_FLAG)) {
                options.setServer(args[++iLoop]);
                continue;
            }
            if (argument.equals(USER_FLAG)) {
                options.setUser(args[++iLoop]);
                continue;
            }
            if (argument.equals(PASSWORD_FLAG)) {
                options.setPassword(args[++iLoop]);
                continue;
            }
            if (argument.equals(AUTHENTICATION_FLAG)) {
                options.setAuthentication(args[++iLoop]);
                continue;
            }
            if (argument.equals(PORT_NUM)) {
                options.setPortNumber(Integer.parseInt(args[++iLoop]));
                continue;
            }
            if (argument.equals(OVERLAY_GROUP)) {
                options.setOverlayGroup(args[++iLoop]);
                continue;
            }
            if (argument.equals(EXPORTFILE_FLAG)) {
                if (options.getOperation() != DefinitionOptions.Operation.NONE) {
                    throw new DefinitionException("Only one operation is supported.");
                }
                options.setOperation(DefinitionOptions.Operation.EXPORT);
                options.setFileName(args[++iLoop]);
                continue;
            }
            if (argument.equals(IMPORTFILE_FLAG)) {
                if (options.getOperation() != DefinitionOptions.Operation.NONE) {
                    throw new DefinitionException("Only one operation is supported.");
                }
                options.setOperation(DefinitionOptions.Operation.IMPORT);
                options.setFileName(args[++iLoop]);
                continue;
            }
            if (argument.equals(ACTLINK_FLAG)) {
                ArrayList<String> names2 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names2);
                for (String string : names2) {
                    options.add(DefinitionItemType.ACTIVE_LINK, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(ACTLINK_ALL_FLAG)) {
                options.setAll(DefinitionItemType.ACTIVE_LINK, true);
                continue;
            }
            if (argument.equals(DSOPOOL_FLAG)) {
                ArrayList<String> names3 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names3);
                for (String string : names3) {
                    options.add(DefinitionItemType.DISTRIBUTED_POOL, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(DSOPOOL_ALL_FLAG)) {
                options.setAll(DefinitionItemType.DISTRIBUTED_POOL, true);
                continue;
            }
            if (argument.equals(DSOMAP_FLAG)) {
                ArrayList<String> names4 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names4);
                for (String string : names4) {
                    options.add(DefinitionItemType.DISTRIBUTED_MAPPING, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(DSOMAP_ALL_FLAG)) {
                options.setAll(DefinitionItemType.DISTRIBUTED_MAPPING, true);
                continue;
            }
            if (argument.equals(FORM_FLAG)) {
                ArrayList<String> names5 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names5);
                for (String string : names5) {
                    options.add(DefinitionItemType.FORM, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(FORM_ALL_FLAG)) {
                options.setAll(DefinitionItemType.FORM, true);
                continue;
            }
            if (argument.equals(ALGUIDE_FLAG)) {
                ArrayList<String> names6 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names6);
                for (String string : names6) {
                    options.add(DefinitionItemType.ACTIVE_LINK_GUIDE, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(ALGUIDE_ALL_FLAG)) {
                options.setAll(DefinitionItemType.ACTIVE_LINK_GUIDE, true);
                continue;
            }
            if (argument.equals(FILGUIDE_FLAG)) {
                ArrayList<String> names7 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names7);
                for (String string : names7) {
                    options.add(DefinitionItemType.FILTER_GUIDE, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(FILGUIDE_ALL_FLAG)) {
                options.setAll(DefinitionItemType.FILTER_GUIDE, true);
                continue;
            }
            if (argument.equals("-j")) {
                int typeId = Integer.parseInt(args[++iLoop]);
                Iterator name3 = args[++iLoop];
                options.add(new DefinitionItemData(DefinitionItemType.ADMIN_EXT, (String)((Object)name3), RelatedType.NONE, typeId));
                continue;
            }
            if (argument.equals("-J")) {
                options.setAll(DefinitionItemType.ADMIN_EXT, Boolean.parseBoolean(args[++iLoop]));
                continue;
            }
            if (argument.equals(PACKLIST_FLAG)) {
                ArrayList<String> names8 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names8);
                for (String string : names8) {
                    options.add(DefinitionItemType.PACKING_LIST, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(PACKLIST_ALL_FLAG)) {
                options.setAll(DefinitionItemType.PACKING_LIST, true);
                continue;
            }
            if (argument.equals(XML_PACKLIST)) {
                options.setCommandSetFile(args[++iLoop]);
                continue;
            }
            if (argument.equals(MENU_FLAG)) {
                ArrayList<String> names9 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names9);
                for (String string : names9) {
                    options.add(DefinitionItemType.MENU, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(MENU_ALL_FLAG)) {
                options.setAll(DefinitionItemType.MENU, true);
                continue;
            }
            if (argument.equals(APP_EXPORT_RELATED_FLAG) || argument.equals(APP_IMPORT_RELATED_FLAG)) {
                ArrayList<String> names10 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names10);
                if (names10.size() == 0) {
                    throw new DefinitionException("No Application specified in Application option.");
                }
                for (String string : names10) {
                    options.add(DefinitionItemType.APPLICATION, string, RelatedType.FULL);
                }
                if (names10.size() == 0) continue;
                iLoop += names10.size() - 1;
                continue;
            }
            if (argument.equals(APP_INDIVIDUAL_FLAG)) {
                ArrayList<String> names11 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names11);
                if (names11.size() == 0) {
                    throw new DefinitionException("No Application specified in Application option.");
                }
                for (String string : names11) {
                    options.add(DefinitionItemType.APPLICATION, string, RelatedType.NONE);
                }
                if (names11.size() == 0) continue;
                iLoop += names11.size() - 1;
                continue;
            }
            if (argument.equals(LOCALES_FLAG)) {
                if (!options.getItems().containsKey((Object)DefinitionItemType.APPLICATION)) {
                    throw new DefinitionException("Application locale option only valid for Application command.");
                }
                int optionMask = options.getExportOption();
                if ((optionMask & 8) == 8) {
                    throw new DefinitionException("locales cannot be specified with Application integration option.");
                }
                names = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names);
                for (String name : names) {
                    if (name.equalsIgnoreCase("default")) {
                        if ((optionMask & 4) == 4) continue;
                        optionMask |= 2;
                        break;
                    }
                    if ((optionMask & 2) == 2) continue;
                    optionMask |= 4;
                    options.addElement(name, options.getLastName(DefinitionItemType.APPLICATION));
                }
                if (names.size() != 0) {
                    iLoop += names.size() - 1;
                }
                options.setExportOption(optionMask);
                continue;
            }
            if (argument.equals(INTEGRATION_FLAG)) {
                if (!options.getItems().containsKey((Object)DefinitionItemType.APPLICATION)) {
                    throw new DefinitionException("Application integration option only valid for Application command.");
                }
                int optionMask = options.getExportOption();
                if ((optionMask & 1) == 1) {
                    throw new DefinitionException("Application integration option cannot be selected with shared workflow.");
                }
                if ((optionMask & 4) == 4 || (optionMask & 2) == 2) {
                    throw new DefinitionException("Application integration option cannot be selected with locales.");
                }
                names = new ArrayList();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names);
                for (String name : names) {
                    options.addElement(name, options.getLastName(DefinitionItemType.APPLICATION));
                }
                if (names.size() != 0) {
                    iLoop += names.size() - 1;
                }
                options.setExportOption(optionMask |= 8);
                continue;
            }
            if (argument.equals(SHARED_WORKFLOW_FLAG)) {
                if (!options.getItems().containsKey((Object)DefinitionItemType.APPLICATION)) {
                    throw new DefinitionException("Shared Workflow option only valid for Application command.");
                }
                int optionMask = options.getExportOption();
                if ((optionMask & 8) == 8) {
                    throw new DefinitionException("Shared workflow cannot be selected with Application integration option.");
                }
                if ((optionMask & 0x10) == 16) {
                    throw new DefinitionException("Shared workflow cannot be selected with locale only option.");
                }
                options.setExportOption(optionMask |= 1);
                continue;
            }
            if (argument.equals(LOCALE_ONLY)) {
                if (!options.getItems().containsKey((Object)DefinitionItemType.APPLICATION)) {
                    throw new DefinitionException("Application Locale option only valid for Application command.");
                }
                int optionMask = options.getExportOption();
                if ((optionMask & 8) == 8) {
                    throw new DefinitionException("Locale only option cannot be selected with Application integration option.");
                }
                if ((optionMask & 1) == 1) {
                    throw new DefinitionException("Locale only option cannot be selected with shared workflow option.");
                }
                options.setExportOption(optionMask |= 0x10);
                continue;
            }
            if (argument.equals(APP_ALL_FLAG)) {
                options.setAll(DefinitionItemType.APPLICATION, true);
                continue;
            }
            if (argument.equals(ESCAL_FLAG)) {
                ArrayList<String> names12 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names12);
                for (String string : names12) {
                    options.add(DefinitionItemType.ESCALATION, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(ESCAL_ALL_FLAG)) {
                options.setAll(DefinitionItemType.ESCALATION, true);
                continue;
            }
            if (argument.equals(FILTER_FLAG)) {
                ArrayList<String> names13 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names13);
                for (String string : names13) {
                    options.add(DefinitionItemType.FILTER, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(FILTER_ALL_FLAG)) {
                options.setAll(DefinitionItemType.FILTER, true);
                continue;
            }
            if (argument.equals(WEBSERVICE_FLAG)) {
                ArrayList<String> names14 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names14);
                for (String string : names14) {
                    options.add(DefinitionItemType.WEB_SERVICE, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(WEBSERVICE_ALL_FLAG)) {
                options.setAll(DefinitionItemType.WEB_SERVICE, true);
                continue;
            }
            if (argument.equals(INPLACE)) {
                options.setOverwrite(true);
                continue;
            }
            if (argument.equals(LOCK)) {
                options.setLockType(Integer.parseInt(args[++iLoop]));
                options.setLockKey(args[++iLoop]);
                continue;
            }
            if (argument.equals(LOG_FILE)) {
                options.setLogFile(args[++iLoop]);
                continue;
            }
            if (argument.equals(VERSION)) {
                this.printVersion();
                return null;
            }
            if (argument.equals("-debug")) {
                try {
                    debugLevel = Integer.parseInt(args[++iLoop]);
                }
                catch (Exception e) {
                    debugLevel = 2;
                }
                continue;
            }
            if (argument.equals(CHAR_SET)) {
                options.setCharset(args[++iLoop]);
                continue;
            }
            if (argument.equals(FLASHBOARD_FLAG)) {
                ArrayList<String> names15 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names15);
                for (String string : names15) {
                    options.add(DefinitionItemType.FLASHBOARD, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(FLASHBOARD_ALL_FLAG)) {
                options.setAll(DefinitionItemType.FLASHBOARD, true);
                continue;
            }
            if (argument.equals(FLASHBOARD_VARIABLE_FLAG)) {
                ArrayList<String> names16 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names16);
                for (String string : names16) {
                    options.add(DefinitionItemType.FLASHBOARD_VARIABLE, string, RelatedType.NONE);
                }
                continue;
            }
            if (argument.equals(FLASHBOARD_VARIABLE_ALL_FLAG)) {
                options.setAll(DefinitionItemType.FLASHBOARD_VARIABLE, true);
                continue;
            }
            if (argument.equals(FLASHBOARD_ALARM_FLAG)) {
                ArrayList<String> names17 = new ArrayList<String>();
                ++iLoop;
                iLoop = this.extractNames(args, iLoop, names17);
                for (String string : names17) {
                    options.add(DefinitionItemType.FLASHBOARD_ALARM, string, RelatedType.NONE);
                }
                continue;
            }
            if (!argument.equals(FLASHBOARD_ALARM_ALL_FLAG)) continue;
            options.setAll(DefinitionItemType.FLASHBOARD_ALARM, true);
        }
        switch (debugLevel) {
            case 0: 
            case 1: 
            case 2: {
                CommandLineBase.initLogging(options.getLogFile(), Level.INFO);
                break;
            }
            case 3: {
                CommandLineBase.initLogging(options.getLogFile(), Level.DEBUG);
                break;
            }
            case 4: 
            case 5: {
                CommandLineBase.initLogging(options.getLogFile(), Level.WARN);
                break;
            }
            case 6: {
                CommandLineBase.initLogging(options.getLogFile(), Level.ALL);
                break;
            }
            default: {
                CommandLineBase.initLogging(options.getLogFile(), Level.OFF);
            }
        }
        return options;
    }

    protected void printUsage(boolean forExport) {
        System.out.println("Command Line Options:");
        System.out.println("    -u user : Required login parameter that identifies the user account.");
        System.out.println("    -p password : Optional login parameter that identifies the user account. Omit the option if the user account has no password.");
        System.out.println("    -x server name : Required login parameter that specifies the server to log in to.");
        System.out.println("    -w authenticator : Specifies the name of an external authentication string or Windows domain. This is related to the Login window Authentication field, which is discussed in the Configuring guide.");
        System.out.println("    -portnum : TCP port number used to log in when the portmapper is turned off.");
        if (forExport) {
            System.out.println("    -e <filename> Specifies the file to which to export object definitions from the source server (identified with the -x login parameter).");
            System.out.println("    -og     set overlay group property -2 [full mode], -1 [base mode], 0 [server mode], 1 [custom mode].");
        } else {
            System.out.println("    -i <filename> Specifies the file that contains the object definitions to be imported to the target server (identified with the -x login parameter). The -i option requires a <file> argument to identify the source file.");
        }
        System.out.println("    -o <logfile> Use to redirect errors normally displayed within the command line interface so that they appear in a file");
        System.out.println("");
        System.out.println("Nested Options:");
        System.out.println("    -a <active_link_name> for an active link");
        System.out.println("    -A for all active links");
        System.out.println("    -b <DSO_pool_name> for a DSO pool");
        System.out.println("    -B for all DSO pools");
        System.out.println("    -d <DSO_mapping_name> for a single DSO mapping");
        System.out.println("    -D for all DSO mappings");
        System.out.println("    -f <form_name> for a form");
        System.out.println("    -F for all forms");
        System.out.println("    -g <active_link_guide_name> for an active link guide");
        System.out.println("    -G for all active link guides");
        System.out.println("    -h <filter_guide_name> for a filter guide");
        System.out.println("    -H for all filter guides");
        System.out.println("    -k <packing_list_name> for a packing list object");
        System.out.println("    -K for packing list objects");
        System.out.println("    -l <packing_list.xml> for an XML command set. Provide either a command set file generated by Developer Studio or a packing list XML file generated by the Windows Admin Tool.");
        System.out.println("    -m <menu_name> for a menu");
        System.out.println("    -M for menus");
        System.out.println("    -n <application_name> for an application object");
        System.out.println("    -N for all application objects");
        if (forExport) {
            System.out.println("    -expapp <application_name> for complete application");
            System.out.println("    Application specific options:");
            System.out.println("        -loc <locale...>        to specify the locales to include");
            System.out.println("        -loconly                for exporting locale objects only");
            System.out.println("        -shared                 to include shared workflow");
            System.out.println("        -int <applications...>  to specify the applications for integration workflow");
            System.out.println("             Note: locale and integration workflow are mutually exclusive");
        } else {
            System.out.println("    -impapp <application_name> for complete application");
        }
        System.out.println("    -q <escalation_name> for an escalation");
        System.out.println("    -Q for all escalations");
        System.out.println("    -t <filter_name> for a filter");
        System.out.println("    -T for all filters");
        System.out.println("    -z <web_service_name> for a web service");
        System.out.println("    -Z for all web services");
        System.out.println("    -fb <flashboard_name> for a flashboard");
        System.out.println("    -FB for all flashboards");
        System.out.println("    -fa <flashboard_alarm_name> for a flashboard alarm");
        System.out.println("    -FA for all flashboard alarms");
        System.out.println("    -fv <flashboard_variable_name> for a flashboard variable");
        System.out.println("    -FV for all flashboard variables");
        System.out.println("    -charset <name>    : Specifies the character set used in the definition file. The character set name must be supplied as listed in the IANA Charset Registry");
        if (!forExport) {
            System.out.println("    -inplace to overwrite existing objects, without deleting objects first");
        }
        if (forExport) {
            System.out.println("    -lock <type> <key> to export objects as locked. Valid values for type are 1 (read only) and 2 (hidden). The key is a string that is to be used as a key (or password) to enforce locking");
        }
    }

    protected void printVersion() {
        System.out.println("7.6.04 Build 001");
    }

    protected final List<StructItemInfo> convertToItemList(boolean isXML) {
        ArrayList<StructItemInfo> result = new ArrayList<StructItemInfo>();
        for (DefinitionItemType type : this.getOptions().getItems().keySet()) {
            StructItemInfo info;
            List<BaseItemData> items = this.getOptions().getItems(type);
            if (items == null) continue;
            if (type == DefinitionItemType.VIEW) {
                HashMap formViews = new HashMap();
                for (BaseItemData item : items) {
                    ViewItemData view;
                    if (!(item instanceof ViewItemData) || (view = (ViewItemData)item).getForm() == null) continue;
                    ArrayList<String> viewList = (ArrayList<String>)formViews.get(view.getForm());
                    if (viewList == null) {
                        viewList = new ArrayList<String>();
                    }
                    if (!viewList.contains(view.getName())) {
                        viewList.add(view.getName());
                    }
                    formViews.put(view.getForm(), viewList);
                }
                for (String key : formViews.keySet()) {
                    List views = (List)formViews.get(key);
                    if (views == null || views.size() <= 0) continue;
                    info = new StructItemInfo(DefinitionItemType.VIEW.getConstant(), key);
                    info.setSelectedElements(views.toArray(new String[views.size()]));
                    if (isXML) {
                        info.setType(info.getType() | 0x40000000);
                    }
                    result.add(info);
                }
                continue;
            }
            for (BaseItemData item : items) {
                boolean skipItem = false;
                int constant = item.getType().getConstant();
                info = null;
                if (item instanceof DefinitionItemData) {
                    DefinitionItemData data = (DefinitionItemData)item;
                    if (!(this.getOptions().isDsoLicensed() || data.getType() != DefinitionItemType.DISTRIBUTED_MAPPING && data.getType() != DefinitionItemType.DISTRIBUTED_POOL)) {
                        if (logger.isEnabledFor((Priority)Level.INFO)) {
                            logger.info((Object)MessageFormat.format("{0} \"{1}\" has been removed from the list of objects. Server {2} does not have a Distributed Server Option license", data.getType().getTypeName(), data.getName(), this.getOptions().getServer()));
                        }
                        skipItem = true;
                    }
                    if (data.getType() != DefinitionItemType.FLASHBOARD && data.getType() != DefinitionItemType.FLASHBOARD_VARIABLE && data.getType() != DefinitionItemType.FLASHBOARD_ALARM) {
                        if (data.getType() == DefinitionItemType.APPLICATION && data.getRelated() == RelatedType.FULL) {
                            constant = 16;
                        }
                        if (constant == 16) {
                            for (BaseItemData appItem : items) {
                                int appConstant = item.getType().getConstant();
                                StructItemInfo appInfo = null;
                                appInfo = new StructItemInfo(isXML ? appConstant | 0x40000000 : constant, appItem.getName());
                                if (this.getOptions().hasElements(appItem.getName())) {
                                    List<String> elements = this.getOptions().getElements(appItem.getName());
                                    appInfo.setSelectedElements(elements.toArray(new String[elements.size()]));
                                }
                                result.add(appInfo);
                                skipItem = true;
                            }
                        }
                        info = new StructItemInfo(constant, item.getName());
                        if (data.getSubItems() != null && data.getSubItems().size() > 0) {
                            info.setSelectedElements(data.getSubItems().toArray(new String[data.getSubItems().size()]));
                        }
                    }
                }
                if (info == null) continue;
                if (isXML) {
                    info.setType(info.getType() | 0x40000000);
                }
                if (skipItem) continue;
                result.add(info);
            }
        }
        return result;
    }

    protected String getDataVisualizationForm() throws ARException {
        if (this.dataVisualizationForm != null) {
            return this.dataVisualizationForm;
        }
        int[] dvdFields = new int[]{41000, 41050, 41051, 41052, 61001, 41053};
        List dvdForms = this.getOptions().getContext().getListForm(0L, FormType.ALL.toInt(), null, dvdFields);
        this.dataVisualizationForm = dvdForms != null && dvdForms.size() >= 1 ? (String)dvdForms.get(0) : "Data Visualization Definition";
        return this.dataVisualizationForm;
    }

    protected QualifierInfo getDataVisualizationQualifier(String module, String type, String name) {
        ArithmeticOrRelationalOperand moduleLeft = new ArithmeticOrRelationalOperand(41000);
        ArithmeticOrRelationalOperand moduleRight = new ArithmeticOrRelationalOperand(new Value(module));
        QualifierInfo moduleQualifier = new QualifierInfo(new RelationalOperationInfo(1, moduleLeft, moduleRight));
        ArithmeticOrRelationalOperand nameLeft = new ArithmeticOrRelationalOperand(41050);
        ArithmeticOrRelationalOperand nameRight = new ArithmeticOrRelationalOperand(new Value(name));
        QualifierInfo nameQualifier = new QualifierInfo(new RelationalOperationInfo(1, nameLeft, nameRight));
        ArithmeticOrRelationalOperand subLeft = new ArithmeticOrRelationalOperand(41052);
        ArithmeticOrRelationalOperand subRight = new ArithmeticOrRelationalOperand(new Value(type));
        QualifierInfo subTypeQual = new QualifierInfo(new RelationalOperationInfo(1, subLeft, subRight));
        return new QualifierInfo(1, moduleQualifier, new QualifierInfo(1, nameQualifier, subTypeQual));
    }

    private static void initLogging(String pluginPath, Level level) {
        logger.setLevel(level);
        Object layout = null;
        layout = level.toInt() < Level.DEBUG.toInt() ? new PatternLayout("%d %-5p [%t] %C (%F:%L) - %m%n") : new SimpleLayout();
        if (pluginPath != null && pluginPath.length() > 0) {
            try {
                logger.addAppender((Appender)new FileAppender((Layout)layout, pluginPath, false));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean addConsole = true;
        Enumeration allAppenders = logger.getRootLogger().getAllAppenders();
        while (allAppenders.hasMoreElements()) {
            Object nextElement = allAppenders.nextElement();
            if (!(nextElement instanceof ConsoleAppender)) continue;
            addConsole = false;
            break;
        }
        if (addConsole) {
            allAppenders = null;
            Enumeration currentLogger = LogManager.getLoggerRepository().getCurrentLoggers();
            if (currentLogger != null) {
                block3: while (currentLogger.hasMoreElements()) {
                    Logger loggerElement = (Logger)currentLogger.nextElement();
                    allAppenders = loggerElement.getAllAppenders();
                    while (allAppenders.hasMoreElements()) {
                        Object appenderElement = allAppenders.nextElement();
                        if (!(appenderElement instanceof ConsoleAppender)) continue;
                        addConsole = false;
                        continue block3;
                    }
                }
            }
        }
        if (addConsole) {
            logger.addAppender((Appender)new ConsoleAppender((Layout)layout));
        }
    }

    protected void validateCommandLine(DefinitionOptions options, boolean isExport) {
        Set<Map.Entry<DefinitionItemType, Boolean>> entrySet = options.getAllFlags().entrySet();
        for (Map.Entry<DefinitionItemType, Boolean> entry : entrySet) {
            List<BaseItemData> items;
            Boolean allFlag;
            if (entry.getKey() == null || (allFlag = entry.getValue()) == null || !allFlag.booleanValue() || (items = options.getItems(entry.getKey())) == null || items.isEmpty() || !logger.isEnabledFor((Priority)Level.WARN)) continue;
            logger.warn((Object)MessageFormat.format("Command Line options specifies both all objects of type {0} and specific objects. All {0} objects will be {1}.", entry.getKey().getTypeName(), isExport ? "exported" : "imported"));
        }
    }

    protected void checkDSOLicense() throws ARException {
        int[] infoRequest = new int[]{43, 127};
        ServerInfoMap serverInfo = this.getOptions().getContext().getServerInfo(infoRequest);
        if (((Value)serverInfo.get((Object)43)).getValue() != null) {
            String licInfo = ((Value)serverInfo.get((Object)43)).getValue().toString();
            if (licInfo.length() > 0) {
                this.options.setDsoLicensed(true);
            } else {
                this.options.setDsoLicensed(false);
            }
        }
    }

    private void getDSOForms() throws ARException {
        int[] infoRequest = new int[]{43, 127};
        ServerInfoMap serverInfo = this.getOptions().getContext().getServerInfo(infoRequest);
        if (serverInfo != null) {
            Object value = ((Value)serverInfo.get((Object)43)).getValue();
            this.dsoMapForm = value != null ? value.toString() : "Distributed Mapping";
            value = ((Value)serverInfo.get((Object)127)).getValue();
            this.dsoPoolForm = value != null ? value.toString() : "Distributed Pool";
        }
    }

    protected String getDSOPoolForm() throws ARException {
        if (this.dsoPoolForm != null) {
            return this.dsoPoolForm;
        }
        this.getDSOForms();
        return this.dsoPoolForm;
    }

    protected String getDSOMapForm() throws ARException {
        if (this.dsoMapForm != null) {
            return this.dsoMapForm;
        }
        this.getDSOForms();
        return this.dsoMapForm;
    }
}

