/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.csv;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.Parser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class CSVParser
extends Parser {
    protected char separator = (char)44;
    private final int EOF = 65535;
    protected char qualifier = (char)34;
    protected boolean hasTitles = false;

    public CSVParser(boolean hasTitles) {
        this.hasTitles = hasTitles;
    }

    protected List<String> parseLine(String line, int lineNumber) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        if (line == null) {
            line = "";
        }
        for (int counter = 0; counter <= line.length(); ++counter) {
            buffer.setLength(0);
            if (counter < line.length() && line.charAt(counter) == this.qualifier) {
                ++counter;
                counter = this.handleQuotedField(line, buffer, counter);
            } else {
                counter = this.handlePlainField(line, buffer, counter);
            }
            if (counter > line.length()) continue;
            result.add(buffer.toString());
        }
        return result;
    }

    private int handleQuotedField(String token, StringBuffer buffer, int i) {
        int jLoop;
        int size = token.length();
        for (jLoop = i; jLoop < size; ++jLoop) {
            if (token.charAt(jLoop) == this.qualifier && jLoop + 1 < size) {
                if (token.charAt(jLoop + 1) == this.qualifier) {
                    ++jLoop;
                } else if (token.charAt(jLoop + 1) == this.separator) {
                    ++jLoop;
                    break;
                }
            } else if (token.charAt(jLoop) == this.qualifier && jLoop + 1 == size) break;
            buffer.append(token.charAt(jLoop));
        }
        return jLoop;
    }

    private int handlePlainField(String token, StringBuffer buffer, int index) {
        int position = token.indexOf(this.separator, index);
        if (position == -1) {
            if (index > 0 && token.charAt(index - 1) == this.separator || index == 0 && token.substring(index).length() != 0) {
                buffer.append(token.substring(index));
                return token.length();
            }
            return token.length() + 1;
        }
        buffer.append(token.substring(index, position));
        return position;
    }

    public BufferedReader openFile(String fileName, String charSet) throws IOException {
        FileInputStream inStream = new FileInputStream(fileName);
        InputStreamReader streamReader = null;
        streamReader = charSet != null && charSet.length() > 0 ? new InputStreamReader((InputStream)inStream, charSet) : new InputStreamReader(inStream);
        BufferedReader fileReader = new BufferedReader(streamReader);
        return fileReader;
    }

    private String readDataLine(BufferedReader fileReader, int nTitles) throws IOException {
        String line = null;
        int tokenCount = 1;
        StringBuffer data = new StringBuffer();
        char ch = '\u0000';
        boolean openQuotes = false;
        if (0 == nTitles) {
            line = fileReader.readLine();
            return line;
        }
        while ((ch = (char)fileReader.read()) != '\uffffffff') {
            if ('\uffff' == ch) {
                if (data.length() == 0) {
                    return null;
                }
                return data.toString();
            }
            if ('\"' == ch) {
                boolean bl = openQuotes = !openQuotes;
            }
            if (!(openQuotes || ch != '\r' && ch != '\n')) {
                if (ch == '\r' && fileReader.markSupported()) {
                    fileReader.mark(1);
                    ch = (char)fileReader.read();
                    if (ch != '\n') {
                        fileReader.reset();
                    }
                }
                return data.toString();
            }
            data.append(ch);
            if (openQuotes || ',' != ch) continue;
            ++tokenCount;
        }
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(String fileName, String charSet) throws IOException, ARImportException, ARException {
        try (BufferedReader fileReader = null;){
            List<String> dataTokens;
            fileReader = this.openFile(fileName, charSet);
            int lineNumber = 1;
            int nTitles = 0;
            String line = null;
            if (this.isHasTitles() && (line = fileReader.readLine()) != null && !this.isAbort() && !this.isCopyToLog()) {
                dataTokens = this.parseLine(line, lineNumber);
                this.fireEvent(new ParseEvent(3, dataTokens, line));
                nTitles = dataTokens.size();
            }
            while ((line = this.readDataLine(fileReader, nTitles)) != null && (!this.isAbort() || this.isAbort() && this.isCopyToLog())) {
                ++lineNumber;
                if (this.isAbort() && this.isCopyToLog()) {
                    this.fireEvent(new ParseEvent(1, null, line));
                    continue;
                }
                dataTokens = this.parseLine(line, lineNumber);
                if (dataTokens.size() <= 0) continue;
                this.fireEvent(new ParseEvent(1, dataTokens, line));
            }
            this.fireEvent(new ParseEvent(2));
        }
    }

    public char getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(char qualifier) {
        this.qualifier = qualifier;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public boolean isHasTitles() {
        return this.hasTitles;
    }

    public void setHasTitles(boolean hasTitles) {
        this.hasTitles = hasTitles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> extractFirstLine(String fileName, String charSet) throws IOException, ARImportException {
        List<String> result = null;
        try (BufferedReader reader = null;){
            reader = this.openFile(fileName, charSet);
            String line = reader.readLine();
            List<String> list = result = this.parseLine(line, 0);
            return list;
        }
    }
}

