/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import java.util.Collection;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Mapping {
    private static final String DELIMETER = "$";
    private Type type = Type.NONE;
    private int fieldId = -1;
    private Object keyword = null;
    private String constant = null;
    private String compound = null;
    private String compoundValue = null;
    private String fieldName = null;
    private int tokenIndex = -1;
    public static final Keyword[] keywords = new Keyword[]{Keyword.AR_KEYWORD_DATABASE, Keyword.AR_KEYWORD_DATE_ONLY, Keyword.AR_KEYWORD_DEFAULT, Keyword.AR_KEYWORD_GROUPS, Keyword.AR_KEYWORD_HARDWARE, Keyword.AR_KEYWORD_INBULKTRANS, Keyword.AR_KEYWORD_LASTID, Keyword.AR_KEYWORD_LOCALE, Keyword.AR_KEYWORD_OPERATION, Keyword.AR_KEYWORD_OS, Keyword.AR_KEYWORD_SCHEMA, Keyword.AR_KEYWORD_SERVER, Keyword.AR_KEYWORD_TIME_ONLY, Keyword.AR_KEYWORD_TIMESTAMP, Keyword.AR_KEYWORD_USER, Keyword.AR_KEYWORD_VERSION, Keyword.AR_KEYWORD_WEEKDAY};

    public Mapping() {
    }

    public Mapping(Type type, int fieldId, String fieldName, Object keyword, String constant, String compound) {
        this.type = type;
        this.fieldId = fieldId;
        this.fieldName = fieldName;
        this.keyword = keyword;
        this.constant = constant;
        this.compound = compound;
    }

    public Mapping(int fieldId) {
        this.type = Type.FIELDID;
        this.fieldId = fieldId;
    }

    public Mapping(Type type, String value) {
        this.type = type;
        if (type == Type.COMPOUND) {
            this.compound = value;
        } else if (type == Type.CONSTANT) {
            this.constant = value;
        } else if (type == Type.FIELDNAME) {
            this.fieldName = value;
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getConstant() {
        return this.constant;
    }

    public void setConstant(String constant) {
        this.constant = constant;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Object getKeyword() {
        return this.keyword;
    }

    public void setKeyword(Object keyword) {
        this.keyword = keyword;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(int fileField) {
        this.fieldId = fileField;
    }

    public String getCompound() {
        return this.compound;
    }

    public void setCompound(String compound) {
        this.compound = compound;
    }

    public String toARMString() {
        if (this.type == Type.FIELDID) {
            return "=$" + this.fieldId + DELIMETER;
        }
        if (this.type == Type.CONSTANT) {
            return '=' + this.constant;
        }
        if (this.type == Type.KEYWORD) {
            return '=' + this.keyword.toString();
        }
        if (this.type == Type.COMPOUND) {
            return '=' + this.compound;
        }
        if (this.type == Type.FIELDNAME) {
            return "=$" + this.fieldName + DELIMETER;
        }
        return "";
    }

    public String getTypeString() {
        if (this.type == Type.FIELDID) {
            return "Field Value";
        }
        if (this.type == Type.CONSTANT) {
            return "Constant";
        }
        if (this.type == Type.KEYWORD) {
            return "Keyword";
        }
        if (this.type == Type.COMPOUND) {
            return "Compound";
        }
        if (this.type == Type.FIELDNAME) {
            return "Field Value";
        }
        return "";
    }

    public String getDisplayString(FormInformation formInfo) {
        if (this.type == Type.FIELDID) {
            if (this.fieldName != null && this.fieldName.length() > 0) {
                return DELIMETER + this.fieldName + DELIMETER;
            }
            FieldInformation field = formInfo.getFields().get(this.fieldId);
            if (field != null && field.getName() != null && field.getName().length() > 0) {
                return DELIMETER + field.getName() + DELIMETER;
            }
            return DELIMETER + this.fieldId + DELIMETER;
        }
        if (this.type == Type.CONSTANT) {
            return this.constant;
        }
        if (this.type == Type.KEYWORD) {
            if (this.keyword instanceof Integer) {
                return "$NULL$";
            }
            return this.keyword.toString();
        }
        if (this.type == Type.COMPOUND) {
            String result = this.compound;
            Collection<FieldInformation> fields = formInfo.getFields().values();
            for (FieldInformation field : fields) {
                String fieldName = field.getName();
                if (fieldName == null || fieldName.length() <= 0) continue;
                result = result.replace(DELIMETER + field.getFieldId() + DELIMETER, DELIMETER + fieldName + DELIMETER);
            }
            for (Keyword keyword : keywords) {
                result = result.replace(DELIMETER + -keyword.toInt() + DELIMETER, keyword.toString());
            }
            result = result.replace("$--1$", "$NULL$");
            return result;
        }
        if (this.type == Type.FIELDNAME) {
            return DELIMETER + this.fieldName + DELIMETER;
        }
        return "";
    }

    public String getDisplayID() {
        if (this.type == Type.FIELDID || this.type == Type.FIELDNAME) {
            return Integer.toString(this.fieldId);
        }
        return "";
    }

    public String fallBackToArmString() {
        String result = "";
        if (this.type == Type.KEYWORD) {
            result = this.keyword instanceof Integer ? "$--1$" : "$-" + ((Keyword)this.keyword).toInt() + DELIMETER;
        } else {
            if (this.type == Type.COMPOUND) {
                result = this.compound;
            } else if (this.type == Type.CONSTANT) {
                result = this.constant;
            }
            result = result.replaceAll("\\$NULL\\$", "\\$--1\\$");
            for (int kLoop = 0; kLoop < keywords.length; ++kLoop) {
                String regex = keywords[kLoop].toString().replaceAll("\\$", "\\\\\\$");
                String regExResult = result;
                result = regExResult.replaceAll(regex, "\\$-" + Integer.toString(keywords[kLoop].toInt()) + '\\' + DELIMETER);
            }
        }
        return result;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("Type", this.type.toString());
        if (this.type == Type.KEYWORD) {
            builder.append("Keyword", this.keyword);
        } else if (this.type == Type.CONSTANT) {
            builder.append("Constant", this.constant);
        } else if (this.type == Type.COMPOUND) {
            builder.append("Compound", this.compound);
        } else if (this.type == Type.FIELDID) {
            builder.append("Field ID", this.fieldId);
        } else if (this.type == Type.FIELDNAME) {
            builder.append("Field Name", this.fieldName).toString();
        }
        builder.append("Token Index", this.tokenIndex);
        return builder.toString();
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public void setTokenIndex(int tokenIndex) {
        this.tokenIndex = tokenIndex;
    }

    public String getCompoundValue() {
        return this.compoundValue;
    }

    public void setCompoundValue(String compoundValue) {
        this.compoundValue = compoundValue;
    }

    public static enum Type {
        NONE,
        FIELDID,
        KEYWORD,
        CONSTANT,
        COMPOUND,
        FIELDNAME;

    }
}

