/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wsn;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandler;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeChannel;
import com.kaazing.gateway.client.html5.util.StringUtils;
import com.kaazing.gateway.client.html5.util.WSURI;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketNativeBalancingHandler
extends WebSocketHandlerAdapter {
    private static final String CLASS_NAME = WebSocketNativeBalancingHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    @Override
    public synchronized void processConnect(WebSocketChannel channel, WSURI uri, String protocol) {
        LOG.entering(CLASS_NAME, "connect", new Object[]{uri, protocol});
        WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
        wsChannel.balanced.set(0);
        this.nextHandler.processConnect(channel, (WSURI)uri.addQueryParameter(".kl=Y"), protocol);
    }

    private synchronized void reconnect(WebSocketChannel channel, WSURI uri, String protocol) {
        LOG.entering(CLASS_NAME, "reconnect", new Object[]{uri, protocol});
        WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
        wsChannel.redirectUri = uri;
        wsChannel.balanced.set(0);
        wsChannel.reconnecting.compareAndSet(false, true);
    }

    void handleMessageReceived(WebSocketChannel channel, ByteBuffer message) {
        LOG.entering(CLASS_NAME, "handleMessageReceived", message);
        WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
        if (wsChannel.balanced.get() <= 1 && message.remaining() >= 4) {
            String prefixString;
            byte[] prefix = new byte[3];
            message.mark();
            message.get(prefix);
            try {
                prefixString = new String(prefix, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                throw new IllegalStateException(e1);
            }
            if (prefixString.charAt(0) == '\uf0ff') {
                byte code = message.get();
                LOG.finest("Balancer code = " + code);
                if (code == 78) {
                    if (wsChannel.balanced.getAndIncrement() == 0) {
                        this.listener.connectionOpened(channel, "x-kaazing-handshake");
                    } else {
                        this.listener.connectionOpened(channel, "");
                    }
                    return;
                }
                if (code == 82) {
                    try {
                        String reconnectLocation = message.getString(UTF_8);
                        LOG.finest("Balancer redirect location = " + StringUtils.stripControlCharacters(reconnectLocation));
                        WSURI uri = new WSURI(reconnectLocation);
                        this.reconnect(channel, uri, channel.getProtocol());
                        this.nextHandler.processClose(channel);
                        return;
                    }
                    catch (URISyntaxException e) {
                        LOG.log(Level.WARNING, e.getMessage(), e);
                        this.listener.connectionFailed(channel);
                    }
                }
            }
            message.reset();
            this.listener.messageReceived(channel, message);
        } else {
            this.listener.messageReceived(channel, message);
        }
    }

    @Override
    public void setNextHandler(WebSocketHandler handler) {
        this.nextHandler = handler;
        handler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                if (!"x-kaazing-handshake".equals(protocol)) {
                    WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
                    wsChannel.balanced.set(2);
                    WebSocketNativeBalancingHandler.this.listener.connectionOpened(channel, protocol);
                }
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
                try {
                    LOG.finest("Balancer redirect location = " + StringUtils.stripControlCharacters(location));
                    WSURI uri = new WSURI(location);
                    WebSocketNativeBalancingHandler.this.reconnect(channel, uri, channel.getProtocol());
                    WebSocketNativeBalancingHandler.this.nextHandler.processClose(channel);
                }
                catch (URISyntaxException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                    WebSocketNativeBalancingHandler.this.listener.connectionFailed(channel);
                }
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
                WebSocketNativeBalancingHandler.this.listener.authenticationRequested(channel, location, challenge);
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer buf) {
                WebSocketNativeBalancingHandler.this.handleMessageReceived(channel, buf);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
                if (wsChannel.reconnecting.compareAndSet(true, false)) {
                    wsChannel.reconnected.set(true);
                    String protocol = channel.getProtocol();
                    String protocols = "x-kaazing-handshake";
                    if (protocol != null && protocol.length() > 0) {
                        protocols = protocols + "," + protocol;
                    }
                    WebSocketNativeBalancingHandler.this.processConnect(channel, wsChannel.redirectUri, protocols);
                } else {
                    WebSocketNativeBalancingHandler.this.listener.connectionClosed(channel);
                }
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
                WebSocketNativeBalancingHandler.this.listener.connectionClosed(channel);
            }
        });
    }
}

