/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.serializer.support;

import com.bmc.thirdparty.org.springframework.core.convert.converter.Converter;
import com.bmc.thirdparty.org.springframework.core.serializer.DefaultSerializer;
import com.bmc.thirdparty.org.springframework.core.serializer.Serializer;
import com.bmc.thirdparty.org.springframework.core.serializer.support.SerializationFailedException;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.ByteArrayOutputStream;

public class SerializingConverter
implements Converter<Object, byte[]> {
    private final Serializer<Object> serializer;

    public SerializingConverter() {
        this.serializer = new DefaultSerializer();
    }

    public SerializingConverter(Serializer<Object> serializer) {
        Assert.notNull(serializer, "Serializer must not be null");
        this.serializer = serializer;
    }

    @Override
    public byte[] convert(Object source) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(256);
        try {
            this.serializer.serialize(source, byteStream);
            return byteStream.toByteArray();
        }
        catch (Throwable ex) {
            throw new SerializationFailedException("Failed to serialize object using " + this.serializer.getClass().getSimpleName(), ex);
        }
    }
}

