/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans;

import com.bmc.thirdparty.org.springframework.beans.ConversionNotSupportedException;
import com.bmc.thirdparty.org.springframework.beans.PropertyEditorRegistrySupport;
import com.bmc.thirdparty.org.springframework.beans.TypeConverter;
import com.bmc.thirdparty.org.springframework.beans.TypeConverterDelegate;
import com.bmc.thirdparty.org.springframework.beans.TypeMismatchException;
import com.bmc.thirdparty.org.springframework.core.MethodParameter;
import com.bmc.thirdparty.org.springframework.core.convert.ConversionException;
import com.bmc.thirdparty.org.springframework.core.convert.ConverterNotFoundException;
import java.lang.reflect.Field;

public abstract class TypeConverterSupport
extends PropertyEditorRegistrySupport
implements TypeConverter {
    TypeConverterDelegate typeConverterDelegate;

    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return this.doConvert(value, requiredType, null, null);
    }

    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return this.doConvert(value, requiredType, methodParam, null);
    }

    @Override
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, Field field) throws TypeMismatchException {
        return this.doConvert(value, requiredType, null, field);
    }

    private <T> T doConvert(Object value, Class<T> requiredType, MethodParameter methodParam, Field field) throws TypeMismatchException {
        try {
            if (field != null) {
                return this.typeConverterDelegate.convertIfNecessary(value, requiredType, field);
            }
            return this.typeConverterDelegate.convertIfNecessary(value, requiredType, methodParam);
        }
        catch (ConverterNotFoundException ex) {
            throw new ConversionNotSupportedException(value, requiredType, (Throwable)ex);
        }
        catch (ConversionException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            throw new ConversionNotSupportedException(value, requiredType, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
    }
}

