/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.framework;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisedSupport;
import com.bmc.thirdparty.org.springframework.aop.framework.CglibAopProxy;
import com.bmc.thirdparty.org.springframework.cglib.proxy.Callback;
import com.bmc.thirdparty.org.springframework.cglib.proxy.Enhancer;
import com.bmc.thirdparty.org.springframework.cglib.proxy.Factory;
import com.bmc.thirdparty.org.springframework.objenesis.ObjenesisException;
import com.bmc.thirdparty.org.springframework.objenesis.ObjenesisStd;

class ObjenesisCglibAopProxy
extends CglibAopProxy {
    private static final Log logger = LogFactory.getLog(ObjenesisCglibAopProxy.class);
    private final ObjenesisStd objenesis = new ObjenesisStd(true);

    public ObjenesisCglibAopProxy(AdvisedSupport config) {
        super(config);
    }

    @Override
    protected Object createProxyClassAndInstance(Enhancer enhancer, Callback[] callbacks) {
        try {
            Factory factory = (Factory)this.objenesis.newInstance(enhancer.createClass());
            factory.setCallbacks(callbacks);
            return factory;
        }
        catch (ObjenesisException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to instantiate proxy using Objenesis, falling back to regular proxy construction", ex);
            }
            return super.createProxyClassAndInstance(enhancer, callbacks);
        }
    }
}

