/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration;

import com.bmc.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.bmc.thirdparty.org.apache.commons.lang.StringUtils;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIConfiguration
extends AbstractConfiguration {
    private String prefix;
    private Context context;
    private Context baseContext;
    private Set<String> clearedProperties = new HashSet<String>();

    public JNDIConfiguration() throws NamingException {
        this((String)null);
    }

    public JNDIConfiguration(String prefix) throws NamingException {
        this(new InitialContext(), prefix);
    }

    public JNDIConfiguration(Context context) {
        this(context, null);
    }

    public JNDIConfiguration(Context context, String prefix) {
        this.context = context;
        this.prefix = prefix;
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveGetKeys(Set<String> keys, Context context, String prefix, Set<Context> processedCtx) throws NamingException {
        processedCtx.add(context);
        NamingEnumeration<NameClassPair> elements = null;
        try {
            elements = context.list("");
            while (elements.hasMore()) {
                NameClassPair nameClassPair = elements.next();
                String name = nameClassPair.getName();
                Object object = context.lookup(name);
                StringBuilder key = new StringBuilder();
                key.append(prefix);
                if (key.length() > 0) {
                    key.append(".");
                }
                key.append(name);
                if (object instanceof Context) {
                    Context subcontext = (Context)object;
                    if (processedCtx.contains(subcontext)) continue;
                    this.recursiveGetKeys(keys, subcontext, key.toString(), processedCtx);
                    continue;
                }
                keys.add(key.toString());
            }
        }
        finally {
            if (elements != null) {
                elements.close();
            }
        }
    }

    @Override
    public Iterator<String> getKeys() {
        return this.getKeys("");
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        String[] splitPath = StringUtils.split(prefix, ".");
        List<String> path = Arrays.asList(splitPath);
        try {
            Context context = this.getContext(path, this.getBaseContext());
            HashSet<String> keys = new HashSet<String>();
            if (context != null) {
                this.recursiveGetKeys(keys, context, prefix, new HashSet<Context>());
            } else if (this.containsKey(prefix)) {
                keys.add(prefix);
            }
            return keys.iterator();
        }
        catch (NameNotFoundException e) {
            return new ArrayList().iterator();
        }
        catch (NamingException e) {
            this.fireError(5, null, null, e);
            return new ArrayList().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(List<String> path, Context context) throws NamingException {
        if (path == null || path.isEmpty()) {
            return context;
        }
        String key = path.get(0);
        NamingEnumeration<NameClassPair> elements = null;
        try {
            elements = context.list("");
            while (elements.hasMore()) {
                NameClassPair nameClassPair = elements.next();
                String name = nameClassPair.getName();
                Object object = context.lookup(name);
                if (!(object instanceof Context) || !name.equals(key)) continue;
                Context subcontext = (Context)object;
                Context context2 = this.getContext(path.subList(1, path.size()), subcontext);
                return context2;
            }
        }
        finally {
            if (elements != null) {
                elements.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean bl;
        block6: {
            NamingEnumeration<NameClassPair> enumeration = null;
            try {
                enumeration = this.getBaseContext().list("");
                boolean bl2 = bl = !enumeration.hasMore();
                if (enumeration == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (enumeration != null) {
                        enumeration.close();
                    }
                    throw throwable;
                }
                catch (NamingException e) {
                    this.fireError(5, null, null, e);
                    return true;
                }
            }
            enumeration.close();
        }
        return bl;
    }

    @Override
    public void setProperty(String key, Object value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public void clearProperty(String key) {
        this.clearedProperties.add(key);
    }

    @Override
    public boolean containsKey(String key) {
        if (this.clearedProperties.contains(key)) {
            return false;
        }
        key = key.replaceAll("\\.", "/");
        try {
            this.getBaseContext().lookup(key);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
        catch (NamingException e) {
            this.fireError(5, key, null, e);
            return false;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.baseContext = null;
    }

    @Override
    public Object getProperty(String key) {
        if (this.clearedProperties.contains(key)) {
            return null;
        }
        try {
            key = key.replaceAll("\\.", "/");
            return this.getBaseContext().lookup(key);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NotContextException nctxex) {
            return null;
        }
        catch (NamingException e) {
            this.fireError(5, key, null, e);
            return null;
        }
    }

    @Override
    protected void addPropertyDirect(String key, Object obj) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Context getBaseContext() throws NamingException {
        if (this.baseContext == null) {
            this.baseContext = (Context)this.getContext().lookup(this.prefix == null ? "" : this.prefix);
        }
        return this.baseContext;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.clearedProperties.clear();
        this.context = context;
    }
}

